/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.util;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigitalFingerprint {
    public static final byte[] RB_SECRET_STAMP = "Files_signature_of_the_heros_line_stamped_by_Itzik_Tomer_&_Alex_for_BreezeMax".getBytes();

    public static byte[] appendFingerprint(byte[] secretStamp, MessageDigestAlgorithm algorithm, byte[] message) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(algorithm.toString());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return message;
        }
        messageDigest.update(secretStamp);
        ByteBuffer fingerprint = ByteBuffer.wrap(messageDigest.digest(message));
        ByteBuffer result = ByteBuffer.allocate(message.length + 55);
        result.put("<?NPU File Signature=".getBytes());
        result.put(Long.toHexString(fingerprint.getLong()).toUpperCase().getBytes());
        result.put(Long.toHexString(fingerprint.getLong()).toUpperCase().getBytes());
        result.put("?>".getBytes());
        result.put(message);
        return result.array();
    }

    public static byte[] getFingerprint(byte[] secretStamp, MessageDigestAlgorithm algorithm, byte[] message) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(algorithm.toString());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        messageDigest.update(secretStamp);
        return messageDigest.digest(message);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MessageDigestAlgorithm {
        MD2("MD2"),
        MD5("MD5"),
        SHA1("SHA-1"),
        SHA256("SHA-256"),
        SHA384("SHA-384"),
        SHA512("SHA-512");

        private final String identifier;

        private MessageDigestAlgorithm(String identifier) {
            this.identifier = identifier;
        }

        public String toString() {
            return this.identifier;
        }
    }
}

