/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.topology;

import com.bwanms.gui.Internationalizer;
import com.bwanms.model.ObjectID;
import com.bwanms.model.topology.Link;
import com.bwanms.model.topology.Node;
import com.bwanms.model.topology.RadioLink;
import com.bwanms.model.topology.TopologyAdapter;
import com.bwanms.rb.model.RbSU;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbSUTopologyAdapter
implements TopologyAdapter<RbSU> {
    private static Internationalizer i18n = Internationalizer.getInternationalizer(RbSUTopologyAdapter.class);

    public Node getVertex(RbSU su) {
        ArrayList<Link> outboundLinks = new ArrayList<Link>();
        if (su.getManagerBS() != null) {
            outboundLinks.add((Link)new RadioLink(new ObjectID((Object)su), new ObjectID((Object)su.getManagerBS())));
        }
        return new SUNode(new ObjectID((Object)su), su.getName(), false, su.getAlarmState(), outboundLinks, new ArrayList<Link>(), su.getState(), new String[][]{{"Model", su.getModel()}, {"AuSlotNo", su.getServingAUId() != null ? su.getServingAUId().toString() : ""}});
    }

    public List<Object> getOutboundLinkEndPoints(RbSU su) {
        ArrayList<Object> ret = new ArrayList<Object>();
        if (su.getManagerBS() != null) {
            ret.add((Object)su.getManagerBS());
        }
        return ret;
    }

    public List<Object> getAlarmPropagationLinks(RbSU su) {
        ArrayList<Object> ret = new ArrayList<Object>();
        if (su.getLocation() != null) {
            ret.add(su.getLocation());
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SUNode
    extends Node {
        private String[][] details;

        public SUNode(ObjectID objectID, String name, boolean logical, int alarmState, List<Link> outboundLinks, List<Link> inboundLinks, int state, String[][] details) {
            super(objectID, name, logical, alarmState, outboundLinks, inboundLinks, state);
            this.details = details;
        }

        public String[][] getDetails() {
            String[][] ret = new String[this.details.length][2];
            for (int i = 0; i < ret.length; ++i) {
                ret[i][0] = i18n.translateString(this.details[i][0]);
                ret[i][1] = this.details[i][1];
            }
            return ret;
        }
    }
}

