/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.topology;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.equipmentmanager.AbstractEquipmentManagerConfig;
import com.bwanms.model.EquipmentStateEnum;
import com.bwanms.model.ObjectID;
import com.bwanms.model.topology.Link;
import com.bwanms.model.topology.Node;
import com.bwanms.model.topology.RadioLink;
import com.bwanms.model.topology.TopologyAdapter;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbSU;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbBaseStationTopologyAdapter
implements TopologyAdapter<RbBaseStationEquipment> {
    private static Internationalizer i18n = Internationalizer.getInternationalizer(AbstractEquipmentManagerConfig.class);

    public Node getVertex(RbBaseStationEquipment bs) {
        ArrayList<Link> inboundLinks = new ArrayList<Link>();
        for (RbSU su : bs.getManagedSUs()) {
            inboundLinks.add((Link)new RadioLink(new ObjectID((Object)su), new ObjectID((Object)bs)));
        }
        ArrayList<Link> outboundLinks = new ArrayList<Link>();
        if (bs.getLocation() != null) {
            outboundLinks.add(new Link(new ObjectID((Object)bs), new ObjectID((Object)bs.getLocation())));
        }
        return new BSNode(new ObjectID((Object)bs), bs.getName(), false, bs.getAlarmState(), outboundLinks, inboundLinks, bs.getState(), new String[][]{{"RunningSoftware", bs.getFirmwareVersion() != null ? bs.getFirmwareVersion() : ""}, {"IPAddress", bs.getIPAddress()}, {"Location", bs.getLocation() != null ? bs.getLocation().getName() : ""}, {"State", EquipmentStateEnum.toString((int)bs.getState())}, {"SerialNumber", bs.getSerialNumber()}});
    }

    public List<Object> getOutboundLinkEndPoints(RbBaseStationEquipment bs) {
        ArrayList<Object> ret = new ArrayList<Object>();
        if (bs.getLocation() != null) {
            ret.add(bs.getLocation());
        }
        return ret;
    }

    public String getLinkEndPointId(RbBaseStationEquipment bs) {
        return ((Object)((Object)bs)).getClass().getName() + "#" + bs.getId();
    }

    public List<Object> getAlarmPropagationLinks(RbBaseStationEquipment object) {
        return this.getOutboundLinkEndPoints(object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BSNode
    extends Node {
        private String[][] details;

        public BSNode(ObjectID objectID, String name, boolean logical, int alarmState, List<Link> outboundLinks, List<Link> inboundLinks, int state, String[][] details) {
            super(objectID, name, logical, alarmState, outboundLinks, inboundLinks, state);
            this.details = details;
        }

        public String[][] getDetails() {
            String[][] ret = new String[this.details.length][2];
            for (int i = 0; i < ret.length; ++i) {
                ret[i][0] = i18n.translateString(this.details[i][0]);
                ret[i][1] = i == 3 ? i18n.translateString(this.details[i][1]) : this.details[i][1];
            }
            return ret;
        }
    }
}

