/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.softwareupgrade;

import com.bwanms.rb.command.RbMbsCommand;
import com.bwanms.rb.command.RbNpuCommand;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import java.util.Comparator;

public class RbSoftwareUpgradeUtil {
    public static final Version VERSION_2_5 = VersionFactory.getInstance().createVersion("2.5");

    public static boolean isSameVersionDomain(String file1, String file2) {
        Version v1 = RbSoftwareUpgradeUtil.getVersionFromFile(file1);
        Version v2 = RbSoftwareUpgradeUtil.getVersionFromFile(file2);
        return v1.isOlderThan(VERSION_2_5) && v2.isOlderThan(VERSION_2_5) || v1.isNewerOrEqualWith(VERSION_2_5) && v2.isNewerOrEqualWith(VERSION_2_5);
    }

    public static Version getVersionFromFile(String file) {
        String versionPart = null;
        for (int i = 0; i < file.length(); ++i) {
            if (!Character.isDigit(file.charAt(i))) continue;
            versionPart = file.substring(i);
            break;
        }
        return VersionFactory.getInstance().createVersion(versionPart, "_");
    }

    public static String getFileNameFromVersion(String version, String prefix, String suffix) {
        return prefix + version.replace('.', '_') + suffix;
    }

    public static boolean isV25File(String file) {
        return RbSoftwareUpgradeUtil.getVersionFromFile(file).isNewerOrEqualWith(VERSION_2_5);
    }

    public static Object createNPUResetCommand() {
        return RbSoftwareUpgradeUtil.createNPUControlCommand(2);
    }

    public static Object createNPURunFromShadowCommand() {
        return RbSoftwareUpgradeUtil.createNPUControlCommand(4);
    }

    public static Object createNPUMakeOperationalCommand() {
        return RbSoftwareUpgradeUtil.createNPUControlCommand(5);
    }

    private static Object createNPUControlCommand(Integer command) {
        RbNpuCommand controlCommand = new RbNpuCommand();
        controlCommand.setRbSlotNumber(5);
        controlCommand.setRbNpuUnitControl(command);
        return controlCommand;
    }

    public static Object createMBSResetCommand() {
        return RbSoftwareUpgradeUtil.createMBSControlCommand(2);
    }

    public static Object createMBSRunFromShadowCommand() {
        return RbSoftwareUpgradeUtil.createMBSControlCommand(4);
    }

    public static Object createMBSMakeOperationalCommand() {
        return RbSoftwareUpgradeUtil.createMBSControlCommand(5);
    }

    private static Object createMBSControlCommand(Integer command) {
        RbMbsCommand resetCommand = new RbMbsCommand();
        resetCommand.setRbMBSTUnitControl(command);
        return resetCommand;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FirmwareFileComparator
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            return RbSoftwareUpgradeUtil.getVersionFromFile(o1).compareTo((Object)RbSoftwareUpgradeUtil.getVersionFromFile(o2));
        }
    }
}

