/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.softwareupgrade;

import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.ExceptionUtil;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.SelectorUtil;
import com.bwanms.gui.SelectorView;
import com.bwanms.gui.Selectors;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JComboBoxBinding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.mediation.FileSystemService;
import com.bwanms.model.EqTreeNode;
import com.bwanms.model.EqTreeNodeValue;
import com.bwanms.model.Equipment;
import com.bwanms.model.ManagedEntity;
import com.bwanms.rb.model.RbAU;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbSU;
import com.bwanms.rb.tasks.softwareupgrade.RbSoftwareUpgradeTask;
import com.bwanms.rb.tasks.softwareupgrade.RbSoftwareUpgradeTaskPanel;
import com.bwanms.rb.tasks.softwareupgrade.RbSwUpgradeEquipmentWeakAssociation;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.EquipmentSelectorTreeTableModel;
import com.bwanms.util.MessageBox;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbSoftwareUpgradeTaskView
extends AbstractBindedEditorView<RbSoftwareUpgradeTask> {
    private static final Logger log = Logger.getLogger(RbSoftwareUpgradeTaskView.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbSoftwareUpgradeTask.class);
    private static final String FIRMWARE_PATH = "firmware/rb";
    private RbSoftwareUpgradeTaskPanel panel;
    private EquipmentSelectorTreeTableModel equipmentTreeTableModel = new EquipmentSelectorTreeTableModel();

    public RbSoftwareUpgradeTaskView() {
        this.panel = new RbSoftwareUpgradeTaskPanel(this.equipmentTreeTableModel);
        this.fillCombos();
        this.addListeners();
    }

    private void fillCombos() {
        ComboItem noneItem = new ComboItem((Object)"none", "none");
        this.panel.getComboBSFileName().removeAllItems();
        this.panel.getComboBSFileName().addItem(noneItem);
        this.panel.getComboMBSFileName().removeAllItems();
        this.panel.getComboMBSFileName().addItem(noneItem);
        this.panel.getComboAUFileName().removeAllItems();
        this.panel.getComboAUFileName().addItem(noneItem);
        this.panel.getComboAUSIFileName().removeAllItems();
        this.panel.getComboAUSIFileName().addItem(noneItem);
        this.panel.getComboSUFileName().removeAllItems();
        this.panel.getComboSUFileName().addItem(noneItem);
        this.panel.getComboSUSIFileName().removeAllItems();
        this.panel.getComboSUSIFileName().addItem(noneItem);
        try {
            String[] firmware;
            FileSystemService fileSystem = ServiceRegistry.getFileSystemService();
            for (String file : firmware = fileSystem.listFiles(FIRMWARE_PATH)) {
                String fileName = file.substring(file.lastIndexOf(47) + 1);
                ComboItem comboItem = new ComboItem((Object)file, fileName);
                if (fileName.startsWith("npu")) {
                    this.panel.getComboBSFileName().addItem(comboItem);
                    continue;
                }
                if (fileName.startsWith("micro")) {
                    this.panel.getComboMBSFileName().addItem(comboItem);
                    continue;
                }
                if (fileName.startsWith("au")) {
                    this.panel.getComboAUFileName().addItem(comboItem);
                    this.panel.getComboAUSIFileName().addItem(comboItem);
                    continue;
                }
                if (!fileName.startsWith("su")) continue;
                this.panel.getComboSUFileName().addItem(comboItem);
                this.panel.getComboSUSIFileName().addItem(comboItem);
            }
        }
        catch (IOException e) {
            log.warn((Object)"Error while listing firmware folder: firmware/rb: ", (Throwable)e);
            MessageBox.Error.showResult((Component)this.panel, ExceptionUtil.getMessage((Throwable)e), i18n.translateString("ListingFolderErrorTitle"));
        }
    }

    public JComponent getUI() {
        return this.panel;
    }

    private void addListeners() {
        this.panel.getBtnEquipmentAdd().addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                char keyChar = e.getKeyChar();
                if (keyChar == '\n' || keyChar == ' ') {
                    RbSoftwareUpgradeTaskView.this.processAddButtonEvent(e);
                }
            }
        });
        this.panel.getBtnEquipmentAdd().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                RbSoftwareUpgradeTaskView.this.processAddButtonEvent(e);
            }
        });
        this.panel.getBtnEquipmentRemove().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RbSoftwareUpgradeTaskView.this.actionRemoveEquipment();
            }
        });
        this.panel.getComboEquipmentSelectionMode().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    RbSoftwareUpgradeTaskView.this.removeCurrentSelection();
                }
            }
        });
    }

    public List<Binder> getBinders() {
        log.debug((Object)"getBinders");
        ArrayList<Binder> binders = new ArrayList<Binder>();
        DefaultBinder binder = new DefaultBinder((Object)this.panel, (Object)this.entity);
        binder.add((Binding)new JTextFieldBinding("txtName", "name", i18n.translateString("Name")));
        binder.add((Binding)new JComboBoxBinding("comboBSFileName", "npuFile", i18n.translateString("BSFileName")));
        binder.add((Binding)new JComboBoxBinding("comboMBSFileName", "mbstFile", i18n.translateString("MBSFileName")));
        binder.add((Binding)new JComboBoxBinding("comboAUFileName", "auFile", i18n.translateString("AUFileName")));
        binder.add((Binding)new JComboBoxBinding("comboAUSIFileName", "auSiFile", i18n.translateString("AUSIFileName")));
        binder.add((Binding)new JComboBoxBinding("comboSUFileName", "suFile", i18n.translateString("SUFileName")));
        binder.add((Binding)new JComboBoxBinding("comboSUSIFileName", "suSiFile", i18n.translateString("SUSIFileName")));
        binder.add((Binding)new JComboBoxBinding(i18n, "comboBSOperation", "npuOperation", i18n.translateString("BSOperation")));
        binder.add((Binding)new JComboBoxBinding(i18n, "comboMBSOperation", "mbstOperation", i18n.translateString("MBSOperation")));
        binder.add((Binding)new JComboBoxBinding(i18n, "comboAUOperation", "auOperation", i18n.translateString("AUOperation")));
        binder.add((Binding)new JComboBoxBinding(i18n, "comboAUSIOperation", "auSiOperation", i18n.translateString("AUSIOperation")));
        binder.add((Binding)new JComboBoxBinding(i18n, "comboSUOperation", "suOperation", i18n.translateString("SUOperation")));
        binder.add((Binding)new JComboBoxBinding(i18n, "comboSUSIOperation", "suSiOperation", i18n.translateString("SUSIOperation")));
        binders.add((Binder)binder);
        return binders;
    }

    public void fillUI(RbSoftwareUpgradeTask entity) {
        this.panel.getRadioDeleteOldest().setSelected(entity.getFileManagementPolicy() == 2);
        this.panel.getRadioSkip().setSelected(entity.getFileManagementPolicy() == 1);
        this.panel.getRadioShadowSkip().setSelected(entity.getShadowBSPolicy() == 1);
        this.panel.getRadioMakeRunningOp().setSelected(entity.getShadowBSPolicy() == 2);
        this.panel.getCkbxSUDefault().setSelected(entity.isSetSUDefault());
        int selectionMode = entity.getEquipmentSelectionMode();
        for (int i = 0; i < this.panel.getComboEquipmentSelectionMode().getItemCount(); ++i) {
            ComboItem item = (ComboItem)this.panel.getComboEquipmentSelectionMode().getItemAt(i);
            if (selectionMode != (Integer)item.getValue()) continue;
            this.panel.getComboEquipmentSelectionMode().setSelectedItem(item);
            break;
        }
        this.initAddPopupMenu();
        for (RbSwUpgradeEquipmentWeakAssociation assoc : entity.getTargetEquipment()) {
            Equipment equipment = (Equipment)assoc.getEntity();
            if (equipment != null) {
                if (equipment instanceof RbBaseStationEquipment) {
                    this.addBSToModel((RbBaseStationEquipment)equipment, assoc.getUpgrade());
                    continue;
                }
                this.addEquipmentToModel(equipment, this.getManagerBS(equipment), assoc.getUpgrade());
                continue;
            }
            log.debug((Object)("WeakAssociation with id " + assoc.getId() + " no longer points to anything"));
        }
    }

    public List<InvalidValue> configureEntity(RbSoftwareUpgradeTask entity) {
        if (this.panel.getRadioDeleteOldest().isSelected()) {
            entity.setFileManagementPolicy(2);
        } else {
            entity.setFileManagementPolicy(1);
        }
        if (this.panel.getRadioMakeRunningOp().isSelected()) {
            entity.setShadowBSPolicy(2);
        } else {
            entity.setShadowBSPolicy(1);
        }
        entity.setSetSUDefault(this.panel.getCkbxSUDefault().isEnabled() && this.panel.getCkbxSUDefault().isSelected());
        this.setTargetEquipment(entity);
        entity.setEquipmentSelectionMode(this.getComboEquipmentSelectionMode());
        return super.configureEntity((Serializable)((Object)entity));
    }

    public String getTitle() {
        return i18n.translateString("RbSoftwareUpgradeTaskTitle");
    }

    private void setTargetEquipment(RbSoftwareUpgradeTask entity) {
        List eqNodes = this.equipmentTreeTableModel.getNodes();
        ArrayList<RbSwUpgradeEquipmentWeakAssociation> associations = new ArrayList<RbSwUpgradeEquipmentWeakAssociation>(eqNodes.size());
        for (EqTreeNode eqNode : eqNodes) {
            EqTreeNodeValue eqValue = eqNode.getValue();
            RbSwUpgradeEquipmentWeakAssociation assoc = new RbSwUpgradeEquipmentWeakAssociation((ManagedEntity)eqValue.getEquipment());
            assoc.setUpgrade(eqValue.isSelected());
            associations.add(assoc);
        }
        entity.setTargetEquipment(associations);
    }

    private RbBaseStationEquipment getManagerBS(Equipment equipment) {
        if (equipment instanceof RbAU) {
            return ((RbAU)equipment).getManagerBS();
        }
        if (equipment instanceof RbSU) {
            return ((RbSU)equipment).getManagerBS();
        }
        return null;
    }

    private void initAddPopupMenu() {
        JPopupMenu popup = this.panel.getPopupAdd();
        popup.removeAll();
        popup.add(new JMenuItem(new SelectNpuMbsManagerAction("selectNpuMBS")));
        popup.add(new JMenuItem(new SelectAUsManagerAction("selectAUs")));
        popup.add(new JMenuItem(new SelectSUsManagerAction("selectSUs")));
        i18n.getSwingInternationalizer().translateJPopupMenu(popup);
    }

    private void removeCurrentSelection() {
        this.panel.getTreeTableEquipment().getTree().getCellEditor().stopCellEditing();
        this.equipmentTreeTableModel.removeChildrenNodes(this.equipmentTreeTableModel.getRoot());
    }

    private void actionSelectBaseStations() {
        SelectorView selectorView = Selectors.getSelectorView(RbBaseStationEquipment.class, null);
        SelectorUtil.displayModalSelector((JComponent)this.panel, (SelectorView)selectorView);
        List selection = selectorView.getSelection();
        if (!selection.isEmpty()) {
            for (RbBaseStationEquipment bs : selection) {
                this.addBSToModel(bs, true);
            }
        }
    }

    private void actionRemoveEquipment() {
        TreePath[] selectionPaths = this.panel.getTreeTableEquipment().getTree().getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length == 0) {
            return;
        }
        this.panel.getTreeTableEquipment().getTree().getCellEditor().stopCellEditing();
        for (TreePath selectionPath : selectionPaths) {
            EqTreeNode selNode = (EqTreeNode)selectionPath.getLastPathComponent();
            this.equipmentTreeTableModel.removeNode(selNode);
        }
    }

    private void actionAddAUSelection() {
        SelectorView selectorView = Selectors.getSelectorView(RbAU.class, null);
        SelectorUtil.displayModalSelector((JComponent)this.panel, (SelectorView)selectorView);
        List selection = selectorView.getSelection();
        if (!selection.isEmpty()) {
            for (RbAU au : selection) {
                this.addEquipmentToModel(au, au.getManagerBS(), true);
            }
        }
    }

    private void actionAddSUSelection() {
        SelectorView selectorView = Selectors.getSelectorView(RbSU.class, null);
        SelectorUtil.displayModalSelector((JComponent)this.panel, (SelectorView)selectorView);
        List selection = selectorView.getSelection();
        if (!selection.isEmpty()) {
            for (RbSU su : selection) {
                this.addEquipmentToModel(su, su.getManagerBS(), true);
            }
        }
    }

    private void addBSToModel(RbBaseStationEquipment bs, boolean selected) {
        EqTreeNode bsNode = this.equipmentTreeTableModel.getNode((Equipment)bs);
        if (bsNode != null) {
            this.equipmentTreeTableModel.updateNode(bsNode, (Equipment)bs, 1, selected);
            return;
        }
        EqTreeNode rootNode = this.equipmentTreeTableModel.getRoot();
        bsNode = this.newEqTreeNode(rootNode, bs, 1, true, selected);
        this.equipmentTreeTableModel.addNode(rootNode, bsNode);
        this.makeNodeVisible((TreeNode)bsNode);
    }

    private void addEquipmentToModel(Equipment equipment, RbBaseStationEquipment managerBS, boolean selected) {
        EqTreeNode eqNode = this.equipmentTreeTableModel.getNode(equipment);
        int equipmentType = this.getEquipmentType(equipment);
        if (eqNode != null) {
            this.equipmentTreeTableModel.updateNode(eqNode, equipment, equipmentType, selected);
            return;
        }
        if (managerBS == null) {
            log.warn((Object)("Equipment with id = " + equipment.getId() + " of type " + equipment.getClass().getName() + " does not have a manager BS."));
            EqTreeNode rootNode = this.equipmentTreeTableModel.getRoot();
            eqNode = this.newEqTreeNode(rootNode, equipment, equipmentType, false, false);
            this.equipmentTreeTableModel.addNode(rootNode, eqNode);
        } else {
            EqTreeNode bsNode = this.equipmentTreeTableModel.getNode((Equipment)managerBS);
            if (bsNode == null) {
                EqTreeNode rootNode = this.equipmentTreeTableModel.getRoot();
                bsNode = this.newEqTreeNode(rootNode, managerBS, 1, true, true);
                this.equipmentTreeTableModel.addNode(rootNode, bsNode);
            }
            eqNode = this.newEqTreeNode(bsNode, equipment, equipmentType, true, selected);
            this.equipmentTreeTableModel.addNode(bsNode, eqNode);
        }
        this.makeNodeVisible((TreeNode)eqNode);
    }

    private EqTreeNode newEqTreeNode(EqTreeNode parentNode, Equipment equipment, int equipmentType, boolean selectable, boolean selected) {
        EqTreeNodeValue eqValue = new EqTreeNodeValue(equipment, equipment.getName(), equipmentType, selectable);
        eqValue.setSelected(selected);
        EqTreeNode eqNode = new EqTreeNode(parentNode, eqValue);
        return eqNode;
    }

    private int getEquipmentType(Equipment equipment) {
        if (equipment instanceof RbBaseStationEquipment) {
            return 1;
        }
        if (equipment instanceof RbAU) {
            return 2;
        }
        if (equipment instanceof RbSU) {
            return 3;
        }
        return -1;
    }

    private void makeNodeVisible(TreeNode node) {
        TreePath nodePath;
        JTree tree = this.panel.getTreeTableEquipment().getTree();
        if (!tree.isVisible(nodePath = this.equipmentTreeTableModel.getTreePath(node))) {
            tree.makeVisible(nodePath);
        }
    }

    private int getComboEquipmentSelectionMode() {
        return (Integer)ComboItem.getSelectedItem((JComboBox)this.panel.getComboEquipmentSelectionMode());
    }

    private void processAddButtonEvent(AWTEvent event) {
        int selectionMode = this.getComboEquipmentSelectionMode();
        if (0 == selectionMode) {
            this.actionSelectBaseStations();
            return;
        }
        if (1 != selectionMode) {
            log.error((Object)("Unknown selection mode: " + selectionMode));
            return;
        }
        JButton addButton = this.panel.getBtnEquipmentAdd();
        if (event instanceof KeyEvent) {
            addButton.getComponentPopupMenu().show(addButton, addButton.getX() + addButton.getSize().width / 2, addButton.getY() + addButton.getSize().height / 2);
        } else if (event instanceof MouseEvent) {
            int clickedButton;
            MouseEvent mouseEvent = (MouseEvent)event;
            if (mouseEvent.getClickCount() == 1 && ((clickedButton = mouseEvent.getButton()) == 1 || clickedButton == 2)) {
                addButton.getComponentPopupMenu().show(addButton, mouseEvent.getX(), mouseEvent.getY());
            }
        } else {
            log.debug((Object)("Event ignored: " + event.getClass().getName()));
        }
    }

    public String getApplicationPermission() {
        return "Av:ConfigureTasks";
    }

    public String getHelpTopic() {
        return "ngnms.help.sw_upgrade_session_manager";
    }

    private class SelectSUsManagerAction
    extends SelectEquipmentManagerAction {
        private static final long serialVersionUID = -7089948082640085375L;

        SelectSUsManagerAction(String key) {
            super(key);
        }

        public void actionPerformed(ActionEvent e) {
            RbSoftwareUpgradeTaskView.this.actionAddSUSelection();
        }
    }

    private class SelectAUsManagerAction
    extends SelectEquipmentManagerAction {
        private static final long serialVersionUID = -6476859954701614218L;

        SelectAUsManagerAction(String key) {
            super(key);
        }

        public void actionPerformed(ActionEvent e) {
            RbSoftwareUpgradeTaskView.this.actionAddAUSelection();
        }
    }

    private class SelectNpuMbsManagerAction
    extends SelectEquipmentManagerAction {
        private static final long serialVersionUID = 4172242655094041033L;

        SelectNpuMbsManagerAction(String key) {
            super(key);
        }

        public void actionPerformed(ActionEvent e) {
            RbSoftwareUpgradeTaskView.this.actionSelectBaseStations();
        }
    }

    private class SelectEquipmentManagerAction
    extends AbstractAction {
        private static final long serialVersionUID = -4260621646801040095L;

        SelectEquipmentManagerAction(String key) {
            super.putValue("Name", key);
        }

        public void actionPerformed(ActionEvent e) {
        }
    }
}

