/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.softwareupgrade;

import com.bwanms.model.TaskRuntimeStatus;
import com.bwanms.rb.tasks.softwareupgrade.RbSoftwareUpgradeTaskExecutor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbSoftwareUpgradeTaskRuntimeStatus
extends TaskRuntimeStatus {
    private static final Logger log = Logger.getLogger(RbSoftwareUpgradeTaskExecutor.class);
    private ArrayList<UpgradeOperation> operations = new ArrayList();

    public synchronized List<UpgradeOperation> getStatusSince(int index) {
        return this.operations.subList(index, this.operations.size() - 1);
    }

    public synchronized void logStatus(long bsId, String target, int operation, String status, String reason) {
        log.debug((Object)("Status[ " + bsId + " " + target + " " + operation + " " + status + " " + reason));
        this.operations.add(new UpgradeOperation(bsId, target, operation, status, reason));
    }

    public static class UpgradeOperation
    implements Serializable {
        private long baseStationId;
        private long time;
        private int operation;
        private String target;
        private String status;
        private String reason;

        public UpgradeOperation(long baseStationId, String target, int operation, String status, String reason) {
            this.baseStationId = baseStationId;
            this.time = System.currentTimeMillis();
            this.operation = operation;
            this.target = target;
            this.status = status;
            this.reason = reason;
        }

        public long getBaseStationId() {
            return this.baseStationId;
        }

        public int getOperation() {
            return this.operation;
        }

        public String getStatus() {
            return this.status;
        }

        public String getTarget() {
            return this.target;
        }

        public long getTime() {
            return this.time;
        }
    }

    private class BaseStationStatus
    implements Serializable {
        long bsId;
        String bsName;

        private BaseStationStatus() {
        }
    }
}

