/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.softwareupgrade;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.SwingInternationalizer;
import com.bwanms.gui.util.treetable.JTreeTable;
import com.bwanms.rb.tasks.softwareupgrade.RbSoftwareUpgradeTaskPanel;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.EqNodeEditorPanel;
import com.bwanms.ui.components.EqNodeTreeCellEditor;
import com.bwanms.ui.components.EqNodeTreeCellRenderer;
import com.bwanms.util.FormUtil;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;

public class RbSoftwareUpgradeTaskPanelController {
    private static final SwingInternationalizer i18n = new SwingInternationalizer(Internationalizer.getInternationalizer(RbSoftwareUpgradeTaskPanelController.class));
    private RbSoftwareUpgradeTaskPanel panel;
    private Boolean selectedSuFileWasNone;

    public RbSoftwareUpgradeTaskPanelController(RbSoftwareUpgradeTaskPanel panel) {
        this.panel = panel;
    }

    public void checkBSFile() {
        this.checkFileCombo(this.panel.getComboBSFileName(), this.panel.getComboBSOperation());
    }

    public void checkMBSFile() {
        this.checkFileCombo(this.panel.getComboMBSFileName(), this.panel.getComboMBSOperation());
    }

    public void checkAUFile() {
        this.checkFileCombo(this.panel.getComboAUFileName(), this.panel.getComboAUOperation());
    }

    public void checkAUSIFile() {
        this.checkFileCombo(this.panel.getComboAUSIFileName(), this.panel.getComboAUSIOperation());
    }

    public void checkSUSIFile() {
        this.checkFileCombo(this.panel.getComboSUSIFileName(), this.panel.getComboSUSIOperation());
    }

    public void checkSUFile() {
        this.checkFileCombo(this.panel.getComboSUFileName(), this.panel.getComboSUOperation());
        this.checkFileCombo(this.panel.getComboSUFileName(), this.panel.getCkbxSUDefault());
        if (this.selectedSuFileWasNone == null && this.panel.getComboSUFileName().getItemCount() > 1) {
            Boolean bl = this.selectedSuFileWasNone = "none".equals(FormUtil.getSelectedValue((JComboBox)this.panel.getComboSUFileName())) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (!this.panel.getCkbxSUDefault().isEnabled()) {
            this.panel.getCkbxSUDefault().setSelected(false);
        } else if (this.selectedSuFileWasNone.booleanValue()) {
            this.panel.getCkbxSUDefault().setSelected(true);
            this.selectedSuFileWasNone = Boolean.FALSE;
        }
    }

    private void checkFileCombo(JComboBox fileCombo, JComponent actionCombo) {
        boolean enabled = fileCombo.getSelectedItem() != null && !"none".equals(FormUtil.getSelectedValue((JComboBox)fileCombo));
        actionCombo.setEnabled(enabled);
        if (!enabled && actionCombo instanceof JComboBox && ((JComboBox)actionCombo).getItemCount() > 0) {
            ((JComboBox)actionCombo).setSelectedIndex(0);
        }
    }

    public void initializeBSOperations(JComboBox operationsCombo) {
        operationsCombo.removeAllItems();
        operationsCombo.addItem(new ComboItem((Object)0, "opNone"));
        operationsCombo.addItem(new ComboItem((Object)1, "opLoadToShadow"));
        operationsCombo.addItem(new ComboItem((Object)2, "opMakeOperational"));
        operationsCombo.addItem(new ComboItem((Object)4, "opRunFromShadow"));
        i18n.translateCombo(operationsCombo);
    }

    public void initializeAUSUOperations(JComboBox operationsCombo) {
        operationsCombo.removeAllItems();
        operationsCombo.addItem(new ComboItem((Object)0, "opNone"));
        operationsCombo.addItem(new ComboItem((Object)1, "opLoadToBaseStation"));
        operationsCombo.addItem(new ComboItem((Object)3, "opLoadToShadow"));
        operationsCombo.addItem(new ComboItem((Object)2, "opMakeOperational"));
        operationsCombo.addItem(new ComboItem((Object)4, "opRunFromShadow"));
        i18n.translateCombo(operationsCombo);
    }

    public void translate() {
        i18n.translateComponent((Component)this.panel);
    }

    public void initializeEqSelectionMode(JComboBox selectionModeCombo) {
        selectionModeCombo.removeAllItems();
        selectionModeCombo.addItem(new ComboItem((Object)0, "selModeFullBaseStation"));
        selectionModeCombo.addItem(new ComboItem((Object)1, "selModeIndividualNetworkComponents"));
        i18n.translateCombo(selectionModeCombo);
    }

    public void initializeEquipmentTreeTable() {
        JTreeTable equipmentTreeTable = this.panel.getTreeTableEquipment();
        equipmentTreeTable.setSelectRowsFromTree(true);
        this.panel.getEquipmentScrollPane().setViewportView((Component)equipmentTreeTable);
        JTree tree = equipmentTreeTable.getTree();
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setEditable(true);
        EqNodeEditorPanel panel = new EqNodeEditorPanel();
        tree.setCellRenderer((TreeCellRenderer)new EqNodeTreeCellRenderer(panel));
        tree.setCellEditor((TreeCellEditor)new EqNodeTreeCellEditor(panel, equipmentTreeTable));
    }
}

