/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.softwareupgrade;

import com.bwanms.domain.logic.LicenseHelper;
import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.model.TaskExecutor;
import com.bwanms.persistence.CallableDatastoreDecorator;
import com.bwanms.rb.mo.RbSwUpgrade;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbMBS;
import com.bwanms.rb.model.RbSU;
import com.bwanms.rb.tasks.softwareupgrade.BaseStationDeleteFileCommand;
import com.bwanms.rb.tasks.softwareupgrade.RbSoftwareUpgradeExecutorBase;
import com.bwanms.rb.tasks.softwareupgrade.RbSoftwareUpgradeTask;
import com.bwanms.rb.tasks.softwareupgrade.RbSoftwareUpgradeTaskBase;
import com.bwanms.rb.tasks.softwareupgrade.RbSoftwareUpgradeUtil;
import com.bwanms.rb.tasks.softwareupgrade.SetSUDefaultCommand;
import com.bwanms.util.task.OperationStatus;
import com.bwanms.util.version.impl.DefaultVersion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbSoftwareUpgradeTaskExecutor
extends RbSoftwareUpgradeExecutorBase
implements TaskExecutor {
    private static final Logger log = Logger.getLogger(RbSoftwareUpgradeTaskExecutor.class);
    private static final int SW_UPGRADE_WAIT_AFTER_SUCCESSFUL_UPLOAD = Integer.getInteger("com.bwanms.rb.softwareupgrade.waitAfterSuccessfultimeout", 3000);

    public RbSoftwareUpgradeTaskExecutor(RbSoftwareUpgradeTask task) {
        super(task);
    }

    @Override
    public RbSoftwareUpgradeExecutorBase.BaseStationExecutorBase createBaseStationExecutor(RbBaseStationEquipment bs) {
        return new BaseStationExecutor(bs, (RbSoftwareUpgradeTask)this.task);
    }

    @Override
    public Class<? extends RbSoftwareUpgradeTaskBase> getTaskClass() {
        return RbSoftwareUpgradeTask.class;
    }

    public int getExecutionResult() {
        if (this.ctx.shouldAbort()) {
            return 2;
        }
        if (this.taskFailed) {
            return 3;
        }
        if (this.failures == 0) {
            return 1;
        }
        return 4;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BaseStationExecutor
    extends RbSoftwareUpgradeExecutorBase.BaseStationExecutorBase {
        private RbSoftwareUpgradeTask task;

        public BaseStationExecutor(RbBaseStationEquipment baseStation, RbSoftwareUpgradeTask task) {
            super(baseStation);
            this.task = task;
        }

        @Override
        public Runnable getNextOperation() {
            switch (this.currentOperation) {
                case -1: {
                    return null;
                }
                case 0: {
                    this.logOperationStatus(this.bsOperation, OperationStatus.IN_PROGRESS);
                    return new Runnable(){

                        public void run() {
                            BaseStationExecutor.this.runUpload();
                            RbSoftwareUpgradeTaskExecutor.this.scheduleNextOperation(BaseStationExecutor.this);
                        }
                    };
                }
                case 1: {
                    this.logOperationStatus(this.bsOperation, OperationStatus.IN_PROGRESS);
                    return new Runnable(){

                        public void run() {
                            BaseStationExecutor.this.runMakeOperationalSU();
                            RbSoftwareUpgradeTaskExecutor.this.scheduleNextOperation(BaseStationExecutor.this);
                        }
                    };
                }
                case 2: {
                    this.logOperationStatus(this.bsOperation, OperationStatus.IN_PROGRESS);
                    return new Runnable(){

                        public void run() {
                            BaseStationExecutor.this.runMakeOperationalAU();
                            RbSoftwareUpgradeTaskExecutor.this.scheduleNextOperation(BaseStationExecutor.this);
                        }
                    };
                }
                case 3: {
                    this.logOperationStatus(this.bsOperation, OperationStatus.IN_PROGRESS);
                    return new Runnable(){

                        public void run() {
                            BaseStationExecutor.this.runSetSUDefaultFile();
                            RbSoftwareUpgradeTaskExecutor.this.scheduleNextOperation(BaseStationExecutor.this);
                        }
                    };
                }
                case 4: {
                    this.logOperationStatus(this.bsOperation, OperationStatus.IN_PROGRESS);
                    return new Runnable(){

                        public void run() {
                            BaseStationExecutor.this.runMakeOperationalBS();
                            RbSoftwareUpgradeTaskExecutor.this.scheduleNextOperation(BaseStationExecutor.this);
                        }
                    };
                }
                case 5: {
                    this.logOperationStatus(this.bsOperation, OperationStatus.IN_PROGRESS);
                    return new Runnable(){

                        public void run() {
                            BaseStationExecutor.this.runMakeOperationalMBS();
                            RbSoftwareUpgradeTaskExecutor.this.scheduleNextOperation(BaseStationExecutor.this);
                        }
                    };
                }
            }
            this.logOperationStatus(this.bsOperation, OperationStatus.COMPLETED);
            return null;
        }

        private void runMakeOperationalMBS() {
            this.runMakeOperationalMBS(this.task.getMbstOperation(), this.task.getMbstFile());
        }

        private void runMakeOperationalBS() {
            this.runMakeOperationalBS(this.task.getNpuOperation(), this.task.getNpuFile());
        }

        private boolean checkAUSUFile(MOAccessSession access, List<?> equipmentForUpload, String ausuFile, Integer ausuOper, String[] bsFiles, int maxFiles, List<String> uploadFiles) throws MediationException {
            if (null == ausuOper || null == ausuFile || 0 == ausuFile.length() || uploadFiles.contains(ausuFile)) {
                return true;
            }
            switch (ausuOper) {
                case 0: {
                    return true;
                }
                case 1: {
                    break;
                }
                default: {
                    if (null == equipmentForUpload || !equipmentForUpload.isEmpty()) break;
                    return true;
                }
            }
            String simpleFile = ausuFile.substring(ausuFile.lastIndexOf(47) + 1);
            for (String bsFile : bsFiles) {
                if (!simpleFile.equals(bsFile)) continue;
                this.logStatus("Upload", OperationStatus.SKIPPED, "AlreadyInDevice", simpleFile);
                return true;
            }
            uploadFiles.add(ausuFile);
            if (bsFiles.length >= maxFiles) {
                if (this.task.getFileManagementPolicy() == 1) {
                    this.logStatus("Upload", OperationStatus.SKIPPED, "NoSpaceInBaseStation", ausuFile);
                    this.logOperationStatus(this.bsOperation, OperationStatus.SKIPPED, "UploadSkipped", new Object[0]);
                    return false;
                }
                ArrayList<String> files = new ArrayList<String>(1);
                files.add(ausuFile);
                return this.deleteOldestFiles(access, bsFiles, 1, files);
            }
            return true;
        }

        public void runMakeOperationalSU() {
            this.runMakeOperationalSU(new Integer[]{this.task.getSuOperation(), this.task.getSuSiOperation()}, new String[]{this.getSimpleFileName(this.task.getSuFile()), this.getSimpleFileName(this.task.getSuSiFile())});
        }

        public void runMakeOperationalAU() {
            this.runMakeOperationalAU(new Integer[]{this.task.getAuOperation()}, new String[]{this.getSimpleFileName(this.task.getAuFile())}, false);
            this.runMakeOperationalAU(new Integer[]{this.task.getAuSiOperation()}, new String[]{this.getSimpleFileName(this.task.getAuSiFile())}, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runUpload() {
            log.debug((Object)("[" + this.baseStation.getIPAddress() + "] runUpload"));
            ArrayList<String> uploadFiles = new ArrayList<String>();
            MOAccessSession access = null;
            try {
                RbSwUpgrade suFileData;
                String rbSuFiles;
                int maxNumberOfAuSuFiles;
                access = this.createMOAccessSession();
                boolean updateBSVersions = false;
                try {
                    boolean licensed = (Boolean)new CallableDatastoreDecorator((Callable)new Callable<Boolean>(){

                        @Override
                        public Boolean call() {
                            return LicenseHelper.isLicensed((Object)((Object)BaseStationExecutor.this.baseStation));
                        }
                    }).call();
                    if (!licensed) {
                        RbSoftwareUpgradeTaskExecutor.this.runtimeStatus.logOperationStatus(this.bsOperation, OperationStatus.SKIPPED, (Serializable)((Object)"UnlicensedBS"));
                        this.currentOperation = -1;
                        return;
                    }
                }
                catch (Exception e1) {
                    // empty catch block
                }
                if (this.baseStation instanceof RbBS) {
                    if (!this.checkBaseStationFile("npu", "", this.task.getNpuFile(), this.task.getNpuOperation(), uploadFiles, access)) {
                        this.currentOperation = -1;
                        return;
                    }
                    updateBSVersions = uploadFiles.size() > 0;
                } else if (this.baseStation instanceof RbMBS) {
                    if (!this.checkBaseStationFile("micro", ".res", this.task.getMbstFile(), this.task.getMbstOperation(), uploadFiles, access)) {
                        this.currentOperation = -1;
                        return;
                    }
                    updateBSVersions = uploadFiles.size() > 0;
                }
                int n = maxNumberOfAuSuFiles = this.baseStation.getSoftwareVersion().compareTo((Object)new DefaultVersion("4.0")) < 0 ? 3 : 4;
                if (this.baseStation instanceof RbBS) {
                    RbSwUpgrade auFileData = (RbSwUpgrade)((Object)access.fetchObject(null, RbSwUpgrade.class, new String[]{"rbSwAuFiles"}, "*").get(0));
                    String rbAuFiles = auFileData.getRbSwAuFiles();
                    String[] auFiles = rbAuFiles.length() > 0 ? rbAuFiles.split("\\;") : new String[]{};
                    List<String> uploadAUs = this.task.getAUSerialNumbers((RbBS)this.baseStation);
                    if (!this.checkAUSUFile(access, uploadAUs, this.task.getAuFile(), this.task.getAuOperation(), auFiles, maxNumberOfAuSuFiles, uploadFiles)) {
                        this.currentOperation = -1;
                        return;
                    }
                    if (!this.checkAUSUFile(access, uploadAUs, this.task.getAuSiFile(), this.task.getAuSiOperation(), auFiles, maxNumberOfAuSuFiles, uploadFiles)) {
                        this.currentOperation = -1;
                        return;
                    }
                }
                String[] suFiles = (rbSuFiles = (suFileData = (RbSwUpgrade)((Object)access.fetchObject(null, RbSwUpgrade.class, new String[]{"rbSwSuFiles"}, "*").get(0))).getRbSwSuFiles()).length() > 0 ? rbSuFiles.split("\\;") : new String[]{};
                List<RbSU> uploadSUs = this.task.getSUList(this.baseStation);
                if (!this.checkAUSUFile(access, uploadSUs, this.task.getSuFile(), this.task.getSuOperation(), suFiles, maxNumberOfAuSuFiles, uploadFiles)) {
                    this.currentOperation = -1;
                    return;
                }
                if (!this.checkAUSUFile(access, uploadSUs, this.task.getSuSiFile(), this.task.getSuSiOperation(), suFiles, maxNumberOfAuSuFiles, uploadFiles)) {
                    this.currentOperation = -1;
                    return;
                }
                log.debug((Object)("[" + this.baseStation.getIPAddress() + "] Files to upload: " + uploadFiles));
                if (!this.uploadFiles(uploadFiles, SW_UPGRADE_WAIT_AFTER_SUCCESSFUL_UPLOAD)) {
                    this.currentOperation = -1;
                    return;
                }
                if (updateBSVersions) {
                    super.updateBSVersions(access);
                }
                ++this.currentOperation;
            }
            catch (MediationException e) {
                this.currentOperation = -1;
                log.debug((Object)"", (Throwable)e);
                this.logOperationStatus(this.bsOperation, OperationStatus.FAILED, "ErrorMessage", null, this.getMessage(e));
            }
            catch (Exception e) {
                this.currentOperation = -1;
                log.error((Object)"", (Throwable)e);
                this.logOperationStatus(this.bsOperation, OperationStatus.FAILED, "ErrorMessage", null, this.getMessage(e));
            }
            finally {
                this.closeMOAccessSession(access);
            }
        }

        private boolean deleteOldestFiles(MOAccessSession access, String[] files, int toDelete, ArrayList<String> filesToNotDelete) throws MediationException {
            if (toDelete < 1) {
                return true;
            }
            Arrays.sort(files, new RbSoftwareUpgradeUtil.FirmwareFileComparator());
            StringBuilder filesToDelete = new StringBuilder();
            for (int i = 0; i < toDelete; ++i) {
                if (filesToNotDelete.contains(files[i])) continue;
                filesToDelete.append(files[i]);
                filesToDelete.append(";");
            }
            if (filesToDelete.length() > 0) {
                filesToDelete.setLength(filesToDelete.length() - 1);
                String fd = filesToDelete.toString();
                try {
                    this.logStatus("Delete", OperationStatus.IN_PROGRESS, fd);
                    BaseStationDeleteFileCommand deleteCommand = new BaseStationDeleteFileCommand();
                    deleteCommand.setRbSwUpgradeDeleteFiles(filesToDelete.toString());
                    access.commitObject(null, (Object)deleteCommand);
                    this.logStatus("Delete", OperationStatus.COMPLETED, fd);
                    return true;
                }
                catch (MediationException e) {
                    this.logStatus("Delete", OperationStatus.FAILED, "ErrorMessage", fd, this.getMessage(e));
                    this.logOperationStatus(this.bsOperation, OperationStatus.FAILED, "DeleteOldestFilesFailed", new Object[0]);
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runSetSUDefaultFile() {
            if (!this.task.isSetSUDefault() || null == this.task.getSuOperation() || 1 == this.task.getSuOperation() || this.baseStation.isIPCSSwitchingMode()) {
                ++this.currentOperation;
                return;
            }
            MOAccessSession access = null;
            try {
                access = this.createMOAccessSession();
                SetSUDefaultCommand command = new SetSUDefaultCommand();
                switch (this.task.getSuOperation()) {
                    case 0: {
                        command.setRbSuSwDefaultAction(SetSUDefaultCommand.RbSuSwDefaultActionNone);
                        break;
                    }
                    case 3: {
                        command.setRbSuSwDefaultAction(SetSUDefaultCommand.RbSuSwDefaultActionPutToShadow);
                        break;
                    }
                    case 4: {
                        command.setRbSuSwDefaultAction(SetSUDefaultCommand.RbSuSwDefaultActionRunFromShadow);
                        break;
                    }
                    case 2: {
                        command.setRbSuSwDefaultAction(SetSUDefaultCommand.RbSuSwDefaultActionMakeOperational);
                    }
                }
                command.setRbSuSwDefaultFile(this.task.getSuFile().substring(this.task.getSuFile().lastIndexOf(47) + 1));
                access.commitObject(null, (Object)command);
                this.logStatus("SetSUDefault", OperationStatus.COMPLETED, this.getBSOperationName());
            }
            catch (MediationException e) {
                this.logStatus("SetSUDefault", OperationStatus.FAILED, "ErrorMessage", this.getBSOperationName(), this.getMessage(e));
            }
            catch (Exception e) {
                this.logStatus("SetSUDefault", OperationStatus.FAILED, "ErrorMessage", this.getBSOperationName(), this.getMessage(e));
            }
            finally {
                ++this.currentOperation;
                this.closeMOAccessSession(access);
            }
        }
    }
}

