/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.softwareupgrade;

import com.bwanms.gui.Internationalizer;
import com.bwanms.model.Equipment;
import com.bwanms.model.Task;
import com.bwanms.model.Validatable;
import com.bwanms.persistence.Datastore;
import com.bwanms.persistence.RunnableDatastoreDecorator;
import com.bwanms.rb.model.RbAU;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbSU;
import com.bwanms.rb.tasks.softwareupgrade.RbSwUpgradeEquipmentWeakAssociation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public abstract class RbSoftwareUpgradeTaskBase
extends Task
implements Validatable {
    public static final int OP_NONE = 0;
    public static final int OP_LOAD_FIRMWARE = 1;
    public static final int OP_MAKE_OPERATIONAL = 2;
    public static final int OP_LOAD_TO_SHADOW = 3;
    public static final int OP_RUN_FROM_SHADOW = 4;
    public static final int FILE_POLICY_SKIP = 1;
    public static final int FILE_POLICY_DELETE_OLDEST = 2;
    public static final int SHADOW_POLICY_SKIP = 1;
    public static final int SHADOW_POLICY_MAKE_OP = 2;
    public static final int SEL_MODE_FULL_BS = 0;
    public static final int SEL_MODE_INC = 1;
    public static final String FILE_NAME_NONE = "none";
    private Integer fileManagementPolicy = 1;
    private Integer shadowBSPolicy = 1;
    private List<RbSwUpgradeEquipmentWeakAssociation> targetEquipment;
    private Integer equipmentSelectionMode = 0;

    public Integer getFileManagementPolicy() {
        return this.fileManagementPolicy;
    }

    public void setFileManagementPolicy(Integer fileManagementPolicy) {
        this.fileManagementPolicy = fileManagementPolicy;
    }

    public Integer getShadowBSPolicy() {
        return this.shadowBSPolicy;
    }

    public void setShadowBSPolicy(Integer shadowBSPolicy) {
        this.shadowBSPolicy = shadowBSPolicy;
    }

    @Transient
    public List<RbBaseStationEquipment> getBaseStations() {
        ArrayList<RbBaseStationEquipment> baseStations = new ArrayList<RbBaseStationEquipment>();
        for (RbSwUpgradeEquipmentWeakAssociation assoc : this.targetEquipment) {
            Equipment equipment = (Equipment)assoc.getEntity();
            if (!(equipment instanceof RbBaseStationEquipment) || !assoc.getUpgrade().booleanValue() && (this.isFullBSSelectionMode() || !this.hasBSUnitsToUpgrade((RbBaseStationEquipment)equipment))) continue;
            baseStations.add((RbBaseStationEquipment)equipment);
        }
        return baseStations;
    }

    public void validate(List<InvalidValue> invalidValues) {
        Internationalizer i18n = Internationalizer.getInternationalizer(RbSoftwareUpgradeTaskBase.class);
        super.validate(invalidValues);
        for (RbSwUpgradeEquipmentWeakAssociation assoc : this.getTargetEquipment()) {
            if (!assoc.getUpgrade().booleanValue()) continue;
            return;
        }
        invalidValues.add(new InvalidValue(i18n.translateString("NoDevicesSelected"), RbSoftwareUpgradeTaskBase.class, "", (Object)"", (Object)this));
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinTable(table=@Table(name="RbSwUpgrTask_EquipmentWAssoc"))
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<RbSwUpgradeEquipmentWeakAssociation> getTargetEquipment() {
        if (this.targetEquipment == null) {
            this.targetEquipment = new ArrayList<RbSwUpgradeEquipmentWeakAssociation>();
        }
        return this.targetEquipment;
    }

    public void setTargetEquipment(List<RbSwUpgradeEquipmentWeakAssociation> targetEquipment) {
        this.targetEquipment = targetEquipment;
    }

    public Integer getEquipmentSelectionMode() {
        return this.equipmentSelectionMode;
    }

    public void setEquipmentSelectionMode(Integer equipmentSelectionMode) {
        this.equipmentSelectionMode = equipmentSelectionMode;
    }

    @Transient
    public boolean shouldUpgradeNPU(RbBaseStationEquipment bs) {
        for (RbSwUpgradeEquipmentWeakAssociation assoc : this.targetEquipment) {
            Equipment equipment = (Equipment)assoc.getEntity();
            if (equipment.getId() != bs.getId()) continue;
            return assoc.getUpgrade();
        }
        return false;
    }

    @Transient
    public List<String> getAUSerialNumbers(RbBS bs) {
        if (this.isFullBSSelectionMode()) {
            return null;
        }
        ArrayList<String> auSerialNumbers = new ArrayList<String>();
        for (RbSwUpgradeEquipmentWeakAssociation assoc : this.targetEquipment) {
            RbAU au;
            Equipment equipment;
            if (!assoc.getUpgrade().booleanValue() || !((equipment = (Equipment)assoc.getEntity()) instanceof RbAU) || (au = (RbAU)equipment).getManagerBS() == null || au.getManagerBS().getId() != bs.getId()) continue;
            auSerialNumbers.add(au.getSerialNumber());
        }
        return auSerialNumbers;
    }

    @Transient
    public List<RbSU> getSUList(final RbBaseStationEquipment bs) {
        final ArrayList<RbSU> ret = new ArrayList<RbSU>();
        if (this.isFullBSSelectionMode()) {
            new RunnableDatastoreDecorator(new Runnable(){

                public void run() {
                    RbBaseStationEquipment bsEq = (RbBaseStationEquipment)((Object)Datastore.session().get(((Object)((Object)bs)).getClass(), (Serializable)Long.valueOf(bs.getId())));
                    ret.addAll(bsEq.getManagedSUs());
                }
            }).run();
        } else {
            for (RbSwUpgradeEquipmentWeakAssociation assoc : this.targetEquipment) {
                RbSU su;
                Equipment equipment;
                if (!assoc.getUpgrade().booleanValue() || !((equipment = (Equipment)assoc.getEntity()) instanceof RbSU) || (su = (RbSU)equipment).getManagerBS() == null || su.getManagerBS().getId() != bs.getId()) continue;
                ret.add(su);
            }
        }
        return ret;
    }

    @Transient
    public boolean isFullBSSelectionMode() {
        return this.equipmentSelectionMode == 0;
    }

    @Transient
    private boolean hasBSUnitsToUpgrade(RbBaseStationEquipment bs) {
        for (RbSwUpgradeEquipmentWeakAssociation assoc : this.targetEquipment) {
            RbSU su;
            RbAU au;
            Equipment equipment;
            if (!assoc.getUpgrade().booleanValue() || !((equipment = (Equipment)assoc.getEntity()) instanceof RbAU ? (au = (RbAU)equipment).getManagerBS().getId() == bs.getId() : equipment instanceof RbSU && (su = (RbSU)equipment).getManagerBS().getId() == bs.getId())) continue;
            return true;
        }
        return false;
    }
}

