/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.softwareupgrade;

import com.bwanms.gui.Internationalizer;
import com.bwanms.mediation.FileTransferEvent;
import com.bwanms.mediation.FileTransferRequest;
import com.bwanms.mediation.FileTransferService;
import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.mediation.MediationServiceRegistry;
import com.bwanms.mediation.TftpFileTransferRequest;
import com.bwanms.mediation.TftpFileTransferService;
import com.bwanms.mediation.filetransfer.SynchronousFileTransfer;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.model.TaskExecutionContext;
import com.bwanms.model.TaskExecutor;
import com.bwanms.model.TaskRuntimeStatus;
import com.bwanms.persistence.Datastore;
import com.bwanms.persistence.RunnableDatastoreDecorator;
import com.bwanms.protocols.snmp.SNMPTimeoutException;
import com.bwanms.protocols.tftp.TftpTimeoutException;
import com.bwanms.rb.mo.RbAuConfigEntry;
import com.bwanms.rb.mo.RbNpuConfigEntry;
import com.bwanms.rb.mo.RbRegisteredSuEntry;
import com.bwanms.rb.mo.RbSwAuConfigEntry;
import com.bwanms.rb.mo.RbSwRegisteredSuEntry;
import com.bwanms.rb.mo.RbSysMicroBSTConfig;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbMBS;
import com.bwanms.rb.model.RbSU;
import com.bwanms.rb.tasks.softwareupgrade.RbSoftwareUpgradeTask;
import com.bwanms.rb.tasks.softwareupgrade.RbSoftwareUpgradeTaskBase;
import com.bwanms.rb.tasks.softwareupgrade.RbSoftwareUpgradeTaskInterpretor;
import com.bwanms.rb.tasks.softwareupgrade.RbSoftwareUpgradeUtil;
import com.bwanms.rb.tasks.softwareupgrade.RbSwUpgradeLogEntry;
import com.bwanms.services.EntityNotFoundException;
import com.bwanms.util.ExecutorUtils;
import com.bwanms.util.MacAddress;
import com.bwanms.util.Settings;
import com.bwanms.util.task.Operation;
import com.bwanms.util.task.OperationStatus;
import com.bwanms.util.task.OperationTaskRuntimeStatus;
import com.bwanms.util.version.impl.DefaultVersion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RbSoftwareUpgradeExecutorBase
implements TaskExecutor {
    private static final int tftpDefaultTimeout = Integer.getInteger("com.bwanms.rb.tasks.softwareupgrade.tftpDefaultTimeout", 5000);
    private static final int tftpDefaultRetries = Integer.getInteger("com.bwanms.rb.tasks.softwareupgrade.tftpDefaultRetries", 3);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbSoftwareUpgradeExecutorBase.class);
    private static final Logger log = Logger.getLogger(RbSoftwareUpgradeExecutorBase.class);
    private static String[] SU_Entry_Fields = new String[]{"rbSuMacAddr", "rbSuPersistence", "rbSuRegistrationState", "rbSuRunningSoftware", "rbSuOperSwFileName", "rbSuShadowSwFileName"};
    private static String[] SU_Entry_4_x_Fields = new String[]{"rbSuMacAddr", "rbSuPersistence", "rbSuRegistrationState", "rbSuRunningSoftware", "rbSuOperSwFileName", "rbSuShadowSwFileName", "rbSuAirInterfaceType", "rbAuId"};
    protected static String STR_OP_MAKE_OPERATIONAL = "MakeOperational";
    protected static String STR_OP_LOAD_TO_SHADOW = "LoadToShadow";
    protected static String STR_OP_RUN_FROM_SHADOW = "RunFromShadow";
    protected OperationTaskRuntimeStatus runtimeStatus;
    protected TaskExecutionContext ctx;
    protected RbSoftwareUpgradeTaskBase task;
    private ExecutorService executor;
    private int runningBaseStations;
    protected int failures;
    protected boolean taskFailed;
    private Operation taskOperation;

    public RbSoftwareUpgradeExecutorBase(RbSoftwareUpgradeTaskBase task) {
        this.task = task;
        this.runningBaseStations = 0;
        this.failures = 0;
        this.taskFailed = false;
    }

    public void execute(TaskExecutionContext ctx) {
        this.ctx = ctx;
        this.executor = Executors.newFixedThreadPool(10);
        this.taskOperation = new Operation(null, "TaskTitle", new Object[]{this.task.getName()});
        this.runtimeStatus = new OperationTaskRuntimeStatus(this.taskOperation);
        this.runtimeStatus.logOperationStatus(this.taskOperation, OperationStatus.IN_PROGRESS);
        new RunnableDatastoreDecorator(new Runnable(){

            public void run() {
                RbSoftwareUpgradeExecutorBase.this.task = (RbSoftwareUpgradeTaskBase)((Object)Datastore.session().get(RbSoftwareUpgradeExecutorBase.this.getTaskClass(), (Serializable)Long.valueOf(RbSoftwareUpgradeExecutorBase.this.task.getId())));
                new RbSoftwareUpgradeTaskInterpretor().prepareFetch((Object)RbSoftwareUpgradeExecutorBase.this.task);
            }
        }).run();
        List<RbBaseStationEquipment> baseStations = this.task.getBaseStations();
        if (baseStations != null && baseStations.size() > 0) {
            ArrayList<BaseStationExecutorBase> bsExecutors = new ArrayList<BaseStationExecutorBase>();
            for (RbBaseStationEquipment bs : baseStations) {
                if (bs == null) continue;
                BaseStationExecutorBase exec = this.createBaseStationExecutor(bs);
                ++this.runningBaseStations;
                bsExecutors.add(exec);
            }
            for (BaseStationExecutorBase exec : bsExecutors) {
                this.scheduleNextOperation(exec);
            }
        } else {
            this.runtimeStatus.logOperationStatus(this.taskOperation, OperationStatus.FAILED, (Serializable)((Object)"NoBaseStations"));
            this.taskFailed = true;
            this.shutdown();
        }
    }

    public abstract BaseStationExecutorBase createBaseStationExecutor(RbBaseStationEquipment var1);

    public abstract Class<? extends RbSoftwareUpgradeTaskBase> getTaskClass();

    private void shutdown() {
        if (log.isDebugEnabled()) {
            log.debug((Object)this.getReport());
        }
        this.ctx.taskFinished();
        ExecutorUtils.shutdownAndWait((String)"RbSwUpgrade", (ExecutorService)this.executor);
    }

    protected void scheduleNextOperation(BaseStationExecutorBase bsExec) {
        Runnable nextOperation = bsExec.getNextOperation();
        if (nextOperation == null || this.ctx.shouldAbort()) {
            if (this.ctx.shouldAbort()) {
                bsExec.logAbort();
            }
            --this.runningBaseStations;
            if (this.runningBaseStations == 0) {
                if (this.ctx.shouldAbort()) {
                    this.runtimeStatus.logOperationStatus(this.taskOperation, OperationStatus.ABORTED);
                } else {
                    this.runtimeStatus.logOperationStatus(this.taskOperation, this.failures == 0 ? OperationStatus.COMPLETED : OperationStatus.COMPLETED_WITH_ERRORS);
                }
                this.shutdown();
            }
        } else {
            this.executor.execute(nextOperation);
        }
    }

    public TaskRuntimeStatus getStatus(Object clientData) {
        int index = clientData == null ? 0 : (Integer)clientData;
        return this.runtimeStatus.getDiff(index);
    }

    public String getReport() {
        return this.runtimeStatus.toXMLString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class BaseStationExecutorBase {
        protected int currentOperation = 0;
        protected RbBaseStationEquipment baseStation;
        protected Operation bsOperation;
        private Map<String, Operation> operationMap = new HashMap<String, Operation>();
        private Object bsResetCommand;
        private Object bsRunFromShadowCommand;
        private Object bsMakeOperationalCommand;
        private String opVersion;
        private String shadowVersion;
        private String runningVersion;

        public BaseStationExecutorBase(RbBaseStationEquipment baseStation) {
            this.baseStation = baseStation;
            String opName = "";
            if (baseStation instanceof RbBS) {
                opName = "BSOp";
                this.bsResetCommand = RbSoftwareUpgradeUtil.createNPUResetCommand();
                this.bsRunFromShadowCommand = RbSoftwareUpgradeUtil.createNPURunFromShadowCommand();
                this.bsMakeOperationalCommand = RbSoftwareUpgradeUtil.createNPUMakeOperationalCommand();
            } else if (baseStation instanceof RbMBS) {
                opName = "MBSOp";
                this.bsResetCommand = RbSoftwareUpgradeUtil.createMBSResetCommand();
                this.bsRunFromShadowCommand = RbSoftwareUpgradeUtil.createMBSRunFromShadowCommand();
                this.bsMakeOperationalCommand = RbSoftwareUpgradeUtil.createMBSMakeOperationalCommand();
            } else {
                throw new RuntimeException("Unknown instanceof baseStation: " + ((Object)((Object)this.baseStation)).getClass().getName());
            }
            this.bsOperation = RbSoftwareUpgradeExecutorBase.this.runtimeStatus.addOperation(RbSoftwareUpgradeExecutorBase.this.taskOperation, opName, new Object[]{baseStation.getName() + " " + baseStation.getIPAddress(), ""});
            this.logOperationStatus(this.bsOperation, OperationStatus.IN_PROGRESS);
            try {
                this.updateBSVersions(this.createMOAccessSession());
            }
            catch (MediationException e) {
                log.debug((Object)"", (Throwable)e);
                this.logOperationStatus(this.bsOperation, OperationStatus.FAILED, "ErrorMessage", null, this.getMessage(e));
                this.currentOperation = -1;
            }
        }

        public void logAbort() {
            this.logOperationStatus(this.bsOperation, OperationStatus.ABORTED);
        }

        public abstract Runnable getNextOperation();

        protected void logStatus(String operation, OperationStatus status, String target) {
            this.logStatus(operation, status, null, target);
        }

        protected void logStatus(String operation, OperationStatus status, String message, Object ... params) {
            Operation op;
            String target;
            String translated = message;
            String string = target = params.length == 0 ? null : (String)params[0];
            if (message != null) {
                translated = i18n.translateString(message, params);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(target + " " + operation + " " + status + (translated != null ? ": " + translated : "")));
            }
            if ((op = this.operationMap.get(target + "#" + operation)) == null) {
                op = RbSoftwareUpgradeExecutorBase.this.runtimeStatus.addOperation(this.bsOperation, operation, new Object[]{target});
                this.operationMap.put(target + "#" + operation, op);
            }
            this.logOperationStatus(op, status, message, params);
        }

        protected void logOperationStatus(Operation operation, OperationStatus status) {
            if (status == OperationStatus.FAILED) {
                ++RbSoftwareUpgradeExecutorBase.this.failures;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(operation.getTranslatedName(i18n) + " " + status));
            }
            RbSoftwareUpgradeExecutorBase.this.runtimeStatus.logOperationStatus(operation, status);
        }

        protected void logOperationStatus(Operation operation, OperationStatus status, String message, Object ... params) {
            if (status == OperationStatus.FAILED) {
                ++RbSoftwareUpgradeExecutorBase.this.failures;
            }
            String translated = message;
            if (message != null) {
                translated = i18n.translateString(message, params);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(operation.getTranslatedName(i18n) + " " + status + (translated != null ? ": " + translated : "")));
            }
            RbSoftwareUpgradeExecutorBase.this.runtimeStatus.logOperationStatus(operation, status, (Serializable)((Object)message), params);
        }

        protected boolean uploadFiles(List<String> uploadFiles) {
            return this.uploadFiles(uploadFiles, 0L);
        }

        protected boolean uploadFiles(List<String> uploadFiles, long waitAfterSuccessfulUpload) {
            if (uploadFiles == null || uploadFiles.size() == 0) {
                this.logStatus("Upload", OperationStatus.SKIPPED, "NoFilesToUpload", "NONE");
                return true;
            }
            TftpFileTransferService fts = MediationServiceRegistry.getTftpFileTransferService();
            ArrayList<String> failedUploads = new ArrayList<String>(uploadFiles.size());
            for (String uploadFile : uploadFiles) {
                String simpleFileName = uploadFile.substring(uploadFile.lastIndexOf(47) + 1);
                SynchronousFileTransfer syncFTS = new SynchronousFileTransfer((FileTransferService)fts, "topic/TftpMediationTopic");
                this.logStatus("Upload", OperationStatus.IN_PROGRESS, simpleFileName);
                FileTransferEvent res = syncFTS.executeTransfer((FileTransferRequest)new TftpFileTransferRequest(this.baseStation.getIPAddress(), tftpDefaultRetries, tftpDefaultTimeout, uploadFile, simpleFileName, 0, null), 600000L);
                if (res == null || res.getEventType() != 3) {
                    String message = null;
                    if (res != null && res.getError() != null) {
                        message = this.getMessage(res.getError());
                    }
                    this.logStatus("Upload", OperationStatus.FAILED, "ErrorMessage", simpleFileName, message);
                    failedUploads.add(simpleFileName);
                    continue;
                }
                this.logStatus("Upload", OperationStatus.COMPLETED, simpleFileName);
                if (waitAfterSuccessfulUpload <= 0L) continue;
                try {
                    Thread.sleep(waitAfterSuccessfulUpload);
                }
                catch (InterruptedException e) {
                    log.debug((Object)"waitAfterSuccessfulUpload interrupted.");
                }
            }
            if (failedUploads.size() > 0) {
                String message = "FailedToUploadFiles";
                StringBuilder fileNames = new StringBuilder();
                for (String fileName : failedUploads) {
                    fileNames.append(fileName).append(", ");
                }
                fileNames.setLength(fileNames.length() - 2);
                this.logOperationStatus(this.bsOperation, OperationStatus.FAILED, message, fileNames.toString());
                return false;
            }
            return true;
        }

        protected void waitForBaseStation(long waitTime) throws EntityNotFoundException, TimeoutException {
            long stepTime = 2L * Settings.instance().getPollingServiceReachableSynchronizationPeriod();
            long startTime = System.currentTimeMillis();
            String sleeping = "[" + this.baseStation.getIPAddress() + "] sleeping for " + stepTime / 1000L + "sec";
            while (System.currentTimeMillis() - startTime < waitTime) {
                log.debug((Object)sleeping);
                try {
                    Thread.sleep(stepTime);
                }
                catch (InterruptedException e) {
                    log.debug((Object)"", (Throwable)e);
                }
                new RunnableDatastoreDecorator(new Runnable(){

                    public void run() {
                        BaseStationExecutorBase.this.baseStation = (RbBaseStationEquipment)((Object)Datastore.session().get(RbBaseStationEquipment.class, (Serializable)Long.valueOf(BaseStationExecutorBase.this.baseStation.getId())));
                    }
                }).run();
                if (this.baseStation == null) {
                    throw new EntityNotFoundException();
                }
                if (this.baseStation.getState() != 0) continue;
                return;
            }
            throw new TimeoutException();
        }

        protected void runMakeOperationalMBS(Integer mbstOperation, String mbstFile) {
            if (!(this.baseStation instanceof RbMBS) || mbstOperation == null || mbstOperation != 2 && mbstOperation != 4 || !RbSoftwareUpgradeExecutorBase.this.task.shouldUpgradeNPU(this.baseStation)) {
                ++this.currentOperation;
                return;
            }
            if (mbstOperation == 4) {
                this.runMakeOperationalBaseStation("micro", ".res", mbstFile, this.bsResetCommand, this.bsRunFromShadowCommand, this.bsMakeOperationalCommand, true);
            } else {
                this.runMakeOperationalBaseStation("micro", ".res", mbstFile, this.bsResetCommand, this.bsRunFromShadowCommand, this.bsMakeOperationalCommand, false);
            }
        }

        protected void runMakeOperationalBS(Integer npuOperation, String npuFile) {
            if (!(this.baseStation instanceof RbBS) || npuOperation == null || npuOperation != 2 && npuOperation != 4 || !RbSoftwareUpgradeExecutorBase.this.task.shouldUpgradeNPU(this.baseStation)) {
                ++this.currentOperation;
                return;
            }
            if (npuOperation == 4) {
                this.runMakeOperationalBaseStation("npu", "", npuFile, this.bsResetCommand, this.bsRunFromShadowCommand, this.bsMakeOperationalCommand, true);
            } else {
                this.runMakeOperationalBaseStation("npu", "", npuFile, this.bsResetCommand, this.bsRunFromShadowCommand, this.bsMakeOperationalCommand, false);
            }
        }

        protected boolean checkBaseStationFile(String prefix, String suffix, String file, Integer operation, List<String> uploadFiles, MOAccessSession access) {
            if (operation == null || 0 == operation || !RbSoftwareUpgradeExecutorBase.this.task.shouldUpgradeNPU(this.baseStation)) {
                return true;
            }
            String simpleFile = this.getSimpleFileName(file);
            prefix = prefix + "_";
            String opFileName = RbSoftwareUpgradeUtil.getFileNameFromVersion(this.opVersion, prefix, suffix);
            String shadowFileName = RbSoftwareUpgradeUtil.getFileNameFromVersion(this.shadowVersion, prefix, suffix);
            String runningFileName = RbSoftwareUpgradeUtil.getFileNameFromVersion(this.runningVersion, prefix, suffix);
            if (!opFileName.equals(simpleFile) && !shadowFileName.equals(simpleFile)) {
                if (runningFileName.equals(shadowFileName)) {
                    if (RbSoftwareUpgradeExecutorBase.this.task.getShadowBSPolicy() == null || RbSoftwareUpgradeExecutorBase.this.task.getShadowBSPolicy() == 1) {
                        this.logStatus("Upload", OperationStatus.FAILED, "BSRunningFromShadow", simpleFile);
                        this.logOperationStatus(this.bsOperation, OperationStatus.FAILED, "UploadFailed", new Object[0]);
                        return false;
                    }
                    try {
                        access.commitObject(null, this.bsMakeOperationalCommand);
                        this.logStatus("Upload", OperationStatus.IN_PROGRESS, "MakeOperational", simpleFile);
                    }
                    catch (MediationException e) {
                        this.logStatus("Upload", OperationStatus.FAILED, "FailedToMakeOperational", simpleFile);
                        this.logOperationStatus(this.bsOperation, OperationStatus.FAILED, "UploadFailed", new Object[0]);
                        return false;
                    }
                }
                uploadFiles.add(file);
            } else {
                this.logStatus("Upload", OperationStatus.SKIPPED, "AlreadyInDevice", simpleFile);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runMakeOperationalBaseStation(String prefix, String suffix, String file, Object resetCommand, Object runFromShadowCommand, Object makeOperationalCommand, boolean forceRunFromShadow) {
            String target = this.getBSOperationName();
            String operationName = forceRunFromShadow ? STR_OP_RUN_FROM_SHADOW : STR_OP_MAKE_OPERATIONAL;
            prefix = prefix + "_";
            String simpleFile = null;
            String opFileName = null;
            String shadowFileName = null;
            String runningFileName = null;
            try {
                opFileName = RbSoftwareUpgradeUtil.getFileNameFromVersion(this.opVersion, prefix, suffix);
                shadowFileName = RbSoftwareUpgradeUtil.getFileNameFromVersion(this.shadowVersion, prefix, suffix);
                runningFileName = RbSoftwareUpgradeUtil.getFileNameFromVersion(this.runningVersion, prefix, suffix);
                if (null != file && -1 != file.indexOf(47)) {
                    simpleFile = file.substring(file.lastIndexOf(47) + 1);
                }
                if (runningFileName.equals(simpleFile) && opFileName.equals(simpleFile)) {
                    this.logStatus(operationName, OperationStatus.SKIPPED, "AlreadyRunning", target);
                    ++this.currentOperation;
                    return;
                }
            }
            catch (Exception e) {
                this.logStatus(operationName, OperationStatus.SKIPPED, "ErrorReadingBSVersions", target);
                this.currentOperation = -1;
                return;
            }
            MOAccessSession access = null;
            if (forceRunFromShadow) {
                boolean updateBSVersions;
                block34: {
                    boolean makeOperationalError = false;
                    updateBSVersions = false;
                    access = this.createMOAccessSession();
                    try {
                        access.commitObject(null, runFromShadowCommand);
                        this.logStatus(operationName, OperationStatus.IN_PROGRESS, "PerformingRunFromShadow", target);
                        updateBSVersions = true;
                        this.waitForBaseStation(600000L);
                    }
                    catch (MediationException e) {
                        log.debug((Object)"", (Throwable)e);
                        this.logStatus(operationName, OperationStatus.FAILED, "ErrorMessage", target, this.getMessage(e));
                    }
                    catch (EntityNotFoundException e) {
                        this.logStatus(operationName, OperationStatus.FAILED, "BSWasDeleted", this.getBSOperationName());
                    }
                    catch (TimeoutException e) {
                        this.logStatus(operationName, OperationStatus.FAILED, "TimedOutWhileWaiting", target);
                    }
                    if (!makeOperationalError) break block34;
                    this.logOperationStatus(this.bsOperation, OperationStatus.FAILED, "FailedToMakeOperational", new Object[0]);
                    this.currentOperation = -1;
                    this.closeMOAccessSession(access);
                    return;
                }
                try {
                    if (updateBSVersions) {
                        this.updateBSVersions(access);
                    }
                    this.logStatus(operationName, OperationStatus.COMPLETED, target);
                    ++this.currentOperation;
                    this.closeMOAccessSession(access);
                    return;
                }
                catch (MediationException e) {
                    try {
                        log.debug((Object)"", (Throwable)e);
                        this.logStatus(operationName, OperationStatus.FAILED, "ErrorMessage", target, this.getMessage(e));
                        this.logOperationStatus(this.bsOperation, OperationStatus.FAILED, "FailedToMakeRunFromShadow", new Object[0]);
                        this.currentOperation = -1;
                        this.closeMOAccessSession(access);
                        return;
                    }
                    catch (Throwable throwable) {
                        this.closeMOAccessSession(access);
                        throw throwable;
                    }
                }
            }
            try {
                boolean reset;
                boolean updateBSVersions = false;
                access = this.createMOAccessSession();
                boolean makeOperationalError = false;
                boolean runFromShadow = shadowFileName.equals(simpleFile) && !runningFileName.equals(simpleFile);
                boolean bl = reset = opFileName.equals(simpleFile) && !runningFileName.equals(simpleFile);
                if (runFromShadow || reset) {
                    try {
                        access.commitObject(null, runFromShadow ? runFromShadowCommand : resetCommand);
                        this.logStatus(operationName, OperationStatus.IN_PROGRESS, runFromShadow ? "RunFromShadow" : "Reset", target);
                        updateBSVersions = true;
                        this.waitForBaseStation(600000L);
                    }
                    catch (MediationException e) {
                        makeOperationalError = true;
                        log.debug((Object)"", (Throwable)e);
                        this.logStatus(operationName, OperationStatus.FAILED, "ErrorMessage", target, this.getMessage(e));
                    }
                    catch (EntityNotFoundException e) {
                        makeOperationalError = true;
                        this.logStatus(operationName, OperationStatus.FAILED, "BSWasDeleted", this.getBSOperationName());
                    }
                    catch (TimeoutException e) {
                        makeOperationalError = true;
                        this.logStatus(operationName, OperationStatus.FAILED, "TimedOutWhileWaiting", target);
                    }
                }
                if (makeOperationalError) {
                    this.logOperationStatus(this.bsOperation, OperationStatus.FAILED, "FailedToMakeOperational", new Object[0]);
                    this.currentOperation = -1;
                    return;
                }
                if (updateBSVersions) {
                    this.updateBSVersions(access);
                    opFileName = RbSoftwareUpgradeUtil.getFileNameFromVersion(this.opVersion, prefix, suffix);
                    shadowFileName = RbSoftwareUpgradeUtil.getFileNameFromVersion(this.shadowVersion, prefix, suffix);
                    runningFileName = RbSoftwareUpgradeUtil.getFileNameFromVersion(this.runningVersion, prefix, suffix);
                }
                if (!runningFileName.equals(simpleFile)) {
                    this.logStatus(STR_OP_MAKE_OPERATIONAL, OperationStatus.FAILED, "WrongVersion", target);
                    this.logOperationStatus(this.bsOperation, OperationStatus.FAILED, "FailedToMakeOperational", new Object[0]);
                    this.currentOperation = -1;
                    return;
                }
                if (shadowFileName.equals(simpleFile)) {
                    try {
                        access.commitObject(null, makeOperationalCommand);
                    }
                    catch (MediationException e) {
                        log.debug((Object)"", (Throwable)e);
                        this.logStatus(operationName, OperationStatus.FAILED, "ErrorMessage", target, this.getMessage(e));
                        this.logOperationStatus(this.bsOperation, OperationStatus.FAILED, "FailedToMakeOperational", new Object[0]);
                        this.currentOperation = -1;
                        this.closeMOAccessSession(access);
                        return;
                    }
                }
                this.logStatus(operationName, OperationStatus.COMPLETED, target);
                ++this.currentOperation;
                return;
            }
            catch (MediationException e) {
                log.debug((Object)"", (Throwable)e);
                this.logStatus(operationName, OperationStatus.FAILED, "ErrorMessage", target, this.getMessage(e));
                this.logOperationStatus(this.bsOperation, OperationStatus.FAILED, "FailedToMakeOperational", new Object[0]);
                this.currentOperation = -1;
                return;
            }
            finally {
                this.closeMOAccessSession(access);
            }
        }

        protected void updateBSVersions(MOAccessSession access) throws MediationException {
            boolean isOperationalVersionRunning;
            log.debug((Object)"Update baseStation's versions.");
            if (this.baseStation instanceof RbMBS) {
                RbSysMicroBSTConfig mbs = (RbSysMicroBSTConfig)((Object)access.fetchObject(null, RbSysMicroBSTConfig.class, new String[]{"rbMBSTOperSwVersion", "rbMBSTShadowSwVersion", "rbMBSTRunningSoftware"}, "*").get(0));
                this.opVersion = mbs.getRbMBSTOperSwVersion();
                this.shadowVersion = mbs.getRbMBSTShadowSwVersion();
                isOperationalVersionRunning = mbs.getRbMBSTRunningSoftware() == 1;
            } else if (this.baseStation instanceof RbBS) {
                RbNpuConfigEntry bs = (RbNpuConfigEntry)((Object)access.fetchObject(null, RbNpuConfigEntry.class, new String[]{"rbNpuOperSwVersion", "rbNpuShadowSwVersion", "rbNpuRunningSoftware"}, "*").get(0));
                this.opVersion = bs.getRbNpuOperSwVersion();
                this.shadowVersion = bs.getRbNpuShadowSwVersion();
                isOperationalVersionRunning = bs.getRbNpuRunningSoftware() == 1;
            } else {
                throw new RuntimeException("Unknown instanceof baseStation: " + ((Object)((Object)this.baseStation)).getClass().getName());
            }
            this.runningVersion = isOperationalVersionRunning ? this.opVersion : this.shadowVersion;
            if (!this.opVersion.equals(this.baseStation.getOperationalSoftwareVersion())) {
                this.baseStation.setOperationalSoftwareVersion(this.opVersion);
            }
            if (!this.shadowVersion.equals(this.baseStation.getShadowSoftwareVersion())) {
                this.baseStation.setShadowSoftwareVersion(this.shadowVersion);
            }
            if (!this.runningVersion.equals(this.baseStation.getRunningSoftwareVersion())) {
                this.baseStation.setRunningSoftwareVersion(this.runningVersion);
            }
        }

        private List<RbRegisteredSuEntry> getNextSUs(MOAccessSession access, int count, List<String> suMacAddresses, List<String> processedSUs) throws MediationException {
            ArrayList<RbRegisteredSuEntry> ret = new ArrayList<RbRegisteredSuEntry>();
            String[] fields = this.baseStation.getSoftwareVersion().compareTo((Object)new DefaultVersion("4.0")) >= 0 ? new String[]{"rbSuMacAddr", "rbSuPersistence", "rbSuRegistrationState", "rbSuRunningSoftware", "rbSuOperSwFileName", "rbSuShadowSwFileName", "rbSuAirInterfaceType", "rbAuId"} : new String[]{"rbSuMacAddr", "rbSuPersistence", "rbSuRegistrationState", "rbSuRunningSoftware", "rbSuOperSwFileName", "rbSuShadowSwFileName"};
            String[] instances = new String[suMacAddresses.size()];
            int idx = 0;
            for (String suMacAddr : suMacAddresses) {
                if (processedSUs.contains(suMacAddr)) continue;
                instances[idx++] = this.getSuInstanceString(suMacAddr);
            }
            String instancesList = this.buildCommaSeparatedList(instances, idx);
            if (0 == instancesList.length()) {
                return ret;
            }
            List sus = access.fetchObject(null, RbRegisteredSuEntry.class, fields, instancesList);
            for (RbRegisteredSuEntry su : sus) {
                String suMacAddr = su.getRbSuMacAddr().toUpperCase();
                if (processedSUs.contains(suMacAddr)) continue;
                ret.add(su);
                processedSUs.add(suMacAddr);
                if (ret.size() != count) continue;
                return ret;
            }
            return ret;
        }

        private RbRegisteredSuEntry fetchSUEntry(MOAccessSession access, RbSU su) throws MediationException {
            String[] suEntryFields = this.baseStation.getSoftwareVersion().compareTo((Object)new DefaultVersion("4.0")) >= 0 ? SU_Entry_4_x_Fields : SU_Entry_Fields;
            String suMACAddrInstance = MacAddress.fromSimpleString((String)su.getMacAddress()).toInstanceString();
            List sus = access.fetchObject(null, RbRegisteredSuEntry.class, suEntryFields, suMACAddrInstance);
            return (RbRegisteredSuEntry)((Object)sus.get(0));
        }

        public boolean suAcceptsFile(RbRegisteredSuEntry suEntry, String fileName) {
            return true;
        }

        public boolean suAcceptsFile(RbSU su, String fileName) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runMakeOperationalSU(Integer[] suOperations, String[] suFiles) {
            List<RbSU> suList = null;
            boolean processFlag = false;
            for (int i = 0; i < suOperations.length && !processFlag; ++i) {
                processFlag = processFlag || suOperations[i] != null && suOperations[i] == 2;
                processFlag = processFlag || suOperations[i] != null && suOperations[i] == 3;
                processFlag = processFlag || suOperations[i] != null && suOperations[i] == 4;
            }
            if (processFlag && (suList = RbSoftwareUpgradeExecutorBase.this.task.getSUList(this.baseStation)).isEmpty()) {
                processFlag = false;
            }
            if (!processFlag) {
                ++this.currentOperation;
                return;
            }
            MOAccessSession access = null;
            Iterator suListIt = suList.iterator();
            ArrayList<RbRegisteredSuEntry> currentSUEntries = new ArrayList<RbRegisteredSuEntry>(5);
            try {
                access = this.createMOAccessSession();
                while (!RbSoftwareUpgradeExecutorBase.this.ctx.shouldAbort() && suListIt.hasNext()) {
                    RbSU su = (RbSU)((Object)suListIt.next());
                    String target = this.getSUTargetName(su);
                    RbRegisteredSuEntry suEntry = null;
                    try {
                        suEntry = this.fetchSUEntry(access, su);
                    }
                    catch (MediationException me) {
                        log.error((Object)"", (Throwable)me);
                        String operationName = this.getSUOperationName(suOperations[su.isOperationModeSi() ? 1 : 0]);
                        this.logStatus(operationName, OperationStatus.FAILED, "ErrorMessage", target, this.getMessage(me));
                        continue;
                    }
                    boolean siMode = null != suEntry.getRbSuAirInterfaceType() && 2 == suEntry.getRbSuAirInterfaceType();
                    Integer suOperation = suOperations[siMode ? 1 : 0];
                    String suFileName = suFiles[siMode ? 1 : 0];
                    String suOperationName = this.getSUOperationName(suOperation);
                    if (null == suOperationName || null == suFileName) {
                        this.logStatus("SUOp", OperationStatus.SKIPPED, "NoOperationForDeviceType", target);
                        log.debug((Object)("Skipping " + suEntry.getRbSuMacAddr() + ", reason: no operation/file."));
                        continue;
                    }
                    if (suEntry.isTemporary() && this.baseStation.getSoftwareVersion().compareTo((Object)new DefaultVersion("4.1")) < 0) {
                        this.logStatus(suOperationName, OperationStatus.SKIPPED, "DeviceTemporary", target);
                        continue;
                    }
                    if (suEntry.getRbSuRunningSoftware() == 1 && suEntry.getRbSuOperSwFileName().equals(suFileName)) {
                        this.logStatus(suOperationName, OperationStatus.SKIPPED, "AlreadyRunning", target);
                        continue;
                    }
                    boolean skipSU = false;
                    switch (suOperation) {
                        case 3: {
                            if (suFileName.equals(suEntry.getRbSuShadowSwFileName())) {
                                this.logStatus(suOperationName, OperationStatus.SKIPPED, "AlreadyLoadedToShadow", target);
                                skipSU = true;
                                break;
                            }
                            if (suEntry.getRbSuRunningSoftware() != 2) break;
                            this.logStatus(suOperationName, OperationStatus.SKIPPED, "RunningDifferentShadowVersion", target);
                            skipSU = true;
                            break;
                        }
                        case 4: {
                            if (suEntry.getRbSuRunningSoftware() != 2) break;
                            if (suFileName.equals(suEntry.getRbSuShadowSwFileName())) {
                                this.logStatus(suOperationName, OperationStatus.SKIPPED, "AlreadyRunningFromShadow", target);
                                skipSU = true;
                                break;
                            }
                            this.logStatus(suOperationName, OperationStatus.SKIPPED, "RunningDifferentShadowVersion", target);
                            skipSU = true;
                        }
                    }
                    if (skipSU) continue;
                    currentSUEntries.add(suEntry);
                    if (currentSUEntries.size() < 5) continue;
                    this.performSUsBatch(access, currentSUEntries, suOperations, suFiles);
                    currentSUEntries.clear();
                }
                if (!RbSoftwareUpgradeExecutorBase.this.ctx.shouldAbort() && !currentSUEntries.isEmpty()) {
                    this.performSUsBatch(access, currentSUEntries, suOperations, suFiles);
                }
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
            finally {
                try {
                    this.closeMOAccessSession(access);
                }
                catch (Exception e) {}
                ++this.currentOperation;
            }
        }

        private void performSUsBatch(MOAccessSession access, List<RbRegisteredSuEntry> suEntries, Integer[] suOperations, String[] suFiles) {
            HashMap<String, RbRegisteredSuEntry> registered = new HashMap<String, RbRegisteredSuEntry>(suEntries.size());
            HashMap<String, String> registeredOpNames = new HashMap<String, String>(suEntries.size());
            for (RbRegisteredSuEntry suEntry : suEntries) {
                String target = this.getSUTargetName(suEntry);
                boolean siMode = null != suEntry.getRbSuAirInterfaceType() && 2 == suEntry.getRbSuAirInterfaceType();
                Integer suOperation = suOperations[siMode ? 1 : 0];
                String suFileName = suFiles[siMode ? 1 : 0];
                String suOperationName = this.getSUOperationName(suOperation);
                try {
                    if (suEntry.getRbSuRegistrationState() == 2) {
                        RbSwRegisteredSuEntry command;
                        this.logStatus(suOperationName, OperationStatus.IN_PROGRESS, target);
                        Integer unitControlCommand = null;
                        switch (suOperation) {
                            case 3: {
                                unitControlCommand = 3;
                                break;
                            }
                            case 4: {
                                unitControlCommand = 4;
                                break;
                            }
                            case 2: {
                                if (suEntry.getRbSuRunningSoftware() == 2) {
                                    command = new RbSwRegisteredSuEntry();
                                    command.setRbSuMacAddr(suEntry.getRbSuMacAddr());
                                    command.setRbSuUnitControl(5);
                                    access.commitObject(null, (Object)command);
                                    try {
                                        Thread.sleep(2000L);
                                    }
                                    catch (InterruptedException e) {
                                        // empty catch block
                                    }
                                }
                                unitControlCommand = 5;
                                break;
                            }
                            default: {
                                this.logStatus(suOperationName, OperationStatus.SKIPPED, "NoOperationForDeviceType", target);
                            }
                        }
                        if (null == unitControlCommand) continue;
                        command = new RbSwRegisteredSuEntry();
                        command.setRbSuMacAddr(suEntry.getRbSuMacAddr());
                        command.setRbSuUnitControl(unitControlCommand);
                        command.setRbSuUpgradeSwFileName(suFileName);
                        access.commitObject(null, (Object)command);
                        String suInstance = this.getSuInstanceString(suEntry.getRowKey());
                        registered.put(suInstance, suEntry);
                        registeredOpNames.put(suInstance, suOperationName);
                        continue;
                    }
                    this.logStatus(suOperationName, OperationStatus.SKIPPED, "SuNotRegistered", target);
                }
                catch (MediationException e) {
                    log.debug((Object)"", (Throwable)e);
                    this.logStatus(suOperationName, OperationStatus.FAILED, "ErrorMessage", target, this.getMessage(e));
                }
            }
            long pollingStart = System.currentTimeMillis();
            while (!registered.isEmpty() && System.currentTimeMillis() - pollingStart < 300000L) {
                try {
                    log.debug((Object)"Sleeping for 10s");
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    log.debug((Object)"", (Throwable)e);
                }
                String[] instances = new String[registered.size()];
                int idx = 0;
                for (String instance : registered.keySet()) {
                    instances[idx++] = "2." + instance;
                }
                try {
                    List swUpgradeLog = access.fetchObject(null, RbSwUpgradeLogEntry.class, null, this.buildCommaSeparatedList(instances, instances.length));
                    block20: for (RbSwUpgradeLogEntry logEntry : swUpgradeLog) {
                        String suInstance = logEntry.getInstance().substring(logEntry.getInstance().indexOf(46) + 1);
                        RbRegisteredSuEntry suEntry = (RbRegisteredSuEntry)((Object)registered.get(suInstance));
                        if (suEntry == null) {
                            throw new RuntimeException("What is happening here?");
                        }
                        String operationName = (String)registeredOpNames.get(suInstance);
                        String target = this.getSUTargetName(suEntry);
                        switch (logEntry.getRbSwUpgradeStatus()) {
                            case 4: {
                                this.logStatus(operationName, OperationStatus.FAILED, "BSFailedToCompleteOperation", target);
                                registered.remove(suInstance);
                                registeredOpNames.remove(suInstance);
                                continue block20;
                            }
                            case 2: {
                                this.logStatus(operationName, OperationStatus.COMPLETED, target);
                                registered.remove(suInstance);
                                registeredOpNames.remove(suInstance);
                                continue block20;
                            }
                        }
                        log.debug((Object)(target + " in progress"));
                    }
                }
                catch (MediationException e) {
                    log.debug((Object)("Error requesting su operation status: " + e.getMessage() + "   (ignored)."));
                }
            }
            for (RbRegisteredSuEntry su : registered.values()) {
                String target = this.getSUTargetName(su);
                String operationName = (String)registeredOpNames.get(this.getSuInstanceString(su.getRowKey()));
                this.logStatus(operationName, OperationStatus.FAILED, "MakeOperationalTimedOut", target);
            }
        }

        private String getSUOperationName(Integer op) {
            String operationName = null;
            if (null != op) {
                switch (op) {
                    case 2: {
                        operationName = STR_OP_MAKE_OPERATIONAL;
                        break;
                    }
                    case 3: {
                        operationName = STR_OP_LOAD_TO_SHADOW;
                        break;
                    }
                    case 4: {
                        operationName = STR_OP_RUN_FROM_SHADOW;
                    }
                }
            }
            return operationName;
        }

        public boolean auAcceptsFile(RbAuConfigEntry auState, String fileName) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void runMakeOperationalAU(Integer[] auOperations, String[] auFiles, boolean forAuSi) {
            processFlag = false;
            for (i = 0; i < auOperations.length && !processFlag; ++i) {
                processFlag = processFlag != false || auOperations[i] != null && auOperations[i] == 2;
                processFlag = processFlag != false || auOperations[i] != null && auOperations[i] == 3;
                processFlag = processFlag != false || auOperations[i] != null && auOperations[i] == 4;
            }
            auSerialNumbers = null;
            if (this.baseStation instanceof RbBS) {
                auSerialNumbers = RbSoftwareUpgradeExecutorBase.this.task.getAUSerialNumbers((RbBS)this.baseStation);
                v0 = processFlag = processFlag != false && (auSerialNumbers == null || auSerialNumbers.isEmpty() == false);
            }
            if (this.baseStation instanceof RbMBS || !processFlag) {
                if (!forAuSi) return;
                ++this.currentOperation;
                return;
            }
            access = null;
            registered = new HashMap<String, RbAuConfigEntry>();
            registeredOpNames = new HashMap<String, String>();
            try {
                access = this.createMOAccessSession();
                allAus = access.fetchObject(null, RbAuConfigEntry.class, new String[]{"rbSlotNumber", "rbAuSerialNo", "rbAuRunningSoftware", "rbAuFaultStatus", "rbAuOperSwFileName", "rbAuShadowSwFileName", "rbAuAirInterfaceType"}, "*");
                selectedAus = new ArrayList<RbAuConfigEntry>();
                for (RbAuConfigEntry au : allAus) {
                    if (Integer.valueOf(5).equals(au.getRbAuFaultStatus())) {
                        if (auSerialNumbers == null) continue;
                        auSerialNumbers.remove(au.getRbAuSerialNo());
                        continue;
                    }
                    if (forAuSi ^ Integer.valueOf(2).equals(au.getRbAuAirInterfaceType())) {
                        auSerialNo = au.getRbAuSerialNo();
                        target = this.getAUTargetName(auSerialNo);
                        if (forAuSi) {
                            if (((RbSoftwareUpgradeTask)RbSoftwareUpgradeExecutorBase.this.task).getAuOperation() == null) {
                                operationName = auOperations != null && auOperations.length > 0 ? this.getOperationName(auOperations[0]) : "";
                                this.logStatus(operationName, OperationStatus.SKIPPED, "NoAuStandardOperation", new Object[]{target});
                            }
                        } else if (((RbSoftwareUpgradeTask)RbSoftwareUpgradeExecutorBase.this.task).getAuSiOperation() == null) {
                            operationName = auOperations != null && auOperations.length > 0 ? this.getOperationName(auOperations[0]) : "";
                            this.logStatus(operationName, OperationStatus.SKIPPED, "NoAuSIOperation", new Object[]{target});
                        }
                        if (auSerialNumbers == null) continue;
                        auSerialNumbers.remove(au.getRbAuSerialNo());
                        continue;
                    }
                    selectedAus.add(au);
                }
                for (RbAuConfigEntry au : selectedAus) {
                    target = this.getAUTargetName(au);
                    fileName = null;
                    operationName = null;
                    doMakeOperational = false;
                    for (i = 0; i < auFiles.length && fileName == null; ++i) {
                        if (auOperations[i] == null || auOperations[i] == 0 || !this.auAcceptsFile(au, auFiles[i])) continue;
                        fileName = auFiles[i];
                        operationName = this.getOperationName(auOperations[i]);
                        if (auOperations[i] != 2) continue;
                        doMakeOperational = true;
                    }
                    if (fileName == null) {
                        this.logStatus(operationName, OperationStatus.SKIPPED, "DeviceTypeNotIncluded", new Object[]{target});
                        continue;
                    }
                    command = new RbSwAuConfigEntry();
                    command.setRbSlotNumber(au.getRbSlotNumber());
                    try {
                        if (auSerialNumbers != null && !auSerialNumbers.remove(au.getRbAuSerialNo())) continue;
                        this.logStatus(operationName, OperationStatus.IN_PROGRESS, target);
                        if (au.getRbAuFaultStatus() != 5) {
                            if (au.getRbAuRunningSoftware() == 1 && fileName.equals(au.getRbAuOperSwFileName())) {
                                this.logStatus(operationName, OperationStatus.SKIPPED, "AlreadyRunning", new Object[]{target});
                                continue;
                            }
                            if (!doMakeOperational && fileName.equals(au.getRbAuShadowSwFileName())) {
                                if (au.getRbAuRunningSoftware() == 2) {
                                    this.logStatus(operationName, OperationStatus.SKIPPED, "AlreadyRunningFromShadow", new Object[]{target});
                                    continue;
                                }
                                if (operationName.equals(RbSoftwareUpgradeExecutorBase.STR_OP_LOAD_TO_SHADOW)) {
                                    this.logStatus(operationName, OperationStatus.SKIPPED, "AlreadyLoadedToShadow", new Object[]{target});
                                    continue;
                                }
                            }
                            if (!operationName.equals(RbSoftwareUpgradeExecutorBase.STR_OP_RUN_FROM_SHADOW)) {
                                if (doMakeOperational) {
                                    command.setRbAuUnitControl(5);
                                } else {
                                    command.setRbAuUnitControl(3);
                                }
                                if (au.getRbAuRunningSoftware() == 2) {
                                    if (doMakeOperational) {
                                        access.commitObject(null, (Object)command);
                                        try {
                                            Thread.sleep(1000L);
                                        }
                                        catch (InterruptedException e) {}
                                    } else {
                                        if (fileName.equals(au.getRbAuShadowSwFileName())) continue;
                                        this.logStatus(operationName, OperationStatus.SKIPPED, "RunningDifferentShadowVersion", new Object[]{target});
                                        continue;
                                    }
                                }
                            } else {
                                command.setRbAuUnitControl(4);
                            }
                            command.setRbAuUpgradeSwFileName(fileName);
                            access.commitObject(null, (Object)command);
                            registered.put(au.getRbSlotNumber().toString(), au);
                            registeredOpNames.put(au.getRbAuSerialNo(), operationName);
                            continue;
                        }
                        access.commitObject(null, (Object)command);
                        this.logStatus(operationName, OperationStatus.SKIPPED, "AuNotConnected", new Object[]{target});
                    }
                    catch (MediationException e) {
                        RbSoftwareUpgradeExecutorBase.access$100().debug((Object)"", (Throwable)e);
                        this.logStatus(operationName, OperationStatus.FAILED, "ErrorMessage", new Object[]{target, this.getMessage(e)});
                    }
                }
                pollingStart = System.currentTimeMillis();
                while (true) {
                    if (!registered.isEmpty() && System.currentTimeMillis() - pollingStart < 300000L) {
                        try {
                            RbSoftwareUpgradeExecutorBase.access$100().debug((Object)"Sleeping for 10s");
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException e) {
                            RbSoftwareUpgradeExecutorBase.access$100().debug((Object)"", (Throwable)e);
                        }
                        instances = new String[registered.size()];
                        idx = 0;
                        for (String instance : registered.keySet()) {
                            instances[idx++] = "1." + instance;
                        }
                        swUpgradeLog = access.fetchObject(null, RbSwUpgradeLogEntry.class, null, this.buildCommaSeparatedList(instances, instances.length));
                        i$ = swUpgradeLog.iterator();
                        break;
                    }
                    if (auSerialNumbers == null) return;
                    while (auSerialNumbers.size() > 0) {
                        auSerialNo = auSerialNumbers.remove(0);
                        target = this.getAUTargetName(auSerialNo);
                        operationName = (String)registeredOpNames.get(auSerialNo);
                        this.logStatus(operationName, OperationStatus.SKIPPED, "DeviceNotFound", new Object[]{target});
                    }
                    return;
                }
            }
            catch (MediationException e) {
                RbSoftwareUpgradeExecutorBase.access$100().debug((Object)"", (Throwable)e);
                for (RbAuConfigEntry au : registered.values()) {
                    operationName = (String)registeredOpNames.get(au.getRbAuSerialNo());
                    this.logStatus(operationName, OperationStatus.FAILED, "ErrorMessage", new Object[]{this.getAUTargetName(au), this.getMessage(e)});
                }
                return;
            }
            finally {
                if (forAuSi) {
                    ++this.currentOperation;
                }
                this.closeMOAccessSession(access);
            }
            while (true) lbl-1000:
            // 4 sources

            {
                if (!i$.hasNext()) ** continue;
                entry = (RbSwUpgradeLogEntry)i$.next();
                au = null;
                auInstance = entry.getInstance().substring(entry.getInstance().indexOf(46) + 1);
                au = (RbAuConfigEntry)registered.get(auInstance);
                if (au == null) {
                    throw new RuntimeException("What is happening here?");
                }
                auSerialNo = au.getRbAuSerialNo();
                operationName = (String)registeredOpNames.get(auSerialNo);
                target = this.getAUTargetName(au);
                switch (entry.getRbSwUpgradeStatus()) {
                    case 4: {
                        this.logStatus(operationName, OperationStatus.FAILED, "BSFailedToCompleteOperation", new Object[]{target});
                        registered.remove(auInstance);
                        registeredOpNames.remove(auSerialNo);
                        ** continue;
                    }
                    case 2: {
                        this.logStatus(operationName, OperationStatus.COMPLETED, target);
                        registered.remove(auInstance);
                        registeredOpNames.remove(auSerialNo);
                        ** continue;
                    }
                }
                RbSoftwareUpgradeExecutorBase.access$100().debug((Object)(target + " in progress"));
            }
        }

        private String getOperationName(int operationType) {
            if (operationType == 2) {
                return STR_OP_MAKE_OPERATIONAL;
            }
            if (operationType == 3) {
                return STR_OP_LOAD_TO_SHADOW;
            }
            if (operationType == 4) {
                return STR_OP_RUN_FROM_SHADOW;
            }
            return "";
        }

        protected MOAccessSession createMOAccessSession() throws MediationException {
            return MediationServiceRegistry.getMOSession((SNMPManagementInterface)this.baseStation.getManagementInterface(), null);
        }

        protected void closeMOAccessSession(MOAccessSession access) {
            if (access != null) {
                access.close();
            }
        }

        protected String getSimpleFileName(String fullPath) {
            if (fullPath.indexOf(47) == -1) {
                return fullPath;
            }
            return fullPath.substring(fullPath.lastIndexOf(47) + 1);
        }

        protected String getBSOperationName() {
            return this.bsOperation.getTranslatedName(i18n);
        }

        private String getSUTargetName(RbRegisteredSuEntry su) {
            return "SU." + MacAddress.fromOctetString((String)su.getRbSuMacAddr()).toDashedString();
        }

        private String getSUTargetName(RbSU su) {
            return "SU." + MacAddress.fromSimpleString((String)su.getMacAddress()).toDashedString();
        }

        private String getAUTargetName(RbAuConfigEntry au) {
            return this.getAUTargetName(String.valueOf(au.getRbSlotNumber()));
        }

        private String getAUTargetName(String info) {
            return "AU." + info;
        }

        protected String getMessage(Throwable e) {
            if (e == null) {
                return "";
            }
            Throwable cause = e.getCause();
            String message = cause instanceof SNMPTimeoutException ? i18n.translateString("SNMPTimeoutError") : (cause instanceof TftpTimeoutException ? i18n.translateString("TFTPTimeoutError") : (cause != null ? cause.getMessage() : e.getMessage()));
            if (message == null) {
                return "";
            }
            return message;
        }

        private String buildCommaSeparatedList(String[] words, int count) {
            StringBuilder retList = new StringBuilder();
            for (int i = 0; i < count; ++i) {
                retList.append(words[i]).append(',');
            }
            if (retList.length() > 0) {
                retList.deleteCharAt(retList.length() - 1);
            }
            return retList.toString();
        }

        private String getSuInstanceString(String macAddress) {
            return MacAddress.fromOctetString((String)macAddress).toInstanceString();
        }
    }
}

