/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.servicedistribution;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.ExceptionUtil;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.SelectorUtil;
import com.bwanms.gui.SelectorView;
import com.bwanms.gui.Selectors;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.equipmentmanager.EquipmentRowProviderClient;
import com.bwanms.mediation.FileSystemService;
import com.bwanms.model.Task;
import com.bwanms.model.entity.Assembly;
import com.bwanms.rb.gui.selectors.equipment.RbBaseStationSelectorView;
import com.bwanms.rb.gui.selectors.serviceprofile.RbServiceProfileSelectorView;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.services.RbServiceProfile;
import com.bwanms.rb.tasks.servicedistribution.RbServiceDistributionTask;
import com.bwanms.rb.tasks.servicedistribution.RbXMLServiceProfileDistributionTask;
import com.bwanms.rb.tasks.servicedistribution.RbXMLServiceProfileDistributionTaskPanel;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.EntityManagerTableModel;
import com.bwanms.ui.components.SimpleRowTable;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.MessageBox;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.impl.DefaultVersion;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbXMLServiceProfileDistributionTaskView
extends AbstractBindedEditorView<Task> {
    public static final Internationalizer i18n = Internationalizer.getInternationalizer(RbXMLServiceProfileDistributionTask.class);
    private static final Logger log = Logger.getLogger(RbXMLServiceProfileDistributionTaskView.class);
    private static final String SP_FOLDER = "service_profiles";
    private RbXMLServiceProfileDistributionTaskPanel panel;
    private EntityManagerTableModel<RbBaseStationEquipment> equipmentTableModel;
    private EntityManagerTableModel<EntityManagerRow> serviceProfileTableModel;
    private static final Version sw4 = new DefaultVersion("4.0");

    public RbXMLServiceProfileDistributionTaskView() {
        this.initUI();
    }

    public List<Binder> getBinders() {
        ArrayList<Binder> binders = new ArrayList<Binder>();
        DefaultBinder binder = new DefaultBinder((Object)this.getUI(), (Object)this.entity);
        binder.add((Binding)new JTextFieldBinding("txtName", "name", i18n.translateString("Name")));
        binders.add((Binder)binder);
        return binders;
    }

    public void fillUI(Task entity) {
        boolean bEditTask;
        RbXMLServiceProfileDistributionTask task = (RbXMLServiceProfileDistributionTask)entity;
        boolean bl = bEditTask = task.getId() > 0L;
        if (bEditTask) {
            this.panel.getTxtName().setText(task.getName());
        }
        this.equipmentTableModel.clearTable();
        if (task.getEquipmentList() != null) {
            for (RbBaseStationEquipment equipment : task.getEquipmentList()) {
                this.equipmentTableModel.addRow((Object)equipment, String.valueOf(equipment.getId()));
            }
        }
        this.serviceProfileTableModel.clearTable();
        if (task.getServiceProfileList() != null) {
            RbServiceProfileSelectorView spManagerSelectorView = new RbServiceProfileSelectorView(RbServiceProfile.class);
            EntityManagerRowProvider rowProvider = spManagerSelectorView.getEntityRowProvider();
            for (RbServiceProfile serviceProfile : task.getServiceProfileList()) {
                EntityManagerRow spRow = rowProvider.createRow((Serializable)((Object)serviceProfile));
                this.serviceProfileTableModel.addRow((Object)spRow, String.valueOf(serviceProfile.getId()));
            }
        }
        if (task.getXmlFileName() != null) {
            this.panel.getCmbXmlFile().setSelectedItem(task.getXmlFileName().substring(task.getXmlFileName().lastIndexOf(47) + 1));
        }
        if (task.getSource() != null) {
            this.panel.getRdbSpList().setSelected(task.getSource().equals((Object)RbXMLServiceProfileDistributionTask.MSPDDataSource.SP));
            this.panel.getRdbXmlFile().setSelected(task.getSource().equals((Object)RbXMLServiceProfileDistributionTask.MSPDDataSource.XML));
        }
    }

    public List<InvalidValue> configureEntity(Task entity) {
        RbXMLServiceProfileDistributionTask task = (RbXMLServiceProfileDistributionTask)entity;
        task.setName(this.panel.getTxtName().getText());
        List ivList = super.configureEntity((Serializable)entity);
        ArrayList<RbBaseStationEquipment> equipmentList = new ArrayList<RbBaseStationEquipment>(this.equipmentTableModel.getRowCount());
        for (int row = 0; row < this.equipmentTableModel.getRowCount(); ++row) {
            if (1 == this.equipmentTableModel.getRowState(row)) continue;
            RbBaseStationEquipment equipment = (RbBaseStationEquipment)((Object)this.equipmentTableModel.getEntity(row));
            if (equipment.getSoftwareVersion().compareTo((Object)sw4) >= 0) {
                equipmentList.add(equipment);
                continue;
            }
            ivList.add(new InvalidValue(i18n.translateString("ThisFeatureIsAvailableForEqWithSw4OrHigher"), RbBaseStationEquipment.class, i18n.translateString("WrongSWVerForEq", new Object[]{equipment.getName()}), (Object)equipment.getRunningSoftwareVersion(), (Object)equipment));
        }
        task.setEquipmentList(equipmentList);
        ArrayList<RbServiceProfile> serviceProfileList = new ArrayList<RbServiceProfile>(this.serviceProfileTableModel.getRowCount());
        for (int row = 0; row < this.serviceProfileTableModel.getRowCount(); ++row) {
            if (1 == this.serviceProfileTableModel.getRowState(row)) continue;
            serviceProfileList.add((RbServiceProfile)((Object)((EntityManagerRow)this.serviceProfileTableModel.getEntity(row)).getEntity()));
        }
        task.setServiceProfileList(serviceProfileList);
        Object xmlFileSelected = this.panel.getCmbXmlFile().getSelectedItem();
        task.setXmlFileName(null != xmlFileSelected ? "service_profiles/" + xmlFileSelected.toString() : null);
        if (this.panel.getRdbXmlFile().isSelected()) {
            task.setSource(RbXMLServiceProfileDistributionTask.MSPDDataSource.XML);
        } else {
            task.setSource(RbXMLServiceProfileDistributionTask.MSPDDataSource.SP);
        }
        if (this.panel.getTableEquipment().getModel().getRowCount() == 0) {
            ivList.add(new InvalidValue(i18n.translateString("NoEquipment"), List.class, i18n.translateString("Equipment"), (Object)"", null));
        }
        if (this.panel.getTableServiceProfiles().getModel().getRowCount() == 0 && this.panel.getRdbSpList().isSelected()) {
            ivList.add(new InvalidValue(i18n.translateString("NoServiceProfiles"), List.class, i18n.translateString("ServiceProfiles"), (Object)"", null));
        }
        return ivList;
    }

    private void actionAddEquipment() {
        SelectorView selectorView = Selectors.getSelectorView(RbBaseStationEquipment.class, (String)(RbServiceDistributionTask.class.getName() + "_selector"), (String)"multipleSelection");
        if (selectorView == null) {
            throw new IllegalArgumentException("Selector View must be defined!");
        }
        SelectorUtil.displayModalSelector((JComponent)this.panel, (SelectorView)selectorView);
        for (RbBaseStationEquipment equipment : selectorView.getSelection()) {
            String key = String.valueOf(equipment.getId());
            int row = this.equipmentTableModel.getEntityRow(key);
            if (-1 != row) {
                this.equipmentTableModel.updateRow((Object)equipment, key);
                this.equipmentTableModel.revertRow(row);
                continue;
            }
            this.equipmentTableModel.addRow((Object)equipment, key);
        }
    }

    private void actionRemoveEquipment() {
        int[] selectedRows = this.panel.getTableEquipment().getSelectedRows();
        this.equipmentTableModel.removeRows(selectedRows);
    }

    private void actionAddServiceProfiles() {
        RbServiceProfileSelectorView selectorView = new RbServiceProfileSelectorView(RbServiceProfile.class);
        SelectorUtil.displayModalSelector((JComponent)this.panel, (SelectorView)selectorView);
        for (Assembly spAssembly : selectorView.getSelectionData()) {
            RbServiceProfile serviceProfile = (RbServiceProfile)((Object)spAssembly.getEntity());
            String key = String.valueOf(serviceProfile.getId());
            int row = this.serviceProfileTableModel.getEntityRow(key);
            if (-1 != row) {
                this.serviceProfileTableModel.updateRow((Object)((EntityManagerRow)spAssembly), key);
                this.serviceProfileTableModel.revertRow(row);
                continue;
            }
            this.serviceProfileTableModel.addRow((Object)((EntityManagerRow)spAssembly), key);
        }
    }

    private void actionRemoveServiceProfiles() {
        int[] selectedRows = this.panel.getTableServiceProfiles().getSelectedRows();
        this.serviceProfileTableModel.removeRows(selectedRows);
    }

    private void initUI() {
        this.panel = new RbXMLServiceProfileDistributionTaskPanel();
        final RbBaseStationSelectorView bsEqManagerSelectorView = new RbBaseStationSelectorView("RbServiceProfileDistributionTask_selector", "multipleSelection");
        SimpleRowTableModel.ColumnDefinition[] colDefs = new SimpleRowTableModel.ColumnDefinition[bsEqManagerSelectorView.getColumnNames().length];
        int idx = 0;
        for (String colName : bsEqManagerSelectorView.getColumnNames()) {
            colDefs[idx++] = new SimpleRowTableModel.ColumnDefinition(colName, String.class);
        }
        this.equipmentTableModel = new EntityManagerTableModel<RbBaseStationEquipment>(colDefs){
            private static final long serialVersionUID = -8530492792413535921L;

            public void setRowValues(int row, RbBaseStationEquipment entity) {
                EquipmentRowProviderClient rowProvider = new EquipmentRowProviderClient(bsEqManagerSelectorView.getEntityRowProvider().getAttributes());
                EntityManagerRow entityRow = rowProvider.createRow((Serializable)((Object)entity));
                List displayValues = rowProvider.getDisplayValues(entityRow);
                for (int i = 0; i < displayValues.size(); ++i) {
                    this.setInitialValueAt(displayValues.get(i), row, i);
                }
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        };
        new SimpleRowTable(this.panel.getTableEquipment(), this.equipmentTableModel);
        this.panel.getCmbXmlFile().removeAllItems();
        try {
            String[] spFiles;
            FileSystemService fileSystem = ServiceRegistry.getFileSystemService();
            for (String file : spFiles = fileSystem.listFiles(SP_FOLDER)) {
                this.panel.getCmbXmlFile().addItem(file.substring(file.lastIndexOf(47) + 1));
            }
        }
        catch (IOException ioe) {
            log.warn((Object)"Error while listing firmware service_profiles: ", (Throwable)ioe);
            MessageBox.Error.showResult((Component)this.panel, ExceptionUtil.getMessage((Throwable)ioe), i18n.translateString("ListingFolderErrorTitle"));
        }
        final RbServiceProfileSelectorView spManagerSelectorView = new RbServiceProfileSelectorView(RbServiceProfile.class);
        colDefs = new SimpleRowTableModel.ColumnDefinition[spManagerSelectorView.getColumnNames().length];
        idx = 0;
        for (String colName : spManagerSelectorView.getColumnNames()) {
            colDefs[idx++] = new SimpleRowTableModel.ColumnDefinition(colName, String.class);
        }
        this.serviceProfileTableModel = new EntityManagerTableModel<EntityManagerRow>(colDefs){
            private static final long serialVersionUID = 8751654291956695731L;

            public void setRowValues(int row, EntityManagerRow spRow) {
                EntityManagerRowProvider rowProvider = spManagerSelectorView.getEntityRowProvider();
                List displayValues = rowProvider.getDisplayValues(spRow);
                for (int i = 0; i < displayValues.size(); ++i) {
                    this.setInitialValueAt(displayValues.get(i), row, i);
                }
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        };
        new SimpleRowTable(this.panel.getTableServiceProfiles(), this.serviceProfileTableModel);
        this.panel.getBtnEquipmentAdd().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RbXMLServiceProfileDistributionTaskView.this.actionAddEquipment();
            }
        });
        this.panel.getBtnEquipmentRemove().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RbXMLServiceProfileDistributionTaskView.this.actionRemoveEquipment();
            }
        });
        this.panel.getBtnServiceProfilesAdd().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RbXMLServiceProfileDistributionTaskView.this.actionAddServiceProfiles();
            }
        });
        this.panel.getBtnServiceProfilesRemove().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RbXMLServiceProfileDistributionTaskView.this.actionRemoveServiceProfiles();
            }
        });
        this.panel.getTableEquipment().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                RbXMLServiceProfileDistributionTaskView.this.fireEquipmentTableSelectionChanged();
            }
        });
        this.panel.getTableServiceProfiles().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                RbXMLServiceProfileDistributionTaskView.this.fireServiceProfilesTableSelectionChanged();
            }
        });
        i18n.getSwingInternationalizer().translateComponent((Component)this.panel);
        this.fireEquipmentTableSelectionChanged();
        this.fireServiceProfilesTableSelectionChanged();
    }

    private void fireServiceProfilesTableSelectionChanged() {
        this.panel.getBtnServiceProfilesRemove().setEnabled(0 < this.panel.getTableServiceProfiles().getSelectedRowCount());
    }

    private void fireEquipmentTableSelectionChanged() {
        this.panel.getBtnEquipmentRemove().setEnabled(0 < this.panel.getTableEquipment().getSelectedRowCount());
    }

    public JComponent getUI() {
        return this.panel;
    }

    public boolean close() {
        return true;
    }

    public String getTitle() {
        return i18n.translateString("RbXMLServiceProfileDistributionTaskTitle");
    }

    public String getApplicationPermission() {
        return "Av:ConfigureTasks";
    }

    public String getHelpTopic() {
        return "";
    }
}

