/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.servicedistribution;

import com.bwanms.domain.logic.Helpers;
import com.bwanms.mediation.FileSystemService;
import com.bwanms.mediation.FileTransferRequest;
import com.bwanms.mediation.FileTransferService;
import com.bwanms.mediation.MediationServiceRegistry;
import com.bwanms.mediation.TftpFileTransferRequest;
import com.bwanms.mediation.TftpFileTransferService;
import com.bwanms.mediation.filesystem.FileSystemFileOutputStream;
import com.bwanms.mediation.filetransfer.SynchronousFileTransfer;
import com.bwanms.model.Equipment;
import com.bwanms.model.TaskExecutionContext;
import com.bwanms.model.TaskExecutor;
import com.bwanms.model.TaskRuntimeStatus;
import com.bwanms.persistence.Datastore;
import com.bwanms.persistence.RunnableDatastoreDecorator;
import com.bwanms.rb.ddi.RbServiceSynchronizationUtil;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.services.RbForwardingRule;
import com.bwanms.rb.model.services.RbIPModeDataServiceProfile;
import com.bwanms.rb.model.services.RbIPModeMngVoIPServiceProfile;
import com.bwanms.rb.model.services.RbIPModeVoIPServiceProfile;
import com.bwanms.rb.model.services.RbL2ServiceProfile;
import com.bwanms.rb.model.services.RbManagedVoIPServiceProfile;
import com.bwanms.rb.model.services.RbPPPoEServiceProfile;
import com.bwanms.rb.model.services.RbPolicyRule;
import com.bwanms.rb.model.services.RbQoSProfile;
import com.bwanms.rb.model.services.RbServiceProfile;
import com.bwanms.rb.model.services.RbVoIPServiceProfile;
import com.bwanms.rb.tasks.servicedistribution.RbServiceProfileDistributionTaskInterpretor;
import com.bwanms.rb.tasks.servicedistribution.RbXMLServiceProfileDistributionTask;
import com.bwanms.rb.tasks.servicedistribution.RbXMLServiceProfileDistributionTaskView;
import com.bwanms.rb.tasks.servicedistribution.RbXmlErrorReportEntry;
import com.bwanms.rb.util.DigitalFingerprint;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.concurrent.AsyncItemsExecutor;
import com.bwanms.util.concurrent.AsyncItemsProvider;
import com.bwanms.util.task.Operation;
import com.bwanms.util.task.OperationStatus;
import com.bwanms.util.task.OperationTaskRuntimeStatus;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbXMLServiceProfileDistributionTaskExecutor
implements TaskExecutor {
    private static final Logger logger = Logger.getLogger(RbXMLServiceProfileDistributionTaskExecutor.class);
    private transient TaskExecutionContext ctx = null;
    private RbXMLServiceProfileDistributionTask task;
    private OperationTaskRuntimeStatus runtimeStatus;
    private Operation rootOperation;
    private String xmlFileName;
    private byte[] fileData;
    private boolean completedWithErrors = false;
    private boolean oneDidNotFailed = false;
    private static final String[] qosTypes = new String[]{"CG", "RT", "NRT", "BE"};
    private static final String[] qosCTTypes = new String[]{"", "short", "medium", "long"};
    private static final String[] policyTypes = new String[]{"", "DSCP", "802.1p"};
    private static final String[] fwdTypes = new String[]{"", "L2", "PPPoE", "Voice"};
    private static final String[] slaTypes = new String[]{"", "L2", "PPPoE", "Voice"};
    private static final String[] qosMarkingTypes = new String[]{"", "transparent", "802.1p", "DSCP"};

    public RbXMLServiceProfileDistributionTaskExecutor(RbXMLServiceProfileDistributionTask task) {
        this.task = task;
        this.runtimeStatus = new OperationTaskRuntimeStatus();
        this.rootOperation = this.runtimeStatus.addOperation(null, "RbXMLServiceProfileDistributionTaskWithName", new Object[]{task.getName()});
    }

    public void execute(TaskExecutionContext ctx) {
        block5: {
            this.ctx = ctx;
            try {
                List<RbBaseStationEquipment> bsEquipmentList;
                this.task = (RbXMLServiceProfileDistributionTask)ServiceRegistry.getTaskManagerService().retrieveTask(this.task.getId());
                boolean fileIsNotSigned = true;
                if (this.task.getSource().equals((Object)RbXMLServiceProfileDistributionTask.MSPDDataSource.SP)) {
                    bsEquipmentList = this.createFileData();
                } else {
                    bsEquipmentList = new Vector<RbBaseStationEquipment>();
                    bsEquipmentList.addAll(this.task.getEquipmentList());
                    fileIsNotSigned = this.loadFileData();
                }
                if (fileIsNotSigned) {
                    this.fileData = DigitalFingerprint.appendFingerprint(DigitalFingerprint.RB_SECRET_STAMP, DigitalFingerprint.MessageDigestAlgorithm.MD5, this.fileData);
                }
                final Iterator<RbBaseStationEquipment> bsEquipmentIterator = bsEquipmentList.iterator();
                AsyncItemsExecutor itemsExecutor = new AsyncItemsExecutor((AsyncItemsProvider)new AsyncItemsProvider<RbServiceProfileConfigurator>(){

                    public boolean shouldAbort() {
                        return RbXMLServiceProfileDistributionTaskExecutor.this.taskShouldAbort();
                    }

                    public void itemFinished(RbServiceProfileConfigurator item) {
                    }

                    public void itemStarting(RbServiceProfileConfigurator item) {
                    }

                    public boolean hasNext() {
                        return bsEquipmentIterator.hasNext();
                    }

                    public RbServiceProfileConfigurator next() {
                        RbBaseStationEquipment nextBaseStation = (RbBaseStationEquipment)((Object)bsEquipmentIterator.next());
                        if (null == nextBaseStation) {
                            return null;
                        }
                        return new RbServiceProfileConfigurator(nextBaseStation);
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Remove Not Implemented!");
                    }
                });
                logger.debug((Object)("Starting task ItemsExecutor: " + this.task.getName()));
                itemsExecutor.executeItems();
                logger.debug((Object)("Done task ItemsExecutor: " + this.task.getName()));
                this.runtimeStatus.logOperationStatus(this.rootOperation, OperationStatus.COMPLETED);
            }
            catch (Exception e) {
                this.runtimeStatus.logOperationStatus(this.rootOperation, OperationStatus.FAILED);
                if (!logger.isDebugEnabled()) break block5;
                logger.debug((Object)"execute(TaskExecutionContext) -  : ", (Throwable)e);
            }
        }
        ctx.taskFinished();
    }

    private boolean loadFileData() throws FileNotFoundException, IOException {
        Operation op = this.runtimeStatus.addOperation(this.rootOperation, "LoadXMLFile");
        FileSystemService fileSystem = null;
        long handle = 0L;
        try {
            fileSystem = ServiceRegistry.getFileSystemService();
            handle = fileSystem.openFile(this.task.getXmlFileName(), 0);
            this.fileData = fileSystem.read(handle, (int)fileSystem.length(handle));
            this.runtimeStatus.logOperationStatus(op, OperationStatus.COMPLETED);
        }
        catch (FileNotFoundException e) {
            this.runtimeStatus.logOperationStatus(op, OperationStatus.FAILED, (Serializable)((Object)"FileNotFound"));
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            this.runtimeStatus.logOperationStatus(op, OperationStatus.FAILED, (Serializable)((Object)"FailedToLoadXMLFile"));
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                if (fileSystem != null) {
                    fileSystem.closeFile(handle);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        byte[] sigHeader = "<?NPU File Signature=".getBytes();
        if (sigHeader.length >= this.fileData.length) {
            return true;
        }
        for (int i = 0; i < sigHeader.length; ++i) {
            if (sigHeader[i] == this.fileData[i]) continue;
            return true;
        }
        return false;
    }

    private List<RbBaseStationEquipment> createFileData() throws Exception {
        final Vector<RbBaseStationEquipment> bsEquipmentList = new Vector<RbBaseStationEquipment>();
        final Vector<RbServiceProfile> serviceProfiles = new Vector<RbServiceProfile>();
        final Vector<RbForwardingRule> fwdRules = new Vector<RbForwardingRule>();
        final Vector<RbPolicyRule> policyRules = new Vector<RbPolicyRule>();
        final Vector<RbQoSProfile> qosProfiles = new Vector<RbQoSProfile>();
        this.xmlFileName = RbXMLServiceProfileDistributionTaskExecutor.createXMLFileName(this.task.getName());
        final Operation op = this.runtimeStatus.addOperation(this.rootOperation, "CreateXMLFile", new Object[]{this.xmlFileName});
        new RunnableDatastoreDecorator(new Runnable(){

            public void run() {
                RbXMLServiceProfileDistributionTaskExecutor.this.runtimeStatus.logOperationStatus(op, OperationStatus.IN_PROGRESS);
                RbXMLServiceProfileDistributionTaskExecutor.this.task = (RbXMLServiceProfileDistributionTask)((Object)Datastore.session().get(((Object)((Object)RbXMLServiceProfileDistributionTaskExecutor.this.task)).getClass(), (Serializable)Long.valueOf(RbXMLServiceProfileDistributionTaskExecutor.this.task.getId())));
                new RbServiceProfileDistributionTaskInterpretor().prepareFetch((Object)RbXMLServiceProfileDistributionTaskExecutor.this.task);
                bsEquipmentList.addAll(RbXMLServiceProfileDistributionTaskExecutor.this.task.getEquipmentList());
                serviceProfiles.addAll(RbXMLServiceProfileDistributionTaskExecutor.this.task.getServiceProfileList());
                RbXMLServiceProfileDistributionTaskExecutor.this.updateRbRules(serviceProfiles, fwdRules, policyRules, qosProfiles);
            }
        }).run();
        try {
            this.fileData = this.buildBaseXMLFile(this.task.getName(), this.xmlFileName, serviceProfiles, fwdRules, policyRules, qosProfiles).getBytes();
            this.runtimeStatus.logOperationStatus(op, OperationStatus.COMPLETED);
        }
        catch (Exception e) {
            this.runtimeStatus.logOperationStatus(op, OperationStatus.FAILED, (Serializable)((Object)e.getMessage()));
            throw e;
        }
        return bsEquipmentList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String buildBaseXMLFile(String taskName, String fileName, List<RbServiceProfile> serviceProfiles, List<RbForwardingRule> fwdRules, List<RbPolicyRule> policyRules, List<RbQoSProfile> qosProfiles) throws Exception {
        BufferedWriter bw = null;
        StringWriter sw = new StringWriter();
        try {
            bw = new BufferedWriter(sw);
            String line = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
            bw.write("\n" + line + "\n");
            line = "<service-profiles-folder name=\"" + taskName + "\">";
            bw.write(line + "\n");
            bw.write("\t<qos-profiles>\n");
            for (RbQoSProfile qos : qosProfiles) {
                int type = qos.getType();
                line = "\t\t<qos-profile name=\"" + qos.getName() + "\" type=\"" + qosTypes[type] + "\"";
                switch (type) {
                    case 0: {
                        line = line + " packet-size=\"" + qos.getParam1() + "\" sample-interval=\"" + qos.getParam2() + "\"";
                        break;
                    }
                    case 1: {
                        line = line + " cir=\"" + qos.getParam1() + "\" ct=\"" + qosCTTypes[qos.getParamTime()] + "\"";
                        break;
                    }
                    case 2: {
                        line = line + " cir=\"" + qos.getParam1() + "\" mir=\"" + qos.getParam2() + "\" ct=\"" + qosCTTypes[qos.getParamTime()] + "\"";
                        break;
                    }
                    case 3: {
                        line = line + " mir=\"" + qos.getParam2() + "\" ct=\"" + qosCTTypes[qos.getParamTime()] + "\"";
                    }
                }
                line = line + " />\n";
                bw.write(line);
            }
            bw.write("\t</qos-profiles>\n");
            bw.write("\t<priority-classifiers>\n");
            for (RbPolicyRule policy : policyRules) {
                line = "\t\t<priority-classifier name=\"" + policy.getName() + "\" type=\"" + policyTypes[policy.getPriorityType()] + "\">";
                bw.write(line + "\n");
                RbQoSProfile qos = policy.getUpQoSProfile1();
                if (null != qos && !qos.isValueNull()) {
                    line = "\t\t\t<uplink limit=\"" + policy.getUpQoSUpperLimit1() + "\" qos-profile=\"" + qos.getName() + "\" />";
                    bw.write(line + "\n");
                }
                if (null != (qos = policy.getUpQoSProfile2()) && !qos.isValueNull()) {
                    line = "\t\t\t<uplink limit=\"" + policy.getUpQoSUpperLimit2() + "\" qos-profile=\"" + qos.getName() + "\" />";
                    bw.write(line + "\n");
                }
                if (null != (qos = policy.getUpQoSProfile3()) && !qos.isValueNull()) {
                    line = "\t\t\t<uplink limit=\"" + policy.getUpQoSUpperLimit3() + "\" qos-profile=\"" + qos.getName() + "\" />";
                    bw.write(line + "\n");
                }
                if (null != (qos = policy.getUpQoSProfile4()) && !qos.isValueNull()) {
                    line = "\t\t\t<uplink limit=\"" + policy.getUpQoSUpperLimit4() + "\" qos-profile=\"" + qos.getName() + "\" />";
                    bw.write(line + "\n");
                }
                if (null != (qos = policy.getDownQoSProfile1()) && !qos.isValueNull()) {
                    line = "\t\t\t<downlink limit=\"" + policy.getDownQoSUpperLimit1() + "\" qos-profile=\"" + qos.getName() + "\" />";
                    bw.write(line + "\n");
                }
                if (null != (qos = policy.getDownQoSProfile2()) && !qos.isValueNull()) {
                    line = "\t\t\t<downlink limit=\"" + policy.getDownQoSUpperLimit2() + "\" qos-profile=\"" + qos.getName() + "\" />";
                    bw.write(line + "\n");
                }
                if (null != (qos = policy.getDownQoSProfile3()) && !qos.isValueNull()) {
                    line = "\t\t\t<downlink limit=\"" + policy.getDownQoSUpperLimit3() + "\" qos-profile=\"" + qos.getName() + "\" />";
                    bw.write(line + "\n");
                }
                if (null != (qos = policy.getDownQoSProfile4()) && !qos.isValueNull()) {
                    line = "\t\t\t<downlink limit=\"" + policy.getDownQoSUpperLimit4() + "\" qos-profile=\"" + qos.getName() + "\" />";
                    bw.write(line + "\n");
                }
                line = "\t\t</priority-classifier>\n";
                bw.write(line);
            }
            bw.write("\t</priority-classifiers>\n");
            bw.write("\t<forwarding-rules>\n");
            for (RbForwardingRule fwd : fwdRules) {
                int type = fwd.getType();
                line = "\t\t<forwarding-rule name=\"" + fwd.getName() + "\" type=\"" + fwdTypes[type] + "\"";
                switch (type) {
                    case 1: 
                    case 3: {
                        line = line + " unicast-relaying=\"" + (1 == fwd.getUnicastRelaying() ? "enabled" : "disabled") + "\"" + " multicast-relaying=\"" + (1 == fwd.getMulticastRelaying() ? "enabled" : "disabled") + "\"" + " unknown-forwarding-policy=\"" + (1 == fwd.getUnknownAddrPolicy() ? "reject" : "forward") + "\"";
                    }
                    case 2: {
                        if (null == fwd.getQoS()) break;
                        line = line + " multicast-qos-profile=\"" + fwd.getQoS().getName() + "\"";
                    }
                }
                line = line + " />\n";
                bw.write(line);
            }
            bw.write("\t</forwarding-rules>\n");
            bw.write("\t<service-profiles>\n");
            for (RbServiceProfile sla : serviceProfiles) {
                int type = RbServiceSynchronizationUtil.lookupServiceProfileType(sla);
                line = "\t\t<service-profile name=\"" + sla.getName() + "\" type=\"" + slaTypes[type] + "\"";
                boolean transparencyMode = sla.getVLANTransparencyMode() == 1;
                Integer VPLId = sla.getVPLId();
                if (null != VPLId && VPLId < 4095) {
                    line = line + " vplid=\"" + VPLId + "\"";
                }
                line = line + " transparent-mode=\"" + (transparencyMode ? "on" : "off") + "\"";
                RbForwardingRule fwd = null;
                RbPolicyRule policy = null;
                int maxNumberOfCalls = -1;
                switch (type) {
                    case 1: {
                        RbL2ServiceProfile rbL2ServiceProfile = (RbL2ServiceProfile)sla;
                        fwd = rbL2ServiceProfile.getForwardingRule();
                        policy = rbL2ServiceProfile.getPolicyRule();
                        maxNumberOfCalls = rbL2ServiceProfile.getMaxNumberOfSimultaneousCalls();
                        break;
                    }
                    case 2: {
                        RbPPPoEServiceProfile rbPPPoEServiceProfile = (RbPPPoEServiceProfile)sla;
                        fwd = rbPPPoEServiceProfile.getForwardingRule();
                        policy = rbPPPoEServiceProfile.getPolicyRule();
                        break;
                    }
                    case 3: {
                        RbVoIPServiceProfile rbVoIPServiceProfile = (RbVoIPServiceProfile)sla;
                        fwd = rbVoIPServiceProfile.getForwardingRule();
                        maxNumberOfCalls = rbVoIPServiceProfile.getMaxNumberOfSimultaneousCalls();
                        break;
                    }
                    case 4: {
                        RbIPModeDataServiceProfile rbIPModeDataServiceProfile = (RbIPModeDataServiceProfile)sla;
                        policy = rbIPModeDataServiceProfile.getPolicyRule();
                        break;
                    }
                    case 5: {
                        RbIPModeVoIPServiceProfile rbIPModeVoIPServiceProfile = (RbIPModeVoIPServiceProfile)sla;
                        policy = rbIPModeVoIPServiceProfile.getPolicyRule();
                        break;
                    }
                    case 6: {
                        RbManagedVoIPServiceProfile rbManagedVoIPServiceProfile = (RbManagedVoIPServiceProfile)sla;
                        fwd = rbManagedVoIPServiceProfile.getForwardingRule();
                        policy = rbManagedVoIPServiceProfile.getPolicyRule();
                        maxNumberOfCalls = rbManagedVoIPServiceProfile.getMaxNumberOfSimultaneousCalls();
                        break;
                    }
                    case 7: {
                        RbIPModeMngVoIPServiceProfile rbIPModeMngVoIPServiceProfile = (RbIPModeMngVoIPServiceProfile)sla;
                        policy = rbIPModeMngVoIPServiceProfile.getPolicyRule();
                        maxNumberOfCalls = rbIPModeMngVoIPServiceProfile.getMaxNumberOfSimultaneousCalls();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid value for RbServiceTemplateConfigEntry type");
                    }
                }
                if (null != fwd && !fwd.isValueNull()) {
                    line = line + " forwarding-rule=\"" + fwd.getName() + "\"";
                }
                if (null != policy) {
                    line = line + " priority-classifier=\"" + policy.getName() + "\"";
                }
                if (0 != sla.getPriorityMarkingMode()) {
                    line = line + " priority-marking-mode=\"" + qosMarkingTypes[sla.getPriorityMarkingMode()] + "\"";
                    if (0 != sla.getPriorityMarkingValue()) {
                        line = line + " priority-marking-value=\"" + sla.getPriorityMarkingValue() + "\"";
                    }
                }
                if (-1 != maxNumberOfCalls) {
                    line = line + " max-number-of-voice-calls=\"" + maxNumberOfCalls + "\"";
                }
                line = line + " />\n";
                bw.write(line);
            }
            bw.write("\t</service-profiles>\n");
            line = "</service-profiles-folder>";
            bw.write(line + "\n");
            bw.close();
            logger.debug((Object)sw.getBuffer().toString());
            FileSystemService fs = MediationServiceRegistry.getFileSystemService();
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileSystemFileOutputStream(fs, fileName)));
            bw.write(sw.getBuffer().toString());
            bw.close();
        }
        finally {
            try {
                if (null != bw) {
                    bw.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return sw.getBuffer().toString();
    }

    private static String createXMLFileName(String baseName) {
        StringBuffer fileName = new StringBuffer("service_profiles/");
        for (int i = 0; i < baseName.length(); ++i) {
            char ch = baseName.charAt(i);
            if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') && (ch < '0' || ch > '9')) continue;
            fileName.append(ch);
        }
        fileName.append(Calendar.getInstance().getTimeInMillis());
        fileName.append(".xml");
        return fileName.toString();
    }

    public TaskRuntimeStatus getStatus(Object clientData) {
        logger.debug((Object)("*** getStatus() " + clientData));
        Integer idx = null != clientData ? (Integer)clientData : 0;
        return this.runtimeStatus.getDiff(idx.intValue());
    }

    public String getReport() {
        return this.runtimeStatus.toXMLString();
    }

    private boolean taskShouldAbort() {
        return this.ctx.shouldAbort();
    }

    public int getExecutionResult() {
        if (this.ctx.shouldAbort()) {
            return 2;
        }
        if (!this.oneDidNotFailed) {
            return 3;
        }
        if (this.completedWithErrors) {
            return 4;
        }
        return 1;
    }

    private void updateRbRules(List<RbServiceProfile> serviceProfiles, List<RbForwardingRule> fwdRules, List<RbPolicyRule> policyRules, List<RbQoSProfile> qosProfiles) {
        TreeSet<String> fwdNames = new TreeSet<String>();
        TreeSet<String> policyNames = new TreeSet<String>();
        TreeSet<String> qosNames = new TreeSet<String>();
        for (RbServiceProfile sp : serviceProfiles) {
            RbQoSProfile qos;
            RbForwardingRule fwdRule = null;
            RbPolicyRule policyRule = null;
            int spType = RbServiceSynchronizationUtil.lookupServiceProfileType(sp);
            switch (spType) {
                case 1: {
                    RbL2ServiceProfile rbL2ServiceProfile = (RbL2ServiceProfile)sp;
                    fwdRule = rbL2ServiceProfile.getForwardingRule();
                    policyRule = rbL2ServiceProfile.getPolicyRule();
                    break;
                }
                case 2: {
                    RbPPPoEServiceProfile rbPPPoEServiceProfile = (RbPPPoEServiceProfile)sp;
                    fwdRule = rbPPPoEServiceProfile.getForwardingRule();
                    policyRule = rbPPPoEServiceProfile.getPolicyRule();
                    break;
                }
                case 4: {
                    RbIPModeDataServiceProfile rbIPModeDataServiceProfile = (RbIPModeDataServiceProfile)sp;
                    policyRule = rbIPModeDataServiceProfile.getPolicyRule();
                    break;
                }
                case 5: {
                    RbIPModeVoIPServiceProfile rbIPModeVoIPServiceProfile = (RbIPModeVoIPServiceProfile)sp;
                    policyRule = rbIPModeVoIPServiceProfile.getPolicyRule();
                    break;
                }
                case 6: {
                    RbManagedVoIPServiceProfile rbManagedVoIPServiceProfile = (RbManagedVoIPServiceProfile)sp;
                    fwdRule = rbManagedVoIPServiceProfile.getForwardingRule();
                    policyRule = rbManagedVoIPServiceProfile.getPolicyRule();
                    break;
                }
                case 7: {
                    RbIPModeMngVoIPServiceProfile rbIPModeMngVoIPServiceProfile = (RbIPModeMngVoIPServiceProfile)sp;
                    policyRule = rbIPModeMngVoIPServiceProfile.getPolicyRule();
                }
            }
            if (null != fwdRule && !fwdRule.isValueNull() && !fwdNames.contains(fwdRule.getName())) {
                fwdRules.add(fwdRule);
                fwdNames.add(fwdRule.getName());
                qos = fwdRule.getQoS();
                if (null != qos && !qos.isValueNull() && !qosNames.contains(qos.getName())) {
                    qosProfiles.add(qos);
                    qosNames.add(qos.getName());
                }
            }
            if (null == policyRule || policyNames.contains(policyRule.getName())) continue;
            policyRules.add(policyRule);
            policyNames.add(policyRule.getName());
            qos = policyRule.getUpQoSProfile1();
            if (null != qos && !qos.isValueNull() && !qosNames.contains(qos.getName())) {
                qosProfiles.add(qos);
                qosNames.add(qos.getName());
            }
            if (null != (qos = policyRule.getUpQoSProfile2()) && !qos.isValueNull() && !qosNames.contains(qos.getName())) {
                qosProfiles.add(qos);
                qosNames.add(qos.getName());
            }
            if (null != (qos = policyRule.getUpQoSProfile3()) && !qos.isValueNull() && !qosNames.contains(qos.getName())) {
                qosProfiles.add(qos);
                qosNames.add(qos.getName());
            }
            if (null != (qos = policyRule.getUpQoSProfile4()) && !qos.isValueNull() && !qosNames.contains(qos.getName())) {
                qosProfiles.add(qos);
                qosNames.add(qos.getName());
            }
            if (null != (qos = policyRule.getDownQoSProfile1()) && !qos.isValueNull() && !qosNames.contains(qos.getName())) {
                qosProfiles.add(qos);
                qosNames.add(qos.getName());
            }
            if (null != (qos = policyRule.getDownQoSProfile2()) && !qos.isValueNull() && !qosNames.contains(qos.getName())) {
                qosProfiles.add(qos);
                qosNames.add(qos.getName());
            }
            if (null != (qos = policyRule.getDownQoSProfile3()) && !qos.isValueNull() && !qosNames.contains(qos.getName())) {
                qosProfiles.add(qos);
                qosNames.add(qos.getName());
            }
            if (null == (qos = policyRule.getDownQoSProfile4()) || qos.isValueNull() || qosNames.contains(qos.getName())) continue;
            qosProfiles.add(qos);
            qosNames.add(qos.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RbServiceProfileConfigurator
    implements Runnable {
        private final int tftpDefaultTimeout = Integer.getInteger("com.bwanms.rb.tasks.servicedistribution.tftpDefaultTimeout", 5000);
        private final int tftpDefaultRetries = Integer.getInteger("com.bwanms.rb.tasks.servicedistribution.tftpDefaultRetries", 3);
        private final Logger logger = Logger.getLogger(RbServiceProfileConfigurator.class);
        private RbBaseStationEquipment equipment;

        public RbServiceProfileConfigurator(RbBaseStationEquipment equipment) {
            this.equipment = equipment;
        }

        @Override
        public void run() {
            if (RbXMLServiceProfileDistributionTaskExecutor.this.taskShouldAbort()) {
                return;
            }
            new RunnableDatastoreDecorator(new Runnable(){

                public void run() {
                    RbServiceProfileConfigurator.this.equipment = (RbBaseStationEquipment)((Object)Datastore.session().get(((Object)((Object)RbServiceProfileConfigurator.this.equipment)).getClass(), (Serializable)Long.valueOf(RbServiceProfileConfigurator.this.equipment.getId())));
                    Operation bsOperation = RbXMLServiceProfileDistributionTaskExecutor.this.runtimeStatus.addOperation(RbXMLServiceProfileDistributionTaskExecutor.this.rootOperation, "BsWithNameAndIP", new Object[]{RbServiceProfileConfigurator.this.equipment.getName(), RbServiceProfileConfigurator.this.equipment.getIPAddress()});
                    Operation uploadOperation = RbXMLServiceProfileDistributionTaskExecutor.this.runtimeStatus.addOperation(bsOperation, "Upload");
                    RbXMLServiceProfileDistributionTaskExecutor.this.runtimeStatus.logOperationStatus(uploadOperation, OperationStatus.IN_PROGRESS);
                    try {
                        TftpFileTransferService tftp = MediationServiceRegistry.getTftpFileTransferService();
                        SynchronousFileTransfer sft = new SynchronousFileTransfer((FileTransferService)tftp, "topic/TftpMediationTopic");
                        sft.executeTransfer((FileTransferRequest)new TftpFileTransferRequest(RbServiceProfileConfigurator.this.equipment.getIPAddress(), RbServiceProfileConfigurator.this.tftpDefaultRetries, RbServiceProfileConfigurator.this.tftpDefaultTimeout, RbXMLServiceProfileDistributionTaskExecutor.this.fileData, "profiles.xml"), 600000L);
                        List errors = Helpers.getConfigurationHelper().retrieveData((Equipment)RbServiceProfileConfigurator.this.equipment, "BS", RbXmlErrorReportEntry.class, "*");
                        if (errors.size() > 0) {
                            RbXMLServiceProfileDistributionTaskExecutor.this.runtimeStatus.logOperationStatus(uploadOperation, OperationStatus.COMPLETED_WITH_ERRORS);
                            RbServiceProfileConfigurator.this.updateRuntimeStatus(errors, RbXMLServiceProfileDistributionTaskExecutor.this.runtimeStatus, RbXMLServiceProfileDistributionTaskExecutor.this.rootOperation);
                            RbXMLServiceProfileDistributionTaskExecutor.this.completedWithErrors = true;
                        } else {
                            RbXMLServiceProfileDistributionTaskExecutor.this.runtimeStatus.logOperationStatus(uploadOperation, OperationStatus.COMPLETED);
                        }
                        RbXMLServiceProfileDistributionTaskExecutor.this.oneDidNotFailed = true;
                    }
                    catch (Exception e) {
                        RbXMLServiceProfileDistributionTaskExecutor.this.runtimeStatus.logOperationStatus(uploadOperation, OperationStatus.FAILED, (Serializable)((Object)e.getMessage()));
                        RbXMLServiceProfileDistributionTaskExecutor.this.runtimeStatus.logOperationStatus(bsOperation, OperationStatus.FAILED);
                        RbXMLServiceProfileDistributionTaskExecutor.this.completedWithErrors = true;
                        RbServiceProfileConfigurator.this.logger.debug((Object)"RbServiceProfileConfigurator.run error = ", (Throwable)e);
                    }
                    RbXMLServiceProfileDistributionTaskExecutor.this.runtimeStatus.logOperationStatus(bsOperation, OperationStatus.COMPLETED);
                }
            }).run();
        }

        private void updateRuntimeStatus(List<RbXmlErrorReportEntry> errors, OperationTaskRuntimeStatus runtimeStatus, Operation rootOperation) {
            Operation rbXmlErrorReportTable = runtimeStatus.addOperation(rootOperation, "rbXmlErrorReportTable", new Object[]{"idx", "lineNo", "folderType", "elementType", "errorType"});
            runtimeStatus.logOperationStatus(rbXmlErrorReportTable, OperationStatus.FAILED, (Serializable)((Object)""), new Object[]{RbXMLServiceProfileDistributionTaskView.i18n.translateString("idx"), RbXMLServiceProfileDistributionTaskView.i18n.translateString("lineNo"), RbXMLServiceProfileDistributionTaskView.i18n.translateString("folderType"), RbXMLServiceProfileDistributionTaskView.i18n.translateString("elementType"), RbXMLServiceProfileDistributionTaskView.i18n.translateString("errorType")});
            for (RbXmlErrorReportEntry error : errors) {
                Operation rbXmlErrorReportEntry = runtimeStatus.addOperation(rbXmlErrorReportTable, "rbXmlErrorReportEntry", new Object[]{"rbXmlErrorIdx", "rbXmlFileLineNumber", "rbXmlFolderType", "rbXmlElementType", "rbXmlErrorType"});
                runtimeStatus.logOperationStatus(rbXmlErrorReportEntry, OperationStatus.FAILED, (Serializable)((Object)""), new Object[]{error.getRbXmlErrorIdx(), error.getRbXmlFileLineNumber(), RbXMLServiceProfileDistributionTaskView.i18n.translateString(RbXmlErrorReportEntry.toStringRbXmlFolderType(error.getRbXmlFolderType())), RbXMLServiceProfileDistributionTaskView.i18n.translateString(RbXmlErrorReportEntry.toStringRbXmlElementType(error.getRbXmlElementType())), RbXMLServiceProfileDistributionTaskView.i18n.translateString(RbXmlErrorReportEntry.toStringRbXmlErrorType(error.getRbXmlErrorType()))});
            }
        }
    }
}

