/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.servicedistribution;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.SelectorUtil;
import com.bwanms.gui.SelectorView;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.model.Task;
import com.bwanms.rb.ddi.RbServiceSynchronizationUtil;
import com.bwanms.rb.gui.selectors.serviceprofile.RbServiceProfileSelectorView;
import com.bwanms.rb.gui.serviceprofiles.preview.RbServiceProfilePreviewContainer;
import com.bwanms.rb.model.services.RbServiceProfile;
import com.bwanms.rb.tasks.servicedistribution.RbServiceProfileMergeTask;
import com.bwanms.rb.tasks.servicedistribution.RbServiceProfileMergeTaskPanel;
import com.bwanms.ui.components.EntityManagerTableModel;
import com.bwanms.ui.components.SimpleRowTable;
import com.bwanms.ui.components.SimpleRowTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbServiceProfileMergeTaskView
extends AbstractBindedEditorView<Task> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbServiceProfileMergeTask.class);
    private static final Internationalizer ddi18n = Internationalizer.getInternationalizer((String)"com.bwanms.ddi");
    private RbServiceProfileMergeTaskPanel panel;
    private EntityManagerTableModel<RbServiceProfile> serviceProfileTableModel;

    public RbServiceProfileMergeTaskView() {
        this.initUI();
    }

    public List<Binder> getBinders() {
        ArrayList<Binder> binders = new ArrayList<Binder>();
        DefaultBinder binder = new DefaultBinder((Object)this.getUI(), (Object)this.entity);
        binder.add((Binding)new JTextFieldBinding("txtName", "name", i18n.translateString("Name")));
        binders.add((Binder)binder);
        return binders;
    }

    public void fillUI(Task entity) {
        boolean bEditTask;
        RbServiceProfileMergeTask task = (RbServiceProfileMergeTask)entity;
        boolean bl = bEditTask = null != task && null != task.getName() && 0 < task.getName().trim().length();
        if (bEditTask) {
            int targetRow;
            this.panel.getTxtName().setText(task.getName());
            for (RbServiceProfile serviceProfile : task.getServiceProfileList()) {
                this.serviceProfileTableModel.addRow((Object)serviceProfile, String.valueOf(serviceProfile.getId()));
            }
            if (0L != task.getTargetServiceProfileId() && -1 != (targetRow = this.serviceProfileTableModel.getEntityRow(String.valueOf(task.getTargetServiceProfileId())))) {
                this.serviceProfileTableModel.setHighlighted(targetRow, true);
            }
        }
    }

    public List<InvalidValue> configureEntity(Task entity) {
        ArrayList<Object> iValues = super.configureEntity((Serializable)entity);
        RbServiceProfileMergeTask task = (RbServiceProfileMergeTask)entity;
        task.setName(this.panel.getTxtName().getText());
        long targetSPId = 0L;
        ArrayList<RbServiceProfile> serviceProfileList = new ArrayList<RbServiceProfile>(this.serviceProfileTableModel.getRowCount());
        for (int row = 0; row < this.serviceProfileTableModel.getRowCount(); ++row) {
            if (1 == this.serviceProfileTableModel.getRowState(row)) continue;
            RbServiceProfile serviceProfile = (RbServiceProfile)((Object)this.serviceProfileTableModel.getEntity(row));
            serviceProfileList.add(serviceProfile);
            if (!this.serviceProfileTableModel.isHighlighted(row)) continue;
            targetSPId = serviceProfile.getId();
        }
        task.setServiceProfileList(serviceProfileList);
        if (serviceProfileList.size() < 2) {
            if (null == iValues) {
                iValues = new ArrayList<InvalidValue>(1);
            }
            iValues.add(new InvalidValue(i18n.translateString("SelectAtLeastTwoServiceProfilesForMerge"), RbServiceProfileMergeTask.class, "", (Object)"", (Object)task));
        } else if (0L == targetSPId) {
            if (null == iValues) {
                iValues = new ArrayList(1);
            }
            iValues.add(new InvalidValue(i18n.translateString("SelectTargetServiceProfile"), RbServiceProfileMergeTask.class, "targetServiceProfileId", (Object)0, (Object)task));
        }
        task.setTargetServiceProfileId(targetSPId);
        return iValues;
    }

    private void actionAddServiceProfiles() {
        RbServiceProfileSelectorView selectorView = new RbServiceProfileSelectorView(RbServiceProfile.class);
        SelectorUtil.displayModalSelector((JComponent)this.panel, (SelectorView)selectorView);
        List selection = selectorView.getSelection();
        if (!selection.isEmpty()) {
            boolean showWarning = false;
            String entityName = null;
            int entityType = 0;
            for (int i = 0; i < this.serviceProfileTableModel.getRowCount(); ++i) {
                if (1 == this.serviceProfileTableModel.getRowState(i)) continue;
                RbServiceProfile serviceProfile = (RbServiceProfile)((Object)this.serviceProfileTableModel.getEntity(i));
                entityName = serviceProfile.getName();
                entityType = RbServiceSynchronizationUtil.lookupServiceProfileType(serviceProfile);
                break;
            }
            if (null == entityName) {
                entityName = ((RbServiceProfile)((Object)selection.get(0))).getName();
                entityType = RbServiceSynchronizationUtil.lookupServiceProfileType((RbServiceProfile)((Object)selection.get(0)));
            }
            for (RbServiceProfile serviceProfile : selection) {
                if (!entityName.equals(serviceProfile.getName()) || entityType != RbServiceSynchronizationUtil.lookupServiceProfileType(serviceProfile)) {
                    showWarning = true;
                    continue;
                }
                String key = String.valueOf(serviceProfile.getId());
                int row = this.serviceProfileTableModel.getEntityRow(key);
                if (-1 != row) {
                    this.serviceProfileTableModel.updateRow((Object)serviceProfile, key);
                    this.serviceProfileTableModel.revertRow(row);
                    continue;
                }
                this.serviceProfileTableModel.addRow((Object)serviceProfile, key);
            }
            if (showWarning) {
                String entityTypeStr = ddi18n.translateString(RbServiceSynchronizationUtil.lookupServiceProfileClass(entityType));
                JOptionPane.showMessageDialog(this.panel, i18n.translateString("OnlyServiceProfilesWithNameAndTypeWereAdded", new Object[]{entityName, entityTypeStr}), i18n.translateString("Warning"), 1);
            }
        }
    }

    private void actionRemoveServiceProfiles() {
        int[] selectedRows = this.panel.getTableServiceProfiles().getSelectedRows();
        this.serviceProfileTableModel.removeRows(selectedRows);
    }

    private void actionSetAsTargetServiceProfile() {
        int[] selectedRows = this.panel.getTableServiceProfiles().getSelectedRows();
        if (1 != selectedRows.length) {
            JOptionPane.showMessageDialog(this.panel, "Please Select One Service Profile");
            return;
        }
        for (int i = 0; i < this.serviceProfileTableModel.getRowCount(); ++i) {
            if (!this.serviceProfileTableModel.isHighlighted(i)) continue;
            this.serviceProfileTableModel.setHighlighted(i, false);
            break;
        }
        this.serviceProfileTableModel.setHighlighted(selectedRows[0], true);
    }

    private void actionPreviewServiceProfile() {
        int[] selectedRows = this.panel.getTableServiceProfiles().getSelectedRows();
        if (1 != selectedRows.length) {
            JOptionPane.showMessageDialog(this.panel, "Please Select One Service Profile");
            return;
        }
        RbServiceProfile serviceProfile = (RbServiceProfile)((Object)this.serviceProfileTableModel.getEntity(selectedRows[0]));
        new RbServiceProfilePreviewContainer(serviceProfile, true, (Object[])null);
    }

    private void initUI() {
        this.panel = new RbServiceProfileMergeTaskPanel();
        final RbServiceProfileSelectorView spSelectorView = new RbServiceProfileSelectorView(RbServiceProfile.class);
        SimpleRowTableModel.ColumnDefinition[] colDefs = new SimpleRowTableModel.ColumnDefinition[spSelectorView.getColumnNames().length];
        int idx = 0;
        for (String colName : spSelectorView.getColumnNames()) {
            colDefs[idx++] = new SimpleRowTableModel.ColumnDefinition(colName, String.class);
        }
        this.serviceProfileTableModel = new EntityManagerTableModel<RbServiceProfile>(colDefs){
            private static final long serialVersionUID = 7450049907564807073L;

            public void setRowValues(int row, RbServiceProfile entity) {
                EntityManagerRowProvider rowProvider = spSelectorView.getEntityRowProvider();
                EntityManagerRow entityRow = rowProvider.createRow((Serializable)((Object)entity));
                List displayValues = rowProvider.getDisplayValues(entityRow);
                for (int i = 0; i < displayValues.size(); ++i) {
                    this.setInitialValueAt(displayValues.get(i), row, i);
                }
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        };
        new SimpleRowTable(this.panel.getTableServiceProfiles(), this.serviceProfileTableModel);
        this.panel.getBtnServiceProfilesAdd().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RbServiceProfileMergeTaskView.this.actionAddServiceProfiles();
            }
        });
        this.panel.getBtnServiceProfilesRemove().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RbServiceProfileMergeTaskView.this.actionRemoveServiceProfiles();
            }
        });
        this.panel.getBtnServiceProfilesSetAsTarget().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RbServiceProfileMergeTaskView.this.actionSetAsTargetServiceProfile();
            }
        });
        this.panel.getBtnServiceProfilesPreview().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RbServiceProfileMergeTaskView.this.actionPreviewServiceProfile();
            }
        });
        this.panel.getTableServiceProfiles().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                RbServiceProfileMergeTaskView.this.fireServiceProfilesTableSelectionChanged();
            }
        });
        i18n.getSwingInternationalizer().translateComponent((Component)this.panel);
        this.fireServiceProfilesTableSelectionChanged();
    }

    private void fireServiceProfilesTableSelectionChanged() {
        this.panel.getBtnServiceProfilesRemove().setEnabled(0 < this.panel.getTableServiceProfiles().getSelectedRowCount());
        this.panel.getBtnServiceProfilesSetAsTarget().setEnabled(1 == this.panel.getTableServiceProfiles().getSelectedRowCount());
        this.panel.getBtnServiceProfilesPreview().setEnabled(1 == this.panel.getTableServiceProfiles().getSelectedRowCount());
    }

    public JComponent getUI() {
        return this.panel;
    }

    public boolean close() {
        return true;
    }

    public String getTitle() {
        return i18n.translateString("RbServiceProfileMergeTaskTitle");
    }

    public String getApplicationPermission() {
        return "Av:ConfigureTasks";
    }

    public String getHelpTopic() {
        return "";
    }
}

