/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.servicedistribution;

import com.bwanms.ddi.ServiceManagementException;
import com.bwanms.mediation.MediationException;
import com.bwanms.model.Equipment;
import com.bwanms.model.ServiceProfile;
import com.bwanms.model.TaskExecutionContext;
import com.bwanms.model.TaskExecutor;
import com.bwanms.model.TaskRuntimeStatus;
import com.bwanms.persistence.Datastore;
import com.bwanms.persistence.RunnableDatastoreDecorator;
import com.bwanms.rb.ddi.RbServiceManagementStrategy;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.services.RbServiceProfile;
import com.bwanms.rb.tasks.servicedistribution.RbServiceDistributionHelper;
import com.bwanms.rb.tasks.servicedistribution.RbServiceProfileMergeTask;
import com.bwanms.services.impl.LockManagerLocator;
import com.bwanms.util.concurrent.AsyncItemsExecutor;
import com.bwanms.util.concurrent.AsyncItemsProvider;
import com.bwanms.util.task.Operation;
import com.bwanms.util.task.OperationStatus;
import com.bwanms.util.task.OperationTaskRuntimeStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import org.apache.log4j.Logger;

public class RbServiceProfileMergeTaskExecutor
implements TaskExecutor {
    private static final Logger logger = Logger.getLogger(RbServiceProfileMergeTaskExecutor.class);
    private transient TaskExecutionContext ctx = null;
    private RbServiceProfileMergeTask task;
    private OperationTaskRuntimeStatus runtimeStatus;
    private Operation rootOperation;
    private HashMap<Long, Operation> operationMap = new HashMap();

    public RbServiceProfileMergeTaskExecutor(RbServiceProfileMergeTask task) {
        this.task = task;
        this.runtimeStatus = new OperationTaskRuntimeStatus();
        this.rootOperation = this.runtimeStatus.addOperation(null, "RbServiceProfileMergeTaskWithName", new Object[]{task.getName()});
    }

    private synchronized void logStatus(RbBaseStationEquipment bsEq, OperationStatus status, String message) {
        if (null != bsEq) {
            logger.debug((Object)("logStatus:  bsEq " + bsEq.getIPAddress() + "  message " + message));
            Operation eqOp = this.operationMap.get(bsEq.getId());
            if (null == eqOp) {
                eqOp = this.runtimeStatus.addOperation(this.rootOperation, "MergeServiceProfileOn", new Object[]{bsEq.getIPAddress() + "/" + bsEq.getName()});
                this.operationMap.put(bsEq.getId(), eqOp);
            }
            this.runtimeStatus.logOperationStatus(eqOp, status, (Serializable)((Object)message));
        } else {
            this.runtimeStatus.logOperationStatus(this.rootOperation, status, (Serializable)((Object)message));
        }
    }

    public void execute(TaskExecutionContext ctx) {
        this.ctx = ctx;
        final ArrayList targetSPList = new ArrayList(1);
        final Vector serviceProfileList = new Vector();
        final Vector bsEquipmentList = new Vector();
        new RunnableDatastoreDecorator(new Runnable(){

            public void run() {
                RbServiceProfileMergeTaskExecutor.this.task = (RbServiceProfileMergeTask)((Object)Datastore.session().get(((Object)((Object)RbServiceProfileMergeTaskExecutor.this.task)).getClass(), (Serializable)Long.valueOf(RbServiceProfileMergeTaskExecutor.this.task.getId())));
                RbServiceProfileMergeTaskExecutor.this.task.loadServiceProfileList();
                RbServiceManagementStrategy strategy = new RbServiceManagementStrategy();
                long targetServiceProfileId = RbServiceProfileMergeTaskExecutor.this.task.getTargetServiceProfileId();
                for (RbServiceProfile serviceProfile : RbServiceProfileMergeTaskExecutor.this.task.getServiceProfileList()) {
                    if (serviceProfile.getId() == targetServiceProfileId) {
                        targetSPList.add(serviceProfile);
                        continue;
                    }
                    serviceProfileList.add(serviceProfile);
                    bsEquipmentList.addAll(strategy.findServiceProfileInstances(serviceProfile));
                }
                if (targetSPList.isEmpty()) {
                    logger.debug((Object)("Target RbSeviceProfile with id " + targetServiceProfileId + " not found!"));
                }
            }
        }).run();
        if (!targetSPList.isEmpty()) {
            final RbServiceProfile targetServiceProfile = (RbServiceProfile)((Object)targetSPList.get(0));
            final Iterator bsEquipmentIterator = bsEquipmentList.iterator();
            if (serviceProfileList.isEmpty()) {
                this.logStatus(null, OperationStatus.FAILED, "NoServiceProfilesToMerge");
            } else {
                AsyncItemsExecutor itemsExecutor = new AsyncItemsExecutor((AsyncItemsProvider)new AsyncItemsProvider<RbServiceProfileMerger>(){

                    public boolean shouldAbort() {
                        return RbServiceProfileMergeTaskExecutor.this.taskShouldAbort();
                    }

                    public void itemFinished(RbServiceProfileMerger item) {
                    }

                    public void itemStarting(RbServiceProfileMerger item) {
                    }

                    public boolean hasNext() {
                        return bsEquipmentIterator.hasNext();
                    }

                    public RbServiceProfileMerger next() {
                        RbBaseStationEquipment nextBaseStation = (RbBaseStationEquipment)((Object)bsEquipmentIterator.next());
                        if (null == nextBaseStation) {
                            return null;
                        }
                        return new RbServiceProfileMerger(nextBaseStation, targetServiceProfile);
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Remove Not Implemented!");
                    }
                });
                logger.debug((Object)"Started merge service profiles executor.");
                itemsExecutor.executeItems();
                logger.debug((Object)"Done merge service profiles executor.");
                this.logStatus(null, OperationStatus.COMPLETED, null);
            }
        } else {
            this.logStatus(null, OperationStatus.FAILED, "TargetServiceProfileNotDefined");
        }
        ctx.taskFinished();
    }

    public TaskRuntimeStatus getStatus(Object clientData) {
        Integer idx = null != clientData ? (Integer)clientData : 0;
        return this.runtimeStatus.getDiff(idx.intValue());
    }

    public String getReport() {
        return this.runtimeStatus.toXMLString();
    }

    private boolean taskShouldAbort() {
        return this.ctx.shouldAbort();
    }

    public int getExecutionResult() {
        if (this.ctx.shouldAbort()) {
            return 2;
        }
        return 1;
    }

    private class RbServiceProfileMerger
    implements Runnable {
        private RbBaseStationEquipment equipment;
        private RbServiceProfile serviceProfile;

        public RbServiceProfileMerger(RbBaseStationEquipment equipment, RbServiceProfile serviceProfile) {
            this.equipment = equipment;
            this.serviceProfile = serviceProfile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (RbServiceProfileMergeTaskExecutor.this.taskShouldAbort()) {
                return;
            }
            final RbServiceManagementStrategy serviceManagement = new RbServiceManagementStrategy();
            Lock lock = LockManagerLocator.locate().getLock(Equipment.getConfigurationLockKey((long)this.equipment.getId()));
            lock.lock();
            try {
                new RunnableDatastoreDecorator(new Runnable(){

                    public void run() {
                        RbServiceProfileMerger.this.equipment = (RbBaseStationEquipment)((Object)Datastore.session().get(((Object)((Object)RbServiceProfileMerger.this.equipment)).getClass(), (Serializable)Long.valueOf(RbServiceProfileMerger.this.equipment.getId())));
                        RbServiceProfileMerger.this.serviceProfile = (RbServiceProfile)((Object)Datastore.session().get(((Object)((Object)RbServiceProfileMerger.this.serviceProfile)).getClass(), (Serializable)Long.valueOf(RbServiceProfileMerger.this.serviceProfile.getId())));
                        RbServiceProfileMergeTaskExecutor.this.logStatus(RbServiceProfileMerger.this.equipment, OperationStatus.IN_PROGRESS, null);
                        logger.debug((Object)("-- starting deploy for service " + RbServiceProfileMerger.this.serviceProfile.getName() + "  on " + RbServiceProfileMerger.this.equipment.getEUID()));
                        String result = null;
                        try {
                            int status = serviceManagement.deployServiceProfile((ServiceProfile)RbServiceProfileMerger.this.serviceProfile, (Equipment)RbServiceProfileMerger.this.equipment);
                            result = RbServiceDistributionHelper.getResultMessage(status, 3);
                            OperationStatus opStatus = RbServiceDistributionHelper.getOperationStatus(status);
                            RbServiceProfileMergeTaskExecutor.this.logStatus(RbServiceProfileMerger.this.equipment, opStatus, result);
                        }
                        catch (ServiceManagementException sme) {
                            RbServiceProfileMergeTaskExecutor.this.logStatus(RbServiceProfileMerger.this.equipment, OperationStatus.FAILED, sme.getMessage());
                            result = "Failed";
                        }
                        catch (MediationException me) {
                            RbServiceProfileMergeTaskExecutor.this.logStatus(RbServiceProfileMerger.this.equipment, OperationStatus.FAILED, "AgentError");
                            result = "Failed";
                            logger.debug((Object)me.getMessage());
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                            RbServiceProfileMergeTaskExecutor.this.logStatus(RbServiceProfileMerger.this.equipment, OperationStatus.FAILED, null);
                            result = "Failed";
                        }
                        logger.debug((Object)("-- done deploy for service " + RbServiceProfileMerger.this.serviceProfile.getName() + "  on " + RbServiceProfileMerger.this.equipment.getEUID() + " result: " + result));
                    }
                }).run();
            }
            finally {
                lock.unlock();
            }
            logger.debug((Object)"-- performing serviceprofiles cleanup.");
            RbServiceDistributionHelper svcDistHelper = new RbServiceDistributionHelper(this.equipment);
            svcDistHelper.performServiceProfilesCleanup();
        }
    }
}

