/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.servicedistribution;

import com.bwanms.model.ManagedEntityBase;
import com.bwanms.model.ManagedEntityWeakAssociation;
import com.bwanms.model.TaskExecutor;
import com.bwanms.model.Validatable;
import com.bwanms.rb.model.services.RbServiceProfile;
import com.bwanms.rb.tasks.servicedistribution.RbServiceDistributionBaseTask;
import com.bwanms.rb.tasks.servicedistribution.RbServiceDistributionHelper;
import com.bwanms.rb.tasks.servicedistribution.RbServiceProfileMergeTaskExecutor;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="RbSPMergeTask")
public class RbServiceProfileMergeTask
extends RbServiceDistributionBaseTask
implements Validatable {
    private long targetServiceProfileId;
    private List<RbServiceProfile> serviceProfileList;

    public long getTargetServiceProfileId() {
        return this.targetServiceProfileId;
    }

    public void setTargetServiceProfileId(long targetServiceProfileId) {
        this.targetServiceProfileId = targetServiceProfileId;
    }

    public TaskExecutor createExecutor() {
        return new RbServiceProfileMergeTaskExecutor(this);
    }

    void loadServiceProfileList() {
        List<ManagedEntityWeakAssociation> meWAList = this.getManagedEntityAssociations();
        this.serviceProfileList = new ArrayList<RbServiceProfile>(meWAList.size());
        for (ManagedEntityWeakAssociation meWA : meWAList) {
            ManagedEntityBase me = meWA.getManagedEntity();
            if (null == me) continue;
            this.serviceProfileList.add((RbServiceProfile)me);
        }
    }

    void saveServiceProfileList() {
        RbServiceDistributionHelper.mergeMEWeakAssociationLists(this.getManagedEntityAssociations(), this.serviceProfileList);
    }

    @Transient
    public List<RbServiceProfile> getServiceProfileList() {
        return this.serviceProfileList;
    }

    public void setServiceProfileList(List<RbServiceProfile> serviceProfileList) {
        this.serviceProfileList = serviceProfileList;
    }

    public void validate(List<InvalidValue> invalidValues) {
        super.validate(invalidValues);
    }
}

