/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.servicedistribution;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.SelectorUtil;
import com.bwanms.gui.SelectorView;
import com.bwanms.gui.Selectors;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.equipmentmanager.EquipmentRowProviderClient;
import com.bwanms.model.ServiceProfile;
import com.bwanms.model.Task;
import com.bwanms.model.entity.Assembly;
import com.bwanms.model.entity.LightQuery;
import com.bwanms.rb.gui.managers.RbBaseStationEquipmentRowProvider;
import com.bwanms.rb.gui.selectors.equipment.RbBaseStationSelectorView;
import com.bwanms.rb.gui.selectors.serviceprofile.RbServiceProfileSelectorView;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.services.RbServiceProfile;
import com.bwanms.rb.tasks.servicedistribution.RbServiceDistributionTask;
import com.bwanms.rb.tasks.servicedistribution.RbServiceProfileDistributionTask;
import com.bwanms.rb.tasks.servicedistribution.RbServiceProfileDistributionTaskPanel;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.EntityManagerTableModel;
import com.bwanms.ui.components.SimpleRowTable;
import com.bwanms.ui.components.SimpleRowTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbServiceProfileDistributionTaskView
extends AbstractBindedEditorView<Task> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbServiceProfileDistributionTask.class);
    private static final Logger log = Logger.getLogger(RbServiceProfileDistributionTaskView.class);
    private RbServiceProfileDistributionTaskPanel panel;
    private EntityManagerTableModel<RbBaseStationEquipment> equipmentTableModel;
    private EntityManagerTableModel<EntityManagerRow> serviceProfileTableModel;

    public RbServiceProfileDistributionTaskView() {
        this.initUI();
    }

    public List<Binder> getBinders() {
        ArrayList<Binder> binders = new ArrayList<Binder>();
        DefaultBinder binder = new DefaultBinder((Object)this.getUI(), (Object)this.entity);
        binder.add((Binding)new JTextFieldBinding("txtName", "name", i18n.translateString("Name")));
        binders.add((Binder)binder);
        return binders;
    }

    public void fillUI(Task entity) {
        ComboItem itemToSelect;
        boolean bEditTask;
        RbServiceProfileDistributionTask task = (RbServiceProfileDistributionTask)entity;
        boolean bl = bEditTask = task.getId() > 0L;
        if (bEditTask) {
            this.panel.getTxtName().setText(task.getName());
        }
        if (null != (itemToSelect = ComboItem.findItemByValue((JComboBox)this.panel.getComboBoxOperation(), (Object)task.getOperation()))) {
            this.panel.getComboBoxOperation().setSelectedItem(itemToSelect);
        }
        this.equipmentTableModel.clearTable();
        if (task.getEquipmentList() != null) {
            for (RbBaseStationEquipment equipment : task.getEquipmentList()) {
                this.equipmentTableModel.addRow((Object)equipment, String.valueOf(equipment.getId()));
            }
        }
        this.serviceProfileTableModel.clearTable();
        if (task.getServiceProfileList() != null) {
            RbServiceProfileSelectorView spManagerSelectorView = new RbServiceProfileSelectorView(RbServiceProfile.class, RbServiceProfile.class.getName() + "_svcdistribution_selector");
            EntityManagerRowProvider rowProvider = spManagerSelectorView.getEntityRowProvider();
            for (RbServiceProfile serviceProfile : task.getServiceProfileList()) {
                EntityManagerRow spRow = rowProvider.createRow((Serializable)((Object)serviceProfile));
                this.serviceProfileTableModel.addRow((Object)spRow, String.valueOf(serviceProfile.getId()));
            }
        }
        this.panel.getChckOverwriteBuildingBlocks().setSelected(task.isOverwriteBuildingBlocks());
    }

    public List<InvalidValue> configureEntity(Task entity) {
        List ivList = super.configureEntity((Serializable)entity);
        RbServiceProfileDistributionTask task = (RbServiceProfileDistributionTask)entity;
        task.setName(this.panel.getTxtName().getText());
        task.setOperation((Integer)((ComboItem)this.panel.getComboBoxOperation().getSelectedItem()).getValue());
        ArrayList<RbBaseStationEquipment> equipmentList = new ArrayList<RbBaseStationEquipment>(this.equipmentTableModel.getRowCount());
        for (int row = 0; row < this.equipmentTableModel.getRowCount(); ++row) {
            if (1 == this.equipmentTableModel.getRowState(row)) continue;
            equipmentList.add((RbBaseStationEquipment)((Object)this.equipmentTableModel.getEntity(row)));
        }
        task.setEquipmentList(equipmentList);
        ArrayList<RbServiceProfile> serviceProfileList = new ArrayList<RbServiceProfile>(this.serviceProfileTableModel.getRowCount());
        for (int row = 0; row < this.serviceProfileTableModel.getRowCount(); ++row) {
            if (1 == this.serviceProfileTableModel.getRowState(row)) continue;
            RbServiceProfile rbSP = (RbServiceProfile)((Object)((EntityManagerRow)this.serviceProfileTableModel.getEntity(row)).getEntity());
            if (this.isServiceProfileMissing(rbSP.getId())) {
                ivList.add(new InvalidValue(i18n.translateString("DeletedServiceProfiles"), List.class, i18n.translateString("ServiceProfiles"), (Object)rbSP.getName(), null));
                continue;
            }
            serviceProfileList.add(rbSP);
        }
        if (ivList.size() > 0) {
            return ivList;
        }
        task.setServiceProfileList(serviceProfileList);
        task.setOverwriteBuildingBlocks(this.panel.getChckOverwriteBuildingBlocks().isSelected());
        if (this.panel.getTableEquipment().getModel().getRowCount() == 0) {
            ivList.add(new InvalidValue(i18n.translateString("NoEquipment"), List.class, i18n.translateString("Equipment"), (Object)"", null));
            return ivList;
        }
        if (this.panel.getTableServiceProfiles().getModel().getRowCount() == 0) {
            ivList.add(new InvalidValue(i18n.translateString("NoServiceProfiles"), List.class, i18n.translateString("ServiceProfiles"), (Object)"", null));
            return ivList;
        }
        return super.configureEntity((Serializable)entity);
    }

    private boolean isServiceProfileMissing(long id) {
        try {
            LightQuery query = new LightQuery(ServiceProfile.class);
            query.addParameter("id", (Object)new Integer((int)id));
            List sps = ServiceRegistry.getEntityManagerService().retrieveByQuery(query);
            if (null == sps || sps.isEmpty()) {
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return false;
    }

    private void actionOperationChanged() {
        ComboItem selection = (ComboItem)this.panel.getComboBoxOperation().getSelectedItem();
        this.panel.getChckOverwriteBuildingBlocks().setVisible(null != selection && 1 == (Integer)selection.getValue());
    }

    private void actionAddEquipment() {
        SelectorView selectorView = Selectors.getSelectorView(RbBaseStationEquipment.class, (String)(RbServiceDistributionTask.class.getName() + "_selector"), (String)"multipleSelection");
        if (selectorView == null) {
            throw new IllegalArgumentException("Selector View must be defined!");
        }
        SelectorUtil.displayModalSelector((JComponent)this.panel, (SelectorView)selectorView);
        for (RbBaseStationEquipment equipment : selectorView.getSelection()) {
            String key = String.valueOf(equipment.getId());
            int row = this.equipmentTableModel.getEntityRow(key);
            if (-1 != row) {
                this.equipmentTableModel.updateRow((Object)equipment, key);
                this.equipmentTableModel.revertRow(row);
                continue;
            }
            this.equipmentTableModel.addRow((Object)equipment, key);
        }
    }

    private void actionRemoveEquipment() {
        int[] selectedRows = this.panel.getTableEquipment().getSelectedRows();
        this.equipmentTableModel.removeRows(selectedRows);
    }

    private void actionAddServiceProfiles() {
        RbServiceProfileSelectorView spManagerSelectorView = new RbServiceProfileSelectorView(RbServiceProfile.class, RbServiceProfile.class.getName() + "_svcdistribution_selector");
        SelectorUtil.displayModalSelector((JComponent)this.panel, (SelectorView)spManagerSelectorView);
        for (Assembly spAssembly : spManagerSelectorView.getSelectionData()) {
            RbServiceProfile serviceProfile = (RbServiceProfile)((Object)spAssembly.getEntity());
            String key = String.valueOf(serviceProfile.getId());
            int row = this.serviceProfileTableModel.getEntityRow(key);
            if (-1 != row) {
                this.serviceProfileTableModel.updateRow((Object)((EntityManagerRow)spAssembly), key);
                this.serviceProfileTableModel.revertRow(row);
                continue;
            }
            this.serviceProfileTableModel.addRow((Object)((EntityManagerRow)spAssembly), key);
        }
    }

    private void actionRemoveServiceProfiles() {
        int[] selectedRows = this.panel.getTableServiceProfiles().getSelectedRows();
        this.serviceProfileTableModel.removeRows(selectedRows);
    }

    private void initUI() {
        this.panel = new RbServiceProfileDistributionTaskPanel();
        this.panel.getComboBoxOperation().setModel(new DefaultComboBoxModel<Object>(new Object[]{new ComboItem((Object)1, i18n.translateString("DeployOp")), new ComboItem((Object)2, i18n.translateString("UndeployOp"))}));
        final RbBaseStationSelectorView bsEqManagerSelectorView = new RbBaseStationSelectorView("RbServiceProfileDistributionTask_selector", "multipleSelection");
        SimpleRowTableModel.ColumnDefinition[] colDefs = new SimpleRowTableModel.ColumnDefinition[bsEqManagerSelectorView.getColumnNames().length];
        int idx = 0;
        for (String colName : bsEqManagerSelectorView.getColumnNames()) {
            colDefs[idx++] = new SimpleRowTableModel.ColumnDefinition(colName, String.class);
        }
        this.equipmentTableModel = new EntityManagerTableModel<RbBaseStationEquipment>(colDefs){
            private static final long serialVersionUID = -8530492792413535921L;

            public void setRowValues(int row, RbBaseStationEquipment entity) {
                EquipmentRowProviderClient rowProvider = new EquipmentRowProviderClient(bsEqManagerSelectorView.getEntityRowProvider().getAttributes()){

                    public List<String> getDisplayValues(EntityManagerRow entityRow) {
                        List ret = super.getDisplayValues(entityRow);
                        ret.set(7, RbBaseStationEquipmentRowProvider.toStringSwitchingMode((String)ret.get(7)));
                        return ret;
                    }
                };
                EntityManagerRow entityRow = rowProvider.createRow((Serializable)((Object)entity));
                List displayValues = rowProvider.getDisplayValues(entityRow);
                for (int i = 0; i < displayValues.size(); ++i) {
                    this.setInitialValueAt(displayValues.get(i), row, i);
                }
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        };
        new SimpleRowTable(this.panel.getTableEquipment(), this.equipmentTableModel);
        final RbServiceProfileSelectorView spManagerSelectorView = new RbServiceProfileSelectorView(RbServiceProfile.class);
        colDefs = new SimpleRowTableModel.ColumnDefinition[spManagerSelectorView.getColumnNames().length];
        idx = 0;
        for (String colName : spManagerSelectorView.getColumnNames()) {
            colDefs[idx++] = new SimpleRowTableModel.ColumnDefinition(colName, String.class);
        }
        this.serviceProfileTableModel = new EntityManagerTableModel<EntityManagerRow>(colDefs){
            private static final long serialVersionUID = 8751654291956695731L;

            public void setRowValues(int row, EntityManagerRow spRow) {
                EntityManagerRowProvider rowProvider = spManagerSelectorView.getEntityRowProvider();
                List displayValues = rowProvider.getDisplayValues(spRow);
                for (int i = 0; i < displayValues.size(); ++i) {
                    this.setInitialValueAt(displayValues.get(i), row, i);
                }
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        };
        new SimpleRowTable(this.panel.getTableServiceProfiles(), this.serviceProfileTableModel);
        this.panel.getComboBoxOperation().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RbServiceProfileDistributionTaskView.this.actionOperationChanged();
            }
        });
        this.panel.getBtnEquipmentAdd().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RbServiceProfileDistributionTaskView.this.actionAddEquipment();
            }
        });
        this.panel.getBtnEquipmentRemove().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RbServiceProfileDistributionTaskView.this.actionRemoveEquipment();
            }
        });
        this.panel.getBtnServiceProfilesAdd().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RbServiceProfileDistributionTaskView.this.actionAddServiceProfiles();
            }
        });
        this.panel.getBtnServiceProfilesRemove().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RbServiceProfileDistributionTaskView.this.actionRemoveServiceProfiles();
            }
        });
        this.panel.getTableEquipment().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                RbServiceProfileDistributionTaskView.this.fireEquipmentTableSelectionChanged();
            }
        });
        this.panel.getTableServiceProfiles().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                RbServiceProfileDistributionTaskView.this.fireServiceProfilesTableSelectionChanged();
            }
        });
        i18n.getSwingInternationalizer().translateComponent((Component)this.panel);
        this.fireEquipmentTableSelectionChanged();
        this.fireServiceProfilesTableSelectionChanged();
    }

    private void fireServiceProfilesTableSelectionChanged() {
        this.panel.getBtnServiceProfilesRemove().setEnabled(0 < this.panel.getTableServiceProfiles().getSelectedRowCount());
    }

    private void fireEquipmentTableSelectionChanged() {
        this.panel.getBtnEquipmentRemove().setEnabled(0 < this.panel.getTableEquipment().getSelectedRowCount());
    }

    public JComponent getUI() {
        return this.panel;
    }

    public boolean close() {
        return true;
    }

    public String getTitle() {
        return i18n.translateString("RbServiceProfileDistributionTaskTitle");
    }

    public String getApplicationPermission() {
        return "Av:ConfigureTasks";
    }

    public String getHelpTopic() {
        return "";
    }
}

