/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.servicedistribution;

import com.bwanms.ddi.ServiceManagementException;
import com.bwanms.domain.logic.LicenseHelper;
import com.bwanms.mediation.MediationException;
import com.bwanms.model.Equipment;
import com.bwanms.model.TaskExecutionContext;
import com.bwanms.model.TaskExecutor;
import com.bwanms.model.TaskRuntimeStatus;
import com.bwanms.model.entity.Assembly;
import com.bwanms.persistence.CallableDatastoreDecorator;
import com.bwanms.persistence.Datastore;
import com.bwanms.persistence.RunnableDatastoreDecorator;
import com.bwanms.rb.ddi.RbServiceManagementStrategy;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.services.RbIPModeDataServiceProfile;
import com.bwanms.rb.model.services.RbIPModeMngVoIPServiceProfile;
import com.bwanms.rb.model.services.RbIPModeVoIPServiceProfile;
import com.bwanms.rb.model.services.RbL2ServiceProfile;
import com.bwanms.rb.model.services.RbManagedVoIPServiceProfile;
import com.bwanms.rb.model.services.RbPPPoEServiceProfile;
import com.bwanms.rb.model.services.RbPolicyRule;
import com.bwanms.rb.model.services.RbQoSProfile;
import com.bwanms.rb.model.services.RbServiceProfile;
import com.bwanms.rb.tasks.servicedistribution.RbServiceDistributionHelper;
import com.bwanms.rb.tasks.servicedistribution.RbServiceProfileDistributionTask;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.services.impl.LockManagerLocator;
import com.bwanms.util.concurrent.AsyncItemsExecutor;
import com.bwanms.util.concurrent.AsyncItemsProvider;
import com.bwanms.util.task.Operation;
import com.bwanms.util.task.OperationStatus;
import com.bwanms.util.task.OperationTaskRuntimeStatus;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import org.apache.log4j.Logger;

public class RbServiceProfileDistributionTaskExecutor
implements TaskExecutor {
    private static final Logger logger = Logger.getLogger(RbServiceProfileDistributionTaskExecutor.class);
    private transient TaskExecutionContext ctx = null;
    private RbServiceProfileDistributionTask task;
    private OperationTaskRuntimeStatus runtimeStatus;
    private Operation rootOperation;
    private int taskExecutionResult = 1;
    private HashMap<Long, Operation> operationMap = new HashMap();
    private HashMap<String, Operation> spOpMap = new HashMap();

    public RbServiceProfileDistributionTaskExecutor(RbServiceProfileDistributionTask task) {
        this.task = task;
        this.runtimeStatus = new OperationTaskRuntimeStatus();
        this.rootOperation = this.runtimeStatus.addOperation(null, "RbServiceProfileDistributionTaskWithName", new Object[]{task.getName()});
    }

    private synchronized void logStatus(RbBaseStationEquipment bsEq, RbServiceProfile serviceProfile, OperationStatus status, String message, Object ... messageParams) {
        if (null != bsEq) {
            logger.debug((Object)("logStatus:  bsEq " + bsEq.getIPAddress() + "   ServiceProfile " + (null != serviceProfile ? serviceProfile.getName() : "null") + "  message " + message));
            Operation eqOp = this.operationMap.get(bsEq.getId());
            if (null == eqOp) {
                String text = 1 == this.task.getOperation() ? "DeployServiceProfilesOn" : "UndeployServiceProfilesFrom";
                eqOp = this.runtimeStatus.addOperation(this.rootOperation, text, new Object[]{bsEq.getIPAddress() + "/" + bsEq.getName()});
                this.operationMap.put(bsEq.getId(), eqOp);
            }
            if (null != serviceProfile) {
                Operation spOp = this.spOpMap.get(bsEq.getId() + "." + serviceProfile.getId());
                if (null == spOp) {
                    String text = 1 == this.task.getOperation() ? "Deploy" : "Undeploy";
                    spOp = this.runtimeStatus.addOperation(eqOp, text, new Object[]{serviceProfile.getName()});
                    this.spOpMap.put(bsEq.getId() + "." + serviceProfile.getId(), spOp);
                }
                this.runtimeStatus.logOperationStatus(spOp, status, (Serializable)((Object)message), messageParams);
            } else {
                this.runtimeStatus.logOperationStatus(eqOp, status, (Serializable)((Object)message), messageParams);
            }
        } else {
            this.runtimeStatus.logOperationStatus(this.rootOperation, status, (Serializable)((Object)message), messageParams);
        }
    }

    public void execute(TaskExecutionContext ctx) {
        this.ctx = ctx;
        this.task = (RbServiceProfileDistributionTask)ServiceRegistry.getTaskManagerService().retrieveTask(this.task.getId());
        final Iterator<RbBaseStationEquipment> bsEquipmentIterator = this.task.getEquipmentList().iterator();
        final List<RbServiceProfile> serviceProfileList = this.task.getServiceProfileList();
        final int operation = this.task.getOperation();
        final boolean overwrite = this.task.isOverwriteBuildingBlocks();
        final Vector itemErrorStatus = new Vector();
        AsyncItemsExecutor itemsExecutor = new AsyncItemsExecutor((AsyncItemsProvider)new AsyncItemsProvider<RbServiceProfileConfigurator>(){

            public boolean shouldAbort() {
                return RbServiceProfileDistributionTaskExecutor.this.taskShouldAbort();
            }

            public void itemFinished(RbServiceProfileConfigurator item) {
                itemErrorStatus.add(item.hasErrors());
            }

            public void itemStarting(RbServiceProfileConfigurator item) {
            }

            public boolean hasNext() {
                return bsEquipmentIterator.hasNext();
            }

            public RbServiceProfileConfigurator next() {
                RbBaseStationEquipment nextBaseStation = (RbBaseStationEquipment)((Object)bsEquipmentIterator.next());
                if (null == nextBaseStation) {
                    return null;
                }
                return new RbServiceProfileConfigurator(nextBaseStation, serviceProfileList, operation, overwrite);
            }

            public void remove() {
                throw new UnsupportedOperationException("Remove Not Implemented!");
            }
        });
        if (!this.task.getEquipmentList().isEmpty()) {
            logger.debug((Object)("Starting task ItemsExecutor: " + this.task.getName()));
            itemsExecutor.executeItems();
            logger.debug((Object)("Done task ItemsExecutor: " + this.task.getName()));
            if (!ctx.shouldAbort()) {
                boolean hasErrors = false;
                for (Boolean errStatus : itemErrorStatus) {
                    if (!errStatus.booleanValue()) continue;
                    hasErrors = true;
                    break;
                }
                this.taskExecutionResult = hasErrors ? 4 : 1;
            } else {
                this.taskExecutionResult = 2;
            }
        } else {
            this.taskExecutionResult = 3;
        }
        switch (this.taskExecutionResult) {
            case 2: {
                this.logStatus(null, null, OperationStatus.ABORTED, null, new Object[0]);
                break;
            }
            case 1: {
                this.logStatus(null, null, OperationStatus.COMPLETED, null, new Object[0]);
                break;
            }
            case 4: {
                this.logStatus(null, null, OperationStatus.COMPLETED_WITH_ERRORS, null, new Object[0]);
                break;
            }
            case 3: {
                this.logStatus(null, null, OperationStatus.FAILED, null, new Object[0]);
            }
        }
        ctx.taskFinished();
    }

    public TaskRuntimeStatus getStatus(Object clientData) {
        logger.debug((Object)("*** getStatus() " + clientData));
        Integer idx = null != clientData ? (Integer)clientData : 0;
        return this.runtimeStatus.getDiff(idx.intValue());
    }

    public String getReport() {
        if (this.taskExecutionResult == 3) {
            return this.runtimeStatus.toXMLStringFailed(this.task.getName());
        }
        return this.runtimeStatus.toXMLString();
    }

    private boolean taskShouldAbort() {
        return this.ctx.shouldAbort();
    }

    public int getExecutionResult() {
        return this.taskExecutionResult;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RbServiceProfileConfigurator
    implements Runnable {
        private RbBaseStationEquipment equipment;
        private List<RbServiceProfile> serviceProfiles;
        private int operation;
        private boolean overwrite;
        private boolean errors;

        public RbServiceProfileConfigurator(RbBaseStationEquipment equipment, List<RbServiceProfile> serviceProfiles, int operation, boolean overwrite) {
            this.equipment = equipment;
            this.serviceProfiles = serviceProfiles;
            this.operation = operation;
            this.overwrite = overwrite;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (RbServiceProfileDistributionTaskExecutor.this.taskShouldAbort()) {
                return;
            }
            if (this.equipment.getFirmwareVersion() == null) {
                RbServiceProfileDistributionTaskExecutor.this.logStatus(this.equipment, null, OperationStatus.SKIPPED, "BSIsUnreachable", new Object[0]);
                return;
            }
            boolean licensed = false;
            try {
                licensed = (Boolean)new CallableDatastoreDecorator((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        return LicenseHelper.isLicensed((Object)((Object)RbServiceProfileConfigurator.this.equipment));
                    }
                }).call();
            }
            catch (Exception e1) {
                if (!licensed) {
                    RbServiceProfileDistributionTaskExecutor.this.logStatus(this.equipment, null, OperationStatus.SKIPPED, "UnlicensedBS", new Object[0]);
                    return;
                }
            }
            finally {
                if (!licensed) {
                    RbServiceProfileDistributionTaskExecutor.this.logStatus(this.equipment, null, OperationStatus.SKIPPED, "UnlicensedBS", new Object[0]);
                    return;
                }
            }
            final RbServiceManagementStrategy serviceManagement = new RbServiceManagementStrategy();
            Lock lock = LockManagerLocator.locate().getLock(Equipment.getConfigurationLockKey((long)this.equipment.getId()));
            lock.lock();
            try {
                RbServiceProfileDistributionTaskExecutor.this.logStatus(this.equipment, null, OperationStatus.IN_PROGRESS, "", new Object[0]);
                boolean nothingToDeploy = true;
                for (final RbServiceProfile serviceProfileIt : this.serviceProfiles) {
                    block29: {
                        nothingToDeploy = false;
                        Integer serviceProfileType = serviceProfileIt.rbServiceTemplateType();
                        if (serviceProfileType != null) {
                            int intServiceProfileType = serviceProfileType;
                            if (this.equipment.getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_ETHERNET_CS) {
                                if (intServiceProfileType == 4 || intServiceProfileType == 5 || intServiceProfileType == 7) {
                                    RbServiceProfileDistributionTaskExecutor.this.logStatus(this.equipment, serviceProfileIt, OperationStatus.SKIPPED, this.operation == 1 ? "CantDeployIpServiceProfileOnEthernetDevice" : "CantUndeployIpServiceProfileOnEthernetDevice", new Object[0]);
                                    continue;
                                }
                            } else if (intServiceProfileType == 1 || intServiceProfileType == 2 || intServiceProfileType == 3 || intServiceProfileType == 6) {
                                RbServiceProfileDistributionTaskExecutor.this.logStatus(this.equipment, serviceProfileIt, OperationStatus.SKIPPED, this.operation == 1 ? "CantDeployEthernetServiceProfileOnIpDevice" : "CantUndeployEthernetServiceProfileOnIpDevice", new Object[0]);
                                continue;
                            }
                        }
                        try {
                            if (this.operation == 1 && !this.isProperQoss(this.equipment, serviceProfileIt)) {
                                RbServiceProfileDistributionTaskExecutor.this.logStatus(this.equipment, serviceProfileIt, OperationStatus.SKIPPED, "CTOnlyShortForBE41", new Object[0]);
                            }
                            break block29;
                        }
                        catch (ServiceException ex) {
                            logger.error((Object)ex.getMessage(), (Throwable)ex);
                            RbServiceProfileDistributionTaskExecutor.this.logStatus(this.equipment, serviceProfileIt, OperationStatus.FAILED, "FatalErrorOccurs", new Object[0]);
                            this.errors = true;
                        }
                        continue;
                    }
                    if (RbServiceProfileDistributionTaskExecutor.this.taskShouldAbort()) {
                        RbServiceProfileDistributionTaskExecutor.this.logStatus(this.equipment, null, OperationStatus.ABORTED, "", new Object[0]);
                        return;
                    }
                    new RunnableDatastoreDecorator(new Runnable(){

                        public void run() {
                            RbServiceProfile serviceProfile = serviceProfileIt;
                            String result = null;
                            try {
                                RbServiceProfileConfigurator.this.equipment = (RbBaseStationEquipment)((Object)Datastore.session().get(((Object)((Object)RbServiceProfileConfigurator.this.equipment)).getClass(), (Serializable)Long.valueOf(RbServiceProfileConfigurator.this.equipment.getId())));
                                serviceProfile = (RbServiceProfile)((Object)Datastore.session().get(((Object)((Object)serviceProfileIt)).getClass(), (Serializable)Long.valueOf(serviceProfileIt.getId())));
                                logger.debug((Object)("-- starting deploy for serviceProfile " + serviceProfile.getName() + "  on " + RbServiceProfileConfigurator.this.equipment.getEUID()));
                                int status = 0;
                                if (RbServiceProfileConfigurator.this.equipment.getState() == 0) {
                                    RbServiceProfileDistributionTaskExecutor.this.logStatus(RbServiceProfileConfigurator.this.equipment, serviceProfile, OperationStatus.IN_PROGRESS, "", new Object[0]);
                                    switch (RbServiceProfileConfigurator.this.operation) {
                                        case 1: {
                                            status = serviceManagement.deployServiceProfile(serviceProfile, RbServiceProfileConfigurator.this.equipment, RbServiceProfileConfigurator.this.overwrite);
                                            break;
                                        }
                                        case 2: {
                                            status = serviceManagement.undeployServiceProfile(serviceProfile, RbServiceProfileConfigurator.this.equipment);
                                        }
                                    }
                                    result = RbServiceDistributionHelper.getResultMessage(status, RbServiceProfileConfigurator.this.operation);
                                    OperationStatus opStatus = RbServiceDistributionHelper.getOperationStatus(status);
                                    RbServiceProfileDistributionTaskExecutor.this.logStatus(RbServiceProfileConfigurator.this.equipment, serviceProfile, opStatus, result, new Object[0]);
                                } else {
                                    result = "Failed";
                                    RbServiceProfileDistributionTaskExecutor.this.logStatus(RbServiceProfileConfigurator.this.equipment, serviceProfile, OperationStatus.FAILED, "BSIsUnreachable", new Object[0]);
                                }
                            }
                            catch (ServiceManagementException sme) {
                                RbServiceProfileDistributionTaskExecutor.this.logStatus(RbServiceProfileConfigurator.this.equipment, serviceProfile, OperationStatus.FAILED, sme.getMessage(), sme.getParams());
                                result = "Failed";
                            }
                            catch (MediationException me) {
                                RbServiceProfileDistributionTaskExecutor.this.logStatus(RbServiceProfileConfigurator.this.equipment, serviceProfile, OperationStatus.FAILED, "AgentError", new Object[0]);
                                result = "Failed";
                                logger.debug((Object)me.getMessage(), (Throwable)me);
                            }
                            catch (Exception e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                                RbServiceProfileDistributionTaskExecutor.this.logStatus(RbServiceProfileConfigurator.this.equipment, serviceProfile, OperationStatus.FAILED, null, new Object[0]);
                                result = "Failed";
                            }
                            if ("Failed".equals(result)) {
                                RbServiceProfileConfigurator.this.errors = true;
                            }
                            logger.debug((Object)("-- done deploy for serviceProfile " + serviceProfile.getName() + "  on " + RbServiceProfileConfigurator.this.equipment.getEUID() + " result: " + result));
                        }
                    }).run();
                }
                if (nothingToDeploy) {
                    RbServiceProfileDistributionTaskExecutor.this.logStatus(this.equipment, null, OperationStatus.SKIPPED, "NoServiceProfilestodeploy", new Object[0]);
                } else if (this.hasErrors()) {
                    RbServiceProfileDistributionTaskExecutor.this.logStatus(this.equipment, null, OperationStatus.COMPLETED_WITH_ERRORS, "", new Object[0]);
                } else {
                    RbServiceProfileDistributionTaskExecutor.this.logStatus(this.equipment, null, OperationStatus.COMPLETED, "", new Object[0]);
                }
            }
            finally {
                lock.unlock();
            }
            if (2 == this.operation) {
                logger.debug((Object)"-- performing serviceprofiles cleanup.");
                RbServiceDistributionHelper svcDistHelper = new RbServiceDistributionHelper(this.equipment);
                svcDistHelper.performServiceProfilesCleanup();
            }
        }

        private boolean isProperQoss(RbBaseStationEquipment equipment, RbServiceProfile serviceProfileIt) throws ServiceException {
            if (equipment.getSoftwareVersion().isOlderThan(RbVersions.V_4_1_1)) {
                return true;
            }
            if (!this.isProperQos(serviceProfileIt.getForwardingRule().getQoS())) {
                return false;
            }
            if (serviceProfileIt instanceof RbIPModeVoIPServiceProfile) {
                RbIPModeVoIPServiceProfile sp = (RbIPModeVoIPServiceProfile)serviceProfileIt;
                Assembly assembly = ServiceRegistry.getEntityManagerService().get(RbIPModeVoIPServiceProfile.class, sp.getId(), "Edit");
                return this.isProperQoss(((RbIPModeVoIPServiceProfile)((Object)assembly.getEntity())).getPolicyRule());
            }
            if (serviceProfileIt instanceof RbIPModeDataServiceProfile) {
                RbIPModeDataServiceProfile sp = (RbIPModeDataServiceProfile)serviceProfileIt;
                Assembly assembly = ServiceRegistry.getEntityManagerService().get(RbIPModeDataServiceProfile.class, sp.getId(), "Edit");
                return this.isProperQoss(((RbIPModeDataServiceProfile)((Object)assembly.getEntity())).getPolicyRule());
            }
            if (serviceProfileIt instanceof RbIPModeMngVoIPServiceProfile) {
                RbIPModeMngVoIPServiceProfile sp = (RbIPModeMngVoIPServiceProfile)serviceProfileIt;
                Assembly assembly = ServiceRegistry.getEntityManagerService().get(RbIPModeMngVoIPServiceProfile.class, sp.getId(), "Edit");
                return this.isProperQoss(((RbIPModeMngVoIPServiceProfile)((Object)assembly.getEntity())).getPolicyRule());
            }
            if (serviceProfileIt instanceof RbManagedVoIPServiceProfile) {
                RbManagedVoIPServiceProfile sp = (RbManagedVoIPServiceProfile)serviceProfileIt;
                Assembly assembly = ServiceRegistry.getEntityManagerService().get(RbManagedVoIPServiceProfile.class, sp.getId(), "Edit");
                return this.isProperQoss(((RbManagedVoIPServiceProfile)((Object)assembly.getEntity())).getPolicyRule());
            }
            if (serviceProfileIt instanceof RbL2ServiceProfile) {
                RbL2ServiceProfile sp = (RbL2ServiceProfile)serviceProfileIt;
                Assembly assembly = ServiceRegistry.getEntityManagerService().get(RbL2ServiceProfile.class, sp.getId(), "Edit");
                return this.isProperQoss(((RbL2ServiceProfile)((Object)assembly.getEntity())).getPolicyRule());
            }
            if (serviceProfileIt instanceof RbPPPoEServiceProfile) {
                RbPPPoEServiceProfile sp = (RbPPPoEServiceProfile)serviceProfileIt;
                Assembly assembly = ServiceRegistry.getEntityManagerService().get(RbPPPoEServiceProfile.class, sp.getId(), "Edit");
                return this.isProperQoss(((RbPPPoEServiceProfile)((Object)assembly.getEntity())).getPolicyRule());
            }
            return true;
        }

        private boolean isProperQoss(RbPolicyRule policyRule) {
            if (policyRule == null) {
                return true;
            }
            return this.isProperQos(policyRule.getDownQoSProfile1()) && this.isProperQos(policyRule.getDownQoSProfile2()) && this.isProperQos(policyRule.getDownQoSProfile3()) && this.isProperQos(policyRule.getDownQoSProfile4()) && this.isProperQos(policyRule.getUpQoSProfile1()) && this.isProperQos(policyRule.getUpQoSProfile2()) && this.isProperQos(policyRule.getUpQoSProfile3()) && this.isProperQos(policyRule.getUpQoSProfile4());
        }

        private boolean isProperQos(RbQoSProfile qoSProfile) {
            if (qoSProfile.getType() == null) {
                return true;
            }
            return qoSProfile.getType() != 3 || qoSProfile.getParamTime() == 1;
        }

        public boolean hasErrors() {
            return this.errors;
        }
    }
}

