/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.servicedistribution;

import com.bwanms.model.ManagedEntityBase;
import com.bwanms.model.ManagedEntityWeakAssociation;
import com.bwanms.model.TaskExecutor;
import com.bwanms.model.Validatable;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.services.RbServiceProfile;
import com.bwanms.rb.tasks.servicedistribution.RbServiceDistributionBaseTask;
import com.bwanms.rb.tasks.servicedistribution.RbServiceDistributionHelper;
import com.bwanms.rb.tasks.servicedistribution.RbServiceProfileDistributionTaskExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="RbSPDistributionTask")
public class RbServiceProfileDistributionTask
extends RbServiceDistributionBaseTask
implements Validatable {
    private List<RbBaseStationEquipment> equipmentList;
    private List<RbServiceProfile> serviceProfileList;
    private boolean overwriteBuildingBlocks;

    public TaskExecutor createExecutor() {
        return new RbServiceProfileDistributionTaskExecutor(this);
    }

    void splitAssociations() {
        this.equipmentList = new Vector<RbBaseStationEquipment>();
        this.serviceProfileList = new Vector<RbServiceProfile>();
        for (ManagedEntityWeakAssociation weakAssociation : this.getManagedEntityAssociations()) {
            ManagedEntityBase me = weakAssociation.getManagedEntity();
            if (null == me) continue;
            if (me instanceof RbBaseStationEquipment) {
                this.equipmentList.add((RbBaseStationEquipment)me);
                continue;
            }
            this.serviceProfileList.add((RbServiceProfile)me);
        }
    }

    void mergeAssociations() {
        ArrayList<Validatable> meList = new ArrayList<Validatable>(this.equipmentList.size() + this.serviceProfileList.size());
        for (RbBaseStationEquipment equipment : this.equipmentList) {
            meList.add(equipment);
        }
        for (RbServiceProfile serviceProfile : this.serviceProfileList) {
            meList.add(serviceProfile);
        }
        RbServiceDistributionHelper.mergeMEWeakAssociationLists(this.getManagedEntityAssociations(), meList);
    }

    @Transient
    public List<RbBaseStationEquipment> getEquipmentList() {
        return this.equipmentList;
    }

    public void setEquipmentList(List<RbBaseStationEquipment> equipmentList) {
        this.equipmentList = equipmentList;
    }

    @Transient
    public List<RbServiceProfile> getServiceProfileList() {
        return this.serviceProfileList;
    }

    public void setServiceProfileList(List<RbServiceProfile> serviceProfileList) {
        this.serviceProfileList = serviceProfileList;
    }

    public void validate(List<InvalidValue> invalidValues) {
        super.validate(invalidValues);
    }

    public boolean isOverwriteBuildingBlocks() {
        return this.overwriteBuildingBlocks;
    }

    public void setOverwriteBuildingBlocks(boolean overwriteBuildingBlocks) {
        this.overwriteBuildingBlocks = overwriteBuildingBlocks;
    }
}

