/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.servicedistribution;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.SelectorUtil;
import com.bwanms.gui.SelectorView;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.model.Task;
import com.bwanms.rb.ddi.RbServiceSynchronizationUtil;
import com.bwanms.rb.gui.selectors.service.RbServiceSelectorView;
import com.bwanms.rb.model.services.RbService;
import com.bwanms.rb.tasks.servicedistribution.RbServiceMergeTask;
import com.bwanms.rb.tasks.servicedistribution.RbServiceMergeTaskPanel;
import com.bwanms.ui.components.EntityManagerTableModel;
import com.bwanms.ui.components.SimpleRowTable;
import com.bwanms.ui.components.SimpleRowTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbServiceMergeTaskView
extends AbstractBindedEditorView<Task> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbServiceMergeTask.class);
    private static final Internationalizer ddi18n = Internationalizer.getInternationalizer((String)"com.bwanms.ddi");
    private RbServiceMergeTaskPanel panel;
    private EntityManagerTableModel<RbService> serviceTableModel;

    public RbServiceMergeTaskView() {
        this.initUI();
    }

    public List<Binder> getBinders() {
        ArrayList<Binder> binders = new ArrayList<Binder>();
        DefaultBinder binder = new DefaultBinder((Object)this.getUI(), (Object)this.entity);
        binder.add((Binding)new JTextFieldBinding("txtName", "name", i18n.translateString("Name")));
        binders.add((Binder)binder);
        return binders;
    }

    public void fillUI(Task entity) {
        boolean bEditTask;
        RbServiceMergeTask task = (RbServiceMergeTask)entity;
        boolean bl = bEditTask = null != task && null != task.getName() && 0 < task.getName().trim().length();
        if (bEditTask) {
            int targetRow;
            this.panel.getTxtName().setText(task.getName());
            for (RbService service : task.getServiceList()) {
                this.serviceTableModel.addRow((Object)service, String.valueOf(service.getId()));
            }
            if (0L != task.getTargetServiceId() && -1 != (targetRow = this.serviceTableModel.getEntityRow(String.valueOf(task.getTargetServiceId())))) {
                this.serviceTableModel.setHighlighted(targetRow, true);
            }
            this.panel.getCheckBoxMergeServiceProfiles().setSelected(task.isMergeServiceProfiles());
            this.panel.getCheckBoxRemoveSuccessful().setSelected(task.isRemoveSuccesfulServices());
        }
    }

    public List<InvalidValue> configureEntity(Task entity) {
        ArrayList<InvalidValue> iValues = super.configureEntity((Serializable)entity);
        RbServiceMergeTask task = (RbServiceMergeTask)entity;
        task.setName(this.panel.getTxtName().getText());
        long targetServiceId = 0L;
        ArrayList<RbService> serviceList = new ArrayList<RbService>(this.serviceTableModel.getRowCount());
        for (int row = 0; row < this.serviceTableModel.getRowCount(); ++row) {
            if (1 == this.serviceTableModel.getRowState(row)) continue;
            RbService service = (RbService)((Object)this.serviceTableModel.getEntity(row));
            serviceList.add(service);
            if (!this.serviceTableModel.isHighlighted(row)) continue;
            targetServiceId = service.getId();
        }
        task.setServiceList(serviceList);
        if (serviceList.size() < 2) {
            if (null == iValues) {
                iValues = new ArrayList<InvalidValue>(1);
            }
            iValues.add(new InvalidValue(i18n.translateString("SelectAtLeastTwoServicesForMerge"), RbServiceMergeTask.class, "", (Object)"", (Object)task));
        } else if (0L == targetServiceId) {
            if (null == iValues) {
                iValues = new ArrayList(1);
            }
            iValues.add(new InvalidValue(i18n.translateString("SelectTargetService"), RbServiceMergeTask.class, "targetServiceId", (Object)0, (Object)task));
        }
        task.setTargetServiceId(targetServiceId);
        task.setMergeServiceProfiles(this.panel.getCheckBoxMergeServiceProfiles().isSelected());
        task.setRemoveSuccesfulServices(this.panel.getCheckBoxRemoveSuccessful().isSelected());
        return iValues;
    }

    private void actionAddServices() {
        RbServiceSelectorView selectorView = new RbServiceSelectorView(RbService.class);
        SelectorUtil.displayModalSelector((JComponent)this.panel, (SelectorView)selectorView);
        List selection = selectorView.getSelection();
        if (!selection.isEmpty()) {
            boolean showWarning = false;
            String entityName = null;
            int entityType = 0;
            for (int i = 0; i < this.serviceTableModel.getRowCount(); ++i) {
                if (1 == this.serviceTableModel.getRowState(i)) continue;
                RbService service = (RbService)((Object)this.serviceTableModel.getEntity(i));
                entityName = service.getName();
                entityType = RbServiceSynchronizationUtil.lookupServiceType(service);
                break;
            }
            if (null == entityName) {
                entityName = ((RbService)((Object)selection.get(0))).getName();
                entityType = RbServiceSynchronizationUtil.lookupServiceType((RbService)((Object)selection.get(0)));
            }
            for (RbService service : selection) {
                if (!entityName.equals(service.getName()) || entityType != RbServiceSynchronizationUtil.lookupServiceType(service)) {
                    showWarning = true;
                    continue;
                }
                String key = String.valueOf(service.getId());
                int row = this.serviceTableModel.getEntityRow(key);
                if (-1 != row) {
                    this.serviceTableModel.updateRow((Object)service, key);
                    this.serviceTableModel.revertRow(row);
                    continue;
                }
                this.serviceTableModel.addRow((Object)service, key);
            }
            if (showWarning) {
                String entityTypeStr = ddi18n.translateString(RbServiceSynchronizationUtil.lookupServiceClass(entityType).getName());
                JOptionPane.showMessageDialog(this.panel, i18n.translateString("OnlyServicesWithNameAndTypeWereAdded", new Object[]{entityName, entityTypeStr}), i18n.translateString("Warning"), 1);
            }
        }
    }

    private void actionRemoveServices() {
        int[] selectedRows = this.panel.getTableServices().getSelectedRows();
        this.serviceTableModel.removeRows(selectedRows);
    }

    private void actionSetAsTargetService() {
        int[] selectedRows = this.panel.getTableServices().getSelectedRows();
        if (1 != selectedRows.length) {
            JOptionPane.showMessageDialog(this.panel, "Please Select One Service ");
            return;
        }
        for (int i = 0; i < this.serviceTableModel.getRowCount(); ++i) {
            if (!this.serviceTableModel.isHighlighted(i)) continue;
            this.serviceTableModel.setHighlighted(i, false);
            break;
        }
        this.serviceTableModel.setHighlighted(selectedRows[0], true);
    }

    private void initUI() {
        this.panel = new RbServiceMergeTaskPanel();
        final RbServiceSelectorView serviceSelectorView = new RbServiceSelectorView(RbService.class);
        SimpleRowTableModel.ColumnDefinition[] colDefs = new SimpleRowTableModel.ColumnDefinition[serviceSelectorView.getColumnNames().length];
        int idx = 0;
        for (String colName : serviceSelectorView.getColumnNames()) {
            colDefs[idx++] = new SimpleRowTableModel.ColumnDefinition(colName, String.class);
        }
        this.serviceTableModel = new EntityManagerTableModel<RbService>(colDefs){
            private static final long serialVersionUID = -8855243014243035197L;

            public void setRowValues(int row, RbService entity) {
                EntityManagerRowProvider rowProvider = serviceSelectorView.getEntityRowProvider();
                EntityManagerRow entityRow = rowProvider.createRow((Serializable)((Object)entity));
                List displayValues = rowProvider.getDisplayValues(entityRow);
                for (int i = 0; i < displayValues.size(); ++i) {
                    this.setInitialValueAt(displayValues.get(i), row, i);
                }
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        };
        new SimpleRowTable(this.panel.getTableServices(), this.serviceTableModel);
        this.panel.getBtnServicesAdd().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RbServiceMergeTaskView.this.actionAddServices();
            }
        });
        this.panel.getBtnServicesRemove().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RbServiceMergeTaskView.this.actionRemoveServices();
            }
        });
        this.panel.getBtnServicesSetAsTarget().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RbServiceMergeTaskView.this.actionSetAsTargetService();
            }
        });
        this.panel.getTableServices().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                RbServiceMergeTaskView.this.fireServicesTableSelectionChanged();
            }
        });
        i18n.getSwingInternationalizer().translateComponent((Component)this.panel);
        this.fireServicesTableSelectionChanged();
    }

    private void fireServicesTableSelectionChanged() {
        this.panel.getBtnServicesRemove().setEnabled(0 < this.panel.getTableServices().getSelectedRowCount());
        this.panel.getBtnServicesSetAsTarget().setEnabled(1 == this.panel.getTableServices().getSelectedRowCount());
    }

    public JComponent getUI() {
        return this.panel;
    }

    public boolean close() {
        return true;
    }

    public String getTitle() {
        return i18n.translateString("RbServiceMergeTaskTitle");
    }

    public String getApplicationPermission() {
        return "Av:ConfigureTasks";
    }

    public String getHelpTopic() {
        return "";
    }
}

