/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.servicedistribution;

import com.bwanms.ddi.ServiceManagementException;
import com.bwanms.mediation.MediationException;
import com.bwanms.model.Equipment;
import com.bwanms.model.TaskExecutionContext;
import com.bwanms.model.TaskExecutor;
import com.bwanms.model.TaskRuntimeStatus;
import com.bwanms.persistence.Datastore;
import com.bwanms.persistence.RunnableDatastoreDecorator;
import com.bwanms.rb.ddi.RbServiceDeploymentHelper;
import com.bwanms.rb.ddi.RbServiceManagementStrategy;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.services.RbService;
import com.bwanms.rb.tasks.servicedistribution.RbServiceDistributionHelper;
import com.bwanms.rb.tasks.servicedistribution.RbServiceMergeTask;
import com.bwanms.services.ServiceManagementService;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.services.impl.LockManagerLocator;
import com.bwanms.util.ServerValidationException;
import com.bwanms.util.concurrent.AsyncItemsExecutor;
import com.bwanms.util.concurrent.AsyncItemsProvider;
import com.bwanms.util.task.Operation;
import com.bwanms.util.task.OperationStatus;
import com.bwanms.util.task.OperationTaskRuntimeStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbServiceMergeTaskExecutor
implements TaskExecutor {
    private static final Logger logger = Logger.getLogger(RbServiceMergeTaskExecutor.class);
    private transient TaskExecutionContext ctx = null;
    private RbServiceMergeTask task;
    private OperationTaskRuntimeStatus runtimeStatus;
    private Operation rootOperation;
    private HashMap<Long, Operation> operationMap = new HashMap();

    public RbServiceMergeTaskExecutor(RbServiceMergeTask task) {
        this.task = task;
        this.runtimeStatus = new OperationTaskRuntimeStatus();
        this.rootOperation = this.runtimeStatus.addOperation(null, "RbServiceMergeTaskWithName", new Object[]{task.getName()});
    }

    private synchronized void logStatus(RbBaseStationEquipment bsEq, OperationStatus status, String message) {
        if (null != bsEq) {
            logger.debug((Object)("logStatus:  bsEq " + bsEq.getIPAddress() + "  message " + message));
            Operation eqOp = this.operationMap.get(bsEq.getId());
            if (null == eqOp) {
                eqOp = this.runtimeStatus.addOperation(this.rootOperation, "MergeServiceOn", new Object[]{bsEq.getIPAddress() + "/" + bsEq.getName()});
                this.operationMap.put(bsEq.getId(), eqOp);
            }
            this.runtimeStatus.logOperationStatus(eqOp, status, (Serializable)((Object)message));
        } else {
            this.runtimeStatus.logOperationStatus(this.rootOperation, status, (Serializable)((Object)message));
        }
    }

    public void execute(TaskExecutionContext ctx) {
        this.ctx = ctx;
        final ArrayList targetServiceList = new ArrayList(1);
        final Vector bsEquipmentList = new Vector();
        final Vector<RbService> serviceList = new Vector<RbService>();
        new RunnableDatastoreDecorator(new Runnable(){

            public void run() {
                RbServiceMergeTaskExecutor.this.task = (RbServiceMergeTask)((Object)Datastore.session().get(((Object)((Object)RbServiceMergeTaskExecutor.this.task)).getClass(), (Serializable)Long.valueOf(RbServiceMergeTaskExecutor.this.task.getId())));
                RbServiceMergeTaskExecutor.this.task.loadServiceList();
                RbServiceManagementStrategy strategy = new RbServiceManagementStrategy();
                long targetServiceId = RbServiceMergeTaskExecutor.this.task.getTargetServiceId();
                for (RbService service : RbServiceMergeTaskExecutor.this.task.getServiceList()) {
                    if (service.getId() == targetServiceId) {
                        targetServiceList.add(service);
                        continue;
                    }
                    serviceList.add(service);
                    bsEquipmentList.addAll(strategy.findServiceInstances(service));
                }
                if (targetServiceList.isEmpty()) {
                    logger.debug((Object)("Target RbSevice with id " + targetServiceId + " not found!"));
                }
            }
        }).run();
        if (!targetServiceList.isEmpty()) {
            final RbService targetService = (RbService)((Object)targetServiceList.get(0));
            final Iterator bsEquipmentIterator = bsEquipmentList.iterator();
            final boolean mergeServiceProfile = this.task.isMergeServiceProfiles();
            if (serviceList.isEmpty()) {
                this.logStatus(null, OperationStatus.FAILED, "NoServicesToMerge");
            } else {
                AsyncItemsExecutor itemsExecutor = new AsyncItemsExecutor((AsyncItemsProvider)new AsyncItemsProvider<RbServiceMerger>(){

                    public boolean shouldAbort() {
                        return RbServiceMergeTaskExecutor.this.taskShouldAbort();
                    }

                    public void itemFinished(RbServiceMerger item) {
                    }

                    public void itemStarting(RbServiceMerger item) {
                    }

                    public boolean hasNext() {
                        return bsEquipmentIterator.hasNext();
                    }

                    public RbServiceMerger next() {
                        RbBaseStationEquipment nextBaseStation = (RbBaseStationEquipment)((Object)bsEquipmentIterator.next());
                        if (null == nextBaseStation) {
                            return null;
                        }
                        return new RbServiceMerger(nextBaseStation, targetService, mergeServiceProfile);
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Remove Not Implemented!");
                    }
                });
                logger.debug((Object)"Execute items.");
                itemsExecutor.executeItems();
                if (this.task.isRemoveSuccesfulServices()) {
                    this.removeSuccessfulServices(serviceList);
                }
                this.logStatus(null, OperationStatus.COMPLETED, null);
            }
        } else {
            this.logStatus(null, OperationStatus.FAILED, "TargetServiceNotDefined");
        }
        ctx.taskFinished();
    }

    private void removeSuccessfulServices(List<RbService> serviceList) {
        logger.debug((Object)"Remove unused services.");
        try {
            ServiceManagementService sms = ServiceRegistry.getServiceManagementService();
            for (RbService service : serviceList) {
                if (0 != sms.findServiceInstances(service.getId()).size()) continue;
                Operation op = this.runtimeStatus.addOperation(this.rootOperation, "DeleteServiceWithName", new Object[]{service.getName()});
                try {
                    sms.deleteService(service.getId());
                    this.runtimeStatus.logOperationStatus(op, OperationStatus.COMPLETED, (Serializable)((Object)"Deleted"));
                }
                catch (ServerValidationException sve) {
                    this.runtimeStatus.logOperationStatus(op, OperationStatus.FAILED, null);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public TaskRuntimeStatus getStatus(Object clientData) {
        Integer idx = null != clientData ? (Integer)clientData : 0;
        return this.runtimeStatus.getDiff(idx.intValue());
    }

    public String getReport() {
        return this.runtimeStatus.toXMLString();
    }

    private boolean taskShouldAbort() {
        return this.ctx.shouldAbort();
    }

    public int getExecutionResult() {
        if (this.ctx.shouldAbort()) {
            return 2;
        }
        return 1;
    }

    private class RbServiceMerger
    implements Runnable {
        private RbBaseStationEquipment equipment;
        private RbService service;
        private boolean mergeServiceProfile;

        public RbServiceMerger(RbBaseStationEquipment equipment, RbService service, boolean mergeServiceProfile) {
            this.equipment = equipment;
            this.service = service;
            this.mergeServiceProfile = mergeServiceProfile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (RbServiceMergeTaskExecutor.this.taskShouldAbort()) {
                return;
            }
            Lock lock = LockManagerLocator.locate().getLock(Equipment.getConfigurationLockKey((long)this.equipment.getId()));
            lock.lock();
            try {
                new RunnableDatastoreDecorator(new Runnable(){

                    public void run() {
                        RbServiceMerger.this.equipment = (RbBaseStationEquipment)((Object)Datastore.session().get(((Object)((Object)RbServiceMerger.this.equipment)).getClass(), (Serializable)Long.valueOf(RbServiceMerger.this.equipment.getId())));
                        RbServiceMerger.this.service = (RbService)((Object)Datastore.session().get(((Object)((Object)RbServiceMerger.this.service)).getClass(), (Serializable)Long.valueOf(RbServiceMerger.this.service.getId())));
                        RbServiceMergeTaskExecutor.this.logStatus(RbServiceMerger.this.equipment, OperationStatus.IN_PROGRESS, null);
                        logger.debug((Object)("-- starting deploy for service " + RbServiceMerger.this.service.getName() + "  on " + RbServiceMerger.this.equipment.getEUID()));
                        String result = null;
                        try {
                            RbServiceDeploymentHelper helper = new RbServiceDeploymentHelper(RbServiceMerger.this.equipment);
                            int status = helper.deployService(RbServiceMerger.this.service, RbServiceMerger.this.mergeServiceProfile);
                            result = RbServiceDistributionHelper.getResultMessage(status, 3);
                            OperationStatus opStatus = RbServiceDistributionHelper.getOperationStatus(status);
                            RbServiceMergeTaskExecutor.this.logStatus(RbServiceMerger.this.equipment, opStatus, result);
                        }
                        catch (ServiceManagementException sme) {
                            RbServiceMergeTaskExecutor.this.logStatus(RbServiceMerger.this.equipment, OperationStatus.FAILED, sme.getMessage());
                            result = "Failed";
                        }
                        catch (MediationException me) {
                            RbServiceMergeTaskExecutor.this.logStatus(RbServiceMerger.this.equipment, OperationStatus.FAILED, "AgentError");
                            result = "Failed";
                            logger.debug((Object)me.getMessage());
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                            RbServiceMergeTaskExecutor.this.logStatus(RbServiceMerger.this.equipment, OperationStatus.FAILED, null);
                            result = "Failed";
                        }
                        logger.debug((Object)("-- done deploy for service " + RbServiceMerger.this.service.getName() + "  on " + RbServiceMerger.this.equipment.getEUID() + " result: " + result));
                    }
                }).run();
            }
            finally {
                lock.unlock();
            }
            logger.debug((Object)"-- performing serviceprofiles cleanup.");
            RbServiceDistributionHelper svcDistHelper = new RbServiceDistributionHelper(this.equipment);
            svcDistHelper.performServiceProfilesCleanup();
        }
    }
}

