/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.servicedistribution;

import com.bwanms.model.ManagedEntityBase;
import com.bwanms.model.ManagedEntityWeakAssociation;
import com.bwanms.model.TaskExecutor;
import com.bwanms.model.Validatable;
import com.bwanms.rb.model.services.RbService;
import com.bwanms.rb.tasks.servicedistribution.RbServiceDistributionBaseTask;
import com.bwanms.rb.tasks.servicedistribution.RbServiceDistributionHelper;
import com.bwanms.rb.tasks.servicedistribution.RbServiceMergeTaskExecutor;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="RbSVCMergeTask")
public class RbServiceMergeTask
extends RbServiceDistributionBaseTask
implements Validatable {
    private long targetServiceId;
    private boolean mergeServiceProfiles;
    private boolean removeSuccesfulServices;
    private List<RbService> serviceList;

    public long getTargetServiceId() {
        return this.targetServiceId;
    }

    public void setTargetServiceId(long targetServiceId) {
        this.targetServiceId = targetServiceId;
    }

    public boolean isMergeServiceProfiles() {
        return this.mergeServiceProfiles;
    }

    public void setMergeServiceProfiles(boolean mergeServiceProfiles) {
        this.mergeServiceProfiles = mergeServiceProfiles;
    }

    public boolean isRemoveSuccesfulServices() {
        return this.removeSuccesfulServices;
    }

    public void setRemoveSuccesfulServices(boolean removeSuccesfulServices) {
        this.removeSuccesfulServices = removeSuccesfulServices;
    }

    public TaskExecutor createExecutor() {
        return new RbServiceMergeTaskExecutor(this);
    }

    void loadServiceList() {
        List<ManagedEntityWeakAssociation> meWAList = this.getManagedEntityAssociations();
        this.serviceList = new ArrayList<RbService>(meWAList.size());
        for (ManagedEntityWeakAssociation meWA : meWAList) {
            ManagedEntityBase me = meWA.getManagedEntity();
            if (null == me) continue;
            this.serviceList.add((RbService)me);
        }
    }

    void saveServiceList() {
        RbServiceDistributionHelper.mergeMEWeakAssociationLists(this.getManagedEntityAssociations(), this.serviceList);
    }

    @Transient
    public List<RbService> getServiceList() {
        return this.serviceList;
    }

    public void setServiceList(List<RbService> serviceList) {
        this.serviceList = serviceList;
    }

    public void validate(List<InvalidValue> invalidValues) {
        super.validate(invalidValues);
    }
}

