/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.servicedistribution;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.SelectorUtil;
import com.bwanms.gui.SelectorView;
import com.bwanms.gui.Selectors;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.model.Task;
import com.bwanms.rb.gui.selectors.equipment.RbBaseStationSelectorView;
import com.bwanms.rb.gui.selectors.service.RbServiceSelectorView;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.services.RbService;
import com.bwanms.rb.tasks.servicedistribution.RbServiceDistributionTask;
import com.bwanms.rb.tasks.servicedistribution.RbServiceDistributionTaskPanel;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.EntityManagerTableModel;
import com.bwanms.ui.components.SimpleRowTable;
import com.bwanms.ui.components.SimpleRowTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbServiceDistributionTaskView
extends AbstractBindedEditorView<Task> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbServiceDistributionTask.class);
    private RbServiceDistributionTaskPanel panel;
    private EntityManagerTableModel<RbBaseStationEquipment> equipmentTableModel;
    private EntityManagerTableModel<RbService> serviceTableModel;

    public RbServiceDistributionTaskView() {
        this.initUI();
    }

    public List<Binder> getBinders() {
        ArrayList<Binder> binders = new ArrayList<Binder>();
        DefaultBinder binder = new DefaultBinder((Object)this.getUI(), (Object)this.entity);
        binder.add((Binding)new JTextFieldBinding("txtName", "name", i18n.translateString("Name")));
        binders.add((Binder)binder);
        return binders;
    }

    public void fillUI(Task entity) {
        boolean bEditTask;
        RbServiceDistributionTask task = (RbServiceDistributionTask)entity;
        boolean bl = bEditTask = null != task && null != task.getName() && 0 < task.getName().trim().length();
        if (bEditTask) {
            this.panel.getTxtName().setText(task.getName());
            ComboItem itemToSelect = ComboItem.findItemByValue((JComboBox)this.panel.getComboBoxOperation(), (Object)task.getOperation());
            this.panel.getComboBoxOperation().setSelectedItem(itemToSelect);
            for (RbBaseStationEquipment equipment : task.getEquipmentList()) {
                this.equipmentTableModel.addRow((Object)equipment, String.valueOf(equipment.getId()));
            }
            for (RbService service : task.getServiceList()) {
                this.serviceTableModel.addRow((Object)service, String.valueOf(service.getId()));
            }
            this.panel.getCheckBoxUndeploySubscriber().setSelected(task.isUndeploySubscriber());
        }
    }

    public List<InvalidValue> configureEntity(Task entity) {
        RbServiceDistributionTask task = (RbServiceDistributionTask)entity;
        task.setName(this.panel.getTxtName().getText());
        task.setOperation((Integer)((ComboItem)this.panel.getComboBoxOperation().getSelectedItem()).getValue());
        ArrayList<RbBaseStationEquipment> equipmentList = new ArrayList<RbBaseStationEquipment>(this.equipmentTableModel.getRowCount());
        for (int row = 0; row < this.equipmentTableModel.getRowCount(); ++row) {
            if (1 == this.equipmentTableModel.getRowState(row)) continue;
            equipmentList.add((RbBaseStationEquipment)((Object)this.equipmentTableModel.getEntity(row)));
        }
        task.setEquipmentList(equipmentList);
        ArrayList<RbService> serviceList = new ArrayList<RbService>(this.serviceTableModel.getRowCount());
        for (int row = 0; row < this.serviceTableModel.getRowCount(); ++row) {
            if (1 == this.serviceTableModel.getRowState(row)) continue;
            serviceList.add((RbService)((Object)this.serviceTableModel.getEntity(row)));
        }
        task.setServiceList(serviceList);
        task.setUndeploySubscriber(this.panel.getCheckBoxUndeploySubscriber().isSelected());
        return super.configureEntity((Serializable)entity);
    }

    private void actionAddEquipment() {
        SelectorView selectorView = Selectors.getSelectorView(RbBaseStationEquipment.class, (String)(RbServiceDistributionTask.class.getName() + "_selector"), (String)"multipleSelection");
        if (selectorView == null) {
            throw new IllegalArgumentException("Selector View must be defined!");
        }
        SelectorUtil.displayModalSelector((JComponent)this.panel, (SelectorView)selectorView);
        for (RbBaseStationEquipment equipment : selectorView.getSelection()) {
            String key = String.valueOf(equipment.getId());
            int row = this.equipmentTableModel.getEntityRow(key);
            if (-1 != row) {
                this.equipmentTableModel.updateRow((Object)equipment, key);
                this.equipmentTableModel.revertRow(row);
                continue;
            }
            this.equipmentTableModel.addRow((Object)equipment, key);
        }
    }

    private void actionRemoveEquipment() {
        int[] selectedRows = this.panel.getTableEquipment().getSelectedRows();
        this.equipmentTableModel.removeRows(selectedRows);
    }

    private void actionAddServices() {
        RbServiceSelectorView selectorView = new RbServiceSelectorView(RbService.class);
        SelectorUtil.displayModalSelector((JComponent)this.panel, (SelectorView)selectorView);
        for (RbService service : selectorView.getSelection()) {
            String key = String.valueOf(service.getId());
            int row = this.serviceTableModel.getEntityRow(key);
            if (-1 != row) {
                this.serviceTableModel.updateRow((Object)service, key);
                this.serviceTableModel.revertRow(row);
                continue;
            }
            this.serviceTableModel.addRow((Object)service, key);
        }
    }

    private void actionRemoveServices() {
        int[] selectedRows = this.panel.getTableServices().getSelectedRows();
        this.serviceTableModel.removeRows(selectedRows);
    }

    private void initUI() {
        this.panel = new RbServiceDistributionTaskPanel();
        this.panel.getComboBoxOperation().setModel(new DefaultComboBoxModel<Object>(new Object[]{new ComboItem((Object)1, i18n.translateString("DeployOp")), new ComboItem((Object)2, i18n.translateString("UndeployOp"))}));
        final RbBaseStationSelectorView bsEqManagerSelectorView = new RbBaseStationSelectorView("RbServiceDistributionTask_selector", null);
        SimpleRowTableModel.ColumnDefinition[] colDefs = new SimpleRowTableModel.ColumnDefinition[bsEqManagerSelectorView.getColumnNames().length];
        int idx = 0;
        for (String colName : bsEqManagerSelectorView.getColumnNames()) {
            colDefs[idx++] = new SimpleRowTableModel.ColumnDefinition(colName, String.class);
        }
        this.equipmentTableModel = new EntityManagerTableModel<RbBaseStationEquipment>(colDefs){
            private static final long serialVersionUID = 2395481500275513343L;

            public void setRowValues(int row, RbBaseStationEquipment entity) {
                EntityManagerRowProvider rowProvider = bsEqManagerSelectorView.getEntityRowProvider();
                EntityManagerRow entityRow = rowProvider.createRow((Serializable)((Object)entity));
                List displayValues = rowProvider.getDisplayValues(entityRow);
                for (int i = 0; i < displayValues.size(); ++i) {
                    this.setInitialValueAt(displayValues.get(i), row, i);
                }
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        };
        new SimpleRowTable(this.panel.getTableEquipment(), this.equipmentTableModel);
        final RbServiceSelectorView serviceSelectorView = new RbServiceSelectorView(RbService.class);
        colDefs = new SimpleRowTableModel.ColumnDefinition[serviceSelectorView.getColumnNames().length];
        idx = 0;
        for (String colName : serviceSelectorView.getColumnNames()) {
            colDefs[idx++] = new SimpleRowTableModel.ColumnDefinition(colName, String.class);
        }
        this.serviceTableModel = new EntityManagerTableModel<RbService>(colDefs){
            private static final long serialVersionUID = 8971230603984592791L;

            public void setRowValues(int row, RbService entity) {
                EntityManagerRowProvider rowProvider = serviceSelectorView.getEntityRowProvider();
                EntityManagerRow entityRow = rowProvider.createRow((Serializable)((Object)entity));
                List displayValues = rowProvider.getDisplayValues(entityRow);
                for (int i = 0; i < displayValues.size(); ++i) {
                    this.setInitialValueAt(displayValues.get(i), row, i);
                }
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        };
        new SimpleRowTable(this.panel.getTableServices(), this.serviceTableModel);
        this.panel.getBtnEquipmentAdd().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RbServiceDistributionTaskView.this.actionAddEquipment();
            }
        });
        this.panel.getBtnEquipmentRemove().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RbServiceDistributionTaskView.this.actionRemoveEquipment();
            }
        });
        this.panel.getBtnServicesAdd().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RbServiceDistributionTaskView.this.actionAddServices();
            }
        });
        this.panel.getBtnServicesRemove().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RbServiceDistributionTaskView.this.actionRemoveServices();
            }
        });
        this.panel.getTableEquipment().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                RbServiceDistributionTaskView.this.fireEquipmentTableSelectionChanged();
            }
        });
        this.panel.getTableServices().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                RbServiceDistributionTaskView.this.fireServicesTableSelectionChanged();
            }
        });
        this.panel.getComboBoxOperation().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RbServiceDistributionTaskView.this.fireComboOperationChanged();
            }
        });
        i18n.getSwingInternationalizer().translateComponent((Component)this.panel);
        this.fireEquipmentTableSelectionChanged();
        this.fireServicesTableSelectionChanged();
        this.fireComboOperationChanged();
    }

    private void fireServicesTableSelectionChanged() {
        this.panel.getBtnServicesRemove().setEnabled(0 < this.panel.getTableServices().getSelectedRowCount());
    }

    private void fireEquipmentTableSelectionChanged() {
        this.panel.getBtnEquipmentRemove().setEnabled(0 < this.panel.getTableEquipment().getSelectedRowCount());
    }

    private void fireComboOperationChanged() {
        if (2 == (Integer)((ComboItem)this.panel.getComboBoxOperation().getSelectedItem()).getValue()) {
            this.panel.getCheckBoxUndeploySubscriber().setEnabled(true);
        } else {
            this.panel.getCheckBoxUndeploySubscriber().setSelected(false);
            this.panel.getCheckBoxUndeploySubscriber().setEnabled(false);
        }
    }

    public JComponent getUI() {
        return this.panel;
    }

    public boolean close() {
        return true;
    }

    public String getTitle() {
        return i18n.translateString("RbServiceDistributionTaskTitle");
    }

    public String getApplicationPermission() {
        return "Av:ConfigureTasks";
    }

    public String getHelpTopic() {
        return "";
    }
}

