/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.servicedistribution;

import com.bwanms.ddi.ServiceManagementException;
import com.bwanms.mediation.MediationException;
import com.bwanms.model.Equipment;
import com.bwanms.model.TaskExecutionContext;
import com.bwanms.model.TaskExecutor;
import com.bwanms.model.TaskRuntimeStatus;
import com.bwanms.persistence.Datastore;
import com.bwanms.persistence.RunnableDatastoreDecorator;
import com.bwanms.rb.ddi.RbServiceManagementStrategy;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.services.RbService;
import com.bwanms.rb.tasks.servicedistribution.RbServiceDistributionHelper;
import com.bwanms.rb.tasks.servicedistribution.RbServiceDistributionTask;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.services.impl.LockManagerLocator;
import com.bwanms.util.concurrent.AsyncItemsExecutor;
import com.bwanms.util.concurrent.AsyncItemsProvider;
import com.bwanms.util.task.Operation;
import com.bwanms.util.task.OperationStatus;
import com.bwanms.util.task.OperationTaskRuntimeStatus;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.apache.log4j.Logger;

public class RbServiceDistributionTaskExecutor
implements TaskExecutor {
    private static final Logger logger = Logger.getLogger(RbServiceDistributionTaskExecutor.class);
    private transient TaskExecutionContext ctx = null;
    private RbServiceDistributionTask task;
    private OperationTaskRuntimeStatus runtimeStatus;
    private Operation rootOperation;
    private boolean taskFailed;
    private HashMap<Long, Operation> operationMap = new HashMap();
    private HashMap<String, Operation> spOpMap = new HashMap();

    public RbServiceDistributionTaskExecutor(RbServiceDistributionTask task) {
        this.task = task;
        this.taskFailed = false;
        this.runtimeStatus = new OperationTaskRuntimeStatus();
        this.rootOperation = this.runtimeStatus.addOperation(null, "RbServiceDistributionTaskWithName", new Object[]{task.getName()});
    }

    private synchronized void logStatus(RbBaseStationEquipment bsEq, RbService service, OperationStatus status, String message) {
        if (null != bsEq) {
            logger.debug((Object)("logStatus:  bsEq " + bsEq.getIPAddress() + "   Service " + (null != service ? service.getName() : "null") + "  message " + message));
            Operation eqOp = this.operationMap.get(bsEq.getId());
            if (null == eqOp) {
                String text = 1 == this.task.getOperation() ? "DeployServicesOn" : "UndeployServicesFrom";
                eqOp = this.runtimeStatus.addOperation(this.rootOperation, text, new Object[]{bsEq.getIPAddress() + "/" + bsEq.getName()});
                this.operationMap.put(bsEq.getId(), eqOp);
            }
            if (null != service) {
                Operation spOp = this.spOpMap.get(bsEq.getId() + "." + service.getId());
                if (null == spOp) {
                    String text = 1 == this.task.getOperation() ? "Deploy" : "Undeploy";
                    spOp = this.runtimeStatus.addOperation(eqOp, text, new Object[]{service.getName()});
                    this.spOpMap.put(bsEq.getId() + "." + service.getId(), spOp);
                }
                this.runtimeStatus.logOperationStatus(spOp, status, (Serializable)((Object)message));
            } else {
                this.runtimeStatus.logOperationStatus(eqOp, status, (Serializable)((Object)message));
            }
        } else {
            this.runtimeStatus.logOperationStatus(this.rootOperation, status, (Serializable)((Object)message));
        }
    }

    public void execute(TaskExecutionContext ctx) {
        this.ctx = ctx;
        this.task = (RbServiceDistributionTask)ServiceRegistry.getTaskManagerService().retrieveTask(this.task.getId());
        final Iterator<RbBaseStationEquipment> bsEquipmentIterator = this.task.getEquipmentList().iterator();
        final List<RbService> serviceList = this.task.getServiceList();
        final int operation = this.task.getOperation();
        final boolean undeploySubscriber = this.task.isUndeploySubscriber();
        AsyncItemsExecutor itemsExecutor = new AsyncItemsExecutor((AsyncItemsProvider)new AsyncItemsProvider<RbServiceConfigurator>(){

            public boolean shouldAbort() {
                return RbServiceDistributionTaskExecutor.this.taskShouldAbort();
            }

            public void itemFinished(RbServiceConfigurator item) {
            }

            public void itemStarting(RbServiceConfigurator item) {
            }

            public boolean hasNext() {
                return bsEquipmentIterator.hasNext();
            }

            public RbServiceConfigurator next() {
                RbBaseStationEquipment nextBaseStation = (RbBaseStationEquipment)((Object)bsEquipmentIterator.next());
                if (null == nextBaseStation) {
                    return null;
                }
                return new RbServiceConfigurator(nextBaseStation, serviceList, operation, undeploySubscriber);
            }

            public void remove() {
                throw new UnsupportedOperationException("Remove Not Implemented!");
            }
        });
        if (!this.task.getEquipmentList().isEmpty()) {
            logger.debug((Object)"Started deploy service profiles.");
            itemsExecutor.executeItems();
            logger.debug((Object)"Done deploy service profiles.");
            this.logStatus(null, null, OperationStatus.COMPLETED, null);
        } else {
            this.taskFailed = true;
        }
        ctx.taskFinished();
    }

    public TaskRuntimeStatus getStatus(Object clientData) {
        logger.debug((Object)("*** getStatus() " + clientData));
        Integer idx = null != clientData ? (Integer)clientData : 0;
        return this.runtimeStatus.getDiff(idx.intValue());
    }

    public String getReport() {
        if (this.taskFailed) {
            return this.runtimeStatus.toXMLStringFailed(this.task.getName());
        }
        return this.runtimeStatus.toXMLString();
    }

    private boolean taskShouldAbort() {
        return this.ctx.shouldAbort();
    }

    public int getExecutionResult() {
        if (this.ctx.shouldAbort()) {
            return 2;
        }
        if (this.taskFailed) {
            return 3;
        }
        return 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RbServiceConfigurator
    implements Runnable {
        private RbBaseStationEquipment equipment;
        private List<RbService> services;
        private int operation;
        private boolean undeploySubscriber;

        public RbServiceConfigurator(RbBaseStationEquipment equipment, List<RbService> services, int operation, boolean undeploySubscriber) {
            this.equipment = equipment;
            this.services = services;
            this.operation = operation;
            this.undeploySubscriber = undeploySubscriber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (RbServiceDistributionTaskExecutor.this.taskShouldAbort()) {
                return;
            }
            final RbServiceManagementStrategy serviceManagement = new RbServiceManagementStrategy();
            Lock lock = LockManagerLocator.locate().getLock(Equipment.getConfigurationLockKey((long)this.equipment.getId()));
            lock.lock();
            try {
                new RunnableDatastoreDecorator(new Runnable(){

                    public void run() {
                        RbServiceConfigurator.this.equipment = (RbBaseStationEquipment)((Object)Datastore.session().get(((Object)((Object)RbServiceConfigurator.this.equipment)).getClass(), (Serializable)Long.valueOf(RbServiceConfigurator.this.equipment.getId())));
                        RbServiceDistributionTaskExecutor.this.logStatus(RbServiceConfigurator.this.equipment, null, OperationStatus.IN_PROGRESS, "");
                        for (RbService service : RbServiceConfigurator.this.services) {
                            if (RbServiceDistributionTaskExecutor.this.taskShouldAbort()) {
                                RbServiceDistributionTaskExecutor.this.logStatus(RbServiceConfigurator.this.equipment, null, OperationStatus.ABORTED, "");
                                return;
                            }
                            String result = null;
                            OperationStatus opStatus = null;
                            boolean serviceOperationOK = false;
                            try {
                                service = (RbService)((Object)Datastore.session().get(((Object)((Object)service)).getClass(), (Serializable)Long.valueOf(service.getId())));
                                logger.debug((Object)("-- starting deploy for service " + service.getName() + "  on " + RbServiceConfigurator.this.equipment.getEUID()));
                                RbServiceDistributionTaskExecutor.this.logStatus(RbServiceConfigurator.this.equipment, service, OperationStatus.IN_PROGRESS, null);
                                int status = 0;
                                switch (RbServiceConfigurator.this.operation) {
                                    case 1: {
                                        status = serviceManagement.deployService(service, RbServiceConfigurator.this.equipment);
                                        break;
                                    }
                                    case 2: {
                                        status = serviceManagement.undeployService(service, RbServiceConfigurator.this.equipment);
                                    }
                                }
                                boolean bl = serviceOperationOK = 0 == status;
                                if (RbServiceConfigurator.this.undeploySubscriber && serviceOperationOK && 2 == RbServiceConfigurator.this.operation) {
                                    serviceManagement.undeploySubscriber(service.getSubscriber(), RbServiceConfigurator.this.equipment);
                                }
                                result = RbServiceDistributionHelper.getResultMessage(status, RbServiceConfigurator.this.operation);
                                opStatus = RbServiceDistributionHelper.getOperationStatus(status);
                            }
                            catch (ServiceManagementException sme) {
                                result = sme.getMessage();
                            }
                            catch (MediationException me) {
                                result = "AgentError";
                                logger.debug((Object)me.getMessage());
                            }
                            catch (Exception e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                            }
                            if (null != opStatus) {
                                RbServiceDistributionTaskExecutor.this.logStatus(RbServiceConfigurator.this.equipment, service, opStatus, result);
                            } else {
                                RbServiceDistributionTaskExecutor.this.logStatus(RbServiceConfigurator.this.equipment, service, OperationStatus.FAILED, serviceOperationOK ? "CouldNotUndeploySubscriber" : result);
                            }
                            logger.debug((Object)("-- done deploy for service " + service.getName() + " on " + RbServiceConfigurator.this.equipment.getEUID() + " result: " + result));
                        }
                        RbServiceDistributionTaskExecutor.this.logStatus(RbServiceConfigurator.this.equipment, null, OperationStatus.COMPLETED, "");
                    }
                }).run();
            }
            finally {
                lock.unlock();
            }
            logger.debug((Object)"-- performing serviceprofiles cleanup.");
            RbServiceDistributionHelper svcDistHelper = new RbServiceDistributionHelper(this.equipment);
            svcDistHelper.performServiceProfilesCleanup();
        }
    }
}

