/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.servicedistribution;

import com.bwanms.model.ManagedEntityBase;
import com.bwanms.model.ManagedEntityWeakAssociation;
import com.bwanms.model.TaskExecutor;
import com.bwanms.model.Validatable;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.services.RbService;
import com.bwanms.rb.tasks.servicedistribution.RbServiceDistributionBaseTask;
import com.bwanms.rb.tasks.servicedistribution.RbServiceDistributionHelper;
import com.bwanms.rb.tasks.servicedistribution.RbServiceDistributionTaskExecutor;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="RbSVCDistributionTask")
public class RbServiceDistributionTask
extends RbServiceDistributionBaseTask
implements Validatable {
    private List<RbBaseStationEquipment> equipmentList;
    private List<RbService> serviceList;
    private boolean undeploySubscriber;

    public TaskExecutor createExecutor() {
        return new RbServiceDistributionTaskExecutor(this);
    }

    void splitAssociations() {
        this.equipmentList = new ArrayList<RbBaseStationEquipment>();
        this.serviceList = new ArrayList<RbService>();
        for (ManagedEntityWeakAssociation weakAssociation : this.getManagedEntityAssociations()) {
            ManagedEntityBase me = weakAssociation.getManagedEntity();
            if (null == me) continue;
            if (me instanceof RbBaseStationEquipment) {
                this.equipmentList.add((RbBaseStationEquipment)me);
                continue;
            }
            this.serviceList.add((RbService)me);
        }
    }

    void mergeAssociations() {
        ArrayList<Validatable> meList = new ArrayList<Validatable>(this.equipmentList.size() + this.serviceList.size());
        for (RbBaseStationEquipment equipment : this.equipmentList) {
            meList.add(equipment);
        }
        for (RbService service : this.serviceList) {
            meList.add(service);
        }
        RbServiceDistributionHelper.mergeMEWeakAssociationLists(this.getManagedEntityAssociations(), meList);
    }

    @Transient
    public List<RbBaseStationEquipment> getEquipmentList() {
        return this.equipmentList;
    }

    public void setEquipmentList(List<RbBaseStationEquipment> equipmentList) {
        this.equipmentList = equipmentList;
    }

    @Transient
    public List<RbService> getServiceList() {
        return this.serviceList;
    }

    public void setServiceList(List<RbService> serviceList) {
        this.serviceList = serviceList;
    }

    public void validate(List<InvalidValue> invalidValues) {
        super.validate(invalidValues);
    }

    public boolean isUndeploySubscriber() {
        return this.undeploySubscriber;
    }

    public void setUndeploySubscriber(boolean undeploySubscriber) {
        this.undeploySubscriber = undeploySubscriber;
    }
}

