/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.servicedistribution;

import com.bwanms.model.Equipment;
import com.bwanms.model.ManagedEntity;
import com.bwanms.model.ManagedEntityBase;
import com.bwanms.model.ManagedEntityWeakAssociation;
import com.bwanms.persistence.Datastore;
import com.bwanms.persistence.RunnableDatastoreDecorator;
import com.bwanms.rb.ddi.RbServiceDeploymentHelper;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.services.impl.LockManagerLocator;
import com.bwanms.util.task.OperationStatus;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbServiceDistributionHelper {
    private static final Logger logger = Logger.getLogger(RbServiceDistributionHelper.class);
    public static final int OPERATION_DEPLOY = 1;
    public static final int OPERATION_UNDEPLOY = 2;
    public static final int OPERATION_MERGE = 3;
    static final String RESULT_DEPLOYED = "Deployed";
    static final String RESULT_UNDEPLOYED = "Undeployed";
    static final String RESULT_MERGED = "Merged";
    static final String RESULT_NOT_SUPPORTED = "OperationNotSupported";
    static final String RESULT_SKIPPED = "Skipped";
    static final String RESULT_DEPLOY_SKIPPED = "Skipped_NoUpdateNeeded";
    static final String RESULT_UNDEPLOY_SKIPPED = "Skipped_NotFound";
    static final String RESULT_MERGE_SKIPPED = "Skipped_NoUpdateNeeded";
    static final String RESULT_FAILED = "Failed";
    private RbBaseStationEquipment bsEquipment;

    public RbServiceDistributionHelper(RbBaseStationEquipment bsEquipment) {
        this.bsEquipment = bsEquipment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performServiceProfilesCleanup() {
        Lock lock = LockManagerLocator.locate().getLock(Equipment.getConfigurationLockKey((long)this.bsEquipment.getId()));
        lock.lock();
        try {
            new RunnableDatastoreDecorator(new Runnable(){

                public void run() {
                    RbServiceDistributionHelper.this.bsEquipment = (RbBaseStationEquipment)((Object)Datastore.session().get(((Object)((Object)RbServiceDistributionHelper.this.bsEquipment)).getClass(), (Serializable)Long.valueOf(RbServiceDistributionHelper.this.bsEquipment.getId())));
                    try {
                        RbServiceDeploymentHelper helper = new RbServiceDeploymentHelper(RbServiceDistributionHelper.this.bsEquipment);
                        helper.performForwardingAndPolicyRulesCleanup();
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }).run();
            new RunnableDatastoreDecorator(new Runnable(){

                public void run() {
                    RbServiceDistributionHelper.this.bsEquipment = (RbBaseStationEquipment)((Object)Datastore.session().get(((Object)((Object)RbServiceDistributionHelper.this.bsEquipment)).getClass(), (Serializable)Long.valueOf(RbServiceDistributionHelper.this.bsEquipment.getId())));
                    try {
                        RbServiceDeploymentHelper helper = new RbServiceDeploymentHelper(RbServiceDistributionHelper.this.bsEquipment);
                        helper.performQoSProfilesCleanup();
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }).run();
            new RunnableDatastoreDecorator(new Runnable(){

                public void run() {
                    RbServiceDistributionHelper.this.bsEquipment = (RbBaseStationEquipment)((Object)Datastore.session().get(((Object)((Object)RbServiceDistributionHelper.this.bsEquipment)).getClass(), (Serializable)Long.valueOf(RbServiceDistributionHelper.this.bsEquipment.getId())));
                    try {
                        RbServiceDeploymentHelper helper = new RbServiceDeploymentHelper(RbServiceDistributionHelper.this.bsEquipment);
                        helper.performVoiceDomainAndPFServerCleanup();
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }).run();
            new RunnableDatastoreDecorator(new Runnable(){

                public void run() {
                    RbServiceDistributionHelper.this.bsEquipment = (RbBaseStationEquipment)((Object)Datastore.session().get(((Object)((Object)RbServiceDistributionHelper.this.bsEquipment)).getClass(), (Serializable)Long.valueOf(RbServiceDistributionHelper.this.bsEquipment.getId())));
                    try {
                        RbServiceDeploymentHelper helper = new RbServiceDeploymentHelper(RbServiceDistributionHelper.this.bsEquipment);
                        helper.performServiceGroupCleanup();
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }).run();
        }
        finally {
            lock.unlock();
        }
    }

    public static String getResultMessage(int serviceDeployStatus, int operation) {
        String result = null;
        switch (serviceDeployStatus) {
            case 0: {
                result = 1 == operation ? RESULT_DEPLOYED : (2 == operation ? RESULT_UNDEPLOYED : RESULT_MERGED);
                break;
            }
            case 1: {
                result = RESULT_NOT_SUPPORTED;
                break;
            }
            case 2: {
                result = 1 == operation ? "Skipped_NoUpdateNeeded" : (2 == operation ? RESULT_UNDEPLOY_SKIPPED : "Skipped_NoUpdateNeeded");
                break;
            }
            default: {
                result = "Unknown";
            }
        }
        return result;
    }

    public static OperationStatus getOperationStatus(int serviceDeployStatus) {
        return 2 != serviceDeployStatus ? OperationStatus.COMPLETED : OperationStatus.SKIPPED;
    }

    public static void mergeMEWeakAssociationLists(List<ManagedEntityWeakAssociation> managedEntityAssociations, List<? extends ManagedEntity> meList) {
        TreeSet<Long> newIds = new TreeSet<Long>();
        for (ManagedEntity managedEntity : meList) {
            newIds.add(managedEntity.getId());
        }
        Iterator<ManagedEntityWeakAssociation> it = managedEntityAssociations.iterator();
        while (it.hasNext()) {
            ManagedEntityBase managedEntityBase = it.next().getManagedEntity();
            if (null == managedEntityBase || !newIds.contains(managedEntityBase.getId())) {
                it.remove();
                continue;
            }
            newIds.remove(managedEntityBase.getId());
        }
        for (ManagedEntity managedEntity : meList) {
            if (!newIds.contains(managedEntity.getId())) continue;
            ManagedEntityWeakAssociation wa = new ManagedEntityWeakAssociation(managedEntity);
            managedEntityAssociations.add(wa);
        }
    }
}

