/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.pmtm;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.mediation.MediationServiceRegistry;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.rb.mo.RbBSPmTmConfigParameters;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.tasks.pmtm.RbPMTMTask;
import com.bwanms.util.Settings;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class RbPMTMUtil {
    private static final Logger log = Logger.getLogger(RbPMTMTask.class);
    public static final String ENDS_WITH_FILE_SEPARATOR = "(.*)(/|\\\\)+$";
    public static final String FILE_SEPARATOR = "/";
    public static final String FILE_SYSTEM = "filesystem";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPmTmLastFileName(RbBaseStationEquipment equipment) throws MediationException {
        MOAccessSession snmpAccess = null;
        String fileName = null;
        try {
            if (equipment instanceof RbBS) {
                snmpAccess = RbPMTMUtil.createMOAccessSession(equipment);
                List confParams = snmpAccess.fetchObject(null, RbBSPmTmConfigParameters.class, new String[]{"rbBSPmTmLastFileName"}, "0");
                RbBSPmTmConfigParameters rbBSPmTmConfigParameters = (RbBSPmTmConfigParameters)((Object)confParams.get(0));
                fileName = rbBSPmTmConfigParameters.getRbBSPmTmLastFileName();
            }
        }
        finally {
            RbPMTMUtil.closeMOAccessSession(snmpAccess);
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getPmTmFileType(RbBaseStationEquipment equipment) throws MediationException {
        MOAccessSession snmpAccess = null;
        Integer fileType = null;
        try {
            if (equipment instanceof RbBS) {
                snmpAccess = RbPMTMUtil.createMOAccessSession(equipment);
                List confParams = snmpAccess.fetchObject(null, RbBSPmTmConfigParameters.class, new String[]{"rbBSPmTmMode"}, "0");
                RbBSPmTmConfigParameters rbBSPmTmConfigParameters = (RbBSPmTmConfigParameters)((Object)confParams.get(0));
                fileType = rbBSPmTmConfigParameters.getRbBSPmTmMode();
            }
        }
        finally {
            RbPMTMUtil.closeMOAccessSession(snmpAccess);
        }
        return fileType;
    }

    private static MOAccessSession createMOAccessSession(RbBaseStationEquipment equipment) throws MediationException {
        return MediationServiceRegistry.getMOSession((SNMPManagementInterface)equipment.getManagementInterface(), null);
    }

    private static void closeMOAccessSession(MOAccessSession access) {
        if (access != null) {
            try {
                access.close();
            }
            catch (Exception e) {
                log.debug((Object)"", (Throwable)e);
            }
        }
    }

    public static String pathConcat(String ... pathList) {
        if (pathList == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String path : pathList) {
            sb.append(RbPMTMUtil.normalizeFilePath(path));
        }
        return sb.toString();
    }

    public static String normalizeFilePath(String path) {
        if (path == null) {
            return null;
        }
        path = true == path.matches(ENDS_WITH_FILE_SEPARATOR) ? path : path + FILE_SEPARATOR;
        String regex = "(/|\\\\)";
        Matcher matcher = Pattern.compile(regex).matcher(path);
        while (matcher.find()) {
            path = path.replace(path.substring(matcher.start(), matcher.end()), FILE_SEPARATOR);
        }
        return path;
    }

    public static String getFileSystemRoot() {
        return Settings.instance().getApplicationDir() + FILE_SEPARATOR + FILE_SYSTEM;
    }
}

