/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.pmtm;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.SelectorUtil;
import com.bwanms.gui.SelectorView;
import com.bwanms.gui.Selectors;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.equipmentmanager.EquipmentRowProviderClient;
import com.bwanms.model.Equipment;
import com.bwanms.model.Task;
import com.bwanms.rb.gui.managers.RbBaseStationEquipmentRowProvider;
import com.bwanms.rb.gui.selectors.equipment.RbBaseStationSelectorView;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.tasks.pmtm.RbPMTMTask;
import com.bwanms.rb.tasks.pmtm.RbPMTMTaskPanel;
import com.bwanms.rb.tasks.pmtm.RbPMTMUtil;
import com.bwanms.ui.components.EntityManagerTableModel;
import com.bwanms.ui.components.SimpleRowTable;
import com.bwanms.ui.components.SimpleRowTableModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbPMTMTaskView
extends AbstractBindedEditorView<Task> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbPMTMTask.class);
    private static final Logger log = Logger.getLogger(RbPMTMTaskView.class);
    private RbPMTMTaskPanel panel;
    private EntityManagerTableModel<RbBaseStationEquipment> equipmentTableModel;
    private EntityManagerTableModel<EntityManagerRow> serviceProfileTableModel;
    public String PMTM_DIR = "pmtm";

    public RbPMTMTaskView() {
        this.initUI();
    }

    public List<Binder> getBinders() {
        ArrayList<Binder> binders = new ArrayList<Binder>();
        DefaultBinder binder = new DefaultBinder((Object)this.getUI(), (Object)this.entity);
        binder.add((Binding)new JTextFieldBinding("txtName", "name", i18n.translateString("Name")));
        binders.add((Binder)binder);
        return binders;
    }

    public void fillUI(Task entity) {
        boolean bEditTask;
        RbPMTMTask task = (RbPMTMTask)entity;
        boolean bl = bEditTask = task.getId() > 0L;
        if (bEditTask) {
            this.panel.getTxtName().setText(task.getName());
            this.panel.getCkbCollectionExport().setSelected(task.isExportEnabled());
            this.panel.getTxtCollectionExportFolder().setText(task.getExportFolderPath());
            this.panel.getTxtCollectionExportFolder().setToolTipText(task.getExportFolderPath());
            this.panel.getSaveFileInDBCBox().setSelected(task.isFileSaved());
        } else {
            this.panel.getCkbCollectionExport().setSelected(false);
            String dir = RbPMTMUtil.pathConcat(RbPMTMUtil.getFileSystemRoot(), this.PMTM_DIR);
            this.panel.getTxtCollectionExportFolder().setText(dir);
            this.panel.getTxtCollectionExportFolder().setToolTipText(dir);
        }
        this.equipmentTableModel.clearTable();
        if (task.getEquipments() != null) {
            for (Equipment equipment : task.getEquipments()) {
                if (null == equipment) continue;
                this.equipmentTableModel.addRow((Object)((RbBaseStationEquipment)equipment), String.valueOf(equipment.getId()));
            }
        }
    }

    public List<InvalidValue> configureEntity(Task entity) {
        RbPMTMTask task = (RbPMTMTask)entity;
        ArrayList<InvalidValue> invalidValues = new ArrayList<InvalidValue>();
        String taskName = this.panel.getTxtName().getText().trim();
        if (taskName.length() > 128 || taskName.length() == 0) {
            invalidValues.add(new InvalidValue(i18n.translateString("InvalidTaskName"), RbPMTMTask.class, i18n.translateString("Name"), (Object)this.panel.getTxtName().getText(), (Object)this.panel.getTxtName()));
        }
        task.setName(taskName);
        task.setExportEnabled(this.panel.getCkbCollectionExport().isSelected());
        task.setExportFolderPath(RbPMTMUtil.normalizeFilePath(this.panel.getTxtCollectionExportFolder().getText()));
        task.setFileSaved(this.panel.getSaveFileInDBCBox().isSelected());
        ArrayList<Object> equipmentList = new ArrayList<Object>(this.equipmentTableModel.getRowCount());
        for (int row = 0; row < this.equipmentTableModel.getRowCount(); ++row) {
            if (1 == this.equipmentTableModel.getRowState(row)) continue;
            equipmentList.add(this.equipmentTableModel.getEntity(row));
        }
        if (equipmentList.isEmpty()) {
            invalidValues.add(new InvalidValue(i18n.translateString("NoEquipmentInList"), RbPMTMTask.class, i18n.translateString("EquipmentTable"), (Object)"", null));
        } else {
            task.setEquipments(equipmentList);
        }
        return invalidValues;
    }

    private void actionAddEquipment() {
        SelectorView selectorView = Selectors.getSelectorView(RbBaseStationEquipment.class, (String)(RbPMTMTask.class.getName() + "_selector"), (String)"multipleSelection");
        if (selectorView == null) {
            throw new IllegalArgumentException("Selector View must be defined!");
        }
        SelectorUtil.displayModalSelector((JComponent)this.panel, (SelectorView)selectorView);
        for (RbBaseStationEquipment equipment : selectorView.getSelection()) {
            String key = String.valueOf(equipment.getId());
            int row = this.equipmentTableModel.getEntityRow(key);
            if (-1 != row) {
                this.equipmentTableModel.updateRow((Object)equipment, key);
                this.equipmentTableModel.revertRow(row);
                continue;
            }
            this.equipmentTableModel.addRow((Object)equipment, key);
        }
    }

    private void actionRemoveEquipment() {
        int[] selectedRows = this.panel.getTableEquipment().getSelectedRows();
        this.equipmentTableModel.removeRows(selectedRows);
    }

    private void initUI() {
        this.panel = new RbPMTMTaskPanel();
        final RbBaseStationSelectorView bsEqManagerSelectorView = new RbBaseStationSelectorView("RbPMTMTask_selector", "multipleSelection");
        SimpleRowTableModel.ColumnDefinition[] colDefs = new SimpleRowTableModel.ColumnDefinition[bsEqManagerSelectorView.getColumnNames().length];
        int idx = 0;
        for (String colName : bsEqManagerSelectorView.getColumnNames()) {
            colDefs[idx++] = new SimpleRowTableModel.ColumnDefinition(colName, String.class);
        }
        this.equipmentTableModel = new EntityManagerTableModel<RbBaseStationEquipment>(colDefs){
            private static final long serialVersionUID = -8530492792413535921L;

            public void setRowValues(int row, RbBaseStationEquipment entity) {
                EquipmentRowProviderClient rowProvider = new EquipmentRowProviderClient(bsEqManagerSelectorView.getEntityRowProvider().getAttributes()){

                    public List<String> getDisplayValues(EntityManagerRow entityRow) {
                        List ret = super.getDisplayValues(entityRow);
                        ret.set(7, RbBaseStationEquipmentRowProvider.toStringSwitchingMode((String)ret.get(7)));
                        return ret;
                    }
                };
                EntityManagerRow entityRow = rowProvider.createRow((Serializable)((Object)entity));
                List displayValues = rowProvider.getDisplayValues(entityRow);
                for (int i = 0; i < displayValues.size(); ++i) {
                    this.setInitialValueAt(displayValues.get(i), row, i);
                }
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        };
        new SimpleRowTable(this.panel.getTableEquipment(), this.equipmentTableModel);
        this.panel.getBtnEquipmentAdd().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RbPMTMTaskView.this.actionAddEquipment();
            }
        });
        this.panel.getBtnEquipmentRemove().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RbPMTMTaskView.this.actionRemoveEquipment();
            }
        });
        this.panel.getTableEquipment().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                RbPMTMTaskView.this.fireEquipmentTableSelectionChanged();
            }
        });
        this.fireEquipmentTableSelectionChanged();
    }

    private void fireEquipmentTableSelectionChanged() {
        this.panel.getBtnEquipmentRemove().setEnabled(0 < this.panel.getTableEquipment().getSelectedRowCount());
    }

    public JComponent getUI() {
        return this.panel;
    }

    public boolean close() {
        return true;
    }

    public String getTitle() {
        return i18n.translateString("RbPMTMTaskTitle");
    }

    public String getApplicationPermission() {
        return "Av:ConfigureTasks";
    }

    public String getHelpTopic() {
        return "";
    }
}

