/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.pmtm;

import com.bwanms.mediation.CommunicationException;
import com.bwanms.mediation.FileTransferEvent;
import com.bwanms.mediation.FileTransferRequest;
import com.bwanms.mediation.FileTransferService;
import com.bwanms.mediation.MediationServiceRegistry;
import com.bwanms.mediation.TftpFileTransferRequest;
import com.bwanms.mediation.TftpFileTransferService;
import com.bwanms.mediation.filetransfer.SynchronousFileTransfer;
import com.bwanms.model.Equipment;
import com.bwanms.model.TaskExecutionContext;
import com.bwanms.model.TaskExecutor;
import com.bwanms.model.TaskRuntimeStatus;
import com.bwanms.model.entity.LightQuery;
import com.bwanms.protocols.tftp.TftpServerException;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbPMTMCollectionFile;
import com.bwanms.rb.tasks.pmtm.RbPMTMTask;
import com.bwanms.rb.tasks.pmtm.RbPMTMUtil;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.services.EntityManagerService;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.concurrent.AsyncItemsExecutor;
import com.bwanms.util.concurrent.AsyncItemsProvider;
import com.bwanms.util.task.Operation;
import com.bwanms.util.task.OperationStatus;
import com.bwanms.util.task.OperationTaskRuntimeStatus;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class RbPMTMTaskExecutor
implements TaskExecutor {
    private static final Logger logger = Logger.getLogger(RbPMTMTaskExecutor.class);
    private transient TaskExecutionContext ctx = null;
    private RbPMTMTask task;
    private boolean hasErrors = false;
    private boolean taskFailed;
    private boolean hasSuccesses = false;
    private RbPMTMCollectionFile.FileType fileType = RbPMTMCollectionFile.FileType.RbPMTMBasic;
    private OperationTaskRuntimeStatus runtimeStatus;
    private Operation rootOperation;
    private int taskExecutionResult = 1;
    private HashMap<String, Operation> operationMap = new HashMap();
    private HashMap<String, Operation> spOpMap = new HashMap();

    private boolean taskShouldAbort() {
        return this.ctx.shouldAbort();
    }

    private synchronized void logStatus(RbBaseStationEquipment bsEq, OperationStatus status, String message, String fileName) {
        if (null != bsEq) {
            logger.debug((Object)("logStatus:  bsEq " + bsEq.getIPAddress() + " message " + message));
            Operation eqOp = this.operationMap.get("" + bsEq.getId());
            if (null == eqOp) {
                String text = "PMTMFileFrom";
                eqOp = this.runtimeStatus.addOperation(this.rootOperation, text, new Object[]{bsEq.getIPAddress() + "/" + bsEq.getName()});
                this.operationMap.put("" + bsEq.getId(), eqOp);
            } else if (null != fileName) {
                Operation eqFileOp = this.operationMap.get(bsEq.getId() + "_" + fileName);
                if (null == eqFileOp) {
                    if (status == OperationStatus.SKIPPED) {
                        eqFileOp = this.runtimeStatus.addOperation(eqOp, "PMTMFileDownload", new Object[]{fileName});
                        this.operationMap.put(bsEq.getId() + "_" + fileName, eqFileOp);
                        this.runtimeStatus.logOperationStatus(eqFileOp, OperationStatus.SKIPPED, (Serializable)((Object)message), new Object[]{fileName});
                    } else {
                        eqFileOp = this.runtimeStatus.addOperation(eqOp, message, new Object[]{fileName});
                        this.operationMap.put(bsEq.getId() + "_" + fileName, eqFileOp);
                    }
                } else {
                    this.runtimeStatus.logOperationStatus(eqFileOp, status, (Serializable)((Object)message));
                    if (status == OperationStatus.ABORTED) {
                        this.runtimeStatus.logOperationStatus(eqOp, OperationStatus.ABORTED, null);
                    }
                }
            } else {
                this.runtimeStatus.logOperationStatus(eqOp, status, (Serializable)((Object)message));
            }
        } else {
            this.runtimeStatus.logOperationStatus(this.rootOperation, status, (Serializable)((Object)message));
        }
    }

    private synchronized void logStatus(RbBaseStationEquipment bsEq, OperationStatus status, String message) {
        this.logStatus(bsEq, status, message, null);
    }

    public RbPMTMTaskExecutor(RbPMTMTask task) {
        this.task = task;
        this.taskFailed = false;
        this.runtimeStatus = new OperationTaskRuntimeStatus(){

            public String toXMLStringFailed(String name) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter out = new PrintWriter(stringWriter);
                out.println("<operations>");
                out.println("<operation name=\"RbPMTMTaskWithName\"");
                out.println("nameParam0=\"" + name + "\"");
                out.println("status=\"failed\"");
                out.println("message=\"NoEquipmentInList\"");
                out.println("time=\"" + new Date().toString() + "\">");
                out.println("</operation>");
                out.println("</operations>");
                out.close();
                return stringWriter.toString();
            }
        };
        this.rootOperation = this.runtimeStatus.addOperation(null, "RbPMTMTaskWithName", new Object[]{task.getName()});
    }

    public void execute(TaskExecutionContext ctx) {
        this.ctx = ctx;
        this.task = (RbPMTMTask)ServiceRegistry.getTaskManagerService().retrieveTask(this.task.getId());
        List eqList = this.task.getEquipments();
        for (int i = 0; i < eqList.size(); ++i) {
            Equipment eq = (Equipment)eqList.get(i);
            if (null != eq) continue;
            eqList.remove(i);
        }
        final Iterator bsEquipmentIterator = eqList.iterator();
        AsyncItemsExecutor itemsExecutor = new AsyncItemsExecutor((AsyncItemsProvider)new AsyncItemsProvider<RbPMTMTaskItem>(){

            public boolean shouldAbort() {
                return false;
            }

            public void itemFinished(RbPMTMTaskItem item) {
            }

            public void itemStarting(RbPMTMTaskItem item) {
            }

            public boolean hasNext() {
                return bsEquipmentIterator.hasNext();
            }

            public RbPMTMTaskItem next() {
                RbBaseStationEquipment nextBaseStation = (RbBaseStationEquipment)((Object)bsEquipmentIterator.next());
                if (null == nextBaseStation) {
                    return null;
                }
                return new RbPMTMTaskItem(nextBaseStation);
            }

            public void remove() {
                throw new UnsupportedOperationException("Remove Not Implemented!");
            }
        });
        String fail_message = null;
        if (!eqList.isEmpty()) {
            logger.debug((Object)("Starting task ItemsExecutor: " + this.task.getName()));
            itemsExecutor.executeItems();
            logger.debug((Object)("Done task ItemsExecutor: " + this.task.getName()));
            this.taskExecutionResult = !ctx.shouldAbort() ? (this.hasErrors ? 4 : 1) : 2;
        } else {
            this.taskExecutionResult = 3;
            fail_message = "NoEquipmentInList";
        }
        switch (this.taskExecutionResult) {
            case 2: {
                this.logStatus(null, OperationStatus.ABORTED, null);
                break;
            }
            case 1: {
                this.logStatus(null, OperationStatus.COMPLETED, null);
                break;
            }
            case 4: {
                this.logStatus(null, OperationStatus.COMPLETED_WITH_ERRORS, null);
                break;
            }
            case 3: {
                this.logStatus(null, OperationStatus.FAILED, fail_message);
            }
        }
        ctx.taskFinished();
    }

    public TaskRuntimeStatus getStatus(Object clientData) {
        Integer idx = null != clientData ? (Integer)clientData : 0;
        return this.runtimeStatus.getDiff(idx.intValue());
    }

    public String getReport() {
        if (this.taskExecutionResult == 3) {
            return this.runtimeStatus.toXMLStringFailed(this.task.getName());
        }
        return this.runtimeStatus.toXMLString();
    }

    public int getExecutionResult() {
        return this.taskExecutionResult;
    }

    private class RbPMTMTaskItem
    implements Runnable {
        private RbBaseStationEquipment equipment;

        public RbPMTMTaskItem(RbBaseStationEquipment nextEquipment) {
            this.equipment = nextEquipment;
        }

        private Calendar getCalendarFromFileName(String lastFileName) {
            Calendar cal = Calendar.getInstance();
            String[] filename = lastFileName.split("_");
            String[] hour = filename[3].split("\\.");
            Integer year = Integer.valueOf(filename[2].substring(0, 4));
            Integer month = Integer.valueOf(filename[2].substring(4, 6));
            Integer day = Integer.valueOf(filename[2].substring(6, 8));
            Integer hr = Integer.valueOf(hour[0].substring(0, 2));
            Integer min = Integer.valueOf(hour[0].substring(2, 4));
            cal.set(year, month - 1, day, hr, min, 0);
            return cal;
        }

        private String getPrevFileName(String lastFileName) {
            String[] filename = lastFileName.split("_");
            String[] hour = filename[3].split("\\.");
            Calendar cal = this.getCalendarFromFileName(lastFileName);
            cal.add(12, -15);
            Integer year = cal.get(1);
            Integer day = cal.get(5);
            Integer month = cal.get(2) + 1;
            Integer min = cal.get(12);
            Integer hr = cal.get(11);
            String lastFile = filename[0] + "_" + filename[1] + "_";
            lastFile = lastFile + year + "" + (month < 10 ? "0" + month : month) + (day < 10 ? "0" + day : day) + "_" + (hr < 10 ? "0" + hr : hr) + (min < 10 ? "0" + min : min) + ".pmtm.gz";
            return lastFile;
        }

        private boolean shouldDownloadFile(String fileName) {
            boolean ret = true;
            EntityManagerService em = ServiceRegistry.getEntityManagerService();
            LightQuery q = new LightQuery(RbPMTMCollectionFile.class);
            q.addParameter("fileName", (Object)fileName);
            List retList = em.retrieveByQuery(q);
            if (0 < retList.size()) {
                ret = false;
            }
            return ret;
        }

        private boolean beginDownload(Integer lastFileType, String lastFileName) throws Exception {
            String[] fileNames = null;
            boolean[] shouldDownload = null;
            try {
                fileNames = this.getFilesToDownload(lastFileType, lastFileName);
            }
            catch (Exception ex) {
                logger.debug((Object)ex, (Throwable)ex);
                RbPMTMTaskExecutor.this.logStatus(this.equipment, OperationStatus.FAILED, "PmTmFileParseError");
                RbPMTMTaskExecutor.this.hasErrors = true;
                throw ex;
            }
            shouldDownload = new boolean[fileNames.length];
            try {
                for (int i = 0; i < fileNames.length; ++i) {
                    shouldDownload[i] = this.shouldDownloadFile(fileNames[i]);
                }
            }
            catch (Exception ex) {
                logger.debug((Object)ex, (Throwable)ex);
                RbPMTMTaskExecutor.this.logStatus(this.equipment, OperationStatus.FAILED, "FileExistenceCheckError");
                RbPMTMTaskExecutor.this.hasErrors = true;
                throw ex;
            }
            boolean isDldSuccessful = true;
            for (int i = 0; i < fileNames.length; ++i) {
                if (shouldDownload[i]) {
                    isDldSuccessful &= this.doDownload(fileNames[i], lastFileType);
                    logger.debug((Object)("File " + fileNames[i] + " downloaded successfully for " + this.equipment.getEUID() + "."));
                    continue;
                }
                RbPMTMTaskExecutor.this.logStatus(this.equipment, OperationStatus.SKIPPED, "PMTMFileAlreadyExist", fileNames[i]);
                logger.debug((Object)("File " + fileNames[i] + " skipped for " + this.equipment.getEUID() + "."));
            }
            return isDldSuccessful;
        }

        private String[] getFilesToDownload(Integer lastFileType, String lastFileName) {
            String[] ret = null;
            ret = lastFileType == 2 ? new String[]{lastFileName, this.getPrevFileName(ret[0])} : new String[]{lastFileName, this.getPrevFileName(ret[0]), this.getPrevFileName(ret[1]), this.getPrevFileName(ret[2])};
            return ret;
        }

        private boolean doDownload(String deviceFileName, Integer deviceFileType) {
            block13: {
                StringBuffer fileName = new StringBuffer(deviceFileName);
                RbPMTMTaskExecutor.this.logStatus(this.equipment, OperationStatus.IN_PROGRESS, "PMTMFileDownload", deviceFileName);
                try {
                    long time = System.currentTimeMillis();
                    TftpFileTransferService tftpService = MediationServiceRegistry.getTftpFileTransferService();
                    SynchronousFileTransfer sft = new SynchronousFileTransfer((FileTransferService)tftpService, "topic/TftpMediationTopic");
                    TftpFileTransferRequest req = new TftpFileTransferRequest(this.equipment.getIPAddress(), null, fileName.toString(), 1, (Serializable)((Object)"me"));
                    FileTransferEvent res = sft.executeTransfer((FileTransferRequest)req, 600000L);
                    if (res == null) {
                        RbPMTMTaskExecutor.this.logStatus(this.equipment, OperationStatus.FAILED, "TFTPFailure", deviceFileName);
                        RbPMTMTaskExecutor.this.hasErrors = true;
                        return false;
                    }
                    if (res.getEventType() == 2) {
                        int errorCode = ((TftpServerException)res.getError().getCause()).getErrorCode();
                        RbPMTMTaskExecutor.this.logStatus(this.equipment, OperationStatus.FAILED, "TFTPRequestError" + errorCode, deviceFileName);
                        RbPMTMTaskExecutor.this.hasErrors = true;
                        return false;
                    }
                    logger.debug((Object)("[" + this.equipment.getIPAddress() + "] collection file downloaded in " + (System.currentTimeMillis() - time) + " millis."));
                    time = System.currentTimeMillis();
                    if (RbPMTMTaskExecutor.this.taskShouldAbort()) {
                        RbPMTMTaskExecutor.this.logStatus(this.equipment, OperationStatus.ABORTED, deviceFileName);
                        return false;
                    }
                    byte[] configFileData = res.getFileData();
                    RbPMTMCollectionFile pmtmFile = new RbPMTMCollectionFile(this.equipment, deviceFileName);
                    pmtmFile.setConfigurationFile(configFileData);
                    pmtmFile.setTimestamp(this.getCalendarFromFileName(deviceFileName).getTimeInMillis());
                    pmtmFile.setType(deviceFileType);
                    logger.info((Object)String.format("Saving collection statistics for %s", this.equipment.getName()));
                    if (RbPMTMTaskExecutor.this.task.isFileSaved()) {
                        try {
                            ServiceRegistry.getEntityManagerService().save((Serializable)((Object)pmtmFile));
                        }
                        catch (ServiceException e) {
                            logger.error((Object)e, (Throwable)e);
                            RbPMTMTaskExecutor.this.logStatus(this.equipment, OperationStatus.FAILED, "PersistenceError", deviceFileName);
                            RbPMTMTaskExecutor.this.hasErrors = true;
                            return false;
                        }
                    }
                    if (!RbPMTMTaskExecutor.this.task.isExportEnabled()) break block13;
                    String fullPathFileName = RbPMTMTaskExecutor.this.task.getExportFolderPath() + pmtmFile.getFileName();
                    File file = new File(fullPathFileName);
                    File dir = new File(RbPMTMTaskExecutor.this.task.getExportFolderPath());
                    if (!dir.exists()) {
                        try {
                            dir.mkdir();
                        }
                        catch (SecurityException ex) {
                            logger.debug((Object)ex, (Throwable)ex);
                            RbPMTMTaskExecutor.this.logStatus(this.equipment, OperationStatus.FAILED, "CantCreateDir", deviceFileName);
                            RbPMTMTaskExecutor.this.hasErrors = true;
                            return false;
                        }
                    }
                    if (file.exists()) break block13;
                    try {
                        FileOutputStream pw = new FileOutputStream(file);
                        pw.write(pmtmFile.getConfigurationFile());
                        pw.flush();
                        pw.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)e, (Throwable)e);
                        RbPMTMTaskExecutor.this.logStatus(this.equipment, OperationStatus.FAILED, "ExportError", deviceFileName);
                        RbPMTMTaskExecutor.this.hasErrors = true;
                        return false;
                    }
                }
                catch (Exception ex) {
                    RbPMTMTaskExecutor.this.hasErrors = true;
                    RbPMTMTaskExecutor.this.logStatus(this.equipment, OperationStatus.FAILED, "DownloadFailure", deviceFileName);
                    return false;
                }
            }
            RbPMTMTaskExecutor.this.logStatus(this.equipment, OperationStatus.COMPLETED, null, deviceFileName);
            return true;
        }

        public void run() {
            if (RbPMTMTaskExecutor.this.taskShouldAbort()) {
                RbPMTMTaskExecutor.this.logStatus(this.equipment, OperationStatus.ABORTED, null);
                return;
            }
            RbPMTMTaskExecutor.this.logStatus(this.equipment, OperationStatus.IN_PROGRESS, null);
            if (this.equipment.getState() == -1) {
                RbPMTMTaskExecutor.this.hasErrors = true;
                RbPMTMTaskExecutor.this.logStatus(this.equipment, OperationStatus.FAILED, "DeviceUnreachable");
                return;
            }
            if (this.equipment.getState() == -5) {
                RbPMTMTaskExecutor.this.hasErrors = true;
                RbPMTMTaskExecutor.this.logStatus(this.equipment, OperationStatus.FAILED, "DeviceUnlicensed");
                return;
            }
            if (!(this.equipment instanceof RbBS)) {
                RbPMTMTaskExecutor.this.hasErrors = true;
                RbPMTMTaskExecutor.this.logStatus(this.equipment, OperationStatus.SKIPPED, "WrongEquipmentType");
                return;
            }
            try {
                boolean isNewerOrEqual4_5 = this.equipment.getSoftwareVersion().isNewerOrEqualWith(RbVersions.V_4_5);
                if (!isNewerOrEqual4_5) {
                    RbPMTMTaskExecutor.this.hasErrors = true;
                    RbPMTMTaskExecutor.this.logStatus(this.equipment, OperationStatus.SKIPPED, "WrongSwVersion");
                    return;
                }
            }
            catch (Exception e) {
                RbPMTMTaskExecutor.this.logStatus(this.equipment, OperationStatus.FAILED, "UnknownSwVersion");
                RbPMTMTaskExecutor.this.hasErrors = true;
                return;
            }
            String lastDeviceFileName = null;
            Integer lastDeviceFileType = null;
            try {
                lastDeviceFileName = RbPMTMUtil.getPmTmLastFileName(this.equipment);
                String[] filename = lastDeviceFileName.split("_");
                String hour = filename[3].substring(0, 4);
                lastDeviceFileName = filename[0] + "_" + filename[1] + "_" + filename[2] + "_" + hour + ".pmtm.gz";
                lastDeviceFileType = RbPMTMUtil.getPmTmFileType(this.equipment);
            }
            catch (CommunicationException ex) {
                logger.debug((Object)ex, (Throwable)ex);
                RbPMTMTaskExecutor.this.hasErrors = true;
                RbPMTMTaskExecutor.this.logStatus(this.equipment, OperationStatus.FAILED, "DeviceUnreachable");
                return;
            }
            catch (Exception ex) {
                logger.debug((Object)ex, (Throwable)ex);
                RbPMTMTaskExecutor.this.hasErrors = true;
                RbPMTMTaskExecutor.this.logStatus(this.equipment, OperationStatus.FAILED, "UnknownFileNameOrType");
                return;
            }
            if (RbPMTMTaskExecutor.this.taskShouldAbort()) {
                RbPMTMTaskExecutor.this.logStatus(this.equipment, OperationStatus.ABORTED, null);
                return;
            }
            boolean downloadComplete = false;
            try {
                downloadComplete = this.beginDownload(lastDeviceFileType, lastDeviceFileName);
            }
            catch (Exception ex) {
                return;
            }
            if (!downloadComplete) {
                RbPMTMTaskExecutor.this.hasErrors = true;
                RbPMTMTaskExecutor.this.logStatus(this.equipment, OperationStatus.COMPLETED_WITH_ERRORS, null);
                this.deleteProcessedFiles();
                return;
            }
            RbPMTMTaskExecutor.this.hasSuccesses = true;
            RbPMTMTaskExecutor.this.logStatus(this.equipment, OperationStatus.COMPLETED, null);
            this.deleteProcessedFiles();
        }

        private void deleteProcessedFiles() {
            try {
                String PMTM_DIR = "pmtm/";
                String dirPath = RbPMTMUtil.pathConcat(RbPMTMUtil.getFileSystemRoot(), PMTM_DIR);
                File dir = new File(dirPath);
                FilenameFilter filter = new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        String leadingChars = "DONE_PM_";
                        return name.toUpperCase().startsWith(leadingChars);
                    }
                };
                File[] files = dir.listFiles(filter);
                String fileName = "";
                for (File file : files) {
                    try {
                        fileName = file.getName();
                        boolean isDeleted = file.delete();
                        if (isDeleted) continue;
                        logger.debug((Object)("File [" + fileName + "] cannot be deleted"));
                    }
                    catch (Exception e) {
                        logger.debug((Object)("error on deleting file [" + fileName + "]"));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

