/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.multipleconfiguration;

import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.SelectorUtil;
import com.bwanms.gui.SelectorView;
import com.bwanms.gui.Selectors;
import com.bwanms.model.EqTreeNode;
import com.bwanms.model.EqTreeNodeValue;
import com.bwanms.model.Equipment;
import com.bwanms.model.ManagedEntity;
import com.bwanms.model.MultipleConfigWeakAssociation;
import com.bwanms.model.Task;
import com.bwanms.rb.gui.configuration.MACDenyListConfigForm;
import com.bwanms.rb.gui.configuration.SuFrequencyScanningPanel402;
import com.bwanms.rb.mo.RbBsRadioParameters;
import com.bwanms.rb.mo.RbSuBestBstAuParamsEntry;
import com.bwanms.rb.mo.RbSuBridgingParameters;
import com.bwanms.rb.mo.RbSuFreqScanningEntry;
import com.bwanms.rb.mo.RbSuLicensesEntry;
import com.bwanms.rb.mo.RbSuMACParametersGroup;
import com.bwanms.rb.mo.RbSuPhyParametersGroup;
import com.bwanms.rb.mo.RbSuSystemEntry;
import com.bwanms.rb.model.RbAU;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbSU;
import com.bwanms.rb.tasks.multipleconfiguration.MultipleConfigTaskMainPanel2;
import com.bwanms.rb.tasks.multipleconfiguration.RbMultipleConfigTask;
import com.bwanms.rb.tasks.multipleconfiguration.RbSUMultipleConfigTask;
import com.bwanms.ui.components.EquipmentSelectorTreeTableModel;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.OctetString;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbSUMultipleConfigTaskView
extends AbstractBindedEditorView<Task> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(MACDenyListConfigForm.class);
    private static final Logger logger = Logger.getLogger(RbSUMultipleConfigTaskView.class);
    private MultipleConfigTaskMainPanel2 panel;
    private EquipmentSelectorTreeTableModel equipmentTreeTableModel;

    public JComponent getUI() {
        return this.panel;
    }

    public RbSUMultipleConfigTaskView() {
        this.initUI();
    }

    private void initUI() {
        this.equipmentTreeTableModel = new EquipmentSelectorTreeTableModel();
        this.panel = new MultipleConfigTaskMainPanel2(this.equipmentTreeTableModel);
        this.panel.setPreferredSize(new Dimension(720, 540));
        this.panel.getBtnEquipmentAdd().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RbSUMultipleConfigTaskView.this.actionAddSUSelection();
            }
        });
        this.panel.getBtnEquipmentRemove().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RbSUMultipleConfigTaskView.this.actionRemoveEquipment();
            }
        });
        this.panel.showSuParamsPanel();
        this.panel.getNpuCommandsPanel().getRadioResetAndShadow().setEnabled(false);
    }

    public String getTitle() {
        return i18n.translateString("MultipleConfigTask");
    }

    public void fillUI(Task entity) {
        int i;
        RbSUMultipleConfigTask task = (RbSUMultipleConfigTask)entity;
        this.panel.getTxtName().setText(task.getName());
        this.loadEquipment(task);
        if (null != task.getSuMACParams().getRbSuConfiguredBaseStationId()) {
            this.panel.getSuPanel().getCfgBaseStationID().setText(OctetString.toDottedDecimalForm((String)task.getSuMACParams().getRbSuConfiguredBaseStationId()));
        }
        if (null != task.getSuMACParams().getRbSuConfiguredBaseStationIdMask()) {
            this.panel.getSuPanel().getCfgBaseStationIDMask().setText(OctetString.toDottedDecimalForm((String)task.getSuMACParams().getRbSuConfiguredBaseStationIdMask()));
        }
        if (null != task.getSuPhyParams().getSuPhyConfiguredBandwidth()) {
            FormUtil.setSelectedValue((JComboBox)this.panel.getSuPanel().getCfgBandwidth(), (Object)task.getSuPhyParams().getSuPhyConfiguredBandwidth());
        }
        if (null != task.getSuFreqScanningEntry().getRbSuConfiguredBandwidth()) {
            FormUtil.setSelectedValue((JComboBox)this.panel.getAdvancedParamsPanel().getComboAdvancedCfgBandwith(), (Object)task.getSuFreqScanningEntry().getRbSuConfiguredBandwidth());
        }
        if (null != task.getSuPhyParams().getSuPhyConfiguredTxFrequencyChannel()) {
            this.panel.getSuPanel().getCfgTxFrequency().setText(task.getSuPhyParams().getSuPhyConfiguredTxFrequencyChannel());
        }
        FormUtil.setSelectedValue((JComboBox)this.panel.getSuPanel().getComboFreqBands(), (Object)task.getFreqBands());
        FormUtil.setSelectedValue((JComboBox)this.panel.getAdvancedParamsPanel().getComboFreqBands(), (Object)task.getFreqBandsAdvanced());
        if (null != task.getSuBridgingParams().getRbSuSupportDevicesLimit()) {
            FormUtil.setSelectedValue((JComboBox)this.panel.getGeneralParamsPanel().getComboDevicesLimitSupport(), (Object)task.getSuBridgingParams().getRbSuSupportDevicesLimit());
        }
        if (null != task.getSuBridgingParams().getRbSuMaxNumberOfSupportedDevices()) {
            this.panel.getGeneralParamsPanel().getTextMaximumDevicesLimit().setText(task.getSuBridgingParams().getRbSuMaxNumberOfSupportedDevices().toString());
        }
        if (null != task.getSuBridgingParams().getRbSuBridgeAgingTime()) {
            this.panel.getGeneralParamsPanel().getTextAgingTime().setText(task.getSuBridgingParams().getRbSuBridgeAgingTime().toString());
        }
        if (null != task.getSuSystemEntry().getRbSuInstallerPassword()) {
            this.panel.getGeneralParamsPanel().getTxtInstPassw().setText(task.getSuSystemEntry().getRbSuInstallerPassword().toString());
        }
        if (null != task.getSuBestBstAuEntry().getRbSuConfiguredBestBstAuSupport()) {
            FormUtil.setSelectedValue((JComboBox)this.panel.getAdvancedParamsPanel().getCmbBestBSAUSupport(), (Object)task.getSuBestBstAuEntry().getRbSuConfiguredBestBstAuSupport());
        }
        if (null != task.getSuBestBstAuEntry().getRbSuConfiguredBstAuId()) {
            this.panel.getAdvancedParamsPanel().getTxtBsAuID().setText(OctetString.toDottedDecimalForm((String)task.getSuBestBstAuEntry().getRbSuConfiguredBstAuId().toString()));
        }
        if (null != task.getSuBestBstAuEntry().getRbSuConfiguredBstAuMask()) {
            this.panel.getAdvancedParamsPanel().getTxtBsAuMask().setText(OctetString.toDottedDecimalForm((String)task.getSuBestBstAuEntry().getRbSuConfiguredBstAuMask().toString()));
        }
        if (null != task.getSuBestBstAuEntry().getRbSuConfiguredPreferredBstAuId()) {
            this.panel.getAdvancedParamsPanel().getTxtPrefferedBsAuID().setText(OctetString.toDottedDecimalForm((String)task.getSuBestBstAuEntry().getRbSuConfiguredPreferredBstAuId().toString()));
        }
        if (null != task.getSuBestBstAuEntry().getRbSuConfiguredPreferredBstAuMask()) {
            this.panel.getAdvancedParamsPanel().getTxtPrefferedBsAuMask().setText(OctetString.toDottedDecimalForm((String)task.getSuBestBstAuEntry().getRbSuConfiguredPreferredBstAuMask().toString()));
        }
        if (null != task.getSuBestBstAuEntry().getRbSuMobilityMode()) {
            FormUtil.setSelectedValue((JComboBox)this.panel.getAdvancedParamsPanel().getMobilityModeCmb(), (Object)task.getSuBestBstAuEntry().getRbSuMobilityMode());
        }
        if (null != task.getSuFreqScanningEntry().getRbSuConfiguredScanStartFreq()) {
            this.panel.getAdvancedParamsPanel().getTxtStartFreq().setText(task.getSuFreqScanningEntry().getRbSuConfiguredScanStartFreq());
        }
        if (null != task.getSuFreqScanningEntry().getRbSuConfiguredScanEndFreq()) {
            this.panel.getAdvancedParamsPanel().getTxtEndFreq().setText(task.getSuFreqScanningEntry().getRbSuConfiguredScanEndFreq());
        }
        if (null != task.getSuFreqScanningEntry().getRbSuConfiguredScanStep()) {
            Double val = Double.parseDouble(task.getSuFreqScanningEntry().getRbSuConfiguredScanStep()) * 1000.0;
            this.panel.getAdvancedParamsPanel().getTxtScanningMainStep().setText(String.valueOf(val.intValue()));
        }
        if (task.isConfigureScanIntermediateMask()) {
            this.panel.getAdvancedParamsPanel().getRadioConfigure().setSelected(true);
        } else {
            this.panel.getAdvancedParamsPanel().getRadioIgnore().setSelected(true);
        }
        if (task.getSuFreqScanningEntry().getRbSuConfiguredScanMask() != null) {
            int mask = Integer.valueOf(task.getSuFreqScanningEntry().getRbSuConfiguredScanMask(), 16);
            for (i = 0; i < this.panel.getAdvancedParamsPanel().getChkRbSuConfiguredScanMask().size(); ++i) {
                boolean flag = (mask & (int)Math.pow(2.0, i)) != 0;
                this.panel.getAdvancedParamsPanel().getChkRbSuConfiguredScanMask().get(i).setSelected(flag);
            }
        }
        if (!task.getRbSuLicensesEntries().isEmpty()) {
            FormUtil.setSelectedValue((JComboBox)this.panel.getSuGeneralPanel().getComboLicense(), (Object)task.getRbSuLicensesEntries().get(0).getRbSuLicenseValue());
        }
        if (task.isClearBSTTable()) {
            this.panel.getAdvancedParamsPanel().getChkClearBSTTable().setSelected(true);
        } else {
            this.panel.getAdvancedParamsPanel().getChkClearBSTTable().setSelected(false);
        }
        if (task.isConfigureDiscreteFreq()) {
            this.panel.getAdvancedParamsPanel().getRadioFreqConfigure().setSelected(true);
        }
        SimpleRowTableModel freqTableModel = (SimpleRowTableModel)this.panel.getAdvancedParamsPanel().getTblDiscreteFreq().getModel();
        if (task.getScanningFreq() != null) {
            for (i = 0; i < 10; ++i) {
                freqTableModel.setInitialValueAt((Object)task.getScanningFreq()[i], i, 1);
            }
        }
        if (task.isUpdateScanningTable()) {
            this.panel.getAdvancedParamsPanel().getChkUpdateScanningTable().setSelected(true);
        } else {
            this.panel.getAdvancedParamsPanel().getChkUpdateScanningTable().setSelected(false);
        }
        if (task.isFullScan()) {
            this.panel.getAdvancedParamsPanel().getChkFullScan().setSelected(true);
        } else {
            this.panel.getAdvancedParamsPanel().getChkFullScan().setSelected(false);
        }
        if (task.getCommand() == 1) {
            this.panel.getNpuCommandsPanel().getRadioReset().setSelected(true);
        }
        if (task.getCommand() == 0) {
            this.panel.getNpuCommandsPanel().getRadioNone().setSelected(true);
        }
    }

    public List<InvalidValue> configureEntity(Task entity) {
        Integer bandwith;
        String advancedFreqBands;
        RbSUMultipleConfigTask task;
        ArrayList<InvalidValue> invalidValues;
        block117: {
            invalidValues = new ArrayList<InvalidValue>();
            task = (RbSUMultipleConfigTask)entity;
            String taskName = this.panel.getTxtName().getText();
            if (null == taskName) {
                taskName = "";
            }
            if (1 > (taskName = taskName.trim()).length() || 32 < taskName.length()) {
                invalidValues.add(new InvalidValue(i18n.translateString("InvalidTaskName"), this.panel.getTxtName().getClass(), i18n.translateString("taskName"), (Object)this.panel.getTxtName().getText(), (Object)this.panel.getTxtName()));
            } else {
                task.setName(taskName);
            }
            if (!this.saveEquipment(task)) {
                invalidValues.add(new InvalidValue(i18n.translateString("NoEquipmentsSelected"), RbBsRadioParameters.class, "", (Object)"", null));
            }
            Integer intValue = null;
            String strValue = null;
            String instPassw = this.panel.getGeneralParamsPanel().getTxtInstPassw().getText();
            if (instPassw != null && !instPassw.trim().equals("")) {
                strValue = instPassw;
            }
            if (strValue != null) {
                if (strValue.matches("^[A-Z,a-z,\\-,_,0-9,$~`!@#^&*()_+-=|{}\\[\\]\\'\\\\:;?/>.<\\\"\\% ]*$") && strValue.length() <= 20) {
                    task.getSuSystemEntry().setRbSuInstallerPassword(strValue);
                } else {
                    invalidValues.add(new InvalidValue(i18n.translateString("InvalidInstallerPassword"), RbSuSystemEntry.class, "", (Object)"", (Object)this.panel.getGeneralParamsPanel().getTxtInstPassw()));
                }
            } else {
                task.getSuSystemEntry().setRbSuInstallerPassword(strValue);
            }
            intValue = (Integer)FormUtil.getSelectedValue((JComboBox)this.panel.getAdvancedParamsPanel().getCmbBestBSAUSupport());
            task.getSuBestBstAuEntry().setRbSuConfiguredBestBstAuSupport(intValue);
            strValue = null;
            String BsAuId = this.panel.getAdvancedParamsPanel().getTxtBsAuID().getText();
            if (BsAuId != null && !BsAuId.trim().equals("")) {
                try {
                    boolean isCorrectIpFormat = true;
                    if (BsAuId.matches("(\\p{Digit}{1,3}\\.){5}(\\p{Digit}{1,3}){1}")) {
                        try {
                            strValue = OctetString.fromDottedDecimalForm((String)BsAuId);
                        }
                        catch (NumberFormatException nfe) {
                            isCorrectIpFormat = false;
                        }
                    } else {
                        isCorrectIpFormat = false;
                    }
                    if (!isCorrectIpFormat) {
                        invalidValues.add(new InvalidValue(i18n.translateString("InvalidBsAuId"), RbSuBestBstAuParamsEntry.class, i18n.translateString("BsAuID"), (Object)BsAuId, (Object)this.panel.getAdvancedParamsPanel().getTxtBsAuID()));
                    }
                }
                catch (NumberFormatException e) {
                    invalidValues.add(new InvalidValue(i18n.translateString("InvalidBsAuId"), RbSuBestBstAuParamsEntry.class, i18n.translateString("BsAuID"), (Object)BsAuId, (Object)this.panel.getAdvancedParamsPanel().getTxtBsAuID()));
                }
            }
            task.getSuBestBstAuEntry().setRbSuConfiguredBstAuId(strValue);
            strValue = null;
            String BsAuMask = this.panel.getAdvancedParamsPanel().getTxtBsAuMask().getText();
            if (BsAuMask != null && !BsAuMask.trim().equals("")) {
                try {
                    boolean isCorrectIpFormat = true;
                    if (BsAuMask.matches("(\\p{Digit}{1,3}\\.){5}(\\p{Digit}{1,3}){1}")) {
                        try {
                            strValue = OctetString.fromDottedDecimalForm((String)BsAuMask);
                        }
                        catch (NumberFormatException nfe) {
                            isCorrectIpFormat = false;
                        }
                    } else {
                        isCorrectIpFormat = false;
                    }
                    if (!isCorrectIpFormat) {
                        invalidValues.add(new InvalidValue(i18n.translateString("InvalidBsAuId"), RbSuBestBstAuParamsEntry.class, i18n.translateString("BsAuMask"), (Object)BsAuMask, (Object)this.panel.getAdvancedParamsPanel().getTxtBsAuMask()));
                    }
                }
                catch (NumberFormatException e) {
                    invalidValues.add(new InvalidValue(i18n.translateString("InvalidBsAuId"), RbSuBestBstAuParamsEntry.class, i18n.translateString("BsAuMask"), (Object)BsAuMask, (Object)this.panel.getAdvancedParamsPanel().getTxtBsAuMask()));
                }
            }
            task.getSuBestBstAuEntry().setRbSuConfiguredBstAuMask(strValue);
            strValue = null;
            String preferredBsAuId = this.panel.getAdvancedParamsPanel().getTxtPrefferedBsAuID().getText();
            if (preferredBsAuId != null && !preferredBsAuId.trim().equals("")) {
                try {
                    boolean isCorrectIpFormat = true;
                    if (preferredBsAuId.matches("(\\p{Digit}{1,3}\\.){5}(\\p{Digit}{1,3}){1}")) {
                        try {
                            strValue = OctetString.fromDottedDecimalForm((String)preferredBsAuId);
                        }
                        catch (NumberFormatException nfe) {
                            isCorrectIpFormat = false;
                        }
                    } else {
                        isCorrectIpFormat = false;
                    }
                    if (!isCorrectIpFormat) {
                        invalidValues.add(new InvalidValue(i18n.translateString("InvalidBsAuId"), RbSuBestBstAuParamsEntry.class, i18n.translateString("preferredBsAuID"), (Object)preferredBsAuId, (Object)this.panel.getAdvancedParamsPanel().getTxtPrefferedBsAuID()));
                    }
                }
                catch (NumberFormatException e) {
                    invalidValues.add(new InvalidValue(i18n.translateString("InvalidBsAuId"), RbSuBestBstAuParamsEntry.class, i18n.translateString("preferredBsAuID"), (Object)preferredBsAuId, (Object)this.panel.getAdvancedParamsPanel().getTxtPrefferedBsAuID()));
                }
            }
            task.getSuBestBstAuEntry().setRbSuConfiguredPreferredBstAuId(strValue);
            strValue = null;
            String preferredBsAuMask = this.panel.getAdvancedParamsPanel().getTxtPrefferedBsAuMask().getText();
            if (preferredBsAuMask != null && !preferredBsAuMask.trim().equals("")) {
                try {
                    boolean isCorrectIpFormat = true;
                    if (preferredBsAuMask.matches("(\\p{Digit}{1,3}\\.){5}(\\p{Digit}{1,3}){1}")) {
                        try {
                            strValue = OctetString.fromDottedDecimalForm((String)preferredBsAuMask);
                        }
                        catch (NumberFormatException nfe) {
                            isCorrectIpFormat = false;
                        }
                    } else {
                        isCorrectIpFormat = false;
                    }
                    if (!isCorrectIpFormat) {
                        invalidValues.add(new InvalidValue(i18n.translateString("InvalidBsAuId"), RbSuBestBstAuParamsEntry.class, i18n.translateString("preferredBsAuMask"), (Object)preferredBsAuMask, (Object)this.panel.getAdvancedParamsPanel().getTxtPrefferedBsAuMask()));
                    }
                }
                catch (NumberFormatException e) {
                    invalidValues.add(new InvalidValue(i18n.translateString("InvalidBsAuId"), RbSuBestBstAuParamsEntry.class, i18n.translateString("preferredBsAuMask"), (Object)preferredBsAuMask, (Object)this.panel.getAdvancedParamsPanel().getTxtPrefferedBsAuMask()));
                }
            }
            task.getSuBestBstAuEntry().setRbSuConfiguredPreferredBstAuMask(strValue);
            intValue = (Integer)FormUtil.getSelectedValue((JComboBox)this.panel.getAdvancedParamsPanel().getMobilityModeCmb());
            task.getSuBestBstAuEntry().setRbSuMobilityMode(intValue);
            strValue = null;
            String tempBSID = this.panel.getSuPanel().getCfgBaseStationID().getText();
            if (tempBSID != null && !tempBSID.trim().equals("")) {
                try {
                    boolean isCorrectIpFormat = true;
                    if (tempBSID.matches("(\\p{Digit}{1,3}\\.){5}(\\p{Digit}{1,3}){1}")) {
                        try {
                            strValue = OctetString.fromDottedDecimalForm((String)tempBSID);
                        }
                        catch (NumberFormatException nfe) {
                            isCorrectIpFormat = false;
                        }
                    } else {
                        isCorrectIpFormat = false;
                    }
                    if (!isCorrectIpFormat) {
                        invalidValues.add(new InvalidValue(i18n.translateString("InvalidBsId"), RbSuMACParametersGroup.class, i18n.translateString("BaseStationID"), (Object)tempBSID, (Object)this.panel.getSuPanel().getCfgBaseStationID()));
                    }
                }
                catch (NumberFormatException e) {
                    invalidValues.add(new InvalidValue(i18n.translateString("InvalidBsId"), RbSuMACParametersGroup.class, "", (Object)tempBSID, (Object)this.panel.getSuPanel().getCfgBaseStationID()));
                }
            }
            task.getSuMACParams().setRbSuConfiguredBaseStationId(strValue);
            strValue = null;
            String tempBSIDMask = this.panel.getSuPanel().getCfgBaseStationIDMask().getText();
            if (tempBSIDMask != null && !tempBSIDMask.trim().equals("")) {
                try {
                    boolean isCorrectIpFormat = true;
                    if (tempBSIDMask.matches("(\\p{Digit}{1,3}\\.){5}(\\p{Digit}{1,3}){1}")) {
                        try {
                            strValue = OctetString.fromDottedDecimalForm((String)tempBSIDMask);
                        }
                        catch (NumberFormatException nfe) {
                            isCorrectIpFormat = false;
                        }
                    } else {
                        isCorrectIpFormat = false;
                    }
                    if (!isCorrectIpFormat) {
                        invalidValues.add(new InvalidValue(i18n.translateString("InvalidBsIdMask"), RbSuMACParametersGroup.class, i18n.translateString("BaseStationIDMask"), (Object)tempBSIDMask, (Object)this.panel.getSuPanel().getCfgBaseStationIDMask()));
                    }
                }
                catch (NumberFormatException e) {
                    invalidValues.add(new InvalidValue(i18n.translateString("InvalidBsIdMask"), RbSuMACParametersGroup.class, "", (Object)tempBSIDMask, (Object)this.panel.getSuPanel().getCfgBaseStationIDMask()));
                }
            }
            task.getSuMACParams().setRbSuConfiguredBaseStationIdMask(strValue);
            String freqBands = (String)FormUtil.getSelectedValue((JComboBox)this.panel.getSuPanel().getComboFreqBands());
            task.setFreqBands(freqBands);
            intValue = (Integer)FormUtil.getSelectedValue((JComboBox)this.panel.getSuPanel().getCfgBandwidth());
            task.getSuPhyParams().setSuPhyConfiguredBandwidth(intValue);
            JTextField tempUplink = this.panel.getSuPanel().getCfgTxFrequency();
            if (tempUplink.getText() != null && !tempUplink.getText().trim().equals("")) {
                strValue = tempUplink.getText();
                Double value = null;
                boolean isNumberFormat = true;
                try {
                    value = Double.valueOf(tempUplink.getText()) * 1000.0;
                }
                catch (NumberFormatException e) {
                    invalidValues.add(new InvalidValue(i18n.translateString("InvalidTxFrequencyMultiple"), RbSuPhyParametersGroup.class, i18n.translateString("ConfigutedUplink(Tx)Frequency"), (Object)tempUplink.getText(), (Object)tempUplink));
                    isNumberFormat = false;
                }
                if (freqBands == null || intValue == null) {
                    invalidValues.add(new InvalidValue(i18n.translateString("MustSelectFreqBandsAndBandwith"), RbSuPhyParametersGroup.class, i18n.translateString("ConfigutedUplink(Tx)Frequency"), (Object)"", null));
                }
                if (freqBands != null && intValue != null && isNumberFormat) {
                    this.verifyMinMaxConfTxFrequency(freqBands, intValue, tempUplink.getText(), tempUplink, invalidValues, "ConfigutedUplink(Tx)Frequency");
                }
            }
            if (invalidValues.isEmpty()) {
                task.getSuPhyParams().setSuPhyConfiguredTxFrequencyChannel(tempUplink.getText());
                if (tempUplink.equals("")) {
                    task.getSuPhyParams().setSuPhyConfiguredTxFrequencyChannel(null);
                }
            }
            intValue = (Integer)FormUtil.getSelectedValue((JComboBox)this.panel.getGeneralParamsPanel().getComboDevicesLimitSupport());
            task.getSuBridgingParams().setRbSuSupportDevicesLimit(intValue);
            intValue = null;
            String tempMax = this.panel.getGeneralParamsPanel().getTextMaximumDevicesLimit().getText();
            if (tempMax != null && !tempMax.trim().equals("")) {
                Integer value = null;
                try {
                    value = Integer.parseInt(tempMax);
                    if (value <= 0 || value > 512) {
                        throw new NumberFormatException();
                    }
                    intValue = value;
                }
                catch (NumberFormatException e) {
                    invalidValues.add(new InvalidValue(i18n.translateString("InvalidMaxDevices"), RbSuBridgingParameters.class, "", (Object)tempMax, (Object)this.panel.getGeneralParamsPanel().getTextMaximumDevicesLimit()));
                }
            }
            task.getSuBridgingParams().setRbSuMaxNumberOfSupportedDevices(intValue);
            intValue = null;
            String tempAging = this.panel.getGeneralParamsPanel().getTextAgingTime().getText();
            if (tempAging != null && !tempAging.trim().equals("")) {
                Integer value = null;
                try {
                    value = Integer.parseInt(tempAging);
                    if (value <= 0 || value > 1440) {
                        throw new NumberFormatException();
                    }
                    intValue = value;
                }
                catch (NumberFormatException e) {
                    invalidValues.add(new InvalidValue(i18n.translateString("InvalidAgingTime"), RbSuBridgingParameters.class, "", (Object)tempAging, (Object)this.panel.getGeneralParamsPanel().getTextAgingTime()));
                }
            }
            task.getSuBridgingParams().setRbSuBridgeAgingTime(intValue);
            advancedFreqBands = (String)FormUtil.getSelectedValue((JComboBox)this.panel.getAdvancedParamsPanel().getComboFreqBands());
            task.setFreqBandsAdvanced(advancedFreqBands);
            intValue = (Integer)FormUtil.getSelectedValue((JComboBox)this.panel.getAdvancedParamsPanel().getComboAdvancedCfgBandwith());
            task.getSuFreqScanningEntry().setRbSuConfiguredBandwidth(intValue);
            bandwith = intValue;
            Double doubleEndFreq = null;
            JTextField endFreq = this.panel.getAdvancedParamsPanel().getTxtEndFreq();
            if (endFreq.getText() != null && !endFreq.getText().trim().equals("")) {
                boolean isNumberFormat = true;
                Double value = null;
                try {
                    doubleEndFreq = value = Double.valueOf(Double.parseDouble(endFreq.getText()));
                }
                catch (NumberFormatException e) {
                    invalidValues.add(new InvalidValue(i18n.translateString("InvalidFreq"), SuFrequencyScanningPanel402.class, i18n.translateString("stopFreq"), (Object)endFreq.getText(), (Object)endFreq));
                    isNumberFormat = false;
                }
                if ((advancedFreqBands == null || intValue == null) && isNumberFormat) {
                    invalidValues.add(new InvalidValue(i18n.translateString("MustSelectFreqBandsAndBandwith"), SuFrequencyScanningPanel402.class, i18n.translateString("stopFreq"), (Object)"", (Object)endFreq));
                }
                if (advancedFreqBands != null && intValue != null && isNumberFormat) {
                    this.verifyMinMaxConfTxFrequency(advancedFreqBands, intValue, endFreq.getText().toString(), endFreq, invalidValues, "stopFreq");
                }
            }
            if (invalidValues.isEmpty()) {
                if (doubleEndFreq != null) {
                    task.getSuFreqScanningEntry().setRbSuConfiguredScanEndFreq(doubleEndFreq.toString());
                } else {
                    task.getSuFreqScanningEntry().setRbSuConfiguredScanEndFreq(null);
                }
            }
            Double doubleValue = null;
            JTextField startFreq = this.panel.getAdvancedParamsPanel().getTxtStartFreq();
            if (startFreq.getText() != null && !startFreq.getText().trim().equals("")) {
                boolean isNumberFormat = true;
                Double value = null;
                try {
                    doubleValue = value = Double.valueOf(Double.parseDouble(startFreq.getText()));
                    if (doubleEndFreq != null && !doubleEndFreq.equals("") && doubleValue > doubleEndFreq) {
                        invalidValues.add(new InvalidValue(i18n.translateString("ScanningStartFrequencyBiggerThanScanningEndFrequency"), SuFrequencyScanningPanel402.class, i18n.translateString("startFreq"), (Object)startFreq.getText(), (Object)startFreq));
                    }
                }
                catch (NumberFormatException e) {
                    invalidValues.add(new InvalidValue(i18n.translateString("InvalidFreq"), SuFrequencyScanningPanel402.class, i18n.translateString("startFreq"), (Object)startFreq.getText(), (Object)startFreq));
                    isNumberFormat = false;
                }
                if ((advancedFreqBands == null || intValue == null) && isNumberFormat) {
                    invalidValues.add(new InvalidValue(i18n.translateString("MustSelectFreqBandsAndBandwith"), SuFrequencyScanningPanel402.class, i18n.translateString("startFreq"), (Object)"", (Object)startFreq));
                }
                if (advancedFreqBands != null && intValue != null && isNumberFormat) {
                    this.verifyMinMaxConfTxFrequency(advancedFreqBands, intValue, startFreq.getText().toString(), startFreq, invalidValues, "startFreq");
                }
            }
            if (invalidValues.isEmpty()) {
                if (doubleValue != null) {
                    task.getSuFreqScanningEntry().setRbSuConfiguredScanStartFreq(doubleValue.toString());
                } else {
                    task.getSuFreqScanningEntry().setRbSuConfiguredScanStartFreq(null);
                }
            }
            task.setConfigureScanIntermediateMask(this.panel.getAdvancedParamsPanel().getRadioConfigure().isSelected());
            task.getSuFreqScanningEntry().setRbSuConfiguredScanMask(null);
            if (this.panel.getAdvancedParamsPanel().getRadioConfigure().isSelected()) {
                int scanMask = 0;
                for (int i = 0; i < this.panel.getAdvancedParamsPanel().getChkRbSuConfiguredScanMask().size(); ++i) {
                    if (!this.panel.getAdvancedParamsPanel().getChkRbSuConfiguredScanMask().get(i).isSelected()) continue;
                    scanMask = (int)((double)scanMask + Math.pow(2.0, i));
                }
                StringBuilder scanMaskString = new StringBuilder(Integer.toHexString(scanMask));
                if (scanMaskString.length() < 2) {
                    scanMaskString.insert(0, '0');
                }
                task.getSuFreqScanningEntry().setRbSuConfiguredScanMask(scanMaskString.toString());
            }
            String mainStep = this.panel.getAdvancedParamsPanel().getTxtScanningMainStep().getText();
            double minStepValue = 125.0;
            double maxStepValue = 5000.0;
            if (mainStep != null && !mainStep.trim().equals("")) {
                try {
                    Double val = Double.parseDouble(mainStep);
                    int valueInKHz = val.intValue();
                    if (val != (double)valueInKHz || (double)valueInKHz < minStepValue || (double)valueInKHz > maxStepValue || valueInKHz % 125 != 0) {
                        throw new NumberFormatException();
                    }
                    int maxIntermediateStep = this.getMainStepScanningFrequency();
                    if (0 != maxIntermediateStep && maxIntermediateStep > valueInKHz) {
                        invalidValues.add(new InvalidValue(i18n.translateString("IntermediateStepGreaterThanMainStep"), SuFrequencyScanningPanel402.class, i18n.translateString("ScanningIntermediateStepMask"), (Object)maxIntermediateStep, (Object)mainStep));
                        task.getSuFreqScanningEntry().setRbSuConfiguredScanStep(null);
                        break block117;
                    }
                    Double d = val / 1000.0;
                    String stringValue = d - (double)d.intValue() == 0.0 ? String.format("%.0f", d) : String.format("%.3f", d);
                    task.getSuFreqScanningEntry().setRbSuConfiguredScanStep(stringValue);
                }
                catch (NumberFormatException e) {
                    invalidValues.add(new InvalidValue(i18n.translateString("InvalidStepFreq", new Object[]{String.valueOf(minStepValue), String.valueOf(maxStepValue)}), SuFrequencyScanningPanel402.class, i18n.translateString("stepFreq"), (Object)mainStep, (Object)this.panel.getAdvancedParamsPanel().getTxtScanningMainStep()));
                    task.getSuFreqScanningEntry().setRbSuConfiguredScanStep(null);
                }
            } else {
                task.getSuFreqScanningEntry().setRbSuConfiguredScanStep(null);
            }
        }
        Long licenseType = (Long)FormUtil.getSelectedValue((JComboBox)this.panel.getSuGeneralPanel().getComboLicense());
        task.getRbSuLicensesEntries().clear();
        if (null != licenseType) {
            RbSuLicensesEntry suLicenseEntry = new RbSuLicensesEntry();
            suLicenseEntry.setRbSuLicenseId(1);
            suLicenseEntry.setRbSuLicenseIdx(1);
            suLicenseEntry.setRbSuLicenseValue(licenseType);
            task.getRbSuLicensesEntries().add(suLicenseEntry);
        }
        boolean configureFreq = this.panel.getAdvancedParamsPanel().getRadioFreqConfigure().isSelected();
        task.setConfigureDiscreteFreq(configureFreq);
        RbSuFreqScanningEntry freqEntry = task.getSuFreqScanningEntry();
        SimpleRowTableModel freqTableModel = (SimpleRowTableModel)this.panel.getAdvancedParamsPanel().getTblDiscreteFreq().getModel();
        FormUtil.stopTableEditing((JTable)this.panel.getAdvancedParamsPanel().getTblDiscreteFreq());
        HashSet<String> frequnciesSet = new HashSet<String>();
        boolean isBandwithFreq = true;
        if (configureFreq) {
            if (bandwith == null) {
                invalidValues.add(new InvalidValue(i18n.translateString("MustSelectBandwith"), SuFrequencyScanningPanel402.class, i18n.translateString("DiscreteScanningFrequency"), (Object)"", null));
                isBandwithFreq = false;
            }
            if (advancedFreqBands == null) {
                invalidValues.add(new InvalidValue(i18n.translateString("MustSelectFrequencyBands"), SuFrequencyScanningPanel402.class, i18n.translateString("DiscreteScanningFrequency"), (Object)"", null));
                isBandwithFreq = false;
            }
            if (isBandwithFreq) {
                for (int i = 0; i < freqTableModel.getRowCount(); ++i) {
                    int k;
                    String frequency = String.valueOf(freqTableModel.getValueAt(i, 1)).trim();
                    if (!RbSUMultipleConfigTaskView.verifyDiscreteFrequency(invalidValues, frequency, String.valueOf(freqTableModel.getValueAt(i, 0)), bandwith, advancedFreqBands)) continue;
                    String[] scanfreq = new String[10];
                    if (freqTableModel.getRowState(i) == 0 || freqTableModel.getRowState(i) == 3) {
                        freqEntry.setRbSuConfiguredDiscreteF(frequency, Integer.valueOf(freqTableModel.getRowKey(i)));
                        if (configureFreq && !"0".equals(freqEntry.getRbSuConfiguredDiscreteF(i + 1)) && !frequnciesSet.add(freqEntry.getRbSuConfiguredDiscreteF(i + 1))) {
                            invalidValues.add(new InvalidValue(i18n.translateString("CantHaveTheSameFrequencyTwice"), RbSuFreqScanningEntry.class, i18n.translateString("DiscreteFrequency"), (Object)freqEntry.getRbSuConfiguredDiscreteF(i + 1), null));
                        }
                        for (k = 0; k < 10; ++k) {
                            scanfreq[k] = task.getSuFreqScanningEntry().getRbSuConfiguredDiscreteF(k + 1);
                        }
                        task.setScanningFreq(scanfreq);
                        continue;
                    }
                    if (freqTableModel.getRowState(i) != 1) continue;
                    freqEntry.setRbSuConfiguredDiscreteF("", Integer.valueOf(freqTableModel.getRowKey(i)));
                    for (k = 0; k < 10; ++k) {
                        scanfreq[k] = task.getSuFreqScanningEntry().getRbSuConfiguredDiscreteF(k + 1);
                    }
                    task.setScanningFreq(scanfreq);
                }
            }
        } else {
            freqEntry.setRbSuConfiguredDiscreteFrequenciesList(null);
        }
        if (this.panel.getAdvancedParamsPanel().getChkClearBSTTable().isSelected()) {
            task.setClearBSTTable(true);
        } else {
            task.setClearBSTTable(false);
        }
        if (this.panel.getAdvancedParamsPanel().getChkUpdateScanningTable().isSelected()) {
            task.setUpdateScanningTable(true);
        } else {
            task.setUpdateScanningTable(false);
        }
        if (this.panel.getAdvancedParamsPanel().getChkFullScan().isSelected()) {
            task.setFullScan(true);
        } else {
            task.setFullScan(false);
        }
        if (this.panel.getNpuCommandsPanel().getRadioNone().isSelected()) {
            task.setCommand(0);
        }
        if (this.panel.getNpuCommandsPanel().getRadioReset().isSelected()) {
            task.setCommand(1);
        }
        invalidValues.addAll(super.configureEntity((Serializable)entity));
        return invalidValues;
    }

    private static boolean verifyDiscreteFrequency(List<InvalidValue> invalidValues, String frequency, String row, Integer bandwith, String freqBands) {
        boolean valid = true;
        if (frequency == null || frequency.equals("null") || frequency.equals("0")) {
            return true;
        }
        Long startRxFreqLowerLimit = null;
        Long startRxFreqUpperLimit = null;
        Long freqBandStep = new Long(125L);
        if (freqBands != null) {
            if (freqBands.startsWith("2,3")) {
                startRxFreqLowerLimit = 2300000L;
                startRxFreqUpperLimit = 2360000L;
            } else if (freqBands.startsWith("2,5")) {
                startRxFreqLowerLimit = 2496000L;
                startRxFreqUpperLimit = 2690000L;
            } else if (freqBands.startsWith("3,5") || freqBands.startsWith("3,4")) {
                startRxFreqLowerLimit = 3399500L;
                startRxFreqUpperLimit = 3600000L;
            } else if (freqBands.startsWith("3,3")) {
                startRxFreqLowerLimit = 3300000L;
                startRxFreqUpperLimit = 3400000L;
            } else if (freqBands.startsWith("5,2")) {
                startRxFreqLowerLimit = 5152500L;
                startRxFreqUpperLimit = 5347500L;
            }
        }
        Double frequencyDouble = null;
        try {
            frequencyDouble = new Double(frequency) * 1000.0;
        }
        catch (NumberFormatException nfe) {
            invalidValues.add(new InvalidValue(i18n.translateString("DiscreteScanningFrequencyNotNumber", new Object[]{row}), RbSuFreqScanningEntry.class, i18n.translateString("DiscreteScanningFrequencies"), (Object)frequency, null));
            return false;
        }
        long frequencyLong = frequencyDouble.longValue();
        if (bandwith != null && freqBandStep != null && startRxFreqLowerLimit != null && startRxFreqUpperLimit != null) {
            double adjust = 0.0;
            switch (bandwith) {
                case 1: {
                    adjust = 0.875;
                    break;
                }
                case 2: {
                    adjust = 1.75;
                    break;
                }
                case 3: {
                    adjust = 2.5;
                    break;
                }
                case 4: {
                    adjust = 3.5;
                    break;
                }
                case 5: {
                    adjust = 5.0;
                }
            }
            long adjustLong = (long)(adjust * 1000.0);
            Long adjustedStartFreqLimit = startRxFreqLowerLimit + adjustLong;
            Long adjustedStopFreqLimit = startRxFreqUpperLimit - adjustLong;
            if (frequencyLong < adjustedStartFreqLimit || adjustedStopFreqLimit < frequencyLong || (frequencyLong - adjustedStartFreqLimit) % freqBandStep != 0L) {
                valid = false;
                invalidValues.add(new InvalidValue(i18n.translateString("ScanFrequencyValueBetween", new Object[]{adjustedStartFreqLimit.doubleValue() / 1000.0, adjustedStopFreqLimit.doubleValue() / 1000.0, freqBandStep.doubleValue() / 1000.0}), RbSuFreqScanningEntry.class, i18n.translateString("DiscreteScanningFrequencyAtRow", new Object[]{row}), (Object)((double)frequencyLong / 1000.0), null));
            }
        }
        return valid;
    }

    private void verifyMinMaxConfTxFrequency(String freqBands, Integer bandwith, String cfgTxFrequency, JTextField cfgTxFrequencyClass, List<InvalidValue> invalidValues, String paramName) {
        double adjust = 0.0;
        switch (bandwith) {
            case 1: {
                adjust = 0.875;
                break;
            }
            case 2: {
                adjust = 1.75;
                break;
            }
            case 3: {
                adjust = 2.5;
                break;
            }
            case 4: {
                adjust = 3.5;
                break;
            }
            case 5: {
                adjust = 5.0;
            }
        }
        long adjustLong = (long)(adjust * 1000.0);
        long startFreqLimit = 0L;
        long stopFreqLimit = 0L;
        int duplexSeparation = 0;
        long step = 125L;
        if (freqBands.equalsIgnoreCase("2,3")) {
            startFreqLimit = 2300000L;
            stopFreqLimit = 2360000L;
        } else if (freqBands.equalsIgnoreCase("2,5")) {
            startFreqLimit = 2496000L;
            stopFreqLimit = 2690000L;
        } else if (freqBands.equalsIgnoreCase("3,3(TDD)")) {
            startFreqLimit = 3300000L;
            stopFreqLimit = 3400000L;
        } else if (freqBands.equalsIgnoreCase("3,3(FDD)")) {
            startFreqLimit = 3316000L;
            stopFreqLimit = 3350000L;
            duplexSeparation = 50000;
        } else if (freqBands.equalsIgnoreCase("3,3G")) {
            startFreqLimit = 0x338380L;
            stopFreqLimit = 3400000L;
            duplexSeparation = -76000;
        } else if (freqBands.equalsIgnoreCase("3,5(FDD)")) {
            startFreqLimit = 3499500L;
            stopFreqLimit = 3600000L;
            duplexSeparation = -100000;
        } else if (freqBands.equalsIgnoreCase("3,5(TDD)")) {
            startFreqLimit = 3399500L;
            stopFreqLimit = 3600000L;
        } else if (freqBands.equalsIgnoreCase("3,6")) {
            startFreqLimit = 3700000L;
            stopFreqLimit = 3800000L;
            duplexSeparation = -100000;
        } else if (freqBands.equalsIgnoreCase("5,2")) {
            startFreqLimit = 5150000L;
            stopFreqLimit = 5350000L;
            step = 500L;
        }
        long startFreq = startFreqLimit + (long)duplexSeparation + adjustLong;
        long stopFreq = stopFreqLimit + (long)duplexSeparation - adjustLong;
        Double cfgTxFrequencyDouble = Double.valueOf(cfgTxFrequency) * 1000.0;
        if (cfgTxFrequencyDouble == null || cfgTxFrequencyDouble.longValue() < startFreq || cfgTxFrequencyDouble.longValue() > stopFreq || (cfgTxFrequencyDouble.longValue() - startFreq) % step != 0L) {
            invalidValues.add(new InvalidValue(i18n.translateString("SuTxFrequencyValueBetween", new Object[]{(double)startFreq / 1000.0, (double)stopFreq / 1000.0, (double)step / 1000.0}), RbSuPhyParametersGroup.class, i18n.translateString(paramName), (Object)cfgTxFrequency, (Object)cfgTxFrequencyClass));
        }
    }

    private static int countOctetItems(String tempBSIDMask) {
        StringTokenizer tokenizer = new StringTokenizer(tempBSIDMask, ".");
        int i = 0;
        while (tokenizer.hasMoreElements()) {
            ++i;
            tokenizer.nextElement();
        }
        return i;
    }

    private void loadEquipment(RbMultipleConfigTask task) {
        if (0L == task.getId()) {
            for (Equipment eq : task.getEquipments()) {
                RbSU su = (RbSU)eq;
                this.addEquipmentToModel(su, su.getManagerBS(), true);
            }
        } else {
            for (MultipleConfigWeakAssociation assoc : task.getManagedEntityWeakAssociation()) {
                RbSU su = (RbSU)((Object)assoc.getEntity());
                if (null != su) {
                    this.addEquipmentToModel(su, su.getManagerBS(), assoc.isSelected());
                    continue;
                }
                logger.debug((Object)("WeakAssociation with id " + assoc.getId() + " no longer points to anything"));
            }
        }
    }

    private boolean saveEquipment(RbSUMultipleConfigTask task) {
        boolean ret = false;
        List eqNodes = this.equipmentTreeTableModel.getNodes();
        ArrayList<MultipleConfigWeakAssociation> associations = new ArrayList<MultipleConfigWeakAssociation>(eqNodes.size());
        for (EqTreeNode eqNode : eqNodes) {
            EqTreeNodeValue eqValue = eqNode.getValue();
            if (!(eqValue.getEquipment() instanceof RbSU)) continue;
            MultipleConfigWeakAssociation assoc = new MultipleConfigWeakAssociation((ManagedEntity)eqValue.getEquipment(), eqValue.isSelected());
            associations.add(assoc);
            ret |= eqValue.isSelected();
        }
        task.setManagedEntityWeakAssociation(associations);
        return ret;
    }

    public String getApplicationPermission() {
        return "Av:ConfigureEquipment";
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.su_general_parameters";
    }

    private void actionAddSUSelection() {
        SelectorView selectorView = Selectors.getSelectorView(RbSU.class, null);
        SelectorUtil.displayModalSelector((JComponent)this.panel, (SelectorView)selectorView);
        List selection = selectorView.getSelection();
        if (!selection.isEmpty()) {
            for (RbSU su : selection) {
                this.addEquipmentToModel(su, su.getManagerBS(), true);
            }
        }
    }

    private void actionRemoveEquipment() {
        TreePath[] selectionPaths = this.panel.getTreeTableEquipment().getTree().getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length == 0) {
            return;
        }
        this.panel.getTreeTableEquipment().getTree().getCellEditor().stopCellEditing();
        for (TreePath selectionPath : selectionPaths) {
            EqTreeNode selNode = (EqTreeNode)selectionPath.getLastPathComponent();
            this.equipmentTreeTableModel.removeNode(selNode);
        }
    }

    private void addEquipmentToModel(Equipment equipment, RbBaseStationEquipment managerBS, boolean selected) {
        EqTreeNode eqNode = this.equipmentTreeTableModel.getNode(equipment);
        int equipmentType = RbSUMultipleConfigTaskView.getEquipmentType(equipment);
        if (eqNode != null) {
            this.equipmentTreeTableModel.updateNode(eqNode, equipment, equipmentType, selected);
            return;
        }
        if (managerBS == null) {
            logger.warn((Object)("Equipment with id = " + equipment.getId() + " of type " + equipment.getClass().getName() + " does not have a manager BS."));
            EqTreeNode rootNode = this.equipmentTreeTableModel.getRoot();
            eqNode = this.newEqTreeNode(rootNode, equipment, equipmentType, false, false);
            this.equipmentTreeTableModel.addNode(rootNode, eqNode);
        } else {
            EqTreeNode bsNode = this.equipmentTreeTableModel.getNode((Equipment)managerBS);
            if (bsNode == null) {
                EqTreeNode rootNode = this.equipmentTreeTableModel.getRoot();
                bsNode = this.newEqTreeNode(rootNode, managerBS, 1, false, false);
                this.equipmentTreeTableModel.addNode(rootNode, bsNode);
            }
            eqNode = this.newEqTreeNode(bsNode, equipment, equipmentType, true, selected);
            this.equipmentTreeTableModel.addNode(bsNode, eqNode);
        }
        this.makeNodeVisible((TreeNode)eqNode);
    }

    private static int getEquipmentType(Equipment equipment) {
        if (equipment instanceof RbBaseStationEquipment) {
            return 1;
        }
        if (equipment instanceof RbAU) {
            return 2;
        }
        if (equipment instanceof RbSU) {
            return 3;
        }
        return -1;
    }

    private EqTreeNode newEqTreeNode(EqTreeNode parentNode, Equipment equipment, int equipmentType, boolean selectable, boolean selected) {
        EqTreeNodeValue eqValue = new EqTreeNodeValue(equipment, equipment.getName(), equipmentType, selectable);
        eqValue.setSelected(selected);
        EqTreeNode eqNode = new EqTreeNode(parentNode, eqValue);
        return eqNode;
    }

    private void makeNodeVisible(TreeNode node) {
        TreePath nodePath;
        JTree tree = this.panel.getTreeTableEquipment().getTree();
        if (!tree.isVisible(nodePath = this.equipmentTreeTableModel.getTreePath(node))) {
            tree.makeVisible(nodePath);
        }
    }

    private int getMainStepScanningFrequency() {
        int maxIntermediateStep = 0;
        if (this.panel.getAdvancedParamsPanel().getChkCfg875KHz().isSelected()) {
            maxIntermediateStep = this.panel.getAdvancedParamsPanel().getChkCfg875KHz().getText().equals(i18n.translateString("+1250KHz")) ? 1250 : 875;
        } else if (this.panel.getAdvancedParamsPanel().getChkCfg750KHz().isSelected()) {
            maxIntermediateStep = 750;
        } else if (this.panel.getAdvancedParamsPanel().getChkCfg625KHz().isSelected()) {
            maxIntermediateStep = 625;
        } else if (this.panel.getAdvancedParamsPanel().getChkCfg500KHz().isSelected()) {
            maxIntermediateStep = 500;
        } else if (this.panel.getAdvancedParamsPanel().getChkCfg375KHz().isSelected()) {
            maxIntermediateStep = 375;
        } else if (this.panel.getAdvancedParamsPanel().getChkCfg250KHz().isSelected()) {
            maxIntermediateStep = 250;
        } else if (this.panel.getAdvancedParamsPanel().getChkCfg125KHz().isSelected()) {
            maxIntermediateStep = 125;
        }
        return maxIntermediateStep;
    }
}

