/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.multipleconfiguration;

import com.bwanms.command.NetworkElementCommand;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.mediation.MediationServiceRegistry;
import com.bwanms.mo.ManagedObject;
import com.bwanms.model.Equipment;
import com.bwanms.model.ManagedEntityBase;
import com.bwanms.model.MultipleConfigWeakAssociation;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.rb.command.RbSuClearBestBstAuData;
import com.bwanms.rb.command.RbSuCommand;
import com.bwanms.rb.command.RbSuRadioParametersCommand;
import com.bwanms.rb.mo.RbSuBestBstAuParamsEntry;
import com.bwanms.rb.mo.RbSuBridgingParameters;
import com.bwanms.rb.mo.RbSuFreqScanningEntry;
import com.bwanms.rb.mo.RbSuLicensesEntry;
import com.bwanms.rb.mo.RbSuLicensesTable;
import com.bwanms.rb.mo.RbSuMACParametersGroup;
import com.bwanms.rb.mo.RbSuPhyParametersGroup;
import com.bwanms.rb.mo.RbSuSystemEntry;
import com.bwanms.rb.model.RbSU;
import com.bwanms.rb.tasks.multipleconfiguration.RbMultipleConfigTask;
import com.bwanms.util.MacAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class RbSUMultipleConfigTask
extends RbMultipleConfigTask {
    public static final int COMMAND_NONE = 0;
    public static final int COMMAND_RESET = 1;
    private RbSuMACParametersGroup suMACParams;
    private RbSuPhyParametersGroup suPhyParams;
    private RbSuBridgingParameters suBridgingParams;
    private RbSuSystemEntry suSystemEntry;
    private RbSuBestBstAuParamsEntry suBestBstAuEntry;
    private RbSuFreqScanningEntry suFreqScanningEntry;
    private boolean configureScanIntermediateMask;
    private boolean configureDiscreteFreq;
    private String freqBands;
    private String freqBandsAdvanced;
    private List<RbSuLicensesEntry> rbSuLicensesEntries;
    private boolean updateScanningTable;
    private boolean fullScan;
    private boolean clearBSTTable;
    private String[] scanningFreq;
    private Set<Long> suSet;

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(table=@Table(name="RbSUMltplCfg_LicenseEntry"))
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<RbSuLicensesEntry> getRbSuLicensesEntries() {
        if (this.rbSuLicensesEntries == null) {
            this.rbSuLicensesEntries = new ArrayList<RbSuLicensesEntry>();
        }
        return this.rbSuLicensesEntries;
    }

    public void setRbSuLicensesEntries(List<RbSuLicensesEntry> rbSuLicensesEntries) {
        this.rbSuLicensesEntries = rbSuLicensesEntries;
    }

    @OneToOne(cascade={CascadeType.ALL})
    public RbSuBridgingParameters getSuBridgingParams() {
        if (null == this.suBridgingParams) {
            this.suBridgingParams = new RbSuBridgingParameters();
        }
        return this.suBridgingParams;
    }

    public void setSuBridgingParams(RbSuBridgingParameters suBridgingParams) {
        this.suBridgingParams = suBridgingParams;
    }

    @OneToOne(cascade={CascadeType.ALL})
    public RbSuFreqScanningEntry getSuFreqScanningEntry() {
        if (null == this.suFreqScanningEntry) {
            this.suFreqScanningEntry = new RbSuFreqScanningEntry();
        }
        return this.suFreqScanningEntry;
    }

    public void setSuFreqScanningEntry(RbSuFreqScanningEntry suFreqScanningEntry) {
        this.suFreqScanningEntry = suFreqScanningEntry;
    }

    @OneToOne(cascade={CascadeType.ALL})
    public RbSuMACParametersGroup getSuMACParams() {
        if (null == this.suMACParams) {
            this.suMACParams = new RbSuMACParametersGroup();
        }
        return this.suMACParams;
    }

    public void setSuMACParams(RbSuMACParametersGroup suMACParams) {
        this.suMACParams = suMACParams;
    }

    @OneToOne(cascade={CascadeType.ALL})
    public RbSuPhyParametersGroup getSuPhyParams() {
        if (null == this.suPhyParams) {
            this.suPhyParams = new RbSuPhyParametersGroup();
        }
        return this.suPhyParams;
    }

    public void setSuPhyParams(RbSuPhyParametersGroup suPhyParams) {
        this.suPhyParams = suPhyParams;
    }

    @OneToOne(cascade={CascadeType.ALL})
    public RbSuSystemEntry getSuSystemEntry() {
        if (null == this.suSystemEntry) {
            this.suSystemEntry = new RbSuSystemEntry();
        }
        return this.suSystemEntry;
    }

    public void setSuSystemEntry(RbSuSystemEntry suSystemEntry) {
        this.suSystemEntry = suSystemEntry;
    }

    @OneToOne(cascade={CascadeType.ALL})
    public RbSuBestBstAuParamsEntry getSuBestBstAuEntry() {
        if (null == this.suBestBstAuEntry) {
            this.suBestBstAuEntry = new RbSuBestBstAuParamsEntry();
        }
        return this.suBestBstAuEntry;
    }

    public void setSuBestBstAuEntry(RbSuBestBstAuParamsEntry suBestBstAuEntry) {
        this.suBestBstAuEntry = suBestBstAuEntry;
    }

    @Override
    @Transient
    protected List<ConfigFormManagedObjectRequest> getManagedObjectRequests(Equipment equipment) {
        this.checkInitSelectedMaps();
        RbSU su = (RbSU)equipment;
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        if (this.suSet.contains(equipment.getId())) {
            if (!su.getManagerBS().isIPCSSwitchingMode()) {
                ret.add(this.createRequest(su.getId(), "SU", RbSuMACParametersGroup.class));
                ret.add(this.createRequest(su.getId(), "SU", RbSuPhyParametersGroup.class));
            }
            ret.add(this.createRequest(su.getId(), "SU", RbSuBridgingParameters.class));
            ret.add(this.createRequest(su.getId(), "SU", RbSuSystemEntry.class));
            if (su.getManagerBS().isTDDDuplexMode()) {
                ret.add(this.createRequest(su.getId(), "SU", RbSuBestBstAuParamsEntry.class));
                ret.add(this.createRequest(su.getId(), "SU", RbSuFreqScanningEntry.class));
            }
            ret.add(this.createRequest(su.getId(), "SU", RbSuLicensesTable.class));
        }
        return ret;
    }

    @Override
    @Transient
    protected List<ManagedObject> getValueObjectMOs(Equipment equipment) {
        ArrayList<ManagedObject> suManagedObjects = new ArrayList<ManagedObject>(4);
        RbSU su = (RbSU)equipment;
        if (!su.getManagerBS().isIPCSSwitchingMode()) {
            suManagedObjects.add((ManagedObject)this.getSuMACParams());
            suManagedObjects.add((ManagedObject)this.getSuPhyParams());
        }
        suManagedObjects.add((ManagedObject)this.getSuBridgingParams());
        suManagedObjects.add((ManagedObject)this.getSuSystemEntry());
        if (su.getManagerBS().isTDDDuplexMode()) {
            suManagedObjects.add((ManagedObject)this.getSuBestBstAuEntry());
            suManagedObjects.add((ManagedObject)this.getSuFreqScanningEntry());
        }
        MacAddress suMacAddress = MacAddress.fromSimpleString((String)su.getMacAddress());
        for (RbSuLicensesEntry suLicenseEntry : this.getRbSuLicensesEntries()) {
            suLicenseEntry.setRbSuMacAddr(suMacAddress.toOctetString());
        }
        suManagedObjects.add((ManagedObject)new RbSuLicensesTable(this.getRbSuLicensesEntries()));
        return suManagedObjects;
    }

    @Override
    protected boolean shouldProcessEquipment(Equipment nextEquipment) {
        this.checkInitSelectedMaps();
        return this.suSet.contains(nextEquipment.getId());
    }

    @Override
    protected String sendCommand(Equipment equipment) {
        String errorString;
        RbSuCommand eqCommand = null;
        RbSU su = (RbSU)equipment;
        if (su != null) {
            switch (this.getCommand()) {
                case 1: {
                    eqCommand = su.createResetCommand();
                }
            }
        }
        if (su.getOperationMode().equals(2)) {
            Object command;
            if (this.isClearBSTTable()) {
                command = new RbSuClearBestBstAuData();
                ((RbSuClearBestBstAuData)command).setRbSuClearBestBstAuData(2);
                ((RbSuClearBestBstAuData)command).setEquipmentId(su.getId());
                ((RbSuClearBestBstAuData)command).setRbSuMacAddr(MacAddress.fromSimpleString((String)su.getMacAddress()).toOctetString());
                errorString = this.commandExecutor((NetworkElementCommand)command, su);
                if (errorString != null) {
                    return "ClearBST/AUTableFailed";
                }
            }
            if (this.isUpdateScanningTable() && (errorString = this.commandExecutor((NetworkElementCommand)(command = this.createFrequencyCommand(3, su)), su)) != null) {
                return "DiscreteScanningFrequenciesUpdateScanningTableFailed";
            }
            if (this.isFullScan() && (errorString = this.commandExecutor((NetworkElementCommand)(command = this.createFrequencyCommand(2, su)), su)) != null) {
                return "DiscreteScanningFrequenciesFullScanFailed";
            }
        }
        if ((errorString = this.commandExecutor(eqCommand, su)) != null) {
            return "SUCouldNotReset";
        }
        return null;
    }

    private RbSuRadioParametersCommand createFrequencyCommand(int param, RbSU su) {
        RbSuRadioParametersCommand command = new RbSuRadioParametersCommand();
        command.setEquipmentId(su.getId());
        command.setRbSuMacAddr(MacAddress.fromSimpleString((String)su.getMacAddress()).toOctetString());
        command.setRbSuRadioParametersCommand(param);
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String commandExecutor(NetworkElementCommand command, RbSU su) {
        if (command != null) {
            MOAccessSession snmpAccess = null;
            try {
                snmpAccess = this.createMOAccessSession(su);
                snmpAccess.commitObject(null, (Object)command);
                String string = null;
                return string;
            }
            catch (MediationException e) {
                e.printStackTrace();
                String string = new String("");
                return string;
            }
            finally {
                this.closeMOAccessSession(snmpAccess);
            }
        }
        return null;
    }

    protected MOAccessSession createMOAccessSession(RbSU equipment) throws MediationException {
        return MediationServiceRegistry.getMOSession((SNMPManagementInterface)equipment.getManagementInterface(), null);
    }

    private void checkInitSelectedMaps() {
        if (null == this.suSet) {
            this.suSet = new TreeSet<Long>();
            for (MultipleConfigWeakAssociation mcWA : this.getManagedEntityWeakAssociation()) {
                ManagedEntityBase me = mcWA.getManagedEntity();
                if (null == me || !mcWA.isSelected()) continue;
                this.suSet.add(me.getId());
            }
        }
    }

    @Override
    protected boolean isTableRemoveOperation(Class clazz) {
        return false;
    }

    @Override
    protected boolean isForceRefresh(Class clazz) {
        return RbSuLicensesTable.class.equals((Object)clazz);
    }

    public boolean isConfigureScanIntermediateMask() {
        return this.configureScanIntermediateMask;
    }

    public void setConfigureScanIntermediateMask(boolean configureScanIntermediateMask) {
        this.configureScanIntermediateMask = configureScanIntermediateMask;
    }

    public String getFreqBands() {
        return this.freqBands;
    }

    public void setFreqBands(String freqBands) {
        this.freqBands = freqBands;
    }

    public String getFreqBandsAdvanced() {
        return this.freqBandsAdvanced;
    }

    public void setFreqBandsAdvanced(String freqBandsAdvanced) {
        this.freqBandsAdvanced = freqBandsAdvanced;
    }

    public boolean isFullScan() {
        return this.fullScan;
    }

    public void setFullScan(boolean fullScan) {
        this.fullScan = fullScan;
    }

    public boolean isUpdateScanningTable() {
        return this.updateScanningTable;
    }

    public void setUpdateScanningTable(boolean updateScanningTable) {
        this.updateScanningTable = updateScanningTable;
    }

    public boolean isConfigureDiscreteFreq() {
        return this.configureDiscreteFreq;
    }

    public void setConfigureDiscreteFreq(boolean configureDiscreteFreq) {
        this.configureDiscreteFreq = configureDiscreteFreq;
    }

    public String[] getScanningFreq() {
        return this.scanningFreq;
    }

    public void setScanningFreq(String[] scanningFreq) {
        this.scanningFreq = scanningFreq;
    }

    public boolean isClearBSTTable() {
        return this.clearBSTTable;
    }

    public void setClearBSTTable(boolean clearBSTTable) {
        this.clearBSTTable = clearBSTTable;
    }
}

