/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.multipleconfiguration;

import com.bwanms.domain.logic.Helpers;
import com.bwanms.domain.logic.LicenseHelper;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.mo.AbstractTableMO;
import com.bwanms.mo.MOUtils;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.TableRowMO;
import com.bwanms.model.Equipment;
import com.bwanms.model.MultipleConfigTask;
import com.bwanms.model.TaskExecutionContext;
import com.bwanms.model.TaskExecutor;
import com.bwanms.model.TaskRuntimeStatus;
import com.bwanms.persistence.CallableDatastoreDecorator;
import com.bwanms.persistence.RunnableDatastoreDecorator;
import com.bwanms.rb.mo.RbAuMultirateParameters;
import com.bwanms.rb.mo.RbAuthorizedManagersEntry;
import com.bwanms.rb.mo.RbBSPFServersEntry;
import com.bwanms.rb.mo.RbBSPFServersTable;
import com.bwanms.rb.mo.RbBsRadioParameters;
import com.bwanms.rb.mo.services.RbServiceGroupEntry;
import com.bwanms.rb.mo.services.RbServiceGroupTable;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigEntry;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigTable;
import com.bwanms.rb.mo.services.RbVoiceDomainsEntry;
import com.bwanms.rb.mo.services.RbVoiceDomainsTable;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbSU;
import com.bwanms.rb.tasks.multipleconfiguration.RbBSMultipleConfigTask;
import com.bwanms.rb.util.RbFeatures;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.util.BeanUtils;
import com.bwanms.util.concurrent.AsyncItemsExecutor;
import com.bwanms.util.concurrent.AsyncItemsProvider;
import com.bwanms.util.task.Operation;
import com.bwanms.util.task.OperationStatus;
import com.bwanms.util.task.OperationTaskRuntimeStatus;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public abstract class RbMultipleConfigTask
extends MultipleConfigTask {
    private static final Logger log = Logger.getLogger(RbMultipleConfigTask.class);
    private int command;

    public TaskExecutor createExecutor() {
        return new RbMultipleConfigTaskExecutor(this);
    }

    public void setCommand(int command) {
        this.command = command;
    }

    public int getCommand() {
        return this.command;
    }

    protected abstract boolean shouldProcessEquipment(Equipment var1);

    @Transient
    protected abstract List<ConfigFormManagedObjectRequest> getManagedObjectRequests(Equipment var1);

    @Transient
    protected abstract List<ManagedObject> getValueObjectMOs(Equipment var1);

    @Transient
    protected abstract String sendCommand(Equipment var1);

    @Transient
    protected abstract boolean isTableRemoveOperation(Class var1);

    @Transient
    protected boolean isForceRefresh(Class clazz) {
        return false;
    }

    protected ConfigFormManagedObjectRequest createRequest(long id, String networkResourceName, Class<? extends ManagedObject> moClass) {
        return new ConfigFormManagedObjectRequest(id, networkResourceName, moClass);
    }

    private static List findInManagedObjects(List<ManagedObject> newManagedObjects, Class clss) {
        ArrayList<ManagedObject> ret = new ArrayList<ManagedObject>();
        for (ManagedObject mo : newManagedObjects) {
            if (!mo.getClass().isAssignableFrom(clss)) continue;
            ret.add(mo);
        }
        return ret;
    }

    protected void closeMOAccessSession(MOAccessSession access) {
        if (access != null) {
            try {
                access.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class RbMultipleConfigTaskExecutor
    implements TaskExecutor {
        private HashMap<Long, Operation> operationMap = new HashMap();
        private RbMultipleConfigTask taskContext;
        private OperationTaskRuntimeStatus runtimeStatus;
        private Operation rootOperation;
        private TaskExecutionContext ctx;
        private boolean taskFailed;
        private boolean taskCompletedWithErrors;
        private Long startTime = null;

        public RbMultipleConfigTaskExecutor(RbMultipleConfigTask task) {
            this.taskContext = task;
            this.taskFailed = false;
            this.taskCompletedWithErrors = false;
            this.runtimeStatus = new OperationTaskRuntimeStatus();
            this.rootOperation = this.runtimeStatus.addOperation(null, "RbMultipleConfigTaskName", new Object[]{task.getName()});
        }

        public void execute(TaskExecutionContext ctx) {
            this.ctx = ctx;
            ArrayList<Equipment> markedEquipments = new ArrayList<Equipment>();
            for (Equipment tmp : this.taskContext.getEquipments()) {
                if (!this.taskContext.shouldProcessEquipment(tmp)) continue;
                markedEquipments.add(tmp);
            }
            if (markedEquipments.size() == 0) {
                this.logStatus(null, OperationStatus.FAILED, "NoEquipmentFound");
                ctx.taskFinished();
                return;
            }
            AsyncItemsProvider<? extends Runnable> itemProvider = this.taskContext instanceof RbBSMultipleConfigTask ? this.createBSAsyncItemProvider(markedEquipments) : this.createSUAsyncItemProvider(markedEquipments);
            AsyncItemsExecutor itemsExecutor = new AsyncItemsExecutor(itemProvider);
            this.logStatus(null, OperationStatus.IN_PROGRESS, null);
            itemsExecutor.executeItems();
            if (ctx.shouldAbort()) {
                this.logStatus(null, OperationStatus.ABORTED, null);
            } else if (this.taskCompletedWithErrors) {
                this.logStatus(null, OperationStatus.COMPLETED_WITH_ERRORS, null);
            } else {
                this.logStatus(null, OperationStatus.COMPLETED, null);
            }
            ctx.taskFinished();
        }

        protected AsyncItemsProvider<? extends Runnable> createBSAsyncItemProvider(List<Equipment> markedEquipments) {
            final Iterator<Equipment> equipments = markedEquipments.iterator();
            return new AsyncItemsProvider<Runnable>(){

                public boolean shouldAbort() {
                    return RbMultipleConfigTaskExecutor.this.shouldAbortTask();
                }

                public void itemFinished(Runnable item) {
                }

                public void itemStarting(Runnable item) {
                }

                public boolean hasNext() {
                    return equipments.hasNext();
                }

                public Runnable next() {
                    Equipment nextEquipment = (Equipment)equipments.next();
                    if (null == nextEquipment) {
                        return null;
                    }
                    if (RbMultipleConfigTaskExecutor.this.startTime == null) {
                        RbMultipleConfigTaskExecutor.this.startTime = new Date().getTime();
                    }
                    return new RbConfigParamsCommandTaskItem(nextEquipment);
                }

                public void remove() {
                    throw new UnsupportedOperationException("Remove Not Implemented!");
                }
            };
        }

        protected AsyncItemsProvider<? extends Runnable> createSUAsyncItemProvider(List<Equipment> markedEquipments) {
            HashMap<Long, ArrayList<RbSU>> equipmentMap = new HashMap<Long, ArrayList<RbSU>>();
            for (Equipment eq : markedEquipments) {
                RbSU su = (RbSU)eq;
                RbBaseStationEquipment bs = su.getManagerBS();
                long bsId = null != bs ? bs.getId() : 0L;
                ArrayList<RbSU> sus = (ArrayList<RbSU>)equipmentMap.get(bsId);
                if (null == sus) {
                    sus = new ArrayList<RbSU>();
                    equipmentMap.put(bsId, sus);
                }
                sus.add(su);
            }
            final Iterator equipments = equipmentMap.values().iterator();
            return new AsyncItemsProvider<Runnable>(){

                public boolean shouldAbort() {
                    return RbMultipleConfigTaskExecutor.this.shouldAbortTask();
                }

                public void itemFinished(Runnable item) {
                }

                public void itemStarting(Runnable item) {
                }

                public boolean hasNext() {
                    return equipments.hasNext();
                }

                public Runnable next() {
                    List nextEquipment = (List)equipments.next();
                    if (null == nextEquipment) {
                        return null;
                    }
                    return new RbConfigParamsCommandTaskItem(nextEquipment);
                }

                public void remove() {
                    throw new UnsupportedOperationException("Remove Not Implemented!");
                }
            };
        }

        protected boolean shouldAbortTask() {
            return this.ctx.shouldAbort();
        }

        private synchronized void logStatus(Equipment equipment, OperationStatus status, String message) {
            if (status == OperationStatus.COMPLETED_WITH_ERRORS) {
                this.taskCompletedWithErrors = true;
            } else if (status == OperationStatus.FAILED) {
                this.taskFailed = true;
            }
            if (null != equipment) {
                Operation eqOp = this.operationMap.get(equipment.getId());
                if (null == eqOp) {
                    eqOp = this.runtimeStatus.addOperation(this.rootOperation, "Configure", new Object[]{equipment.getName() + "/" + equipment.getEUID()});
                    this.operationMap.put(equipment.getId(), eqOp);
                } else {
                    this.runtimeStatus.logOperationStatus(eqOp, status, (Serializable)((Object)message));
                }
            } else {
                this.runtimeStatus.logOperationStatus(this.rootOperation, status, (Serializable)((Object)message));
            }
        }

        public TaskRuntimeStatus getStatus(Object clientData) {
            Integer idx = null != clientData ? (Integer)clientData : 0;
            return this.runtimeStatus.getDiff(idx.intValue());
        }

        public String getReport() {
            return this.runtimeStatus.toXMLString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runEquipment(final Equipment equipment) {
            block70: {
                if (equipment.getFirmwareVersion() == null || !Integer.valueOf(0).equals(equipment.getState())) {
                    this.logStatus(equipment, OperationStatus.SKIPPED, "UnreachableBS");
                    return;
                }
                boolean licensed = false;
                try {
                    licensed = (Boolean)new CallableDatastoreDecorator((Callable)new Callable<Boolean>(){

                        @Override
                        public Boolean call() {
                            return LicenseHelper.isLicensed((Object)equipment);
                        }
                    }).call();
                }
                catch (Exception e) {
                    if (!licensed) {
                        this.logStatus(equipment, OperationStatus.SKIPPED, "UnlicensedBS");
                        return;
                    }
                }
                finally {
                    if (!licensed) {
                        this.logStatus(equipment, OperationStatus.SKIPPED, "UnlicensedBS");
                        return;
                    }
                }
                HashMap<String, String> errorOcurredMap = new HashMap<String, String>();
                HashMap<String, String[]> errorOcurredMapCustom = new HashMap<String, String[]>();
                try {
                    this.logStatus(equipment, OperationStatus.IN_PROGRESS, null);
                    final ArrayList managedObjects = new ArrayList();
                    List<ConfigFormManagedObjectRequest> requests = this.taskContext.getManagedObjectRequests(equipment);
                    for (ConfigFormManagedObjectRequest request : requests) {
                        if (this.shouldAbortTask()) {
                            this.logStatus(equipment, OperationStatus.ABORTED, null);
                            return;
                        }
                        final ConfigFormManagedObjectRequest req = request;
                        new RunnableDatastoreDecorator(new Runnable(){

                            public void run() {
                                try {
                                    log.info((Object)("Retrieving " + req.getNetworkResource() + " " + req.getMoClass().getName() + " for " + equipment.getClass().getName()));
                                    managedObjects.addAll(Helpers.getConfigurationHelper().retrieveCurrentConfiguration(equipment.getId(), req.getNetworkResource(), req.getMoClass(), RbMultipleConfigTaskExecutor.this.taskContext.isForceRefresh(req.getMoClass())));
                                }
                                catch (MediationException ex) {
                                    throw new RuntimeException(ex);
                                }
                            }
                        }).run();
                    }
                    ArrayList<ManagedObject> newManagedObjects = new ArrayList<ManagedObject>();
                    for (ManagedObject mo : managedObjects) {
                        ManagedObject newMO = mo.clone();
                        newManagedObjects.add(newMO);
                    }
                    for (ManagedObject managedObject : this.taskContext.getValueObjectMOs(equipment)) {
                        if (this.shouldAbortTask()) {
                            this.logStatus(equipment, OperationStatus.ABORTED, null);
                            return;
                        }
                        List parameters = RbMultipleConfigTask.findInManagedObjects(newManagedObjects, managedObject.getClass());
                        for (ManagedObject temp : parameters) {
                            RbBsRadioParameters rbBsRadioParameters;
                            if (temp instanceof AbstractTableMO) {
                                AbstractTableMO table = (AbstractTableMO)temp;
                                AbstractTableMO moTable = (AbstractTableMO)managedObject;
                                if (this.taskContext.isTableRemoveOperation(table.getClass())) {
                                    for (TableRowMO row : moTable.getEntries()) {
                                        TableRowMO entry = table.findEntry(row.getRowKey());
                                        if (null == entry) continue;
                                        table.removeEntry(entry.getRowKey());
                                    }
                                    continue;
                                }
                                for (TableRowMO row : moTable.getEntries()) {
                                    TableRowMO entry = table.findEntry(row.getRowKey());
                                    if (null != entry) {
                                        BeanUtils.copyNotNullSNMPProperties((Object)row, (Object)entry);
                                        continue;
                                    }
                                    entry = (TableRowMO)MOUtils.createMO(row.getClass());
                                    BeanUtils.copyNotNullSNMPProperties((Object)row, (Object)entry);
                                    if (row instanceof RbAuthorizedManagersEntry && table.getSize() == 10) {
                                        errorOcurredMap.put("MaxNrOfAuthorizedManagers", null);
                                        continue;
                                    }
                                    table.addEntry(entry);
                                }
                                continue;
                            }
                            if (equipment instanceof RbBaseStationEquipment && managedObject instanceof RbAuMultirateParameters && RbVersions.V_4_1_1.isOlderThan(((RbBaseStationEquipment)equipment).getSoftwareVersion())) {
                                if (Integer.valueOf(2).equals(((RbAuMultirateParameters)managedObject).getRbAuUlBasicRate())) {
                                    errorOcurredMap.put("AuMultirateParameters", "AuUlBasicRateBPSK34On41");
                                    continue;
                                }
                                if (Integer.valueOf(2).equals(((RbAuMultirateParameters)managedObject).getRbAuDlBasicRate())) {
                                    errorOcurredMap.put("AuMultirateParameters", "AuDlBasicRateBPSK34On41");
                                    continue;
                                }
                            }
                            if (managedObject instanceof RbBsRadioParameters && RbVersions.V_3_5.isOlderOrEqualWith(((RbBaseStationEquipment)equipment).getSoftwareVersion()) && RbVersions.V_4_0.isNewerThan(((RbBaseStationEquipment)equipment).getSoftwareVersion()) && (rbBsRadioParameters = (RbBsRadioParameters)managedObject).getRbLocalClockDateAndTime() != null) {
                                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                                simpleDateFormat.setLenient(false);
                                long deltaTime = new Date().getTime() - this.startTime;
                                long delayedTime = simpleDateFormat.parse(rbBsRadioParameters.getRbLocalClockDateAndTime()).getTime() + deltaTime;
                                rbBsRadioParameters.setRbLocalClockDateAndTime(simpleDateFormat.format(new Date(delayedTime)));
                            }
                            BeanUtils.copyNotNullSNMPProperties((Object)managedObject, (Object)temp);
                        }
                    }
                    final HashMap errorOcurredMapTemp = new HashMap();
                    if (this.taskContext instanceof RbBSMultipleConfigTask) {
                        RbBSMultipleConfigTask task;
                        List<RbServiceGroupEntry> serviceGroupTaskEntries;
                        RbBSMultipleConfigTask taskSG;
                        RbBaseStationEquipment bsEquip = (RbBaseStationEquipment)equipment;
                        if (equipment instanceof RbBaseStationEquipment && this.taskContext instanceof RbBSMultipleConfigTask && RbFeatures.isServiceGroupAvailable(bsEquip)) {
                            taskSG = (RbBSMultipleConfigTask)this.taskContext;
                            if (this.shouldAbortTask()) {
                                this.logStatus(equipment, OperationStatus.ABORTED, null);
                                return;
                            }
                            serviceGroupTaskEntries = taskSG.getBsServiceGroupEntries();
                            final ArrayList serviceGroupTableList = new ArrayList();
                            new RunnableDatastoreDecorator(new Runnable(){

                                public void run() {
                                    try {
                                        log.info((Object)("Retrieving BS " + RbServiceGroupTable.class.getName() + " for " + equipment.getClass().getName()));
                                        serviceGroupTableList.addAll(Helpers.getConfigurationHelper().retrieveCurrentConfiguration(equipment.getId(), "BS", RbServiceGroupTable.class, "*", false));
                                    }
                                    catch (MediationException ex) {
                                        log.warn((Object)("Error on retrieving Service Group from " + equipment.getIpAddr()), (Throwable)ex);
                                        errorOcurredMapTemp.put("ServiceGroup", "ErrorRetrievingSG");
                                    }
                                }
                            }).run();
                            RbServiceGroupTable sgTable = (RbServiceGroupTable)((Object)serviceGroupTableList.get(0));
                            if (taskSG.isServiceGroupToInsert()) {
                                this.insertServiceGroups(errorOcurredMapCustom, newManagedObjects, serviceGroupTaskEntries, sgTable);
                            } else {
                                final ArrayList serviceProfileTableList = new ArrayList();
                                new RunnableDatastoreDecorator(new Runnable(){

                                    public void run() {
                                        try {
                                            log.info((Object)("Retrieving BS " + RbServiceTemplateConfigTable.class.getName() + " for " + equipment.getClass().getName()));
                                            serviceProfileTableList.addAll(Helpers.getConfigurationHelper().retrieveCurrentConfiguration(equipment.getId(), "BS", RbServiceTemplateConfigTable.class, "*", false));
                                        }
                                        catch (MediationException ex) {
                                            log.warn((Object)("Error on retrieving Service Profile from " + equipment.getIpAddr()), (Throwable)ex);
                                            errorOcurredMapTemp.put("ServiceGroup", "ErrorRetrievingSP");
                                        }
                                    }
                                }).run();
                                RbServiceTemplateConfigTable spTable = (RbServiceTemplateConfigTable)((Object)serviceProfileTableList.get(0));
                                this.removeServiceGroups(errorOcurredMapCustom, newManagedObjects, serviceGroupTaskEntries, sgTable, spTable);
                            }
                        } else {
                            taskSG = (RbBSMultipleConfigTask)this.taskContext;
                            serviceGroupTaskEntries = taskSG.getBsServiceGroupEntries();
                            if (serviceGroupTaskEntries.size() > 0) {
                                errorOcurredMap.put("ServiceGroup", "ServiceGroupNotAvailableForThisEquipment");
                            }
                        }
                        RbBSMultipleConfigTask taskVD = (RbBSMultipleConfigTask)this.taskContext;
                        if (equipment instanceof RbBaseStationEquipment && this.taskContext instanceof RbBSMultipleConfigTask && ((task = (RbBSMultipleConfigTask)this.taskContext).getVoiceDomainName() != null && task.getVoiceDomainName().length() > 0 || task.getPfServerIPAddress() != null && task.getPfServerIPAddress().length() > 0)) {
                            if (RbFeatures.isSipAwareAvailable(bsEquip)) {
                                String voiceDomainName;
                                final ArrayList pfServerTableList = new ArrayList();
                                if (this.shouldAbortTask()) {
                                    this.logStatus(equipment, OperationStatus.ABORTED, null);
                                    return;
                                }
                                new RunnableDatastoreDecorator(new Runnable(){

                                    public void run() {
                                        try {
                                            log.info((Object)("Retrieving BS " + RbBSPFServersTable.class.getName() + " for " + equipment.getClass().getName()));
                                            pfServerTableList.addAll(Helpers.getConfigurationHelper().retrieveCurrentConfiguration(equipment.getId(), "BS", RbBSPFServersTable.class, "*", false));
                                        }
                                        catch (MediationException ex) {
                                            log.warn((Object)("Error on retrieving PF Servers from " + equipment.getIpAddr()), (Throwable)ex);
                                            errorOcurredMapTemp.put("ServiceGroup", "ErrorRetrievingPF");
                                        }
                                    }
                                }).run();
                                RbBSPFServersTable pfServersTable = (RbBSPFServersTable)((Object)pfServerTableList.get(0));
                                RbBSPFServersEntry bsPFServerEntry = null;
                                for (RbBSPFServersEntry rbBSPFServersEntry : pfServersTable.getEntries()) {
                                    if (!rbBSPFServersEntry.getRbBSPFServerAddress().equals(taskVD.getPfServerIPAddress())) continue;
                                    bsPFServerEntry = rbBSPFServersEntry;
                                    break;
                                }
                                boolean pfServerErrors = false;
                                if (bsPFServerEntry == null) {
                                    int pfLimit;
                                    int n = pfLimit = RbFeatures.isNewLimitInVD(bsEquip) ? 10 : 20;
                                    if (pfServersTable.getEntries().size() < pfLimit) {
                                        bsPFServerEntry = new RbBSPFServersEntry();
                                        bsPFServerEntry.setRbBSPFServerAddress(taskVD.getPfServerIPAddress());
                                        pfServersTable.addEntry((TableRowMO)bsPFServerEntry);
                                    } else {
                                        errorOcurredMap.put("PFServer", "MaxNumberOfPFServersReached");
                                        pfServerErrors = true;
                                    }
                                }
                                if (bsPFServerEntry != null) {
                                    if (RbVersions.V_4_5.isSupersetOf(bsEquip.getSoftwareVersion()) && bsEquip.getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_IP_CS) {
                                        if (taskVD.getPfAdoptDataPort() == 1) {
                                            bsPFServerEntry.setRbBSPFServerPortNumber(taskVD.getPfServerUdpPort());
                                            bsPFServerEntry.setRbBSPFServerSharedString(taskVD.getPfServerSharedSecret());
                                            bsPFServerEntry.setRbPFServerDataPortAdopt(taskVD.getPfAdoptDataPort());
                                            bsPFServerEntry.setRbBSPFServerPFVlan(null);
                                            bsPFServerEntry.setRbPFServerGateway(null);
                                            bsPFServerEntry.setRbPFServerIfcIpAddress(null);
                                            bsPFServerEntry.setRbPFServerIfcSubnetMask(null);
                                        } else {
                                            bsPFServerEntry.setRbBSPFServerPortNumber(taskVD.getPfServerUdpPort());
                                            bsPFServerEntry.setRbBSPFServerPFVlan(taskVD.getPfServerVlanId());
                                            bsPFServerEntry.setRbBSPFServerSharedString(taskVD.getPfServerSharedSecret());
                                            bsPFServerEntry.setRbPFServerDataPortAdopt(taskVD.getPfAdoptDataPort());
                                            bsPFServerEntry.setRbPFServerGateway(taskVD.getPfDomainGateway());
                                            bsPFServerEntry.setRbPFServerIfcIpAddress(taskVD.getPfDomainIpAddress());
                                            bsPFServerEntry.setRbPFServerIfcSubnetMask(taskVD.getPfDomainSubnet());
                                        }
                                    } else {
                                        bsPFServerEntry.setRbBSPFServerPortNumber(taskVD.getPfServerUdpPort());
                                        bsPFServerEntry.setRbBSPFServerPFVlan(taskVD.getPfServerVlanId());
                                        bsPFServerEntry.setRbBSPFServerSharedString(taskVD.getPfServerSharedSecret());
                                    }
                                    if (!pfServerErrors) {
                                        newManagedObjects.add((ManagedObject)pfServersTable);
                                    }
                                }
                                if ((voiceDomainName = taskVD.getVoiceDomainName()) != null && voiceDomainName.length() > 0) {
                                    final ArrayList voiceDomainTableList = new ArrayList();
                                    new RunnableDatastoreDecorator(new Runnable(){

                                        public void run() {
                                            try {
                                                log.info((Object)("Retrieving BS " + RbVoiceDomainsTable.class.getName() + " for " + equipment.getClass().getName()));
                                                voiceDomainTableList.addAll(Helpers.getConfigurationHelper().retrieveCurrentConfiguration(equipment.getId(), "BS", RbVoiceDomainsTable.class, "*", false));
                                            }
                                            catch (MediationException ex) {
                                                log.warn((Object)("Error on retrieving Voice Domain from " + equipment.getIpAddr()), (Throwable)ex);
                                                errorOcurredMapTemp.put("ServiceGroup", "ErrorRetrievingVD");
                                            }
                                        }
                                    }).run();
                                    RbVoiceDomainsTable voiceDomainsTable = (RbVoiceDomainsTable)((Object)voiceDomainTableList.get(0));
                                    RbVoiceDomainsEntry bsVoiceDomainEntry = null;
                                    for (RbVoiceDomainsEntry rbVoiceDomainsEntry : voiceDomainsTable.getEntries()) {
                                        if (!rbVoiceDomainsEntry.getRbVoiceDomainName().equals(voiceDomainName)) continue;
                                        bsVoiceDomainEntry = rbVoiceDomainsEntry;
                                        break;
                                    }
                                    if (bsVoiceDomainEntry == null) {
                                        int vdLimit;
                                        int n = vdLimit = RbFeatures.isNewLimitInVD(bsEquip) ? 5 : 10;
                                        if (voiceDomainsTable.getEntries().size() < vdLimit) {
                                            bsVoiceDomainEntry = new RbVoiceDomainsEntry();
                                            bsVoiceDomainEntry.setRbVoiceDomainName(taskVD.getVoiceDomainName());
                                            bsVoiceDomainEntry.setRbVoiceDomainIdx(-1L);
                                            voiceDomainsTable.addEntry((TableRowMO)bsVoiceDomainEntry);
                                        } else {
                                            errorOcurredMap.put("VoiceDomain", "MaxNumberOfVoiceDomainsReached");
                                        }
                                    }
                                    if (bsVoiceDomainEntry != null) {
                                        if (bsPFServerEntry != null) {
                                            bsVoiceDomainEntry.setRbVoiceDomainPrimaryPFIpAddress(bsPFServerEntry.getRbBSPFServerAddress());
                                            if (!pfServerErrors) {
                                                newManagedObjects.add((ManagedObject)voiceDomainsTable);
                                            }
                                        } else {
                                            errorOcurredMap.put("VoiceDomain", "CantAddVoiceDomainWithoutPFServer");
                                        }
                                    }
                                }
                            } else {
                                errorOcurredMap.put("VoiceDomain", "VoiceDomainNotAvailableForThisEquipment");
                            }
                        }
                    }
                    if (this.shouldAbortTask()) {
                        this.logStatus(equipment, OperationStatus.ABORTED, null);
                        return;
                    }
                    for (final ManagedObject mo : newManagedObjects) {
                        new RunnableDatastoreDecorator(new Runnable(){

                            public void run() {
                                try {
                                    Helpers.getConfigurationHelper().updateCurrentConfiguration(equipment.getId(), mo);
                                }
                                catch (MediationException ex) {
                                    log.warn((Object)("Error on processing MO " + mo.getClass().getName()), (Throwable)ex);
                                    errorOcurredMapTemp.put("GenericError", mo.getClass().getName());
                                }
                            }
                        }).run();
                    }
                    this.logStatus(equipment, OperationStatus.COMPLETED, null);
                    try {
                        String errorString = this.taskContext.sendCommand(equipment);
                        if (errorString == null) {
                            this.logStatus(equipment, OperationStatus.COMPLETED, null);
                        } else {
                            this.logStatus(equipment, OperationStatus.COMPLETED_WITH_ERRORS, errorString);
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)e, (Throwable)e);
                        this.logStatus(equipment, OperationStatus.COMPLETED_WITH_ERRORS, e.getMessage());
                    }
                    if (errorOcurredMap.size() > 0 || errorOcurredMapTemp.size() > 0 || errorOcurredMapCustom.size() > 0) {
                        Operation equipmetOperation = this.operationMap.get(equipment.getId());
                        if (equipmetOperation != null) {
                            String longMessage;
                            Operation operation;
                            for (String errorOcurred : errorOcurredMap.keySet()) {
                                operation = this.runtimeStatus.addOperation(equipmetOperation, errorOcurred);
                                longMessage = (String)errorOcurredMap.get(errorOcurred);
                                this.runtimeStatus.logOperationStatus(operation, OperationStatus.SKIPPED, (Serializable)((Object)(longMessage != null ? longMessage : errorOcurred)));
                            }
                            for (String errorOcurred : errorOcurredMapTemp.keySet()) {
                                operation = this.runtimeStatus.addOperation(equipmetOperation, errorOcurred);
                                longMessage = (String)errorOcurredMapTemp.get(errorOcurred);
                                this.runtimeStatus.logOperationStatus(operation, OperationStatus.SKIPPED, (Serializable)((Object)(longMessage != null ? longMessage : errorOcurred)));
                            }
                            for (String errorOcurred : errorOcurredMapCustom.keySet()) {
                                operation = this.runtimeStatus.addOperation(equipmetOperation, errorOcurred);
                                String[] longMessages = (String[])errorOcurredMapCustom.get(errorOcurred);
                                this.runtimeStatus.logOperationStatus(operation, OperationStatus.SKIPPED, (Serializable)((Object)(longMessages[0] != null ? longMessages[0] : errorOcurred)), new Object[]{longMessages[1]});
                            }
                        }
                        this.logStatus(equipment, OperationStatus.COMPLETED_WITH_ERRORS, null);
                    }
                }
                catch (Exception e) {
                    this.logStatus(equipment, OperationStatus.COMPLETED_WITH_ERRORS, null);
                    if (errorOcurredMap.size() != 0) break block70;
                    if (e.getCause() instanceof MediationException) {
                        log.error((Object)e.getCause(), e.getCause());
                    }
                    log.error((Object)e, (Throwable)e);
                }
            }
        }

        private void removeServiceGroups(Map<String, String[]> errorOcurredMap, ArrayList<ManagedObject> newManagedObjects, List<RbServiceGroupEntry> serviceGroupTaskEntries, RbServiceGroupTable sgTable, RbServiceTemplateConfigTable spTable) {
            List sgEntries = sgTable.getEntries();
            List spEntries = spTable.getEntries();
            boolean entryDeleted = false;
            boolean sgNotFound = true;
            Integer i = 1;
            Integer j = 1;
            for (RbServiceGroupEntry rbServiceGroupTaskEntry : serviceGroupTaskEntries) {
                for (RbServiceGroupEntry rbServiceGroupEntry : sgEntries) {
                    if (rbServiceGroupTaskEntry.getRbServiceGroupName().equals(rbServiceGroupEntry.getRbServiceGroupName())) {
                        boolean sgUsed = false;
                        sgNotFound = false;
                        for (RbServiceTemplateConfigEntry sp : spEntries) {
                            if (!sp.getRbServiceTemplateGroupName().equals(rbServiceGroupTaskEntry.getRbServiceGroupName())) continue;
                            sgUsed = true;
                            break;
                        }
                        if (!sgUsed) {
                            sgTable.removeEntry(rbServiceGroupEntry.getRowKey());
                            entryDeleted = true;
                            break;
                        }
                        String[] arrayMsg = new String[]{"ServiceGroupNameUsedBySP", rbServiceGroupTaskEntry.getRbServiceGroupName()};
                        errorOcurredMap.put("ServiceGroupUsed" + i.toString(), arrayMsg);
                        Integer n = i;
                        Integer n2 = i = Integer.valueOf(i + 1);
                        break;
                    }
                    sgNotFound = true;
                }
                if (!sgNotFound) continue;
                String[] arrayMsg = new String[]{"ServiceGroupNameNotFound", rbServiceGroupTaskEntry.getRbServiceGroupName()};
                errorOcurredMap.put("ServiceGroupNotFound" + j.toString(), arrayMsg);
                Integer n = j;
                Integer n3 = j = Integer.valueOf(j + 1);
            }
            if (entryDeleted) {
                newManagedObjects.add((ManagedObject)sgTable);
            }
        }

        private void insertServiceGroups(Map<String, String[]> errorOcurredMap, ArrayList<ManagedObject> newManagedObjects, List<RbServiceGroupEntry> serviceGroupTaskEntries, RbServiceGroupTable sgTable) {
            List sgEntries = sgTable.getEntries();
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            for (int i = 1; i < 11; ++i) {
                indexes.add(i);
            }
            for (RbServiceGroupEntry rbServiceGroupEntry : sgEntries) {
                int usedIndex = rbServiceGroupEntry.getRbServiceGroupIndex().intValue();
                indexes.remove((Object)usedIndex);
            }
            boolean sgAdded = false;
            boolean entryNotFound = false;
            Integer i = 1;
            for (RbServiceGroupEntry rbServiceGroupTaskEntry : serviceGroupTaskEntries) {
                entryNotFound = false;
                if (indexes.size() > 0) {
                    for (RbServiceGroupEntry rbServiceGroupEntry : sgEntries) {
                        Integer n;
                        Integer n2;
                        String[] arrayMsg;
                        String taskISPDomainName = rbServiceGroupTaskEntry.getRbServiceGroupIspDomainName();
                        if (taskISPDomainName == null) {
                            taskISPDomainName = "";
                        }
                        if (rbServiceGroupTaskEntry.getRbServiceGroupName().equals(rbServiceGroupEntry.getRbServiceGroupName())) {
                            arrayMsg = new String[]{"DuplicateServiceGroupName", rbServiceGroupTaskEntry.getRbServiceGroupName()};
                            errorOcurredMap.put("ServiceGroup" + i.toString(), arrayMsg);
                            n2 = i;
                            n = i = Integer.valueOf(i + 1);
                            entryNotFound = false;
                            break;
                        }
                        if (taskISPDomainName.equals(rbServiceGroupEntry.getRbServiceGroupIspDomainName())) {
                            arrayMsg = new String[]{"DuplicateServiceGroupISPName", rbServiceGroupTaskEntry.getRbServiceGroupIspDomainName()};
                            errorOcurredMap.put("ServiceGroup" + i.toString(), arrayMsg);
                            n2 = i;
                            n = i = Integer.valueOf(i + 1);
                            entryNotFound = false;
                            break;
                        }
                        entryNotFound = true;
                    }
                } else {
                    String[] arrayMsg = new String[]{"MaxNumberOfServiceGroupReached", "10"};
                    errorOcurredMap.put("ServiceGroup0", arrayMsg);
                }
                if (!entryNotFound) continue;
                RbServiceGroupEntry newEntry = new RbServiceGroupEntry();
                newEntry.setRbServiceGroupIndex((long)((Integer)indexes.get(0)));
                newEntry.setRbServiceGroupDhcpServerIp(rbServiceGroupTaskEntry.getRbServiceGroupDhcpServerIp());
                newEntry.setRbServiceGroupGateway(rbServiceGroupTaskEntry.getRbServiceGroupGateway());
                newEntry.setRbServiceGroupGiIpAddress(rbServiceGroupTaskEntry.getRbServiceGroupGiIpAddress());
                newEntry.setRbServiceGroupGiSubnetMask(rbServiceGroupTaskEntry.getRbServiceGroupGiSubnetMask());
                newEntry.setRbServiceGroupIspDomainName(rbServiceGroupTaskEntry.getRbServiceGroupIspDomainName());
                newEntry.setRbServiceGroupName(rbServiceGroupTaskEntry.getRbServiceGroupName());
                newEntry.setRbServiceGroupNomadicity(rbServiceGroupTaskEntry.getRbServiceGroupNomadicity());
                newEntry.setRbServiceGroupRelayMode(rbServiceGroupTaskEntry.getRbServiceGroupRelayMode());
                newEntry.setRbServiceGroupType(rbServiceGroupTaskEntry.getRbServiceGroupType());
                newEntry.setRbServiceGroupVlanId(rbServiceGroupTaskEntry.getRbServiceGroupVlanId());
                indexes.remove(0);
                sgTable.addEntry((TableRowMO)newEntry);
                sgAdded = true;
            }
            if (sgAdded) {
                newManagedObjects.add((ManagedObject)sgTable);
            }
        }

        public int getExecutionResult() {
            if (this.taskFailed) {
                return 3;
            }
            if (this.taskCompletedWithErrors) {
                return 4;
            }
            if (this.ctx.shouldAbort()) {
                return 2;
            }
            return 1;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class RbConfigParamsCommandTaskItem
        implements Runnable {
            private List<Equipment> itemEquipmentList;

            public RbConfigParamsCommandTaskItem(Equipment itemEquipment) {
                this.itemEquipmentList = new ArrayList<Equipment>(1);
                this.itemEquipmentList.add(itemEquipment);
            }

            public RbConfigParamsCommandTaskItem(List<Equipment> itemEquipmentList) {
                this.itemEquipmentList = itemEquipmentList;
            }

            @Override
            public void run() {
                for (Equipment equipment : this.itemEquipmentList) {
                    RbMultipleConfigTaskExecutor.this.logStatus(equipment, OperationStatus.PENDING, null);
                    if (RbMultipleConfigTaskExecutor.this.shouldAbortTask()) {
                        RbMultipleConfigTaskExecutor.this.logStatus(equipment, OperationStatus.ABORTED, null);
                        return;
                    }
                    RbMultipleConfigTaskExecutor.this.runEquipment(equipment);
                }
            }
        }
    }
}

