/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.multipleconfiguration;

import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.SelectorUtil;
import com.bwanms.gui.SelectorView;
import com.bwanms.gui.Selectors;
import com.bwanms.gui.binding.translators.MACAddressTranslator;
import com.bwanms.mo.DuplicateEntryException;
import com.bwanms.mo.TableRowMO;
import com.bwanms.model.EqTreeNode;
import com.bwanms.model.EqTreeNodeValue;
import com.bwanms.model.Equipment;
import com.bwanms.model.ManagedEntity;
import com.bwanms.model.MultipleConfigWeakAssociation;
import com.bwanms.model.Task;
import com.bwanms.model.entity.Assembly;
import com.bwanms.model.entity.LightQuery;
import com.bwanms.rb.gui.configuration.MACDenyListConfigForm;
import com.bwanms.rb.mo.RbAuConfigEntry;
import com.bwanms.rb.mo.RbAuMacParametersGroup;
import com.bwanms.rb.mo.RbAuMultirateParametersGroup;
import com.bwanms.rb.mo.RbAuthorizedManagersEntry;
import com.bwanms.rb.mo.RbAuthorizedManagersTable;
import com.bwanms.rb.mo.RbBsRadioParameters;
import com.bwanms.rb.mo.RbMACAddressDenyListEntry;
import com.bwanms.rb.mo.RbMACAddressDenyListTable;
import com.bwanms.rb.mo.RbMBSTBridgingParameters;
import com.bwanms.rb.mo.RbNpuBridgingParameters;
import com.bwanms.rb.mo.RbNpuConfigEntry;
import com.bwanms.rb.mo.RbRadiusAccountServerEntry;
import com.bwanms.rb.mo.RbRadiusAccountServerTable;
import com.bwanms.rb.mo.RbRadiusAuthServerEntry;
import com.bwanms.rb.mo.RbRadiusAuthServerTable;
import com.bwanms.rb.mo.RbTrapConfigEntry;
import com.bwanms.rb.mo.RbTrapConfigTable;
import com.bwanms.rb.mo.services.RbServiceGroupEntry;
import com.bwanms.rb.mo.services.RbServiceGroupTable;
import com.bwanms.rb.model.RbAU;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbSU;
import com.bwanms.rb.tasks.multipleconfiguration.MultipleConfigTaskMainPanel2;
import com.bwanms.rb.tasks.multipleconfiguration.MultipleConfigTaskVoiceDomainConfigPanel;
import com.bwanms.rb.tasks.multipleconfiguration.MultipleConfigTrapsTableController;
import com.bwanms.rb.tasks.multipleconfiguration.RbBSMultipleConfigTask;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.EquipmentSelectorTreeTableModel;
import com.bwanms.ui.components.ROTableModel;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.IpAddress;
import com.bwanms.util.IpAddressRange;
import com.bwanms.util.MacAddress;
import com.bwanms.validation.IPAddressValidator;
import com.bwanms.validation.IPv4Validator;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbBSMultipleConfigTaskView
extends AbstractBindedEditorView<Task> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(MACDenyListConfigForm.class);
    private static final Logger logger = Logger.getLogger(RbBSMultipleConfigTaskView.class);
    private MultipleConfigTrapsTableController controller;
    private MultipleConfigTaskMainPanel2 panel;
    private EquipmentSelectorTreeTableModel equipmentTreeTableModel;

    public RbBSMultipleConfigTaskView() {
        this.initUI();
    }

    private void initUI() {
        this.equipmentTreeTableModel = new EquipmentSelectorTreeTableModel();
        this.panel = new MultipleConfigTaskMainPanel2(this.equipmentTreeTableModel);
        this.panel.setPreferredSize(new Dimension(720, 540));
        this.panel.getBtnEquipmentAdd().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RbBSMultipleConfigTaskView.this.actionSelectBaseStations();
            }
        });
        this.panel.getBtnEquipmentRemove().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RbBSMultipleConfigTaskView.this.actionRemoveEquipment();
            }
        });
        this.panel.showBsParamsPanel();
    }

    public JComponent getUI() {
        return this.panel;
    }

    public String getTitle() {
        return i18n.translateString("MultipleConfigTask");
    }

    public void fillUI(Task entity) {
        RbAuMultirateParametersGroup auMultiParams;
        RbAuConfigEntry entry;
        RbNpuConfigEntry ttlEntry;
        RbNpuBridgingParameters bridgingConfigParams;
        RbBSMultipleConfigTask task = (RbBSMultipleConfigTask)entity;
        this.panel.getTxtName().setText(task.getName());
        if (task.isFromServiceGroupViewer()) {
            this.panel.getTabbedPane1().setSelectedIndex(1);
            this.panel.getBsPanel().getTabbedPane1().setSelectedIndex(4);
            task.setFromServiceGroupViewer(false);
        }
        if (task.isFromVoiceDomainViewer()) {
            this.panel.getTabbedPane1().setSelectedIndex(1);
            this.panel.getBsPanel().getTabbedPane1().setSelectedIndex(5);
            task.setFromVoiceDomainViewer(false);
        }
        this.loadEquipment(task);
        MultipleConfigTaskVoiceDomainConfigPanel bsVoiceDomainPanel = this.panel.getBsPanel().getBsVoiceDomain();
        bsVoiceDomainPanel.getTxtVoiceDomainName().setText(task.getVoiceDomainName());
        bsVoiceDomainPanel.getTxtServerIPAddress().setText(task.getPfServerIPAddress());
        if (task.getPfServerUdpPort() != null) {
            bsVoiceDomainPanel.getTxtUDPPort().setText(task.getPfServerUdpPort().toString());
        }
        if (task.getPfServerVlanId() != null && task.getPfServerVlanId() != 4095) {
            bsVoiceDomainPanel.getTxtVLANId().setText(task.getPfServerVlanId().toString());
        }
        bsVoiceDomainPanel.getTxtSharedSecret().setText(task.getPfServerSharedSecret());
        bsVoiceDomainPanel.getTxtRetypeSharedSecret().setText(task.getPfServerSharedSecret());
        if (task.getPfAdoptDataPort() != null) {
            bsVoiceDomainPanel.getAdoptDataPortCombo().setSelectedIndex(task.getPfAdoptDataPort() - 1);
        }
        if (task.getPfDomainGateway() != null) {
            bsVoiceDomainPanel.getDomainGatewayTxt().setText(task.getPfDomainGateway());
        }
        if (task.getPfDomainIpAddress() != null) {
            bsVoiceDomainPanel.getDomainIPAddressTxt().setText(task.getPfDomainIpAddress());
        }
        if (task.getPfDomainSubnet() != null) {
            bsVoiceDomainPanel.getDomainSubnetTxt().setText(task.getPfDomainSubnet());
        }
        ROTableModel modelRadiusAuth = this.panel.getBsPanel().getBsRadiusPanel().getTblAuthenticationServersModel();
        ROTableModel modelRadiusAcc = this.panel.getBsPanel().getBsRadiusPanel().getTblAccountingServersModel();
        modelRadiusAuth.clearTable();
        this.panel.getBsPanel().getBsRadiusPanel().getController().fillRadiusTables(modelRadiusAuth);
        modelRadiusAcc.clearTable();
        this.panel.getBsPanel().getBsRadiusPanel().getController().fillRadiusTables(modelRadiusAcc);
        ROTableModel modelSG = this.panel.getBsPanel().getBsServiceGroups().getTblServiceGroupsModel();
        modelSG.clearTable();
        if (task.isServiceGroupToInsert() || 0L == task.getId()) {
            this.panel.getBsPanel().getBsServiceGroups().getRadioSGInsert().setSelected(true);
        } else {
            this.panel.getBsPanel().getBsServiceGroups().getRadioSGRemove().setSelected(true);
        }
        List<RbServiceGroupEntry> serviceGroupEntries = task.getBsServiceGroupEntries();
        int rowIdx = 0;
        for (RbServiceGroupEntry sgEntry : serviceGroupEntries) {
            modelSG.addNewRow(sgEntry.getRowKey(), true);
            String sgStringValue = sgEntry.getRbServiceGroupName();
            modelSG.setInitialValueAt((Object)sgStringValue, rowIdx, 0);
            sgStringValue = sgEntry.getRbServiceGroupIspDomainName();
            modelSG.setInitialValueAt((Object)sgStringValue, rowIdx, 1);
            Integer sgIntValue = sgEntry.getRbServiceGroupNomadicity();
            modelSG.setInitialValueAt((Object)sgIntValue, rowIdx, 2);
            sgIntValue = sgEntry.getRbServiceGroupType();
            modelSG.setInitialValueAt((Object)sgIntValue, rowIdx, 3);
            modelSG.setROCell(rowIdx, 4);
            modelSG.setROCell(rowIdx, 5);
            modelSG.setROCell(rowIdx, 6);
            modelSG.setROCell(rowIdx, 7);
            modelSG.setROCell(rowIdx, 8);
            modelSG.setROCell(rowIdx, 9);
            if (sgEntry.getRbServiceGroupType() == 2) {
                modelSG.resetTableAccess(Integer.valueOf(rowIdx), Integer.valueOf(4));
                sgIntValue = sgEntry.getRbServiceGroupRelayMode();
                modelSG.setInitialValueAt((Object)sgIntValue, rowIdx, 4);
                if (sgEntry.getRbServiceGroupRelayMode() == 1) {
                    modelSG.resetTableAccess(Integer.valueOf(rowIdx));
                    sgIntValue = sgEntry.getRbServiceGroupVlanId() == 4095 ? null : sgEntry.getRbServiceGroupVlanId();
                    modelSG.setInitialValueAt((Object)sgIntValue, rowIdx, 8);
                    sgStringValue = sgEntry.getRbServiceGroupGateway();
                    modelSG.setInitialValueAt((Object)sgStringValue, rowIdx, 9);
                    sgStringValue = sgEntry.getRbServiceGroupDhcpServerIp();
                    modelSG.setInitialValueAt((Object)sgStringValue, rowIdx, 7);
                    sgStringValue = sgEntry.getRbServiceGroupGiSubnetMask();
                    modelSG.setInitialValueAt((Object)sgStringValue, rowIdx, 6);
                    sgStringValue = sgEntry.getRbServiceGroupGiIpAddress();
                    modelSG.setInitialValueAt((Object)sgStringValue, rowIdx, 5);
                }
            } else {
                modelSG.setInitialValueAt((Object)"", rowIdx, 4);
            }
            ++rowIdx;
        }
        this.panel.getBsPanel().getBsServiceGroups().getController().controlInsertRadioGroup();
        if (0L == task.getId()) {
            return;
        }
        RbAuMacParametersGroup auMacParams = task.getBsAuMacParams();
        if (null != auMacParams.getRbAuMaxCellRadius()) {
            this.panel.getAuPanel().getTxtMaxCellRadius().setText(auMacParams.getRbAuMaxCellRadius().toString());
        }
        if (null != auMacParams.getRbAuConfiguredARQState()) {
            FormUtil.setSelectedValue((JComboBox)this.panel.getAuPanel().getComboCfgARQState(), (Object)auMacParams.getRbAuConfiguredARQState());
        }
        if (null != (bridgingConfigParams = task.getBsNpuBridgingParameters()).getRbNpuBridgeAgingTime()) {
            this.panel.getNpuPanel().getTextBridgeAgingTime().setText(bridgingConfigParams.getRbNpuBridgeAgingTime().toString());
        }
        if (null != task.getBsRadioParameters().getRbLocalClockDateAndTime()) {
            this.panel.getNpuPanel().getTxtLocalClockDateAndTime().setText(task.getBsRadioParameters().getRbLocalClockDateAndTime());
        }
        if (null != (ttlEntry = task.getNpuConfigEntry()) && null != ttlEntry.getRbNpuDrapTtlRetries()) {
            this.panel.getNpuPanel().getDrapTTLRetries().setText(ttlEntry.getRbNpuDrapTtlRetries().toString());
        }
        if (null != (entry = task.getAuConfigEntry()) && null != entry.getRbAuMaxNumberOfCalls()) {
            this.panel.getAuPanel().getTxtMaxNrOfVoiceCalls().setText(entry.getRbAuMaxNumberOfCalls().toString());
        }
        if (null != (auMultiParams = task.getBsAuMultirateParams()).getRbAuUlBasicRate()) {
            FormUtil.setSelectedValue((JComboBox)this.panel.getAuPanel().getComboBasicUplinkRate(), (Object)auMultiParams.getRbAuUlBasicRate());
        }
        if (null != auMultiParams.getRbAuDlBasicRate()) {
            FormUtil.setSelectedValue((JComboBox)this.panel.getAuPanel().getComboBasicDownlinkRate(), (Object)auMultiParams.getRbAuDlBasicRate());
        }
        if (null != task.getBsRadioParameters().getRbBsOptimalRSSI()) {
            this.panel.getBsPanel().getBsRadioPanel().getTxtOptimalUploadRSSI().setText(task.getBsRadioParameters().getRbBsOptimalRSSI().toString());
        }
        if (null != task.getBsRadioParameters().getRbBsATPCSupport()) {
            FormUtil.setSelectedValue((JComboBox)this.panel.getBsPanel().getBsRadioPanel().getComboATPCSupport(), (Object)task.getBsRadioParameters().getRbBsATPCSupport());
        }
        if (null != task.getBsRFModeParameters().getRbBsRFConfiguredDlUlRatio()) {
            FormUtil.setSelectedValue((JComboBox)this.panel.getBsPanel().getBsRadioPanel().getCmbCfgDuplexDLULRatio(), (Object)task.getBsRFModeParameters().getRbBsRFConfiguredDlUlRatio());
        }
        if (null != task.getBsRadiusClientGeneralParameters().getRbRadiusClientRetryInterval()) {
            this.panel.getBsPanel().getBsRadiusPanel().getTxtRetryInterval().setText(task.getBsRadiusClientGeneralParameters().getRbRadiusClientRetryInterval().toString());
        }
        if (null != task.getBsRadiusClientGeneralParameters().getRbRadiusClientMaxNumOfRetries()) {
            this.panel.getBsPanel().getBsRadiusPanel().getTxtNrOfRetries().setText(task.getBsRadiusClientGeneralParameters().getRbRadiusClientMaxNumOfRetries().toString());
        }
        if (null != task.getBsRadiusClientGeneralParameters().getRbRadiusClientKeepAliveTimeout()) {
            this.panel.getBsPanel().getBsRadiusPanel().getTxtKeepAliveTimeOut().setText(task.getBsRadiusClientGeneralParameters().getRbRadiusClientKeepAliveTimeout().toString());
        }
        if (null != task.getBsClockConfigParameters().getRbBSConfiguredExternalPPSClock()) {
            FormUtil.setSelectedValue((JComboBox)this.panel.getBsPanel().getBsGPSPanel().getCmbCfgExternalPPSClock(), (Object)task.getBsClockConfigParameters().getRbBSConfiguredExternalPPSClock());
        }
        if (null != task.getBsClockConfigParameters().getRbBSConfiguredExternal16MhzClock()) {
            FormUtil.setSelectedValue((JComboBox)this.panel.getBsPanel().getBsGPSPanel().getCmbCfgExternal16MhzClock(), (Object)task.getBsClockConfigParameters().getRbBSConfiguredExternal16MhzClock());
        }
        List<RbTrapConfigEntry> trapCfgEntries = task.getBsTrapConfigEntries();
        FormUtil.cancelTableEditing((JTable)this.panel.getBsPanel().getBsGeneralPanel().getTblTraps());
        SimpleRowTableModel model = (SimpleRowTableModel)this.panel.getBsPanel().getBsGeneralPanel().getTblTraps().getModel();
        rowIdx = 0;
        for (RbTrapConfigEntry trapEntry : trapCfgEntries) {
            for (int i = 0; i < model.getRowCount(); ++i) {
                if (trapEntry.getTrapEnterprizeId() == 2) {
                    if (!trapEntry.getTrapId().equals(model.getValueAt(i, 0))) continue;
                    rowIdx = i;
                    model.setInitialValueAt((Object)trapEntry.getTrapEnable(), rowIdx, 2);
                    model.setInitialValueAt((Object)trapEntry.getTrapSeverity(), rowIdx, 3);
                    model.setInitialValueAt((Object)trapEntry.getTrapSuppressionInterval(), rowIdx, 4);
                    continue;
                }
                if (trapEntry.getTrapEnterprizeId() != 1) continue;
                int row = 132 - (Integer)model.getValueAt(i, 0);
                if (!trapEntry.getTrapId().equals(row)) continue;
                rowIdx = model.getRowCount() + trapEntry.getTrapId() - 32;
                model.setInitialValueAt((Object)trapEntry.getTrapEnable(), rowIdx, 2);
                model.setInitialValueAt((Object)trapEntry.getTrapSeverity(), rowIdx, 3);
                model.setInitialValueAt((Object)trapEntry.getTrapSuppressionInterval(), rowIdx, 4);
            }
        }
        this.panel.getBsPanel().getBsGeneralPanel().getChkAdminStatus().setSelected(task.getRestoreTrapsDefaultsAdmin());
        this.panel.getBsPanel().getBsGeneralPanel().getChkSeverity().setSelected(task.getRestoreTrapsDefaultsSeverity());
        this.panel.getBsPanel().getBsGeneralPanel().getChkSuppressionInterval().setSelected(task.getRestoreTrapsDefaultsSuppression());
        FormUtil.cancelTableEditing((JTable)this.panel.getBsPanel().getBsGeneralPanel().getTable2());
        if (task.isMacDenyList()) {
            this.panel.getBsPanel().getBsGeneralPanel().getRadioUnblock().setSelected(true);
        } else {
            this.panel.getBsPanel().getBsGeneralPanel().getRadioBlock().setSelected(true);
        }
        List<RbMACAddressDenyListEntry> macDenyEntries = task.getBsMACAddressDenyListEntries();
        SimpleRowTableModel modelMAC = this.panel.getBsPanel().getBsGeneralPanel().getTableModel();
        modelMAC.clearTable();
        rowIdx = 0;
        for (RbMACAddressDenyListEntry macDenyEntry : macDenyEntries) {
            String macAddress = macDenyEntry.getRbMACAddressDenyMacAddress();
            modelMAC.addNewRow(macDenyEntry.getRowKey(), true);
            modelMAC.setInitialValueAt((Object)MacAddress.fromOctetString((String)macAddress).toString(), rowIdx, 0);
            ++rowIdx;
        }
        FormUtil.cancelTableEditing((JTable)this.panel.getNpuPanel().getTable2());
        if (task.isManagersDenyList()) {
            this.panel.getNpuPanel().getRadioDeny().setSelected(true);
        } else {
            this.panel.getNpuPanel().getRadioAuthorize().setSelected(true);
        }
        RbAuthorizedManagersTable authorizedManagersTable = new RbAuthorizedManagersTable(task.getBsAuthorizedManagersEntries());
        SimpleRowTableModel modelAuth = this.panel.getNpuPanel().getTable2Model();
        modelAuth.clearTable();
        rowIdx = 0;
        for (RbAuthorizedManagersEntry entryAuth : authorizedManagersTable.getEntries()) {
            modelAuth.addNewRow(entryAuth.getRowKey(), true);
            modelAuth.setInitialValueAt((Object)entryAuth.getRowKey(), rowIdx, 0);
            modelAuth.setInitialValueAt((Object)entryAuth.getAuthMngrReadCommunity(), rowIdx, 1);
            modelAuth.setInitialValueAt((Object)entryAuth.getAuthMngrWriteCommunity(), rowIdx, 2);
            modelAuth.setInitialValueAt((Object)(1 == entryAuth.getAuthMngrTrapEnable() ? 1 : 0), rowIdx, 3);
            ++rowIdx;
        }
        this.controller = new MultipleConfigTrapsTableController(this.panel.getBsPanel().getBsGeneralPanel());
        this.controller.controlTrapRestoreDefaultsCheckBoxInit();
        FormUtil.cancelTableEditing((JTable)this.panel.getBsPanel().getBsRadiusPanel().getTblAuthenticationServers());
        RbRadiusAuthServerTable radiusAuthTable = new RbRadiusAuthServerTable(task.getBsRadiusAuthServerParams());
        for (RbRadiusAuthServerEntry radiusAuthEntry : radiusAuthTable.getEntries()) {
            String ipAddr = radiusAuthEntry.getRbRadiusAuthServerAddress();
            ipAddr = null == ipAddr ? "" : ipAddr;
            String gwIp = radiusAuthEntry.getRbRadiusAuthServerGateway();
            if (radiusAuthEntry.getRbRadiusAuthServerType() == 1) {
                modelRadiusAuth.setInitialValueAt((Object)true, 0, 7);
                if (!Integer.valueOf(1).equals(radiusAuthEntry.getRbRadiusAuthServerOperStatus())) {
                    modelRadiusAuth.setInitialValueAt((Object)radiusAuthEntry.getRbRadiusAuthServerAddress(), 0, 0);
                    modelRadiusAuth.setInitialValueAt((Object)radiusAuthEntry.getRbRadiusAuthServerPortNumber(), 0, 1);
                    modelRadiusAuth.setInitialValueAt((Object)radiusAuthEntry.getRbRadiusAuthDataPortAdopt(), 0, 2);
                    modelRadiusAuth.setInitialValueAt((Object)radiusAuthEntry.getRbRadiusAuthServerVlanId(), 0, 3);
                    modelRadiusAuth.setInitialValueAt((Object)radiusAuthEntry.getRbRadiusAuthServerIfcIpAddress(), 0, 4);
                    modelRadiusAuth.setInitialValueAt((Object)radiusAuthEntry.getRbRadiusAuthServerSubnetMask(), 0, 5);
                    modelRadiusAuth.setInitialValueAt((Object)radiusAuthEntry.getRbRadiusAuthServerGateway(), 0, 6);
                    modelRadiusAuth.setInitialValueAt((Object)false, 0, 8);
                    continue;
                }
                if (ipAddr.startsWith("127.0.0.")) {
                    if (null == gwIp) {
                        modelRadiusAuth.setInitialValueAt((Object)"", 0, 0);
                    } else {
                        modelRadiusAuth.setInitialValueAt((Object)gwIp, 0, 0);
                    }
                }
                modelRadiusAuth.setInitialValueAt((Object)true, 0, 8);
                continue;
            }
            modelRadiusAuth.setInitialValueAt((Object)false, 1, 7);
            if (!Integer.valueOf(1).equals(radiusAuthEntry.getRbRadiusAuthServerOperStatus())) {
                modelRadiusAuth.setInitialValueAt((Object)radiusAuthEntry.getRbRadiusAuthServerAddress(), 1, 0);
                modelRadiusAuth.setInitialValueAt((Object)radiusAuthEntry.getRbRadiusAuthServerPortNumber(), 1, 1);
                modelRadiusAuth.setInitialValueAt((Object)radiusAuthEntry.getRbRadiusAuthDataPortAdopt(), 1, 2);
                modelRadiusAuth.setInitialValueAt((Object)radiusAuthEntry.getRbRadiusAuthServerVlanId(), 1, 3);
                modelRadiusAuth.setInitialValueAt((Object)radiusAuthEntry.getRbRadiusAuthServerIfcIpAddress(), 1, 4);
                modelRadiusAuth.setInitialValueAt((Object)radiusAuthEntry.getRbRadiusAuthServerSubnetMask(), 1, 5);
                modelRadiusAuth.setInitialValueAt((Object)radiusAuthEntry.getRbRadiusAuthServerGateway(), 1, 6);
                modelRadiusAuth.setInitialValueAt((Object)false, 1, 8);
                continue;
            }
            if (ipAddr.startsWith("127.0.0.")) {
                if (null == gwIp) {
                    modelRadiusAuth.setInitialValueAt((Object)"", 1, 0);
                } else {
                    modelRadiusAuth.setInitialValueAt((Object)gwIp, 1, 0);
                }
            }
            modelRadiusAuth.setInitialValueAt((Object)true, 1, 8);
        }
        this.panel.getBsPanel().getBsRadiusPanel().getController().updatedAdoptDataPort(modelRadiusAuth);
        FormUtil.cancelTableEditing((JTable)this.panel.getBsPanel().getBsRadiusPanel().getTblAccountingServers());
        RbRadiusAccountServerTable radiusAccTable = new RbRadiusAccountServerTable(task.getBsRadiusAccServerParams());
        for (RbRadiusAccountServerEntry radiusAccEntry : radiusAccTable.getEntries()) {
            String ip = radiusAccEntry.getRbRadiusAcctServerAddress();
            ip = null == ip ? "" : ip;
            Integer udpPort = radiusAccEntry.getRbRadiusAcctServerPortNumber();
            Integer vlanId = radiusAccEntry.getRbRadiusAcctServerVlanId();
            String ifcIpAddress = radiusAccEntry.getRbRadiusAcctServerIfcIpAddress();
            String netmask = radiusAccEntry.getRbRadiusAcctServerSubnetMask();
            String gwIp = radiusAccEntry.getRbRadiusAcctServerGateway();
            if (radiusAccEntry.getRbRadiusAcctServerType() == 1) {
                modelRadiusAcc.setInitialValueAt((Object)true, 0, 7);
                if (!Integer.valueOf(1).equals(radiusAccEntry.getRbRadiusAcctServerOperStatus())) {
                    modelRadiusAcc.setInitialValueAt((Object)radiusAccEntry.getRbRadiusAcctServerAddress(), 0, 0);
                    modelRadiusAcc.setInitialValueAt((Object)radiusAccEntry.getRbRadiusAcctServerPortNumber(), 0, 1);
                    modelRadiusAcc.setInitialValueAt((Object)radiusAccEntry.getRbRadiusAcctDataPortAdopt(), 0, 2);
                    modelRadiusAcc.setInitialValueAt((Object)radiusAccEntry.getRbRadiusAcctServerVlanId(), 0, 3);
                    modelRadiusAcc.setInitialValueAt((Object)radiusAccEntry.getRbRadiusAcctServerIfcIpAddress(), 0, 4);
                    modelRadiusAcc.setInitialValueAt((Object)radiusAccEntry.getRbRadiusAcctServerSubnetMask(), 0, 5);
                    modelRadiusAcc.setInitialValueAt((Object)radiusAccEntry.getRbRadiusAcctServerGateway(), 0, 6);
                    modelRadiusAcc.setInitialValueAt((Object)false, 0, 8);
                    continue;
                }
                if (ip.startsWith("127.0.0.")) {
                    if (null == gwIp) {
                        modelRadiusAcc.setInitialValueAt((Object)"", 0, 0);
                    } else {
                        modelRadiusAcc.setInitialValueAt((Object)gwIp, 0, 0);
                    }
                }
                modelRadiusAcc.setInitialValueAt((Object)true, 0, 8);
                continue;
            }
            modelRadiusAcc.setInitialValueAt((Object)false, 1, 7);
            if (!Integer.valueOf(1).equals(radiusAccEntry.getRbRadiusAcctServerOperStatus())) {
                modelRadiusAcc.setInitialValueAt((Object)radiusAccEntry.getRbRadiusAcctServerAddress(), 1, 0);
                modelRadiusAcc.setInitialValueAt((Object)radiusAccEntry.getRbRadiusAcctServerPortNumber(), 1, 1);
                modelRadiusAcc.setInitialValueAt((Object)radiusAccEntry.getRbRadiusAcctDataPortAdopt(), 1, 2);
                modelRadiusAcc.setInitialValueAt((Object)radiusAccEntry.getRbRadiusAcctServerVlanId(), 1, 3);
                modelRadiusAcc.setInitialValueAt((Object)radiusAccEntry.getRbRadiusAcctServerIfcIpAddress(), 1, 4);
                modelRadiusAcc.setInitialValueAt((Object)radiusAccEntry.getRbRadiusAcctServerSubnetMask(), 1, 5);
                modelRadiusAcc.setInitialValueAt((Object)radiusAccEntry.getRbRadiusAcctServerGateway(), 1, 6);
                modelRadiusAcc.setInitialValueAt((Object)false, 1, 8);
                continue;
            }
            if (ip.startsWith("127.0.0.")) {
                if (null == gwIp) {
                    modelRadiusAcc.setInitialValueAt((Object)"", 1, 0);
                } else {
                    modelRadiusAcc.setInitialValueAt((Object)gwIp, 1, 0);
                }
            }
            modelRadiusAcc.setInitialValueAt((Object)true, 1, 8);
        }
        this.panel.getBsPanel().getBsRadiusPanel().getController().updatedAdoptDataPort(modelRadiusAcc);
        if (task.isDfltL2ServiceProfileIsNull()) {
            this.panel.getServicePanel().getChkL2().setSelected(true);
            this.panel.getServicePanel().getAddL2Service().setEnabled(false);
            this.panel.getServicePanel().getRemoveL2Service().setEnabled(false);
        } else {
            this.panel.getServicePanel().getChkL2().setSelected(false);
            this.panel.getServicePanel().getTxtL2Type().setText(task.getServiceType());
        }
        if (task.isDfltPPPoEServiceProfileIsNull()) {
            this.panel.getServicePanel().getChkPPPoE().setSelected(true);
            this.panel.getServicePanel().getAddPPPoEService().setEnabled(false);
            this.panel.getServicePanel().getRemovePPPoEService().setEnabled(false);
        } else {
            this.panel.getServicePanel().getChkPPPoE().setSelected(false);
            this.panel.getServicePanel().getTxtPPPoEType().setText(task.getServicePPPoEType());
        }
        this.panel.getServicePanel().getTxtL2DefaultServiceProfile().setText(task.getDfltServiceProfile());
        this.panel.getServicePanel().getTxtPPPoEDefaultServiceProfile().setText(task.getDfltPPPoEServiceProfile());
        if (task.getCommand() == 1) {
            this.panel.getNpuCommandsPanel().getRadioReset().setSelected(true);
        }
        if (task.getCommand() == 2) {
            this.panel.getNpuCommandsPanel().getRadioResetAndShadow().setSelected(true);
        }
    }

    public List<InvalidValue> configureEntity(Task entity) {
        ArrayList<InvalidValue> invalidValues = new ArrayList<InvalidValue>();
        RbBSMultipleConfigTask task = (RbBSMultipleConfigTask)entity;
        String taskName = this.panel.getTxtName().getText();
        if (null == taskName) {
            taskName = "";
        }
        if (1 > (taskName = taskName.trim()).length() || 32 < taskName.length()) {
            invalidValues.add(new InvalidValue(i18n.translateString("InvalidTaskName"), this.panel.getTxtName().getClass(), i18n.translateString("taskName"), (Object)this.panel.getTxtName().getText(), (Object)this.panel.getTxtName()));
        } else {
            task.setName(taskName);
        }
        if (!this.saveEquipment(task)) {
            invalidValues.add(new InvalidValue(i18n.translateString("NoEquipmentsSelected"), RbBsRadioParameters.class, "", (Object)"", null));
        }
        for (MultipleConfigWeakAssociation multipleConfigWeakAssociation : task.getManagedEntityWeakAssociation()) {
            if (!this.isEquipmentMissing(multipleConfigWeakAssociation.getManagedEntity().getId())) continue;
            invalidValues.add(new InvalidValue(i18n.translateString("EquipmentWasDeleted", new Object[]{multipleConfigWeakAssociation.getManagedEntity().getName()}), Equipment.class, "", (Object)"", null));
        }
        Integer intValue = null;
        JTextField txtOptimalUploadRSSI = this.panel.getBsPanel().getBsRadioPanel().getTxtOptimalUploadRSSI();
        String tempOptimalUplink = txtOptimalUploadRSSI.getText();
        if (tempOptimalUplink != null && !tempOptimalUplink.trim().equals("")) {
            try {
                Integer val = Integer.parseInt(tempOptimalUplink);
                if (val < -103 || val > -60) {
                    throw new NumberFormatException();
                }
                intValue = val;
            }
            catch (NumberFormatException e) {
                invalidValues.add(new InvalidValue(i18n.translateString("InvalidUplinkRSSI"), txtOptimalUploadRSSI.getClass(), i18n.translateString("OptimalUplinkRSSI"), (Object)tempOptimalUplink, (Object)txtOptimalUploadRSSI));
            }
        }
        task.getBsRadioParameters().setRbBsOptimalRSSI(intValue);
        Integer atpcSupport = (Integer)FormUtil.getSelectedValue((JComboBox)this.panel.getBsPanel().getBsRadioPanel().getComboATPCSupport());
        task.getBsRadioParameters().setRbBsATPCSupport(atpcSupport);
        Integer tddRatio = (Integer)FormUtil.getSelectedValue((JComboBox)this.panel.getBsPanel().getBsRadioPanel().getCmbCfgDuplexDLULRatio());
        task.getBsRFModeParameters().setRbBsRFConfiguredDlUlRatio(tddRatio);
        intValue = null;
        JTextField txtNrOfRetries = this.panel.getBsPanel().getBsRadiusPanel().getTxtNrOfRetries();
        String radiusNrRetries = txtNrOfRetries.getText();
        if (radiusNrRetries != null && !radiusNrRetries.trim().equals("")) {
            try {
                Integer val = Integer.parseInt(radiusNrRetries);
                if (val < 0 || val > 5) {
                    throw new NumberFormatException();
                }
                intValue = val;
            }
            catch (NumberFormatException e) {
                invalidValues.add(new InvalidValue(i18n.translateString("invalidRadiusNrRetries"), txtNrOfRetries.getClass(), i18n.translateString("numberOfRetries"), (Object)radiusNrRetries, (Object)txtNrOfRetries));
            }
        }
        task.getBsRadiusClientGeneralParameters().setRbRadiusClientMaxNumOfRetries(intValue);
        intValue = null;
        JTextField txtRetryInterval = this.panel.getBsPanel().getBsRadiusPanel().getTxtRetryInterval();
        String radiusRetryInterval = txtRetryInterval.getText();
        if (radiusRetryInterval != null && !radiusRetryInterval.trim().equals("")) {
            try {
                Integer val = Integer.parseInt(radiusRetryInterval);
                if (val < 1 || val > 5) {
                    throw new NumberFormatException();
                }
                intValue = val;
            }
            catch (NumberFormatException e) {
                invalidValues.add(new InvalidValue(i18n.translateString("invalidRadiusRetryInterval"), txtRetryInterval.getClass(), i18n.translateString("radiusRetryInterval"), (Object)radiusRetryInterval, (Object)txtRetryInterval));
            }
        }
        task.getBsRadiusClientGeneralParameters().setRbRadiusClientRetryInterval(intValue);
        intValue = null;
        JTextField txtKeepAliveTimeOut = this.panel.getBsPanel().getBsRadiusPanel().getTxtKeepAliveTimeOut();
        String radiusKeepAliveTimeOut = txtKeepAliveTimeOut.getText();
        if (radiusKeepAliveTimeOut != null && !radiusKeepAliveTimeOut.trim().equals("")) {
            try {
                Integer val = Integer.parseInt(radiusKeepAliveTimeOut);
                if (val < 60 || val > 180) {
                    throw new NumberFormatException();
                }
                intValue = val;
            }
            catch (NumberFormatException e) {
                invalidValues.add(new InvalidValue(i18n.translateString("invalidRadiusKeepAliveTimeOut"), txtKeepAliveTimeOut.getClass(), i18n.translateString("radiusKeepAliveTimeOut"), (Object)radiusKeepAliveTimeOut, (Object)txtKeepAliveTimeOut));
            }
        }
        task.getBsRadiusClientGeneralParameters().setRbRadiusClientKeepAliveTimeout(intValue);
        Integer externalPPSClock = (Integer)FormUtil.getSelectedValue((JComboBox)this.panel.getBsPanel().getBsGPSPanel().getCmbCfgExternalPPSClock());
        task.getBsClockConfigParameters().setRbBSConfiguredExternalPPSClock(externalPPSClock);
        Integer external16MhzClock = (Integer)FormUtil.getSelectedValue((JComboBox)this.panel.getBsPanel().getBsGPSPanel().getCmbCfgExternal16MhzClock());
        task.getBsClockConfigParameters().setRbBSConfiguredExternal16MhzClock(external16MhzClock);
        String tempBridge = this.panel.getNpuPanel().getTextBridgeAgingTime().getText();
        intValue = null;
        if (tempBridge != null && !tempBridge.trim().equals("")) {
            Integer value = null;
            try {
                value = Integer.parseInt(tempBridge);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (value == null || value < 0 || value > 1440) {
                invalidValues.add(new InvalidValue(i18n.translateString("InvalidBridgeAgingTime"), RbBsRadioParameters.class, i18n.translateString("BridgeAgingTime"), (Object)tempBridge, (Object)this.panel.getNpuPanel().getTextBridgeAgingTime()));
            } else {
                intValue = value;
            }
        }
        task.getBsNpuBridgingParameters().setRbNpuBridgeAgingTime(intValue);
        task.getMBsBridgingParameters().setRbMBSTBridgeAgingTime(intValue);
        String dateAndTime = this.panel.getNpuPanel().getTxtLocalClockDateAndTime().getText();
        if (null != dateAndTime && dateAndTime.trim().length() > 0) {
            ParsePosition parsePosition = new ParsePosition(0);
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            sdf.setLenient(false);
            Date date = sdf.parse(dateAndTime, parsePosition);
            if (parsePosition.getErrorIndex() == -1 && parsePosition.getIndex() == dateAndTime.length()) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(date);
                int year = calendar.get(1);
                if (year < 2000 || year > 2099) {
                    invalidValues.add(new InvalidValue(i18n.translateString("InvalidYear"), JTextField.class, i18n.translateString("LocalClockDateAndTime"), (Object)dateAndTime, (Object)this.panel.getNpuPanel().getTxtLocalClockDateAndTime()));
                } else {
                    task.getBsRadioParameters().setRbLocalClockDateAndTime(dateAndTime);
                }
            } else {
                invalidValues.add(new InvalidValue(i18n.translateString("InvalidDateFormat"), JTextField.class, i18n.translateString("LocalClockDateAndTime"), (Object)dateAndTime, (Object)this.panel.getNpuPanel().getTxtLocalClockDateAndTime()));
            }
        } else {
            task.getBsRadioParameters().setRbLocalClockDateAndTime(null);
        }
        String ttlRetries = this.panel.getNpuPanel().getDrapTTLRetries().getText();
        intValue = null;
        if (ttlRetries != null && !ttlRetries.trim().equals("")) {
            try {
                Integer val = Integer.parseInt(ttlRetries);
                if (val < 1 || val > 100) {
                    throw new NumberFormatException();
                }
                intValue = val;
            }
            catch (NumberFormatException e) {
                invalidValues.add(new InvalidValue(i18n.translateString("InvalidTTLRetries"), RbMBSTBridgingParameters.class, i18n.translateString("TTLRetries"), (Object)ttlRetries, (Object)this.panel.getNpuPanel().getDrapTTLRetries()));
            }
        }
        task.getNpuConfigEntry().setRbNpuDrapTtlRetries(intValue);
        task.getMBsBridgingParameters().setRbMBSTDrapTtlRetries(intValue);
        String temp = this.panel.getAuPanel().getTxtMaxCellRadius().getText();
        intValue = null;
        if (temp != null && !temp.trim().equals("")) {
            Integer value = null;
            try {
                value = Integer.parseInt(temp);
                if (value < 10 || value > 110) {
                    throw new NumberFormatException();
                }
                intValue = value;
            }
            catch (NumberFormatException e) {
                invalidValues.add(new InvalidValue(i18n.translateString("InvalidAuMaxCellRadius"), RbBsRadioParameters.class, i18n.translateString("MaxCellRadius"), (Object)temp, (Object)this.panel.getAuPanel().getTxtMaxCellRadius()));
            }
        }
        task.getBsAuMacParams().setRbAuMaxCellRadius(intValue);
        task.getMBsAuMacParams().setRbAuMaxCellRadius(intValue);
        Integer arqTemp = (Integer)FormUtil.getSelectedValue((JComboBox)this.panel.getAuPanel().getComboCfgARQState());
        task.getBsAuMacParams().setRbAuConfiguredARQState(arqTemp);
        task.getMBsAuMacParams().setRbAuConfiguredARQState(arqTemp);
        Integer uplinkTemp = (Integer)FormUtil.getSelectedValue((JComboBox)this.panel.getAuPanel().getComboBasicUplinkRate());
        task.getBsAuMultirateParams().setRbAuUlBasicRate(uplinkTemp);
        task.getMBsAuMultirateParams().setRbAuUlBasicRate(uplinkTemp);
        Integer downlinkTemp = (Integer)FormUtil.getSelectedValue((JComboBox)this.panel.getAuPanel().getComboBasicDownlinkRate());
        task.getBsAuMultirateParams().setRbAuDlBasicRate(downlinkTemp);
        task.getMBsAuMultirateParams().setRbAuDlBasicRate(downlinkTemp);
        String maxVoiceCalls = this.panel.getAuPanel().getTxtMaxNrOfVoiceCalls().getText();
        intValue = null;
        if (maxVoiceCalls != null && !maxVoiceCalls.trim().equals("")) {
            try {
                Integer max = Integer.parseInt(maxVoiceCalls);
                if (max < 0 || max > 300) {
                    throw new NumberFormatException();
                }
                intValue = max;
            }
            catch (NumberFormatException e) {
                invalidValues.add(new InvalidValue(i18n.translateString("InvalidAuMaxVoiceCalls"), RbBsRadioParameters.class, i18n.translateString("MaxVoiceCalls"), (Object)maxVoiceCalls, (Object)this.panel.getAuPanel().getTxtMaxNrOfVoiceCalls()));
            }
        }
        task.getAuConfigEntry().setRbAuMaxNumberOfCalls(intValue);
        task.getMBsAuAdditionalConfigParams().setRbMBSTMaxNumberOfCalls(intValue);
        task.getBsTrapConfigEntries().clear();
        RbTrapConfigTable trapCfgTbl = new RbTrapConfigTable(new ArrayList<RbTrapConfigEntry>());
        FormUtil.stopTableEditing((JTable)this.panel.getBsPanel().getBsGeneralPanel().getTblTraps());
        SimpleRowTableModel trapTblModel = (SimpleRowTableModel)this.panel.getBsPanel().getBsGeneralPanel().getTblTraps().getModel();
        for (int i = 0; i < trapTblModel.getRowCount(); ++i) {
            Integer trapEnable = (Integer)trapTblModel.getValueAt(i, 2);
            Integer trapSeverity = (Integer)trapTblModel.getValueAt(i, 3);
            Integer trapSuppressionInterval = (Integer)trapTblModel.getValueAt(i, 4);
            if (trapSuppressionInterval != null && (trapSuppressionInterval < 0 || trapSuppressionInterval > 86400)) {
                invalidValues.add(new InvalidValue(i18n.translateString("suppressionInterval", new Object[]{String.valueOf(i + 1)}), RbTrapConfigEntry.class, i18n.translateString("trapSuppressionInterval"), (Object)trapSuppressionInterval, null));
                continue;
            }
            Integer trapId = (Integer)trapTblModel.getValueAt(i, 0);
            if (null == trapEnable && null == trapSeverity && null == trapSuppressionInterval) continue;
            RbTrapConfigEntry entry = new RbTrapConfigEntry();
            if (trapId > 132 || trapId < 128) {
                entry.setTrapEnterprizeId(2);
                entry.setTrapId(trapId);
            } else {
                entry.setTrapEnterprizeId(1);
                entry.setTrapId(trapId - 128);
            }
            entry.setTrapEnable(trapEnable);
            entry.setTrapSeverity(trapSeverity);
            entry.setTrapSuppressionInterval(trapSuppressionInterval);
            trapCfgTbl.addEntry((TableRowMO)entry);
        }
        task.getBsTrapConfigEntries().addAll(trapCfgTbl.getEntries());
        if (this.panel.getBsPanel().getBsGeneralPanel().getChkAdminStatus().isSelected()) {
            task.setRestoreTrapsDefaultsAdmin(true);
        } else {
            task.setRestoreTrapsDefaultsAdmin(false);
        }
        if (this.panel.getBsPanel().getBsGeneralPanel().getChkSeverity().isSelected()) {
            task.setRestoreTrapsDefaultsSeverity(true);
        } else {
            task.setRestoreTrapsDefaultsSeverity(false);
        }
        if (this.panel.getBsPanel().getBsGeneralPanel().getChkSuppressionInterval().isSelected()) {
            task.setRestoreTrapsDefaultsSuppression(true);
        } else {
            task.setRestoreTrapsDefaultsSuppression(false);
        }
        task.getBsMACAddressDenyListEntries().clear();
        RbMACAddressDenyListTable table = new RbMACAddressDenyListTable(new ArrayList<RbMACAddressDenyListEntry>());
        FormUtil.stopTableEditing((JTable)this.panel.getBsPanel().getBsGeneralPanel().getTable2());
        SimpleRowTableModel modelMAC = this.panel.getBsPanel().getBsGeneralPanel().getTableModel();
        ArrayList<Integer> rowsToBeDeleted = new ArrayList<Integer>();
        block52: for (int i = 0; i < modelMAC.getRowCount(); ++i) {
            String macAddress = "";
            try {
                new MACAddressTranslator().convertToBeanValue(modelMAC.getValueAt(i, 0));
            }
            catch (Exception e) {
                invalidValues.add(new InvalidValue(i18n.translateString("macDenyInvalidMACAddress", new Object[]{String.valueOf(i + 1)}), RbMACAddressDenyListEntry.class, "MAC", modelMAC.getValueAt(i, 0), (Object)this));
                continue;
            }
            macAddress = MacAddress.fromString((String)((String)modelMAC.getValueAt(i, 0))).toOctetString();
            switch (modelMAC.getRowState(i)) {
                case 1: {
                    table.removeEntry(macAddress);
                    rowsToBeDeleted.add(i);
                    continue block52;
                }
                default: {
                    RbMACAddressDenyListEntry macDenyEntry = new RbMACAddressDenyListEntry();
                    macDenyEntry.setRbMACAddressDenyMacAddress(macAddress);
                    try {
                        table.addEntry((TableRowMO)macDenyEntry);
                        continue block52;
                    }
                    catch (DuplicateEntryException deea) {
                        invalidValues.add(new InvalidValue(i18n.translateString("entryAlreadyInTable"), RbMACAddressDenyListEntry.class, i18n.translateString("MACAddress"), modelMAC.getValueAt(i, 0), null));
                    }
                }
            }
        }
        this.removeRowsMarkedForDeletion(modelMAC, rowsToBeDeleted);
        if (this.panel.getBsPanel().getBsGeneralPanel().getRadioUnblock().isSelected()) {
            task.setMacDenyList(true);
        } else {
            task.setMacDenyList(false);
        }
        task.getBsMACAddressDenyListEntries().addAll(table.getEntries());
        boolean sgInsertSelected = this.panel.getBsPanel().getBsServiceGroups().getRadioSGInsert().isSelected();
        if (sgInsertSelected) {
            task.setServiceGroupToInsert(true);
        } else {
            task.setServiceGroupToInsert(false);
        }
        task.getBsServiceGroupEntries().clear();
        RbServiceGroupTable sgTable = new RbServiceGroupTable(new ArrayList<RbServiceGroupEntry>());
        ArrayList<String> sgNames = new ArrayList<String>();
        ArrayList<String> sgISPNames = new ArrayList<String>();
        FormUtil.stopTableEditing((JTable)this.panel.getBsPanel().getBsServiceGroups().getTblServiceGroups());
        ROTableModel modelSG = this.panel.getBsPanel().getBsServiceGroups().getTblServiceGroupsModel();
        rowsToBeDeleted.clear();
        for (int i = 0; i < modelSG.getRowCount(); ++i) {
            RbServiceGroupEntry sgEntry;
            String ispName;
            String sgName;
            block235: {
                sgName = (String)modelSG.getValueAt(i, 0);
                if (null == sgName || sgName.trim().equals("") || sgName.trim().length() > 32) {
                    invalidValues.add(new InvalidValue(i18n.translateString("NotNull", new Object[]{String.valueOf(i + 1)}), RbServiceGroupEntry.class, i18n.translateString("ServiceGroup"), (Object)sgName, (Object)this));
                    continue;
                }
                ispName = (String)modelSG.getValueAt(i, 1);
                if (ispName == null) {
                    ispName = "";
                }
                int nomadicity = (Integer)modelSG.getValueAt(i, 2);
                int type = (Integer)modelSG.getValueAt(i, 3);
                Integer relayMode = null == modelSG.getValueAt(i, 4) || modelSG.getValueAt(i, 4).equals("") ? null : (Integer)modelSG.getValueAt(i, 4);
                Integer vlanID = null == modelSG.getValueAt(i, 8) ? null : (Integer)modelSG.getValueAt(i, 8);
                String gateway = null == modelSG.getValueAt(i, 9) ? null : (String)modelSG.getValueAt(i, 9);
                String dhcpServerIp = null == modelSG.getValueAt(i, 7) ? null : (String)modelSG.getValueAt(i, 7);
                String giSubnet = null == modelSG.getValueAt(i, 6) ? null : (String)modelSG.getValueAt(i, 6);
                String giIP = null == modelSG.getValueAt(i, 5) ? null : (String)modelSG.getValueAt(i, 5);
                sgEntry = new RbServiceGroupEntry();
                sgEntry.setRbServiceGroupIndex(Long.valueOf(i + 11));
                sgEntry.setRbServiceGroupName(sgName);
                sgEntry.setRbServiceGroupIspDomainName(ispName);
                sgEntry.setRbServiceGroupNomadicity(nomadicity);
                sgEntry.setRbServiceGroupType(type);
                sgEntry.setRbServiceGroupRelayMode(relayMode);
                if (null != vlanID) {
                    sgEntry.setRbServiceGroupVlanId(vlanID);
                } else {
                    sgEntry.setRbServiceGroupVlanId(4095);
                }
                sgEntry.setRbServiceGroupGateway(gateway);
                sgEntry.setRbServiceGroupDhcpServerIp(dhcpServerIp);
                sgEntry.setRbServiceGroupGiSubnetMask(giSubnet);
                sgEntry.setRbServiceGroupGiIpAddress(giIP);
                if (ispName.trim().length() > 32) {
                    invalidValues.add(new InvalidValue(i18n.translateString("MaximLength", new Object[]{String.valueOf(i + 1)}), RbServiceGroupEntry.class, i18n.translateString("SGISPDomainName"), (Object)ispName, (Object)this));
                }
                if (sgNames.contains(sgName)) {
                    invalidValues.add(new InvalidValue(i18n.translateString("SGNameEntryAlreadyInTable"), RbServiceGroupEntry.class, i18n.translateString("ServiceGroup"), (Object)sgName, null));
                } else if (sgISPNames.contains(ispName) && sgInsertSelected) {
                    invalidValues.add(new InvalidValue(i18n.translateString("SGISPEntryAlreadyInTable"), RbServiceGroupEntry.class, i18n.translateString("SGISPDomainName"), (Object)ispName, null));
                } else if (null != relayMode && relayMode == 1) {
                    if (null != vlanID && (vlanID < 0 || vlanID > 4094)) {
                        invalidValues.add(new InvalidValue(i18n.translateString("ispDomainVLANIdRange"), RbServiceGroupEntry.class, i18n.translateString("VLANID"), (Object)vlanID, null));
                    }
                    if (gateway == null || gateway.equals("")) {
                        gateway = "0.0.0.0";
                    }
                    if (!gateway.trim().equals("0.0.0.0") && !IPv4Validator.isValidIp((String)gateway)) {
                        invalidValues.add(new InvalidValue(i18n.translateString("gatewayNotValid"), RbServiceGroupEntry.class, i18n.translateString("gateway"), (Object)gateway, null));
                    }
                    if (null == dhcpServerIp || !IPv4Validator.isValidIp((String)dhcpServerIp)) {
                        invalidValues.add(new InvalidValue(i18n.translateString("dhcpServerIpNotValid"), RbServiceGroupEntry.class, i18n.translateString("dhcpServerIp"), (Object)dhcpServerIp, null));
                    }
                    if (null == giSubnet || !IPv4Validator.isValidHostMask((String)giSubnet)) {
                        invalidValues.add(new InvalidValue(i18n.translateString("giSubnetNotValid"), RbServiceGroupEntry.class, i18n.translateString("giSubnet"), (Object)giSubnet, null));
                    }
                    if (null == giIP || !IPv4Validator.isValidIp((String)giIP)) {
                        invalidValues.add(new InvalidValue(i18n.translateString("giIPNotValid"), RbServiceGroupEntry.class, i18n.translateString("giIP"), (Object)giIP, null));
                    }
                    if (giIP == null || giIP.equals(dhcpServerIp) && (!giIP.equals("") || dhcpServerIp != null) && !dhcpServerIp.equals("")) {
                        invalidValues.add(new InvalidValue(i18n.translateString("SGTheSame"), RbServiceGroupEntry.class, i18n.translateString("dhcpServerIp"), (Object)dhcpServerIp, null));
                    }
                    if (gateway.trim().equals("0.0.0.0") && null != giIP && null != giSubnet && null != dhcpServerIp) {
                        try {
                            IpAddress IPAddress = new IpAddress(giIP.trim());
                            IpAddress serverSubnet = new IpAddress(giSubnet.trim());
                            IpAddress serverIP = new IpAddress(dhcpServerIp.trim());
                            IpAddressRange subnetRange = IpAddressRange.fromSubnet((IpAddress)IPAddress, (IpAddress)serverSubnet);
                            if (!subnetRange.contains(serverIP)) {
                                invalidValues.add(new InvalidValue(i18n.translateString("multipleInvalidIpRangeSubnet"), JTextField.class, i18n.translateString("dhcpServerIp"), (Object)dhcpServerIp, (Object)giIP));
                                break block235;
                            }
                            sgEntry.setRbServiceGroupGateway("0.0.0.0");
                        }
                        catch (IllegalArgumentException e) {}
                    }
                } else {
                    sgEntry.setRbServiceGroupVlanId(null);
                }
            }
            sgNames.add(sgName);
            sgISPNames.add(ispName);
            try {
                sgTable.addEntry((TableRowMO)sgEntry);
                continue;
            }
            catch (DuplicateEntryException deea) {
                invalidValues.add(new InvalidValue(i18n.translateString("entryAlreadyInTable"), RbServiceGroupEntry.class, i18n.translateString("ServiceGroup"), (Object)sgName, null));
            }
        }
        task.getBsServiceGroupEntries().addAll(sgTable.getEntries());
        task.getBsAuthorizedManagersEntries().clear();
        RbAuthorizedManagersTable authorizedManagersTable = new RbAuthorizedManagersTable(new ArrayList<RbAuthorizedManagersEntry>());
        FormUtil.stopTableEditing((JTable)this.panel.getNpuPanel().getTable2());
        SimpleRowTableModel modelAuth = this.panel.getNpuPanel().getTable2Model();
        block54: for (int i = 0; i < modelAuth.getRowCount(); ++i) {
            String ipAddr = (String)modelAuth.getValueAt(i, 0);
            if (ipAddr == null || !new IPAddressValidator().isValid((Object)ipAddr)) {
                invalidValues.add(new InvalidValue(i18n.translateString("authManagersInvalidIPAddress", new Object[]{String.valueOf(i + 1)}), RbAuthorizedManagersEntry.class, i18n.translateString("IPAddress"), (Object)ipAddr, null));
                continue;
            }
            logger.debug((Object)("Instance is :" + ipAddr));
            for (int k = 1; k < 3; ++k) {
                String strValue = (String)modelAuth.getValueAt(i, k);
                if (strValue != null) {
                    if (!strValue.equals("") && strValue.matches("^[A-Z,a-z,\\-,_,0-9,$~`!@#^&*()_+-=|{}\\[\\]\\'\\\\:;?/>.<\\\"\\% ]*$") && strValue.length() <= 23) continue;
                    if (k == 1) {
                        invalidValues.add(new InvalidValue(i18n.translateString("authManagersInvalidReadCommunities"), RbAuthorizedManagersEntry.class, "", (Object)"", null));
                        continue;
                    }
                    invalidValues.add(new InvalidValue(i18n.translateString("authManagersInvalidWriteCommunities"), RbAuthorizedManagersEntry.class, "", (Object)"", null));
                    continue;
                }
                if (k == 1) {
                    invalidValues.add(new InvalidValue(i18n.translateString("authManagersInvalidReadCommunities"), RbAuthorizedManagersEntry.class, "", (Object)"", null));
                    continue;
                }
                invalidValues.add(new InvalidValue(i18n.translateString("authManagersInvalidWriteCommunities"), RbAuthorizedManagersEntry.class, "", (Object)"", null));
            }
            switch (modelAuth.getRowState(i)) {
                case 1: {
                    authorizedManagersTable.removeEntry((String)modelAuth.getValueAt(i, 0));
                    rowsToBeDeleted.add(i);
                    continue block54;
                }
                default: {
                    RbAuthorizedManagersEntry entryAuth = new RbAuthorizedManagersEntry();
                    entryAuth.setAuthMngrIpAddr((String)modelAuth.getValueAt(i, 0));
                    entryAuth.setAuthMngrReadCommunity((String)modelAuth.getValueAt(i, 1));
                    entryAuth.setAuthMngrWriteCommunity((String)modelAuth.getValueAt(i, 2));
                    entryAuth.setAuthMngrTrapEnable(modelAuth.getValueAt(i, 3) == null || (Boolean)modelAuth.getValueAt(i, 3) == false ? 2 : 1);
                    try {
                        authorizedManagersTable.addEntry((TableRowMO)entryAuth);
                        continue block54;
                    }
                    catch (DuplicateEntryException dee) {
                        invalidValues.add(new InvalidValue(i18n.translateString("DuplicateEntry"), RbAuthorizedManagersEntry.class, "", (Object)"", null));
                    }
                }
            }
        }
        this.removeRowsMarkedForDeletion(modelAuth, rowsToBeDeleted);
        if (this.panel.getNpuPanel().getRadioDeny().isSelected()) {
            task.setManagersDenyList(true);
        } else {
            task.setManagersDenyList(false);
        }
        task.getBsAuthorizedManagersEntries().addAll(authorizedManagersTable.getEntries());
        task.getBsRadiusAuthServerParams().clear();
        RbRadiusAuthServerTable radiusAuthServer = new RbRadiusAuthServerTable(task.getBsRadiusAuthServerParams());
        FormUtil.stopTableEditing((JTable)this.panel.getBsPanel().getBsRadiusPanel().getTblAuthenticationServers());
        ROTableModel modelRadiusAuth = this.panel.getBsPanel().getBsRadiusPanel().getTblAuthenticationServersModel();
        if (this.checkSameIP((SimpleRowTableModel)modelRadiusAuth)) {
            invalidValues.add(new InvalidValue(i18n.translateString("TwoSameTypeServersError"), RbRadiusAuthServerEntry.class, i18n.translateString("AuthServer"), modelRadiusAuth.getValueAt(0, 0), null));
        }
        boolean[] radiusAuthToBeDeleted = new boolean[2];
        for (int i = 0; i < modelRadiusAuth.getRowCount(); ++i) {
            String ipAddr = (String)modelRadiusAuth.getValueAt(i, 0);
            String domainIpAddr = null == (String)modelRadiusAuth.getValueAt(i, 4) ? "" : (String)modelRadiusAuth.getValueAt(i, 4);
            String domainNetmask = null == (String)modelRadiusAuth.getValueAt(i, 5) ? "" : (String)modelRadiusAuth.getValueAt(i, 5);
            String domainGw = null == (String)modelRadiusAuth.getValueAt(i, 6) ? "" : (String)modelRadiusAuth.getValueAt(i, 6);
            Integer dPortAdopt = null == (Integer)modelRadiusAuth.getValueAt(i, 2) ? 2 : (Integer)modelRadiusAuth.getValueAt(i, 2);
            boolean toBeRemoved = (Boolean)modelRadiusAuth.getValueAt(i, 8);
            boolean isDataPortAdoptNo = false;
            if (Integer.valueOf(2).equals(dPortAdopt)) {
                isDataPortAdoptNo = true;
            }
            boolean plzCheckRowInput = false;
            if (!toBeRemoved) {
                if (!this.isNullOrEmpty(ipAddr)) {
                    plzCheckRowInput = true;
                }
                if (!this.isNullOrEmpty(domainIpAddr)) {
                    plzCheckRowInput = true;
                }
                if (!this.isNullOrEmpty(domainGw)) {
                    plzCheckRowInput = true;
                }
                if (!this.isNullOrEmpty(domainNetmask)) {
                    plzCheckRowInput = true;
                }
                if (!isDataPortAdoptNo) {
                    plzCheckRowInput = true;
                }
            }
            if (plzCheckRowInput && (this.isNullOrEmpty(ipAddr) || !IPv4Validator.isValidIp((String)ipAddr))) {
                invalidValues.add(new InvalidValue(i18n.translateString("WrongIpAddress"), RbRadiusAuthServerEntry.class, i18n.translateString("AuthServer"), (Object)(ipAddr == null ? "" : ipAddr), null));
            }
            if (isDataPortAdoptNo && plzCheckRowInput && (this.isNullOrEmpty(domainIpAddr) || !IPv4Validator.isValidIp((String)domainIpAddr))) {
                invalidValues.add(new InvalidValue(i18n.translateString("WrongIpAddress"), RbRadiusAuthServerEntry.class, i18n.translateString("RadiusIfCIPAddress"), (Object)(domainIpAddr == null ? "" : domainIpAddr), null));
            }
            if (domainGw == null || domainGw == "") {
                domainGw = "0.0.0.0";
            }
            if (!domainGw.trim().equals("0.0.0.0")) {
                if (isDataPortAdoptNo && plzCheckRowInput && !IPv4Validator.isValidIp((String)domainGw)) {
                    invalidValues.add(new InvalidValue(i18n.translateString("WrongIpAddress"), RbRadiusAccountServerEntry.class, i18n.translateString("RadiusServerGateway"), (Object)(domainGw == null ? "" : domainGw), null));
                }
            } else if (isDataPortAdoptNo && plzCheckRowInput) {
                try {
                    IpAddress ifcIPAddress = new IpAddress(domainIpAddr.trim());
                    IpAddress serverSubnet = new IpAddress(domainNetmask.trim());
                    IpAddress serverIP = new IpAddress(ipAddr.trim());
                    IpAddressRange subnetRange = IpAddressRange.fromSubnet((IpAddress)ifcIPAddress, (IpAddress)serverSubnet);
                    if (!subnetRange.contains(serverIP)) {
                        invalidValues.add(new InvalidValue(i18n.translateString("InvalidIpRangeSubnet"), JTextField.class, i18n.translateString("RadiusIfCIPAddress"), (Object)ipAddr, (Object)domainIpAddr));
                    }
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            if (isDataPortAdoptNo && plzCheckRowInput && (this.isNullOrEmpty(domainNetmask) || !IPv4Validator.isValidHostMask((String)domainNetmask))) {
                invalidValues.add(new InvalidValue(i18n.translateString("InvalidSubnetMask"), RbRadiusAuthServerEntry.class, i18n.translateString("RadiusServerSubnetMask"), (Object)(domainNetmask == null ? "" : domainNetmask), null));
            }
            if (plzCheckRowInput && domainIpAddr.equals(ipAddr) && (!domainIpAddr.equals("") && domainIpAddr != null || !ipAddr.equals("") && ipAddr != null)) {
                invalidValues.add(new InvalidValue(i18n.translateString("RadiusTheSame"), JTextField.class, i18n.translateString("RadiusIfCIPAddress"), (Object)ipAddr, (Object)domainIpAddr));
            }
            if (invalidValues.size() > 0) continue;
            RbRadiusAuthServerEntry radiusAuthEntry = null;
            switch (modelRadiusAuth.getRowState(i)) {
                default: 
            }
            if (toBeRemoved) {
                radiusAuthEntry = new RbRadiusAuthServerEntry();
                radiusAuthEntry.setRbRadiusAuthServerOperStatus(1);
                radiusAuthEntry.setRbRadiusAuthServerAddress("127.0.0." + i);
                if ("".equals(ipAddr)) {
                    radiusAuthEntry.setRbRadiusAuthServerGateway(null);
                } else {
                    radiusAuthEntry.setRbRadiusAuthServerGateway(ipAddr);
                }
                if (modelRadiusAuth.getValueAt(i, 7) != null) {
                    boolean isPrimary = (Boolean)modelRadiusAuth.getValueAt(i, 7);
                    radiusAuthEntry.setRbRadiusAuthServerType(isPrimary ? 1 : 2);
                } else {
                    radiusAuthEntry.setRbRadiusAuthServerType(2);
                }
                radiusAuthToBeDeleted[i] = toBeRemoved;
            }
            if (ipAddr != null && !ipAddr.equals("") && !toBeRemoved) {
                radiusAuthEntry = new RbRadiusAuthServerEntry();
                radiusAuthEntry.setRbRadiusAuthServerAddress(ipAddr);
                Object serverPortNumber = modelRadiusAuth.getValueAt(i, 1);
                Object dataPortAdopt = modelRadiusAuth.getValueAt(i, 2);
                Object vlanId = modelRadiusAuth.getValueAt(i, 3);
                Object ifcIpAddress = modelRadiusAuth.getValueAt(i, 4);
                Object subnetMask = modelRadiusAuth.getValueAt(i, 5);
                Object gw = modelRadiusAuth.getValueAt(i, 6);
                radiusAuthEntry.setRbRadiusAuthServerPortNumber((Integer)serverPortNumber);
                radiusAuthEntry.setRbRadiusAuthDataPortAdopt((Integer)dataPortAdopt);
                radiusAuthEntry.setRbRadiusAuthServerVlanId((Integer)vlanId);
                radiusAuthEntry.setRbRadiusAuthServerIfcIpAddress((String)ifcIpAddress);
                radiusAuthEntry.setRbRadiusAuthServerSubnetMask((String)subnetMask);
                radiusAuthEntry.setRbRadiusAuthServerGateway((String)gw);
                if (modelRadiusAuth.getValueAt(i, 7) != null) {
                    boolean isPrimary = (Boolean)modelRadiusAuth.getValueAt(i, 7);
                    radiusAuthEntry.setRbRadiusAuthServerType(isPrimary ? 1 : 2);
                } else {
                    radiusAuthEntry.setRbRadiusAuthServerType(2);
                }
            }
            if (radiusAuthEntry == null) continue;
            try {
                radiusAuthServer.addEntry((TableRowMO)radiusAuthEntry);
                continue;
            }
            catch (DuplicateEntryException dee) {
                // empty catch block
            }
        }
        task.setRadiusAuthToBeDeleted(radiusAuthToBeDeleted);
        task.getBsRadiusAuthServerParams().addAll(radiusAuthServer.getEntries());
        boolean[] radiusAccToBeDeleted = new boolean[2];
        task.getBsRadiusAccServerParams().clear();
        RbRadiusAccountServerTable radiusAccServer = new RbRadiusAccountServerTable(task.getBsRadiusAccServerParams());
        FormUtil.stopTableEditing((JTable)this.panel.getBsPanel().getBsRadiusPanel().getTblAccountingServers());
        ROTableModel modelRadiusAcc = this.panel.getBsPanel().getBsRadiusPanel().getTblAccountingServersModel();
        if (this.checkSameIP((SimpleRowTableModel)modelRadiusAcc)) {
            invalidValues.add(new InvalidValue(i18n.translateString("TwoSameTypeServersError"), RbRadiusAccountServerEntry.class, i18n.translateString("AccServer"), modelRadiusAcc.getValueAt(0, 0), null));
        }
        for (int i = 0; i < modelRadiusAcc.getRowCount(); ++i) {
            String ipAddr = null == (String)modelRadiusAcc.getValueAt(i, 0) ? "" : (String)modelRadiusAcc.getValueAt(i, 0);
            String domainIpAddr = null == (String)modelRadiusAcc.getValueAt(i, 4) ? "" : (String)modelRadiusAcc.getValueAt(i, 4);
            String domainNetmask = null == (String)modelRadiusAcc.getValueAt(i, 5) ? "" : (String)modelRadiusAcc.getValueAt(i, 5);
            String domainGw = null == (String)modelRadiusAcc.getValueAt(i, 6) ? "" : (String)modelRadiusAcc.getValueAt(i, 6);
            boolean toBeRemoved = (Boolean)modelRadiusAcc.getValueAt(i, 8);
            Integer dPortAdopt = null == (Integer)modelRadiusAcc.getValueAt(i, 2) ? 2 : (Integer)modelRadiusAcc.getValueAt(i, 2);
            boolean isDataPortAdoptNo = false;
            if (Integer.valueOf(2).equals(dPortAdopt)) {
                isDataPortAdoptNo = true;
            }
            boolean plzCheckRowInput = false;
            if (!toBeRemoved) {
                if (!this.isNullOrEmpty(ipAddr)) {
                    plzCheckRowInput = true;
                }
                if (!this.isNullOrEmpty(domainIpAddr)) {
                    plzCheckRowInput = true;
                }
                if (!this.isNullOrEmpty(domainGw)) {
                    plzCheckRowInput = true;
                }
                if (!this.isNullOrEmpty(domainNetmask)) {
                    plzCheckRowInput = true;
                }
                if (!isDataPortAdoptNo) {
                    plzCheckRowInput = true;
                }
            }
            if (plzCheckRowInput && (this.isNullOrEmpty(ipAddr) || !IPv4Validator.isValidIp((String)ipAddr))) {
                invalidValues.add(new InvalidValue(i18n.translateString("WrongIpAddress"), RbRadiusAccountServerEntry.class, i18n.translateString("AccServer"), (Object)(ipAddr == null ? "" : ipAddr), null));
            }
            if (isDataPortAdoptNo && plzCheckRowInput && (this.isNullOrEmpty(domainIpAddr) || !IPv4Validator.isValidIp((String)domainIpAddr))) {
                invalidValues.add(new InvalidValue(i18n.translateString("WrongIpAddress"), RbRadiusAccountServerEntry.class, i18n.translateString("RadiusIfCIPAddress"), (Object)(domainIpAddr == null ? "" : domainIpAddr), null));
            }
            if (domainGw == null || domainGw == "") {
                domainGw = "0.0.0.0";
            }
            if (!domainGw.trim().equals("0.0.0.0")) {
                if (isDataPortAdoptNo && plzCheckRowInput && !IPv4Validator.isValidIp((String)domainGw)) {
                    invalidValues.add(new InvalidValue(i18n.translateString("WrongIpAddress"), RbRadiusAccountServerEntry.class, i18n.translateString("RadiusServerGateway"), (Object)(domainGw == null ? "" : domainGw), null));
                }
            } else if (isDataPortAdoptNo && plzCheckRowInput) {
                try {
                    IpAddress ifcIPAddress = new IpAddress(domainIpAddr.trim());
                    IpAddress serverSubnet = new IpAddress(domainNetmask.trim());
                    IpAddress serverIP = new IpAddress(ipAddr.trim());
                    IpAddressRange subnetRange = IpAddressRange.fromSubnet((IpAddress)ifcIPAddress, (IpAddress)serverSubnet);
                    if (!subnetRange.contains(serverIP)) {
                        invalidValues.add(new InvalidValue(i18n.translateString("InvalidIpRangeSubnet"), JTextField.class, i18n.translateString("RadiusIfCIPAddress"), (Object)ipAddr, (Object)domainIpAddr));
                    }
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            if (isDataPortAdoptNo && plzCheckRowInput && (this.isNullOrEmpty(domainNetmask) || !IPv4Validator.isValidHostMask((String)domainNetmask))) {
                invalidValues.add(new InvalidValue(i18n.translateString("InvalidSubnetMask"), RbRadiusAccountServerEntry.class, i18n.translateString("RadiusServerSubnetMask"), (Object)(domainNetmask == null ? "" : domainNetmask), null));
            }
            if (plzCheckRowInput && domainIpAddr.equals(ipAddr) && (!domainIpAddr.equals("") && domainIpAddr != null || !ipAddr.equals("") && ipAddr != null)) {
                invalidValues.add(new InvalidValue(i18n.translateString("RadiusTheSame"), JTextField.class, i18n.translateString("RadiusIfCIPAddress"), (Object)ipAddr, (Object)domainIpAddr));
            }
            if (invalidValues.size() > 0) continue;
            RbRadiusAccountServerEntry radiusAccEntry = null;
            switch (modelRadiusAcc.getRowState(i)) {
                default: 
            }
            if (toBeRemoved) {
                radiusAccEntry = new RbRadiusAccountServerEntry();
                radiusAccEntry.setRbRadiusAcctServerOperStatus(1);
                radiusAccEntry.setRbRadiusAcctServerAddress("127.0.0." + i);
                if ("".equals(ipAddr)) {
                    radiusAccEntry.setRbRadiusAcctServerGateway(null);
                } else {
                    radiusAccEntry.setRbRadiusAcctServerGateway(ipAddr);
                }
                if (modelRadiusAcc.getValueAt(i, 7) != null) {
                    boolean isPrimary = (Boolean)modelRadiusAcc.getValueAt(i, 7);
                    radiusAccEntry.setRbRadiusAcctServerType(isPrimary ? 1 : 2);
                } else {
                    radiusAccEntry.setRbRadiusAcctServerType(2);
                }
                radiusAccToBeDeleted[i] = toBeRemoved;
            }
            if (ipAddr != null && !ipAddr.equals("") && !toBeRemoved) {
                radiusAccEntry = new RbRadiusAccountServerEntry();
                radiusAccEntry.setRbRadiusAcctServerAddress(ipAddr);
                radiusAccEntry.setRbRadiusAcctServerPortNumber((Integer)modelRadiusAcc.getValueAt(i, 1));
                radiusAccEntry.setRbRadiusAcctDataPortAdopt((Integer)modelRadiusAcc.getValueAt(i, 2));
                radiusAccEntry.setRbRadiusAcctServerVlanId((Integer)modelRadiusAcc.getValueAt(i, 3));
                radiusAccEntry.setRbRadiusAcctServerIfcIpAddress((String)modelRadiusAcc.getValueAt(i, 4));
                radiusAccEntry.setRbRadiusAcctServerSubnetMask((String)modelRadiusAcc.getValueAt(i, 5));
                radiusAccEntry.setRbRadiusAcctServerGateway((String)modelRadiusAcc.getValueAt(i, 6));
                if (modelRadiusAcc.getValueAt(i, 7) != null) {
                    boolean isPrimary = (Boolean)modelRadiusAcc.getValueAt(i, 7);
                    radiusAccEntry.setRbRadiusAcctServerType(isPrimary ? 1 : 2);
                } else {
                    radiusAccEntry.setRbRadiusAcctServerType(2);
                }
            }
            if (radiusAccEntry == null) continue;
            try {
                radiusAccServer.addEntry((TableRowMO)radiusAccEntry);
                continue;
            }
            catch (DuplicateEntryException dee) {
                // empty catch block
            }
        }
        task.setRadiusAccToBeDeleted(radiusAccToBeDeleted);
        task.getBsRadiusAccServerParams().addAll(radiusAccServer.getEntries());
        if (this.panel.getServicePanel().getChkL2().isSelected()) {
            task.setDfltL2ServiceProfileIsNull(true);
            task.setDfltServiceProfile(null);
        } else {
            task.setDfltServiceProfile(this.panel.getServicePanel().getTxtL2DefaultServiceProfile().getText());
            task.setServiceType(this.panel.getServicePanel().getTxtL2Type().getText());
            task.setDfltL2ServiceProfileIsNull(false);
        }
        if (this.panel.getServicePanel().getChkPPPoE().isSelected()) {
            task.setDfltPPPoEServiceProfile(null);
            task.setDfltPPPoEServiceProfileIsNull(true);
        } else {
            task.setDfltPPPoEServiceProfileIsNull(false);
            task.setServicePPPoEType(this.panel.getServicePanel().getTxtPPPoEType().getText());
            task.setDfltPPPoEServiceProfile(this.panel.getServicePanel().getTxtPPPoEDefaultServiceProfile().getText());
        }
        if (this.panel.getNpuCommandsPanel().getRadioNone().isSelected()) {
            task.setCommand(0);
        }
        if (this.panel.getNpuCommandsPanel().getRadioReset().isSelected()) {
            task.setCommand(1);
        }
        if (this.panel.getNpuCommandsPanel().getRadioResetAndShadow().isSelected()) {
            task.setCommand(2);
        }
        MultipleConfigTaskVoiceDomainConfigPanel bsVoiceDomainPanel = this.panel.getBsPanel().getBsVoiceDomain();
        String voiceDomainName = bsVoiceDomainPanel.getTxtVoiceDomainName().getText().trim();
        String pfServerIPAddress = bsVoiceDomainPanel.getTxtServerIPAddress().getText().trim();
        String pfDomainIp = bsVoiceDomainPanel.getDomainIPAddressTxt().getText().trim();
        String pfDomainSubnet = bsVoiceDomainPanel.getDomainSubnetTxt().getText().trim();
        String pfDomainGateway = bsVoiceDomainPanel.getDomainGatewayTxt().getText().trim();
        int adoptDataport = bsVoiceDomainPanel.getAdoptDataPortCombo().getSelectedIndex() + 1;
        boolean plzCheck = false;
        if (!this.isNullOrEmpty(voiceDomainName)) {
            plzCheck = true;
        }
        if (!this.isNullOrEmpty(pfServerIPAddress)) {
            plzCheck = true;
        }
        if (!this.isNullOrEmpty(pfDomainIp)) {
            plzCheck = true;
        }
        if (!this.isNullOrEmpty(pfDomainSubnet)) {
            plzCheck = true;
        }
        if (!this.isNullOrEmpty(pfDomainGateway)) {
            plzCheck = true;
        }
        if (adoptDataport == 2) {
            plzCheck = true;
        }
        if (voiceDomainName != null && voiceDomainName.length() != 0) {
            if (voiceDomainName.length() > 32) {
                invalidValues.add(new InvalidValue(i18n.translateString("NameLengthBetwen1And32"), JTextField.class, i18n.translateString("VoiceDomainName"), (Object)voiceDomainName, (Object)bsVoiceDomainPanel.getTxtVoiceDomainName()));
            }
            if (pfServerIPAddress == null || pfServerIPAddress.length() == 0) {
                invalidValues.add(new InvalidValue(i18n.translateString("MustDefineIPForVoiceDomain"), JTextField.class, i18n.translateString("IPAddress"), (Object)pfServerIPAddress, (Object)bsVoiceDomainPanel.getTxtServerIPAddress()));
            }
            task.setVoiceDomainName(voiceDomainName);
        } else if (plzCheck) {
            invalidValues.add(new InvalidValue(i18n.translateString("NameLengthBetwen1And32"), JTextField.class, i18n.translateString("VoiceDomainName"), (Object)voiceDomainName, (Object)bsVoiceDomainPanel.getTxtVoiceDomainName()));
        } else {
            task.setVoiceDomainName(null);
        }
        if (pfServerIPAddress != null && pfServerIPAddress.length() != 0) {
            if (!IPv4Validator.isIp((String)pfServerIPAddress)) {
                invalidValues.add(new InvalidValue(i18n.translateString("InvalidIpAddress"), JTextField.class, i18n.translateString("IPAddress"), (Object)pfServerIPAddress, (Object)bsVoiceDomainPanel.getTxtServerIPAddress()));
            } else if (pfServerIPAddress.startsWith("0.")) {
                invalidValues.add(new InvalidValue(i18n.translateString("IPsThatStartsWith0AreNotAllowed"), JTextField.class, i18n.translateString("IPAddress"), (Object)pfServerIPAddress, (Object)bsVoiceDomainPanel.getTxtServerIPAddress()));
            }
            task.setPfServerIPAddress(pfServerIPAddress);
        } else if (plzCheck) {
            invalidValues.add(new InvalidValue(i18n.translateString("InvalidIpAddress"), JTextField.class, i18n.translateString("IPAddress"), (Object)pfServerIPAddress, (Object)bsVoiceDomainPanel.getTxtServerIPAddress()));
        } else {
            task.setPfServerIPAddress(null);
        }
        String udpPortString = bsVoiceDomainPanel.getTxtUDPPort().getText();
        if (udpPortString != null && udpPortString.trim().length() != 0) {
            try {
                Integer udpPortInteger = Integer.valueOf(udpPortString);
                if (udpPortInteger < 1 || udpPortInteger > 65535) {
                    invalidValues.add(new InvalidValue(i18n.translateString("ValueBetween", new Object[]{1, 65535}), JTextField.class, i18n.translateString("udpPort"), (Object)udpPortString, (Object)bsVoiceDomainPanel.getTxtUDPPort()));
                }
                task.setPfServerUdpPort(udpPortInteger);
            }
            catch (NumberFormatException nfe) {
                invalidValues.add(new InvalidValue(i18n.translateString("NotANumber"), JTextField.class, i18n.translateString("udpPort"), (Object)udpPortString, (Object)bsVoiceDomainPanel.getTxtUDPPort()));
            }
        } else if (plzCheck) {
            task.setPfServerUdpPort(1812);
        } else {
            task.setPfServerUdpPort(null);
        }
        String vlanIdString = bsVoiceDomainPanel.getTxtVLANId().getText();
        if (vlanIdString != null && vlanIdString.trim().length() != 0) {
            try {
                Integer vlanIdInteger = Integer.valueOf(vlanIdString);
                if (vlanIdInteger < 0 || vlanIdInteger > 4094) {
                    invalidValues.add(new InvalidValue(i18n.translateString("ValueBetween", new Object[]{0, 4094}), JTextField.class, i18n.translateString("VLANId"), (Object)vlanIdString, (Object)bsVoiceDomainPanel.getTxtVLANId()));
                }
                task.setPfServerVlanId(vlanIdInteger);
            }
            catch (NumberFormatException nfe) {
                invalidValues.add(new InvalidValue(i18n.translateString("NotANumber"), JTextField.class, i18n.translateString("VLANId"), (Object)vlanIdString, (Object)bsVoiceDomainPanel.getTxtVLANId()));
            }
        } else {
            task.setPfServerVlanId(4095);
        }
        String sharedString = String.valueOf(bsVoiceDomainPanel.getTxtSharedSecret().getPassword());
        String retypeSharedString = String.valueOf(bsVoiceDomainPanel.getTxtRetypeSharedSecret().getPassword());
        if (plzCheck && pfServerIPAddress != null && pfServerIPAddress.length() > 0 && (sharedString.length() > 32 || sharedString.length() == 0)) {
            invalidValues.add(new InvalidValue(i18n.translateString("LengthBetween1_32"), JTextField.class, i18n.translateString("SharedSecret"), (Object)"...", (Object)bsVoiceDomainPanel.getTxtSharedSecret()));
        } else if (!sharedString.equals(retypeSharedString)) {
            invalidValues.add(new InvalidValue(i18n.translateString("SharedAndRetypeMustBeSame"), JTextField.class, i18n.translateString("SharedSecret"), (Object)"...", (Object)bsVoiceDomainPanel.getTxtSharedSecret()));
        }
        if (sharedString.length() > 0) {
            task.setPfServerSharedSecret(sharedString);
        } else {
            task.setPfServerSharedSecret(null);
        }
        task.setPfAdoptDataPort(adoptDataport);
        if (pfDomainIp != null && pfDomainIp.length() != 0) {
            if (!IPv4Validator.isIp((String)pfDomainIp)) {
                invalidValues.add(new InvalidValue(i18n.translateString("ifCIPAddress"), JTextField.class, i18n.translateString("IPAddress"), (Object)pfDomainIp, (Object)bsVoiceDomainPanel.getDomainIPAddressTxt()));
            } else if (pfDomainIp.startsWith("0.")) {
                invalidValues.add(new InvalidValue(i18n.translateString("IPsThatStartsWith0AreNotAllowed"), JTextField.class, i18n.translateString("IPAddress"), (Object)pfDomainIp, (Object)bsVoiceDomainPanel.getDomainIPAddressTxt()));
            }
            task.setPfDomainIpAddress(pfDomainIp);
        } else if (adoptDataport == 2) {
            invalidValues.add(new InvalidValue(i18n.translateString("MandatoryDomainIpAddress"), JTextField.class, i18n.translateString("ifCIPAddress"), (Object)pfDomainIp, (Object)bsVoiceDomainPanel.getDomainIPAddressTxt()));
        } else {
            task.setPfDomainIpAddress(null);
        }
        if (pfDomainSubnet != null && pfDomainSubnet.length() != 0) {
            if (!IPv4Validator.isValidHostMask((String)pfDomainSubnet)) {
                invalidValues.add(new InvalidValue(i18n.translateString("InvalidSubnetMask"), JTextField.class, i18n.translateString("ifCSubnetMask"), (Object)pfDomainSubnet, (Object)bsVoiceDomainPanel.getDomainSubnetTxt()));
            }
            task.setPfDomainSubnet(pfDomainSubnet);
        } else if (adoptDataport == 2) {
            invalidValues.add(new InvalidValue(i18n.translateString("MandatoryDomainSubnet"), JTextField.class, i18n.translateString("ifCSubnetMask"), (Object)pfDomainSubnet, (Object)bsVoiceDomainPanel.getDomainSubnetTxt()));
        } else {
            task.setPfDomainSubnet(null);
            task.setPfDomainGateway(null);
        }
        if (pfDomainGateway == null || pfDomainGateway == "") {
            pfDomainGateway = "0.0.0.0";
        }
        if (!pfDomainGateway.trim().equals("0.0.0.0") && !pfDomainGateway.trim().equals("")) {
            if (!IPv4Validator.isIp((String)pfDomainGateway)) {
                invalidValues.add(new InvalidValue(i18n.translateString("ifCIPAddress"), JTextField.class, i18n.translateString("IPAddress"), (Object)pfDomainGateway, (Object)bsVoiceDomainPanel.getDomainGatewayTxt()));
            } else {
                task.setPfDomainGateway(pfDomainGateway);
            }
        } else {
            try {
                IpAddress ifcIPAddress = new IpAddress(pfDomainIp.trim());
                IpAddress serverSubnet = new IpAddress(pfDomainSubnet.trim());
                IpAddress serverIP = new IpAddress(pfServerIPAddress.trim());
                IpAddressRange subnetRange = IpAddressRange.fromSubnet((IpAddress)ifcIPAddress, (IpAddress)serverSubnet);
                if (!subnetRange.contains(serverIP)) {
                    invalidValues.add(new InvalidValue(i18n.translateString("InvalidIpRangeSubnet"), JTextField.class, i18n.translateString("RadiusIfCIPAddress"), (Object)pfDomainIp, (Object)pfServerIPAddress));
                } else {
                    task.setPfDomainGateway("0.0.0.0");
                }
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if (plzCheck && pfDomainIp.equals(pfServerIPAddress) && (!pfDomainIp.equals("") && pfDomainIp != null || !pfServerIPAddress.equals("") && pfServerIPAddress != null)) {
            invalidValues.add(new InvalidValue(i18n.translateString("VDTheSame"), JTextField.class, i18n.translateString("RadiusIfCIPAddress"), (Object)pfDomainIp, (Object)pfServerIPAddress));
        }
        invalidValues.addAll(super.configureEntity((Serializable)entity));
        return invalidValues;
    }

    private boolean checkSameIP(SimpleRowTableModel model) {
        boolean result = false;
        String ip1 = (String)model.getValueAt(0, 0);
        String ip2 = (String)model.getValueAt(1, 0);
        if (ip1 != null && ip2 != null && ip1.equals(ip2) && ip1.length() != 0) {
            result = true;
        }
        return result;
    }

    private void removeRowsMarkedForDeletion(SimpleRowTableModel model, List<Integer> rowsToBeDeleted) {
        for (int nr = rowsToBeDeleted.size(); nr > 0; --nr) {
            model.removeRow(rowsToBeDeleted.get(nr - 1).intValue());
        }
        rowsToBeDeleted.clear();
    }

    private void actionSelectBaseStations() {
        SelectorView selectorView = Selectors.getSelectorView(RbBaseStationEquipment.class, null);
        SelectorUtil.displayModalSelector((JComponent)this.panel, (SelectorView)selectorView);
        List selection = selectorView.getSelection();
        for (RbBaseStationEquipment bsEq : selection) {
            this.addBSToModel(bsEq, true);
            if (!(bsEq instanceof RbBS)) continue;
            RbBS bs = (RbBS)bsEq;
            try {
                Assembly assesbly = ServiceRegistry.getEntityManagerService().get(RbBS.class, bs.getId(), "allCards");
                for (RbAU au : ((RbBS)((Object)assesbly.getEntity())).getManagedAUs()) {
                    this.addEquipmentToModel(au, bs, true);
                }
            }
            catch (ServiceException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    private void actionRemoveEquipment() {
        TreePath[] selectionPaths = this.panel.getTreeTableEquipment().getTree().getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length == 0) {
            return;
        }
        this.panel.getTreeTableEquipment().getTree().getCellEditor().stopCellEditing();
        for (TreePath selectionPath : selectionPaths) {
            EqTreeNode selNode = (EqTreeNode)selectionPath.getLastPathComponent();
            this.equipmentTreeTableModel.removeNode(selNode);
        }
    }

    private void loadEquipment(RbBSMultipleConfigTask task) {
        if (0L == task.getId()) {
            for (Equipment eq : task.getEquipments()) {
                RbBaseStationEquipment bsEq = (RbBaseStationEquipment)eq;
                this.addBSToModel(bsEq, true);
                if (!(bsEq instanceof RbBS)) continue;
                RbBS bs = (RbBS)bsEq;
                try {
                    Assembly assesbly = ServiceRegistry.getEntityManagerService().get(RbBS.class, bs.getId(), "allCards");
                    for (RbAU au : ((RbBS)((Object)assesbly.getEntity())).getManagedAUs()) {
                        this.addEquipmentToModel(au, bs, true);
                    }
                }
                catch (ServiceException e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
        } else {
            for (MultipleConfigWeakAssociation assoc : task.getManagedEntityWeakAssociation()) {
                Equipment equipment = (Equipment)assoc.getEntity();
                if (equipment != null) {
                    if (equipment instanceof RbBaseStationEquipment) {
                        this.addBSToModel((RbBaseStationEquipment)equipment, assoc.isSelected());
                        continue;
                    }
                    this.addEquipmentToModel(equipment, this.getManagerBS(equipment), assoc.isSelected());
                    continue;
                }
                logger.debug((Object)("WeakAssociation with id " + assoc.getId() + " no longer points to anything"));
            }
        }
    }

    private boolean isEquipmentMissing(long id) {
        try {
            LightQuery query = new LightQuery(Equipment.class);
            query.addParameter("id", (Object)new Integer((int)id));
            List sps = ServiceRegistry.getEntityManagerService().retrieveByQuery(query);
            if (null == sps || sps.isEmpty()) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        return false;
    }

    private boolean saveEquipment(RbBSMultipleConfigTask task) {
        boolean ret = false;
        List eqNodes = this.equipmentTreeTableModel.getNodes();
        ArrayList<MultipleConfigWeakAssociation> associations = new ArrayList<MultipleConfigWeakAssociation>(eqNodes.size());
        for (EqTreeNode eqNode : eqNodes) {
            EqTreeNodeValue eqValue = eqNode.getValue();
            MultipleConfigWeakAssociation assoc = new MultipleConfigWeakAssociation((ManagedEntity)eqValue.getEquipment(), eqValue.isSelected());
            associations.add(assoc);
            ret |= eqValue.isSelected();
        }
        task.setManagedEntityWeakAssociation(associations);
        return ret;
    }

    private RbBaseStationEquipment getManagerBS(Equipment equipment) {
        if (equipment instanceof RbAU) {
            return ((RbAU)equipment).getManagerBS();
        }
        if (equipment instanceof RbSU) {
            return ((RbSU)equipment).getManagerBS();
        }
        return null;
    }

    private void addBSToModel(RbBaseStationEquipment bs, boolean selected) {
        EqTreeNode bsNode = this.equipmentTreeTableModel.getNode((Equipment)bs);
        if (bsNode != null) {
            this.equipmentTreeTableModel.updateNode(bsNode, (Equipment)bs, 1, selected);
            return;
        }
        EqTreeNode rootNode = this.equipmentTreeTableModel.getRoot();
        bsNode = this.newEqTreeNode(rootNode, bs, 1, true, selected);
        this.equipmentTreeTableModel.addNode(rootNode, bsNode);
        this.makeNodeVisible((TreeNode)bsNode);
    }

    private void addEquipmentToModel(Equipment equipment, RbBaseStationEquipment managerBS, boolean selected) {
        EqTreeNode eqNode = this.equipmentTreeTableModel.getNode(equipment);
        int equipmentType = this.getEquipmentType(equipment);
        if (eqNode != null) {
            this.equipmentTreeTableModel.updateNode(eqNode, equipment, equipmentType, selected);
            return;
        }
        if (managerBS == null) {
            logger.warn((Object)("Equipment with id = " + equipment.getId() + " of type " + equipment.getClass().getName() + " does not have a manager BS."));
            EqTreeNode rootNode = this.equipmentTreeTableModel.getRoot();
            eqNode = this.newEqTreeNode(rootNode, equipment, equipmentType, false, false);
            this.equipmentTreeTableModel.addNode(rootNode, eqNode);
        } else {
            EqTreeNode bsNode = this.equipmentTreeTableModel.getNode((Equipment)managerBS);
            if (bsNode == null) {
                EqTreeNode rootNode = this.equipmentTreeTableModel.getRoot();
                bsNode = this.newEqTreeNode(rootNode, managerBS, 1, true, true);
                this.equipmentTreeTableModel.addNode(rootNode, bsNode);
            }
            eqNode = this.newEqTreeNode(bsNode, equipment, equipmentType, true, selected);
            this.equipmentTreeTableModel.addNode(bsNode, eqNode);
        }
        this.makeNodeVisible((TreeNode)eqNode);
    }

    private EqTreeNode newEqTreeNode(EqTreeNode parentNode, Equipment equipment, int equipmentType, boolean selectable, boolean selected) {
        EqTreeNodeValue eqValue = new EqTreeNodeValue(equipment, equipment.getName(), equipmentType, selectable);
        eqValue.setSelected(selected);
        EqTreeNode eqNode = new EqTreeNode(parentNode, eqValue);
        return eqNode;
    }

    private int getEquipmentType(Equipment equipment) {
        if (equipment instanceof RbBaseStationEquipment) {
            return 1;
        }
        if (equipment instanceof RbAU) {
            return 2;
        }
        if (equipment instanceof RbSU) {
            return 3;
        }
        return -1;
    }

    private void makeNodeVisible(TreeNode node) {
        TreePath nodePath;
        JTree tree = this.panel.getTreeTableEquipment().getTree();
        if (!tree.isVisible(nodePath = this.equipmentTreeTableModel.getTreePath(node))) {
            tree.makeVisible(nodePath);
        }
    }

    public String getApplicationPermission() {
        return "Av:ConfigureTasks";
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.multiple_bs_params";
    }

    boolean isNullOrEmpty(String val) {
        boolean ret = false;
        if (null == val) {
            ret = true;
        } else if (val.length() == 0) {
            ret = true;
        }
        return ret;
    }
}

