/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.multipleconfiguration;

import com.bwanms.command.NetworkElementCommand;
import com.bwanms.domain.logic.ConfigurationHelper;
import com.bwanms.domain.logic.Helpers;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.mediation.MediationServiceRegistry;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.TableRowMO;
import com.bwanms.model.Equipment;
import com.bwanms.model.ManagedEntityBase;
import com.bwanms.model.MultipleConfigWeakAssociation;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.persistence.Datastore;
import com.bwanms.persistence.RunnableDatastoreDecorator;
import com.bwanms.rb.mo.RbAuConfigEntry;
import com.bwanms.rb.mo.RbAuConfigTable;
import com.bwanms.rb.mo.RbAuMacParametersGroup;
import com.bwanms.rb.mo.RbAuMultirateParametersGroup;
import com.bwanms.rb.mo.RbAuPhyParametersGroup;
import com.bwanms.rb.mo.RbAuthorizedManagersEntry;
import com.bwanms.rb.mo.RbAuthorizedManagersTable;
import com.bwanms.rb.mo.RbBSClockConfigParameters;
import com.bwanms.rb.mo.RbBsIpIfConfigEntry;
import com.bwanms.rb.mo.RbBsIpIfConfigTable;
import com.bwanms.rb.mo.RbBsRFModeParameters;
import com.bwanms.rb.mo.RbBsRadioParameters;
import com.bwanms.rb.mo.RbChainConfig;
import com.bwanms.rb.mo.RbMACAddressDenyListEntry;
import com.bwanms.rb.mo.RbMACAddressDenyListTable;
import com.bwanms.rb.mo.RbMBSTAdditionalConfigParameters;
import com.bwanms.rb.mo.RbMBSTBridgingParameters;
import com.bwanms.rb.mo.RbMbstIpIfConfigEntry;
import com.bwanms.rb.mo.RbMbstIpIfConfigTable;
import com.bwanms.rb.mo.RbMbstMacParametersGroup;
import com.bwanms.rb.mo.RbMbstMultirateParametersGroup;
import com.bwanms.rb.mo.RbMbstPhyParametersGroup;
import com.bwanms.rb.mo.RbNpuBridgingParameters;
import com.bwanms.rb.mo.RbNpuConfigEntry;
import com.bwanms.rb.mo.RbNpuConfigTable;
import com.bwanms.rb.mo.RbRadiusAccountServerEntry;
import com.bwanms.rb.mo.RbRadiusAccountServerTable;
import com.bwanms.rb.mo.RbRadiusAuthServerEntry;
import com.bwanms.rb.mo.RbRadiusAuthServerTable;
import com.bwanms.rb.mo.RbRadiusClientGeneralParameters;
import com.bwanms.rb.mo.RbTrapConfigEntry;
import com.bwanms.rb.mo.RbTrapConfigTable;
import com.bwanms.rb.mo.services.RbDfltServiceTemplateEntry;
import com.bwanms.rb.mo.services.RbDfltServiceTemplateTable;
import com.bwanms.rb.mo.services.RbServiceGroupEntry;
import com.bwanms.rb.mo.services.RbServiceGroupTable;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigEntry;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigTable;
import com.bwanms.rb.model.RbAU;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbMBS;
import com.bwanms.rb.model.RbNPU;
import com.bwanms.rb.tasks.multipleconfiguration.RbMultipleConfigTask;
import com.bwanms.util.version.VersionFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cascade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class RbBSMultipleConfigTask
extends RbMultipleConfigTask {
    private static final Logger log = Logger.getLogger(RbBSMultipleConfigTask.class);
    public static final int COMMAND_NONE = 0;
    public static final int COMMAND_RESET = 1;
    public static final int COMMAND_RESET_AND_RUN_FROM_SHADOW = 2;
    private boolean isTDD;
    private boolean restoreTrapsDefaultsAdmin;
    private boolean restoreTrapsDefaultsSeverity;
    private boolean restoreTrapsDefaultsSuppression;
    private String dfltL2ServiceProfile;
    private String dfltPPPoEServiceProfile;
    private boolean dfltL2ServiceProfileIsNull;
    private boolean dfltPPPoEServiceProfileIsNull;
    private boolean isMacDenyList;
    private boolean isManagersDenyList;
    private boolean isServiceGroupToInsert;
    private List<RbTrapConfigEntry> bsTrapConfigEntries;
    private List<RbMACAddressDenyListEntry> bsMACAddressDenyListEntries;
    private RbBsRadioParameters bsRadioParameters;
    private RbRadiusClientGeneralParameters bsRadiusClientParameters;
    private RbBSClockConfigParameters bsClockConfigParameters;
    private RbBsRFModeParameters bsRFModeParameters;
    private List<RbRadiusAuthServerEntry> bsRadiusAuthServerParams;
    private List<RbRadiusAccountServerEntry> bsRadiusAccServerParams;
    private boolean[] radiusAuthToBeDeleted;
    private boolean[] radiusAccToBeDeleted;
    private List<RbBsIpIfConfigEntry> bsIpIfConfigEntries;
    private List<RbAuthorizedManagersEntry> bsAuthorizedManagersEntries;
    private RbNpuBridgingParameters bsNpuBridgingParameters;
    private List<RbMbstIpIfConfigEntry> mBsIpIfConfigEntries;
    private RbMBSTBridgingParameters mBsBridgingParameters;
    private RbAuMacParametersGroup bsAuMacParams;
    private RbAuPhyParametersGroup bsAuPhyParams;
    private RbAuMultirateParametersGroup bsAuMultirateParams;
    private RbMbstMacParametersGroup mBsAuMacParams;
    private RbMbstPhyParametersGroup mBsAuPhyParams;
    private RbMbstMultirateParametersGroup mBsAuMultirateParams;
    private RbMBSTAdditionalConfigParameters mBsAuAdditionalConfigParams;
    private RbAuConfigEntry auConfigEntry;
    private RbNpuConfigEntry npuConfigEntry;
    private String servicePPPoEType;
    private String voiceDomainName;
    private String pfServerIPAddress;
    private Integer pfServerUdpPort;
    private Integer pfServerVlanId;
    private String pfServerSharedSecret;
    private String pfDomainIpAddress;
    private String pfDomainSubnet;
    private String pfDomainGateway;
    private Integer pfAdoptDataPort;
    private boolean isFromVoiceDomainViewer = false;
    private boolean isFromServiceGroupViewer = false;
    private List<RbServiceGroupEntry> bsServiceGroupEntries;
    private String serviceType;
    private Map<Long, Boolean> bsMap;
    private Map<Long, boolean[]> auMap;

    public String getServicePPPoEType() {
        return this.servicePPPoEType;
    }

    public void setServicePPPoEType(String servicePPPoEType) {
        this.servicePPPoEType = servicePPPoEType;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    @Column(name="RestoreTrapsDfltAdmin")
    public boolean getRestoreTrapsDefaultsAdmin() {
        return this.restoreTrapsDefaultsAdmin;
    }

    public void setRestoreTrapsDefaultsAdmin(boolean restoreTrapsDefaultsAdmin) {
        this.restoreTrapsDefaultsAdmin = restoreTrapsDefaultsAdmin;
    }

    @Column(name="RestoreTrapsDfltSev")
    public boolean getRestoreTrapsDefaultsSeverity() {
        return this.restoreTrapsDefaultsSeverity;
    }

    public void setRestoreTrapsDefaultsSeverity(boolean restoreTrapsDefaultsSeverity) {
        this.restoreTrapsDefaultsSeverity = restoreTrapsDefaultsSeverity;
    }

    @Column(name="RestoreTrapsDfltSuppr")
    public boolean getRestoreTrapsDefaultsSuppression() {
        return this.restoreTrapsDefaultsSuppression;
    }

    public void setRestoreTrapsDefaultsSuppression(boolean restoreTrapsDefaultsSuppression) {
        this.restoreTrapsDefaultsSuppression = restoreTrapsDefaultsSuppression;
    }

    public boolean isMacDenyList() {
        return this.isMacDenyList;
    }

    public void setMacDenyList(boolean isMacDenyList) {
        this.isMacDenyList = isMacDenyList;
    }

    public boolean isManagersDenyList() {
        return this.isManagersDenyList;
    }

    public void setManagersDenyList(boolean isManagersDenyList) {
        this.isManagersDenyList = isManagersDenyList;
    }

    public boolean isServiceGroupToInsert() {
        return this.isServiceGroupToInsert;
    }

    public void setServiceGroupToInsert(boolean isServiceGroupList) {
        this.isServiceGroupToInsert = isServiceGroupList;
    }

    public String getDfltServiceProfile() {
        return this.dfltL2ServiceProfile;
    }

    public void setDfltServiceProfile(String dfltServiceProfile) {
        this.dfltL2ServiceProfile = dfltServiceProfile;
    }

    public String getDfltPPPoEServiceProfile() {
        return this.dfltPPPoEServiceProfile;
    }

    public void setDfltPPPoEServiceProfile(String dfltPPPoEServiceProfile) {
        this.dfltPPPoEServiceProfile = dfltPPPoEServiceProfile;
    }

    public boolean isDfltL2ServiceProfileIsNull() {
        return this.dfltL2ServiceProfileIsNull;
    }

    public void setDfltL2ServiceProfileIsNull(boolean dfltL2ServiceProfileIsNull) {
        this.dfltL2ServiceProfileIsNull = dfltL2ServiceProfileIsNull;
    }

    public boolean isDfltPPPoEServiceProfileIsNull() {
        return this.dfltPPPoEServiceProfileIsNull;
    }

    public void setDfltPPPoEServiceProfileIsNull(boolean dfltPPPoEServiceProfileIsNull) {
        this.dfltPPPoEServiceProfileIsNull = dfltPPPoEServiceProfileIsNull;
    }

    public String getPfServerIPAddress() {
        return this.pfServerIPAddress;
    }

    public void setPfServerIPAddress(String pfServerIPAddress) {
        this.pfServerIPAddress = pfServerIPAddress;
    }

    public String getVoiceDomainName() {
        return this.voiceDomainName;
    }

    public void setVoiceDomainName(String voiceDomainName) {
        this.voiceDomainName = voiceDomainName;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(table=@Table(name="RbBSMltplCfg_RadiusAuth"))
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<RbRadiusAuthServerEntry> getBsRadiusAuthServerParams() {
        if (null == this.bsRadiusAuthServerParams) {
            this.bsRadiusAuthServerParams = new ArrayList<RbRadiusAuthServerEntry>();
        }
        return this.bsRadiusAuthServerParams;
    }

    public void setBsRadiusAuthServerParams(List<RbRadiusAuthServerEntry> radiusAuthServerParameters) {
        this.bsRadiusAuthServerParams = radiusAuthServerParameters;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(table=@Table(name="RbBSMltplCfg_RadiusAcc"))
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<RbRadiusAccountServerEntry> getBsRadiusAccServerParams() {
        if (null == this.bsRadiusAccServerParams) {
            this.bsRadiusAccServerParams = new ArrayList<RbRadiusAccountServerEntry>();
        }
        return this.bsRadiusAccServerParams;
    }

    public void setBsRadiusAccServerParams(List<RbRadiusAccountServerEntry> bsRadiusAccServerParameters) {
        this.bsRadiusAccServerParams = bsRadiusAccServerParameters;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(table=@Table(name="RbBSMltplCfg_MACAddressDeny"))
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<RbMACAddressDenyListEntry> getBsMACAddressDenyListEntries() {
        if (null == this.bsMACAddressDenyListEntries) {
            this.bsMACAddressDenyListEntries = new ArrayList<RbMACAddressDenyListEntry>();
        }
        return this.bsMACAddressDenyListEntries;
    }

    public void setBsMACAddressDenyListEntries(List<RbMACAddressDenyListEntry> bsMACAddressDenyListEntries) {
        this.bsMACAddressDenyListEntries = bsMACAddressDenyListEntries;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(table=@Table(name="RbBSMltplCfg_TrapConfig"))
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<RbTrapConfigEntry> getBsTrapConfigEntries() {
        if (null == this.bsTrapConfigEntries) {
            this.bsTrapConfigEntries = new ArrayList<RbTrapConfigEntry>();
        }
        return this.bsTrapConfigEntries;
    }

    public void setBsTrapConfigEntries(List<RbTrapConfigEntry> bsTrapConfigEntries) {
        this.bsTrapConfigEntries = bsTrapConfigEntries;
    }

    @OneToOne(cascade={CascadeType.ALL})
    public RbBsRadioParameters getBsRadioParameters() {
        if (null == this.bsRadioParameters) {
            this.bsRadioParameters = new RbBsRadioParameters();
        }
        return this.bsRadioParameters;
    }

    public void setBsRadioParameters(RbBsRadioParameters bsRadioParameters) {
        this.bsRadioParameters = bsRadioParameters;
    }

    @OneToOne(cascade={CascadeType.ALL})
    public RbBsRFModeParameters getBsRFModeParameters() {
        if (null == this.bsRFModeParameters) {
            this.bsRFModeParameters = new RbBsRFModeParameters();
        }
        return this.bsRFModeParameters;
    }

    public void setBsRFModeParameters(RbBsRFModeParameters bsRFModeParameters) {
        this.bsRFModeParameters = bsRFModeParameters;
    }

    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="bsRadiusClGenParams_id")
    public RbRadiusClientGeneralParameters getBsRadiusClientGeneralParameters() {
        if (null == this.bsRadiusClientParameters) {
            this.bsRadiusClientParameters = new RbRadiusClientGeneralParameters();
        }
        return this.bsRadiusClientParameters;
    }

    public void setBsRadiusClientGeneralParameters(RbRadiusClientGeneralParameters bsRadiusClientParameters) {
        this.bsRadiusClientParameters = bsRadiusClientParameters;
    }

    @OneToOne(cascade={CascadeType.ALL})
    public RbBSClockConfigParameters getBsClockConfigParameters() {
        if (null == this.bsClockConfigParameters) {
            this.bsClockConfigParameters = new RbBSClockConfigParameters();
        }
        return this.bsClockConfigParameters;
    }

    public void setBsClockConfigParameters(RbBSClockConfigParameters bsClockConfigParameters) {
        this.bsClockConfigParameters = bsClockConfigParameters;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(table=@Table(name="RbBSMltplCfg_AuthMgrs"))
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<RbAuthorizedManagersEntry> getBsAuthorizedManagersEntries() {
        if (null == this.bsAuthorizedManagersEntries) {
            this.bsAuthorizedManagersEntries = new ArrayList<RbAuthorizedManagersEntry>();
        }
        return this.bsAuthorizedManagersEntries;
    }

    public void setBsAuthorizedManagersEntries(List<RbAuthorizedManagersEntry> bsAuthorizedManagersEntries) {
        this.bsAuthorizedManagersEntries = bsAuthorizedManagersEntries;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(table=@Table(name="RbBSMltplCfg_BSIpIfCfg"))
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<RbBsIpIfConfigEntry> getBsIpIfConfigEntries() {
        if (null == this.bsIpIfConfigEntries) {
            this.bsIpIfConfigEntries = new ArrayList<RbBsIpIfConfigEntry>();
        }
        return this.bsIpIfConfigEntries;
    }

    public void setBsIpIfConfigEntries(List<RbBsIpIfConfigEntry> bsIpIfConfigEntries) {
        this.bsIpIfConfigEntries = bsIpIfConfigEntries;
    }

    @OneToOne(cascade={CascadeType.ALL})
    public RbNpuBridgingParameters getBsNpuBridgingParameters() {
        if (null == this.bsNpuBridgingParameters) {
            this.bsNpuBridgingParameters = new RbNpuBridgingParameters();
        }
        return this.bsNpuBridgingParameters;
    }

    public void setBsNpuBridgingParameters(RbNpuBridgingParameters bsNpuBridgingParameters) {
        this.bsNpuBridgingParameters = bsNpuBridgingParameters;
    }

    @OneToOne(cascade={CascadeType.ALL})
    public RbMBSTBridgingParameters getMBsBridgingParameters() {
        if (null == this.mBsBridgingParameters) {
            this.mBsBridgingParameters = new RbMBSTBridgingParameters();
        }
        return this.mBsBridgingParameters;
    }

    public void setMBsBridgingParameters(RbMBSTBridgingParameters bsBridgingParameters) {
        this.mBsBridgingParameters = bsBridgingParameters;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(table=@Table(name="RbBSMltplCfg_MBSIpIfCfg"))
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<RbMbstIpIfConfigEntry> getMBsIpIfConfigEntries() {
        if (null == this.mBsIpIfConfigEntries) {
            this.mBsIpIfConfigEntries = new ArrayList<RbMbstIpIfConfigEntry>();
        }
        return this.mBsIpIfConfigEntries;
    }

    public void setMBsIpIfConfigEntries(List<RbMbstIpIfConfigEntry> bsIpIfConfigEntries) {
        this.mBsIpIfConfigEntries = bsIpIfConfigEntries;
    }

    @OneToOne(cascade={CascadeType.ALL})
    public RbAuMacParametersGroup getBsAuMacParams() {
        if (null == this.bsAuMacParams) {
            this.bsAuMacParams = new RbAuMacParametersGroup();
        }
        return this.bsAuMacParams;
    }

    public void setBsAuMacParams(RbAuMacParametersGroup bsAuMacParams) {
        this.bsAuMacParams = bsAuMacParams;
    }

    @OneToOne(cascade={CascadeType.ALL})
    public RbAuMultirateParametersGroup getBsAuMultirateParams() {
        if (null == this.bsAuMultirateParams) {
            this.bsAuMultirateParams = new RbAuMultirateParametersGroup();
        }
        return this.bsAuMultirateParams;
    }

    public void setBsAuMultirateParams(RbAuMultirateParametersGroup bsAuMultirateParams) {
        this.bsAuMultirateParams = bsAuMultirateParams;
    }

    @OneToOne(cascade={CascadeType.ALL})
    public RbAuPhyParametersGroup getBsAuPhyParams() {
        if (null == this.bsAuPhyParams) {
            this.bsAuPhyParams = new RbAuPhyParametersGroup();
        }
        return this.bsAuPhyParams;
    }

    public void setBsAuPhyParams(RbAuPhyParametersGroup bsAuPhyParams) {
        this.bsAuPhyParams = bsAuPhyParams;
    }

    @OneToOne(cascade={CascadeType.ALL})
    public RbMBSTAdditionalConfigParameters getMBsAuAdditionalConfigParams() {
        if (null == this.mBsAuAdditionalConfigParams) {
            this.mBsAuAdditionalConfigParams = new RbMBSTAdditionalConfigParameters();
        }
        return this.mBsAuAdditionalConfigParams;
    }

    public void setMBsAuAdditionalConfigParams(RbMBSTAdditionalConfigParameters bsAuAdditionalConfigParams) {
        this.mBsAuAdditionalConfigParams = bsAuAdditionalConfigParams;
    }

    @OneToOne(cascade={CascadeType.ALL})
    public RbMbstMacParametersGroup getMBsAuMacParams() {
        if (null == this.mBsAuMacParams) {
            this.mBsAuMacParams = new RbMbstMacParametersGroup();
        }
        return this.mBsAuMacParams;
    }

    public void setMBsAuMacParams(RbMbstMacParametersGroup bsAuMacParams) {
        this.mBsAuMacParams = bsAuMacParams;
    }

    @OneToOne(cascade={CascadeType.ALL})
    public RbMbstMultirateParametersGroup getMBsAuMultirateParams() {
        if (null == this.mBsAuMultirateParams) {
            this.mBsAuMultirateParams = new RbMbstMultirateParametersGroup();
        }
        return this.mBsAuMultirateParams;
    }

    public void setMBsAuMultirateParams(RbMbstMultirateParametersGroup bsAuMultirateParams) {
        this.mBsAuMultirateParams = bsAuMultirateParams;
    }

    @OneToOne(cascade={CascadeType.ALL})
    public RbMbstPhyParametersGroup getMBsAuPhyParams() {
        if (null == this.mBsAuPhyParams) {
            this.mBsAuPhyParams = new RbMbstPhyParametersGroup();
        }
        return this.mBsAuPhyParams;
    }

    public void setMBsAuPhyParams(RbMbstPhyParametersGroup bsAuPhyParams) {
        this.mBsAuPhyParams = bsAuPhyParams;
    }

    @OneToOne(cascade={CascadeType.ALL})
    public RbAuConfigEntry getAuConfigEntry() {
        if (null == this.auConfigEntry) {
            this.auConfigEntry = new RbAuConfigEntry();
        }
        return this.auConfigEntry;
    }

    public void setAuConfigEntry(RbAuConfigEntry entry) {
        this.auConfigEntry = entry;
    }

    @OneToOne(cascade={CascadeType.ALL})
    public RbNpuConfigEntry getNpuConfigEntry() {
        if (null == this.npuConfigEntry) {
            this.npuConfigEntry = new RbNpuConfigEntry();
        }
        return this.npuConfigEntry;
    }

    public void setNpuConfigEntry(RbNpuConfigEntry ttlEntry) {
        this.npuConfigEntry = ttlEntry;
    }

    @Override
    @Transient
    protected List<ConfigFormManagedObjectRequest> getManagedObjectRequests(Equipment equipment) {
        this.checkInitSelectedMaps();
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        RbBaseStationEquipment bs = (RbBaseStationEquipment)equipment;
        if (this.bsMap.get(equipment.getId()).booleanValue()) {
            ret.addAll(this.getBSManagedObjectRequests(bs));
            ret.addAll(this.getNPUManagedObjectRequests(bs));
        }
        if (bs instanceof RbBS) {
            boolean[] equipmentAUs = this.auMap.get(equipment.getId());
            if (equipmentAUs != null) {
                for (int i = 1; i <= 9; ++i) {
                    if (!equipmentAUs[i - 1]) continue;
                    ret.addAll(this.getAUManagedObjectRequests(bs, "AU." + i));
                    if (i != 4) continue;
                    i += 2;
                }
            }
        } else {
            ret.addAll(this.getAUManagedObjectRequests(bs, "BS"));
        }
        return ret;
    }

    @Transient
    private List<ConfigFormManagedObjectRequest> getBSManagedObjectRequests(RbBaseStationEquipment bs) {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.createRequest(bs.getId(), "BS", RbBsRadioParameters.class));
        ret.add(this.createRequest(bs.getId(), "BS", RbTrapConfigTable.class));
        ret.add(this.createRequest(bs.getId(), "BS", RbMACAddressDenyListTable.class));
        this.isTDD = VersionFactory.getInstance().createVersion(bs.getRunningSoftwareVersion()).compareTo((Object)VersionFactory.getInstance().createVersion("4.0")) >= 0;
        if (this.isTDD) {
            ret.add(this.createRequest(bs.getId(), "BS", RbRadiusClientGeneralParameters.class));
            ret.add(this.createRequest(bs.getId(), "BS", RbChainConfig.class));
            ret.add(this.createRequest(bs.getId(), "BS", RbBSClockConfigParameters.class));
            ret.add(this.createRequest(bs.getId(), "BS", RbBsRFModeParameters.class));
            ret.add(this.createRequest(bs.getId(), "BS", RbRadiusAuthServerTable.class));
            ret.add(this.createRequest(bs.getId(), "BS", RbRadiusAccountServerTable.class));
        }
        return ret;
    }

    @Transient
    public List<ConfigFormManagedObjectRequest> getNPUManagedObjectRequests(RbBaseStationEquipment bs) {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        if (bs instanceof RbBS) {
            ret.add(this.createRequest(bs.getId(), "BS", RbBsIpIfConfigTable.class));
            ret.add(this.createRequest(bs.getId(), "BS", RbAuthorizedManagersTable.class));
            ret.add(this.createRequest(bs.getId(), "BS", RbNpuBridgingParameters.class));
            ret.add(this.createRequest(bs.getId(), "BS", RbNpuConfigTable.class));
        } else if (bs instanceof RbMBS) {
            ret.add(this.createRequest(bs.getId(), "BS", RbMbstIpIfConfigTable.class));
            ret.add(this.createRequest(bs.getId(), "BS", RbAuthorizedManagersTable.class));
            ret.add(this.createRequest(bs.getId(), "BS", RbMBSTBridgingParameters.class));
        }
        return ret;
    }

    @Transient
    private List<ConfigFormManagedObjectRequest> getAUManagedObjectRequests(RbBaseStationEquipment bs, String attribute) {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        if (bs instanceof RbBS) {
            ret.add(this.createRequest(bs.getId(), attribute, RbAuMacParametersGroup.class));
            ret.add(this.createRequest(bs.getId(), attribute, RbAuPhyParametersGroup.class));
            ret.add(this.createRequest(bs.getId(), attribute, RbAuMultirateParametersGroup.class));
            ret.add(this.createRequest(bs.getId(), "BS", RbAuConfigTable.class));
        } else if (bs instanceof RbMBS) {
            ret.add(this.createRequest(bs.getId(), attribute, RbMbstMacParametersGroup.class));
            ret.add(this.createRequest(bs.getId(), attribute, RbMbstPhyParametersGroup.class));
            ret.add(this.createRequest(bs.getId(), attribute, RbMbstMultirateParametersGroup.class));
            ret.add(this.createRequest(bs.getId(), attribute, RbMBSTAdditionalConfigParameters.class));
        }
        return ret;
    }

    @Override
    @Transient
    protected synchronized List<ManagedObject> getValueObjectMOs(Equipment equipment) {
        this.checkInitSelectedMaps();
        ArrayList<ManagedObject> mosList = new ArrayList<ManagedObject>();
        mosList.addAll(this.getBsManagedObjects(equipment));
        mosList.addAll(this.getNpuManagedObjects(equipment));
        mosList.addAll(this.getAuManagedObjects(equipment));
        return mosList;
    }

    @Transient
    private List<ManagedObject> getBsManagedObjects(Equipment equipment) {
        ArrayList<ManagedObject> bsManagedObjects = new ArrayList<ManagedObject>();
        bsManagedObjects.add((ManagedObject)this.getBsRadioParameters());
        bsManagedObjects.add((ManagedObject)new RbTrapConfigTable(this.getBsTrapConfigEntries()));
        bsManagedObjects.add((ManagedObject)new RbMACAddressDenyListTable(this.getBsMACAddressDenyListEntries()));
        if (((RbBaseStationEquipment)equipment).isTDDDuplexMode()) {
            bsManagedObjects.add((ManagedObject)this.getBsRadiusClientGeneralParameters());
            bsManagedObjects.add((ManagedObject)this.getBsClockConfigParameters());
            bsManagedObjects.add((ManagedObject)this.getBsRFModeParameters());
            bsManagedObjects.add((ManagedObject)new RbRadiusAuthServerTable(this.getBsRadiusAuthServerParams()));
            bsManagedObjects.add((ManagedObject)new RbRadiusAccountServerTable(this.getBsRadiusAccServerParams()));
        }
        return bsManagedObjects;
    }

    @Transient
    private List<ManagedObject> getNpuManagedObjects(Equipment equipment) {
        boolean bs = equipment instanceof RbBS;
        ArrayList<ManagedObject> npuManagedObjects = new ArrayList<ManagedObject>();
        if (bs) {
            npuManagedObjects.add((ManagedObject)new RbBsIpIfConfigTable(this.getBsIpIfConfigEntries()));
            npuManagedObjects.add((ManagedObject)new RbAuthorizedManagersTable(this.getBsAuthorizedManagersEntries()));
            npuManagedObjects.add((ManagedObject)this.getBsNpuBridgingParameters());
            npuManagedObjects.add((ManagedObject)this.createBsNpuConfigEntries((RbBS)equipment));
        } else {
            npuManagedObjects.add((ManagedObject)new RbMbstIpIfConfigTable(this.getMBsIpIfConfigEntries()));
            npuManagedObjects.add((ManagedObject)new RbAuthorizedManagersTable(this.getBsAuthorizedManagersEntries()));
            npuManagedObjects.add((ManagedObject)this.getMBsBridgingParameters());
        }
        return npuManagedObjects;
    }

    @Transient
    private List<ManagedObject> getAuManagedObjects(Equipment equipment) {
        boolean bs = equipment instanceof RbBS;
        ArrayList<ManagedObject> auManagedObjects = new ArrayList<ManagedObject>();
        if (bs) {
            auManagedObjects.add((ManagedObject)this.getBsAuMacParams());
            auManagedObjects.add((ManagedObject)this.getBsAuPhyParams());
            auManagedObjects.add((ManagedObject)this.getBsAuMultirateParams());
            auManagedObjects.add((ManagedObject)this.createBsAuConfigEntries((RbBS)equipment));
        } else {
            auManagedObjects.add((ManagedObject)this.getMBsAuMacParams());
            auManagedObjects.add((ManagedObject)this.getMBsAuPhyParams());
            auManagedObjects.add((ManagedObject)this.getMBsAuMultirateParams());
            auManagedObjects.add((ManagedObject)this.getMBsAuAdditionalConfigParams());
        }
        return auManagedObjects;
    }

    private RbNpuConfigTable createBsNpuConfigEntries(RbBS bs) {
        RbNpuConfigTable ret = new RbNpuConfigTable(new ArrayList<RbNpuConfigEntry>());
        RbNpuConfigEntry npuTTLEntry = new RbNpuConfigEntry();
        npuTTLEntry.setRbNpuDrapTtlRetries(this.npuConfigEntry.getRbNpuDrapTtlRetries());
        npuTTLEntry.setRbSlotNumber(5);
        ret.addEntry((TableRowMO)npuTTLEntry);
        return ret;
    }

    private RbAuConfigTable createBsAuConfigEntries(RbBS bs) {
        RbAuConfigTable ret = new RbAuConfigTable(new ArrayList<RbAuConfigEntry>());
        boolean[] bsAUs = this.auMap.get(bs.getId());
        if (bsAUs != null) {
            for (int i = 0; i < bsAUs.length; ++i) {
                if (!bsAUs[i]) continue;
                RbAuConfigEntry entry = new RbAuConfigEntry();
                entry.setRbAuMaxNumberOfCalls(this.auConfigEntry.getRbAuMaxNumberOfCalls());
                entry.setRbSlotNumber(i + 1);
                ret.addEntry((TableRowMO)entry);
            }
        }
        return ret;
    }

    @Override
    protected boolean shouldProcessEquipment(Equipment nextEquipment) {
        if (!(nextEquipment instanceof RbBaseStationEquipment)) {
            return false;
        }
        this.checkInitSelectedMaps();
        boolean tmp = false;
        boolean[] aus = this.auMap.get(nextEquipment.getId());
        if (aus != null) {
            for (int i = 0; i < aus.length; ++i) {
                tmp = tmp || aus[i];
            }
        }
        return this.bsMap.get(nextEquipment.getId()) != false || tmp;
    }

    @Override
    protected String sendCommand(final Equipment equipment) {
        this.checkInitSelectedMaps();
        boolean ret = true;
        final ArrayList<Object> eqCommand = new ArrayList<Object>();
        final ArrayList retServicesFailed = new ArrayList();
        if (equipment instanceof RbBS) {
            if (equipment instanceof RbBS) {
                new RunnableDatastoreDecorator(new Runnable(){

                    public void run() {
                        RbNPU npu;
                        boolean[] equipmentAUs;
                        RbBS temp = (RbBS)((Object)Datastore.session().get(RbBS.class, (Serializable)Long.valueOf(equipment.getId())));
                        RbBSMultipleConfigTask.this.serviceProfile(equipment, temp, retServicesFailed);
                        if (RbBSMultipleConfigTask.this.getRestoreTrapsDefaultsAdmin()) {
                            eqCommand.add(temp.createTrapsRestoreCommand(1));
                        }
                        if (RbBSMultipleConfigTask.this.getRestoreTrapsDefaultsSeverity()) {
                            eqCommand.add(temp.createTrapsRestoreCommand(2));
                        }
                        if (RbBSMultipleConfigTask.this.getRestoreTrapsDefaultsSuppression()) {
                            eqCommand.add(temp.createTrapsRestoreCommand(3));
                        }
                        if ((equipmentAUs = (boolean[])RbBSMultipleConfigTask.this.auMap.get(equipment.getId())) != null) {
                            for (int i = 1; i <= 9; ++i) {
                                if (equipmentAUs[i - 1]) {
                                    switch (RbBSMultipleConfigTask.this.getCommand()) {
                                        case 1: {
                                            eqCommand.add(temp.findAuBySlotNumber(i).createResetCommand());
                                            break;
                                        }
                                        case 2: {
                                            eqCommand.add(temp.findAuBySlotNumber(i).createResetAndRunFromShadowCommand(null));
                                        }
                                    }
                                }
                                if (i != 4) continue;
                                i += 2;
                            }
                        }
                        if (((Boolean)RbBSMultipleConfigTask.this.bsMap.get(equipment.getId())).booleanValue() && (npu = temp.getRunningNPU()) != null) {
                            switch (RbBSMultipleConfigTask.this.getCommand()) {
                                case 1: {
                                    eqCommand.add(npu.createResetCommand());
                                    break;
                                }
                                case 2: {
                                    eqCommand.add(npu.createResetAndRunFromShadowCommand());
                                }
                            }
                        }
                    }
                }).run();
            }
        } else {
            new RunnableDatastoreDecorator(new Runnable(){

                public void run() {
                    RbMBS temp = (RbMBS)((Object)Datastore.session().get(RbMBS.class, (Serializable)Long.valueOf(equipment.getId())));
                    RbBSMultipleConfigTask.this.serviceProfile(equipment, temp, retServicesFailed);
                }
            }).run();
            if (this.getRestoreTrapsDefaultsAdmin()) {
                eqCommand.add(((RbMBS)equipment).createTrapsRestoreCommand(1));
            }
            if (this.getRestoreTrapsDefaultsSeverity()) {
                eqCommand.add(((RbMBS)equipment).createTrapsRestoreCommand(2));
            }
            if (this.getRestoreTrapsDefaultsSuppression()) {
                eqCommand.add(((RbMBS)equipment).createTrapsRestoreCommand(3));
            }
            switch (this.getCommand()) {
                case 1: {
                    eqCommand.add(((RbMBS)equipment).createResetCommand());
                    break;
                }
                case 2: {
                    eqCommand.add(((RbMBS)equipment).createResetAndRunFromShadowCommand());
                }
            }
        }
        String errorMessage = null;
        if (eqCommand != null) {
            for (NetworkElementCommand networkElementCommand : eqCommand) {
                if (this.fireCommand(equipment, networkElementCommand)) continue;
                errorMessage = new String("");
            }
        }
        if (!retServicesFailed.isEmpty()) {
            errorMessage = new String("serviceProfileNotDeployedOnEquipment");
        }
        return errorMessage;
    }

    private void serviceProfile(Equipment equipment, RbBaseStationEquipment temp, List<Object> retServicesFailed) {
        ConfigurationHelper cfgHelper;
        RbDfltServiceTemplateTable serviceTable;
        RbServiceTemplateConfigEntry entry;
        RbServiceTemplateConfigTable serviceProfileTable;
        RbDfltServiceTemplateTable serviceTable2;
        if (this.isDfltPPPoEServiceProfileIsNull()) {
            serviceTable2 = (RbDfltServiceTemplateTable)((RbDfltServiceTemplateTable)temp.findCurrentConfiguration().findManagedObject("BS", RbDfltServiceTemplateTable.class)).clone();
            RbDfltServiceTemplateEntry PPPoE = (RbDfltServiceTemplateEntry)serviceTable2.findEntry("2");
            PPPoE.setRbDfltServiceTemplateIdx(new Long(0L));
            try {
                ConfigurationHelper cfgHelper2 = Helpers.getConfigurationHelper();
                cfgHelper2.updateCurrentConfiguration(equipment.getId(), (ManagedObject)serviceTable2);
            }
            catch (Exception e) {}
        } else if (this.getDfltPPPoEServiceProfile() != null && !this.getDfltPPPoEServiceProfile().equals("")) {
            serviceProfileTable = (RbServiceTemplateConfigTable)((RbServiceTemplateConfigTable)temp.findCurrentConfiguration().findManagedObject("BS", RbServiceTemplateConfigTable.class)).clone();
            entry = serviceProfileTable.findEntryByName(this.getDfltPPPoEServiceProfile());
            if (entry != null) {
                serviceTable = (RbDfltServiceTemplateTable)((RbDfltServiceTemplateTable)temp.findCurrentConfiguration().findManagedObject("BS", RbDfltServiceTemplateTable.class)).clone();
                RbDfltServiceTemplateEntry PPPoE = (RbDfltServiceTemplateEntry)serviceTable.findEntry("2");
                PPPoE.setRbDfltServiceTemplateIdx(entry.getRbServiceTemplateIdx());
                try {
                    ConfigurationHelper cfgHelper3 = Helpers.getConfigurationHelper();
                    cfgHelper3.updateCurrentConfiguration(equipment.getId(), (ManagedObject)serviceTable);
                }
                catch (Exception e) {}
            } else {
                retServicesFailed.add(new Object());
            }
        }
        if (this.isDfltL2ServiceProfileIsNull()) {
            serviceTable2 = (RbDfltServiceTemplateTable)((RbDfltServiceTemplateTable)temp.findCurrentConfiguration().findManagedObject("BS", RbDfltServiceTemplateTable.class)).clone();
            RbDfltServiceTemplateEntry l2 = (RbDfltServiceTemplateEntry)serviceTable2.findEntry("1");
            l2.setRbDfltServiceTemplateIdx(new Long(0L));
            RbDfltServiceTemplateEntry voip = (RbDfltServiceTemplateEntry)serviceTable2.findEntry("3");
            voip.setRbDfltServiceTemplateIdx(new Long(0L));
            try {
                cfgHelper = Helpers.getConfigurationHelper();
                cfgHelper.updateCurrentConfiguration(equipment.getId(), (ManagedObject)serviceTable2);
            }
            catch (Exception e) {}
        } else if (this.getDfltServiceProfile() != null && !this.getDfltServiceProfile().equals("")) {
            serviceProfileTable = (RbServiceTemplateConfigTable)((RbServiceTemplateConfigTable)temp.findCurrentConfiguration().findManagedObject("BS", RbServiceTemplateConfigTable.class)).clone();
            entry = serviceProfileTable.findEntryByName(this.getDfltServiceProfile());
            if (entry != null) {
                serviceTable = (RbDfltServiceTemplateTable)((RbDfltServiceTemplateTable)temp.findCurrentConfiguration().findManagedObject("BS", RbDfltServiceTemplateTable.class)).clone();
                if (entry.getRbServiceTemplateType() == 1) {
                    RbDfltServiceTemplateEntry l2 = (RbDfltServiceTemplateEntry)serviceTable.findEntry("1");
                    l2.setRbDfltServiceTemplateIdx(entry.getRbServiceTemplateIdx());
                }
                if (entry.getRbServiceTemplateType() == 3) {
                    RbDfltServiceTemplateEntry voip = (RbDfltServiceTemplateEntry)serviceTable.findEntry("3");
                    voip.setRbDfltServiceTemplateIdx(entry.getRbServiceTemplateIdx());
                }
                try {
                    cfgHelper = Helpers.getConfigurationHelper();
                    cfgHelper.updateCurrentConfiguration(equipment.getId(), (ManagedObject)serviceTable);
                }
                catch (Exception e) {}
            } else {
                retServicesFailed.add(new Object());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fireCommand(Equipment equipment, NetworkElementCommand eqCommand) {
        MOAccessSession snmpAccess = null;
        try {
            snmpAccess = this.createMOAccessSession((RbBaseStationEquipment)equipment);
            snmpAccess.commitObject(null, (Object)eqCommand);
            boolean bl = true;
            return bl;
        }
        catch (MediationException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeMOAccessSession(snmpAccess);
        }
    }

    protected MOAccessSession createMOAccessSession(RbBaseStationEquipment equipment) throws MediationException {
        return MediationServiceRegistry.getMOSession((SNMPManagementInterface)equipment.getManagementInterface(), null);
    }

    private void checkInitSelectedMaps() {
        if (null == this.bsMap) {
            this.bsMap = new HashMap<Long, Boolean>();
            this.auMap = new HashMap<Long, boolean[]>();
            for (MultipleConfigWeakAssociation mcWA : this.getManagedEntityWeakAssociation()) {
                ManagedEntityBase me = mcWA.getManagedEntity();
                if (null == me) continue;
                if (me instanceof RbBaseStationEquipment) {
                    this.bsMap.put(me.getId(), mcWA.isSelected());
                    continue;
                }
                RbAU au = (RbAU)me;
                if (au.getManagerBS() == null) {
                    log.debug((Object)"The AU's Managed BS is null");
                    continue;
                }
                boolean[] selectionArray = this.auMap.get(au.getManagerBS().getId());
                if (null == selectionArray) {
                    selectionArray = new boolean[9];
                    this.auMap.put(au.getManagerBS().getId(), selectionArray);
                }
                int slotNo = au.getSlotNumber();
                selectionArray[slotNo - 1] = mcWA.isSelected();
            }
        }
    }

    @Override
    protected boolean isTableRemoveOperation(Class clazz) {
        if (clazz.isAssignableFrom(RbMACAddressDenyListTable.class)) {
            return this.isMacDenyList();
        }
        if (clazz.isAssignableFrom(RbAuthorizedManagersTable.class)) {
            return this.isManagersDenyList();
        }
        if (clazz.isAssignableFrom(RbServiceGroupTable.class)) {
            return this.isServiceGroupToInsert();
        }
        return false;
    }

    public boolean[] getRadiusAccToBeDeleted() {
        return this.radiusAccToBeDeleted;
    }

    public void setRadiusAccToBeDeleted(boolean[] radiusAccToBeDeleted) {
        this.radiusAccToBeDeleted = radiusAccToBeDeleted;
    }

    public boolean[] getRadiusAuthToBeDeleted() {
        return this.radiusAuthToBeDeleted;
    }

    public void setRadiusAuthToBeDeleted(boolean[] radiusAuthToBeDeleted) {
        this.radiusAuthToBeDeleted = radiusAuthToBeDeleted;
    }

    public Integer getPfServerUdpPort() {
        return this.pfServerUdpPort;
    }

    public void setPfServerUdpPort(Integer pfServerUdpPort) {
        this.pfServerUdpPort = pfServerUdpPort;
    }

    public Integer getPfServerVlanId() {
        return this.pfServerVlanId;
    }

    public void setPfServerVlanId(Integer pfServerVlanId) {
        this.pfServerVlanId = pfServerVlanId;
    }

    public String getPfServerSharedSecret() {
        return this.pfServerSharedSecret;
    }

    public void setPfServerSharedSecret(String sharedSecret) {
        this.pfServerSharedSecret = sharedSecret;
    }

    public String getPfDomainIpAddress() {
        return this.pfDomainIpAddress;
    }

    public void setPfDomainIpAddress(String pfDomainIpAddress) {
        this.pfDomainIpAddress = pfDomainIpAddress;
    }

    public String getPfDomainSubnet() {
        return this.pfDomainSubnet;
    }

    public void setPfDomainSubnet(String pfDomainSubnet) {
        this.pfDomainSubnet = pfDomainSubnet;
    }

    public String getPfDomainGateway() {
        return this.pfDomainGateway;
    }

    public void setPfDomainGateway(String pfDomainGateway) {
        this.pfDomainGateway = pfDomainGateway;
    }

    public Integer getPfAdoptDataPort() {
        return this.pfAdoptDataPort;
    }

    public void setPfAdoptDataPort(Integer pfAdoptDataPort) {
        this.pfAdoptDataPort = pfAdoptDataPort;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(table=@Table(name="RbBSMltplCfg_ServiceGroup"))
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<RbServiceGroupEntry> getBsServiceGroupEntries() {
        if (null == this.bsServiceGroupEntries) {
            this.bsServiceGroupEntries = new ArrayList<RbServiceGroupEntry>();
        }
        return this.bsServiceGroupEntries;
    }

    public void setBsServiceGroupEntries(List<RbServiceGroupEntry> bsServiceGroupEntries) {
        this.bsServiceGroupEntries = bsServiceGroupEntries;
    }

    public boolean isFromVoiceDomainViewer() {
        return this.isFromVoiceDomainViewer;
    }

    public void setFromVoiceDomainViewer(boolean isFromVoiceDomainViewer) {
        this.isFromVoiceDomainViewer = isFromVoiceDomainViewer;
    }

    public boolean isFromServiceGroupViewer() {
        return this.isFromServiceGroupViewer;
    }

    public void setFromServiceGroupViewer(boolean isFromServiceGroupViewer) {
        this.isFromServiceGroupViewer = isFromServiceGroupViewer;
    }
}

