/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.multipleconfiguration;

import com.bwanms.gui.SelectorUtil;
import com.bwanms.gui.SelectorView;
import com.bwanms.gui.Selectors;
import com.bwanms.model.EqTreeNode;
import com.bwanms.model.EqTreeNodeValue;
import com.bwanms.model.Equipment;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbMBS;
import com.bwanms.rb.model.RbSU;
import com.bwanms.rb.tasks.multipleconfiguration.MultipleConfigTaskEqSelectorVer2Panel;
import com.bwanms.ui.components.EqNodeEditorPanel;
import com.bwanms.ui.components.EqNodeTreeCellEditor;
import com.bwanms.ui.components.EqNodeTreeCellRenderer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleConfigTaskEqSelectorVer2PanelController {
    private int type;
    private MultipleConfigTaskEqSelectorVer2Panel panel;

    public MultipleConfigTaskEqSelectorVer2PanelController(MultipleConfigTaskEqSelectorVer2Panel panel) {
        this.panel = panel;
    }

    public void setEquipments(List<Equipment> equipments) {
        ArrayList<Boolean> selection = new ArrayList<Boolean>(equipments.size());
        for (int i = 0; i < equipments.size(); ++i) {
            selection.add(true);
        }
        this.setEquipments(equipments, selection);
    }

    public void setEquipments(List<Equipment> equipments, List<Boolean> selection) {
        EqTreeNodeValue rootValue = new EqTreeNodeValue(null, "root", 0);
        this.type = equipments.get(0) instanceof RbBaseStationEquipment ? 0 : 1;
        this.addEquipments(equipments, selection, rootValue);
        EqTreeNode root = new EqTreeNode(null, rootValue);
        DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)root, false);
        JTree tree1 = this.panel.getTree1();
        EqNodeEditorPanel panel = new EqNodeEditorPanel();
        tree1.setCellRenderer((TreeCellRenderer)new EqNodeTreeCellRenderer(panel));
        tree1.setCellEditor((TreeCellEditor)new EqNodeTreeCellEditor(panel));
        tree1.setModel(treeModel);
        this.expandTree(tree1);
    }

    private void expandTree(JTree tree1) {
        int rc = 0;
        do {
            for (int x = rc = tree1.getRowCount(); x >= 0; --x) {
                tree1.expandRow(x);
            }
        } while (rc < tree1.getRowCount());
    }

    public void addMoreEquipments(List<Equipment> equipments) {
        ArrayList<Boolean> selection = new ArrayList<Boolean>(equipments.size());
        for (int i = 0; i < equipments.size(); ++i) {
            selection.add(true);
        }
        JTree tree1 = this.panel.getTree1();
        TreeModel treeModel = tree1.getModel();
        EqTreeNode root = (EqTreeNode)treeModel.getRoot();
        EqTreeNodeValue rootValue = root.getValue();
        this.addEquipments(equipments, selection, rootValue);
        EqTreeNode root2 = new EqTreeNode(null, rootValue);
        DefaultTreeModel treeModel2 = new DefaultTreeModel((TreeNode)root2, false);
        tree1.setModel(treeModel2);
        this.expandTree(tree1);
    }

    private void addEquipments(List<Equipment> equipments, List<Boolean> selection, EqTreeNodeValue rootValue) {
        for (int i = 0; i < equipments.size(); ++i) {
            Equipment eq = equipments.get(i);
            boolean selected = selection.get(i);
            if (eq instanceof RbBS) {
                this.addBS(rootValue, eq, selected);
                continue;
            }
            if (eq instanceof RbSU) {
                this.addSU(rootValue, eq, selected);
                continue;
            }
            if (!(eq instanceof RbMBS)) continue;
            this.addMBS(rootValue, eq, selected);
        }
    }

    private void addMBS(EqTreeNodeValue rootValue, Equipment eq, boolean selected) {
        RbMBS mbs = (RbMBS)eq;
        EqTreeNodeValue childEq = new EqTreeNodeValue((Equipment)mbs, "MBS " + mbs.getName() + "-" + mbs.getIPAddress(), 1);
        childEq.setSelected(selected);
        boolean add = true;
        for (EqTreeNodeValue temp : rootValue.getChildren()) {
            if (!temp.getName().equals(childEq.getName())) continue;
            add = false;
            break;
        }
        if (add) {
            rootValue.addChild(childEq);
        }
    }

    private void addSU(EqTreeNodeValue rootValue, Equipment eq, boolean selected) {
        RbSU su = (RbSU)eq;
        EqTreeNodeValue childEq = new EqTreeNodeValue((Equipment)su, "SU " + eq.getName(), 3);
        childEq.setSelected(selected);
        if (su.getManagerBS() != null) {
            EqTreeNodeValue parentBS = new EqTreeNodeValue((Equipment)su.getManagerBS(), su.getManagerBS().getName() + "-" + su.getManagerBS().getIPAddress(), 1, false);
            boolean added = false;
            for (EqTreeNodeValue tempBS : rootValue.getChildren()) {
                if (!tempBS.getName().equals(parentBS.getName())) continue;
                tempBS.addChild(childEq);
                added = true;
                break;
            }
            if (!added) {
                parentBS.addChild(childEq);
                rootValue.addChild(parentBS);
            }
        } else {
            rootValue.addChild(childEq);
        }
    }

    private void addBS(EqTreeNodeValue rootValue, Equipment eq, boolean selected) {
        RbBS bs = (RbBS)eq;
        EqTreeNodeValue childEq = new EqTreeNodeValue((Equipment)bs, "BS " + bs.getName() + "-" + bs.getIPAddress(), 1);
        childEq.setSelected(selected);
        int slotNr = 1;
        for (int i = 0; i < 7; ++i) {
            EqTreeNodeValue childAU = new EqTreeNodeValue((Equipment)bs, "AU " + slotNr, 2);
            childAU.setSelected(true);
            childEq.addChild(childAU);
            if (++slotNr != 5) continue;
            slotNr += 2;
        }
        boolean add = true;
        for (EqTreeNodeValue temp : rootValue.getChildren()) {
            if (!temp.getName().equals(childEq.getName())) continue;
            add = false;
            break;
        }
        if (add) {
            rootValue.addChild(childEq);
        }
    }

    public void selectEquipment() {
        SelectorView selectorView = this.type == 0 ? Selectors.getSelectorView(RbBaseStationEquipment.class, null) : Selectors.getSelectorView(RbSU.class, null);
        if (selectorView == null) {
            throw new IllegalArgumentException("Selector View must be defined!");
        }
        SelectorUtil.displayModalSelector((JComponent)this.panel, (SelectorView)selectorView);
        List selection = selectorView.getSelection();
        this.addMoreEquipments(selection);
    }

    public void removeEquipment() {
        List<EqTreeNodeValue> selection = this.getSelection();
        this.removeNodes(selection);
    }

    private void removeNodes(List<EqTreeNodeValue> selection) {
        JTree tree1 = this.panel.getTree1();
        TreeModel treeModel = tree1.getModel();
        EqTreeNode root = (EqTreeNode)treeModel.getRoot();
        EqTreeNodeValue rootValue = root.getValue();
        for (EqTreeNodeValue toDelete : selection) {
            this.removeFromNode(rootValue, toDelete);
        }
        EqTreeNode root2 = new EqTreeNode(null, rootValue);
        DefaultTreeModel treeModel2 = new DefaultTreeModel((TreeNode)root2, false);
        tree1.setModel(treeModel2);
        this.expandTree(tree1);
    }

    private void removeFromNode(EqTreeNodeValue rootValue, EqTreeNodeValue toDelete) {
        ArrayList tempList = new ArrayList();
        tempList.addAll(rootValue.getChildren());
        for (EqTreeNodeValue temp : tempList) {
            if (temp.getName().equals(toDelete.getName())) {
                rootValue.getChildren().remove(temp);
                continue;
            }
            if (temp.getChildren() == null) continue;
            this.removeFromNode(temp, toDelete);
        }
    }

    private List<EqTreeNodeValue> getSelection() {
        TreePath[] selectedPaths;
        ArrayList<EqTreeNodeValue> selection = new ArrayList<EqTreeNodeValue>();
        JTree tree1 = this.panel.getTree1();
        for (TreePath selectedPath : selectedPaths = tree1.getSelectionPaths()) {
            EqTreeNodeValue eqv = ((EqTreeNode)selectedPath.getLastPathComponent()).getValue();
            if (eqv == null || eqv.getEquipment() == null) continue;
            selection.add(eqv);
        }
        return selection;
    }
}

