/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.multipleconfiguration;

import com.bwanms.rb.tasks.multipleconfiguration.MultipleConfigTaskServiceGroupConfigPanel;
import com.bwanms.ui.components.ROTableModel;
import com.bwanms.ui.components.SimpleRowTableModelPanelController;
import com.bwanms.util.FormUtil;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JTable;

public class MultipleConfigServiceGroupController
extends SimpleRowTableModelPanelController {
    MultipleConfigTaskServiceGroupConfigPanel form;
    private static final int MAX_NO_COLUMNS = 10;

    public MultipleConfigServiceGroupController(MultipleConfigTaskServiceGroupConfigPanel form) {
        this.form = form;
    }

    protected ROTableModel getTableModel() {
        return this.form.getTblServiceGroupsModel();
    }

    protected JTable getTable() {
        return this.form.getTblServiceGroups();
    }

    protected JButton getDeleteButton() {
        return this.form.getBtnSGDelete();
    }

    protected JButton getRevertButton() {
        return this.form.getBtnSGRevert();
    }

    protected JButton getAddButton() {
        return this.form.getBtnSGAdd();
    }

    public void btnAddMouseClicked() {
        this.getTableModel().addNewRow(null, false);
        this.setAddBtnState();
        Integer row = this.getTable().getRowCount() - 1;
        this.getTableModel().setValueAt((Object)1, row.intValue(), 2);
        this.getTableModel().setValueAt((Object)1, row.intValue(), 3);
        if (this.form.getRadioSGRemove().isSelected()) {
            this.getTableModel().setROCell(row.intValue(), 1);
            this.getTableModel().setROCell(row.intValue(), 2);
            this.getTableModel().setROCell(row.intValue(), 3);
        }
        this.getTableModel().setROCell(row.intValue(), 4);
        this.getTableModel().setROCell(row.intValue(), 5);
        this.getTableModel().setROCell(row.intValue(), 6);
        this.getTableModel().setROCell(row.intValue(), 7);
        this.getTableModel().setROCell(row.intValue(), 8);
        this.getTableModel().setROCell(row.intValue(), 9);
    }

    private void setAddBtnState() {
        if (this.getTableModel().getRowCount() >= 10) {
            this.form.getBtnSGAdd().setEnabled(false);
        } else {
            this.form.getBtnSGAdd().setEnabled(true);
        }
    }

    public void btnRevertMouseClicked() {
        FormUtil.cancelTableEditing((JTable)this.getTable());
        int[] selectedRows = this.getTable().getSelectedRows();
        Arrays.sort(selectedRows);
        for (int i = selectedRows.length - 1; i >= 0; --i) {
            this.revertRow(selectedRows[i]);
        }
        this.controlTableButtons();
        this.controlInsertRadioGroup();
        this.setAddBtnState();
    }

    public void revertRow(int row) {
        this.getTableModel().removeRow(row);
        this.getTableModel().fireTableRowsDeleted(row, row);
    }

    public void btnDeleteMouseClicked() {
        super.btnDeleteMouseClicked();
        this.controlInsertRadioGroup();
        this.setAddBtnState();
    }

    public void updatedSGType() {
        int selectedRow = this.getTable().getSelectedRow();
        if (selectedRow < 0) {
            return;
        }
        if (this.getTableModel().getValueAt(selectedRow, 3) == null) {
            return;
        }
        if ((Integer)this.getTableModel().getValueAt(selectedRow, 3) == 2) {
            this.getTableModel().resetTableAccess(Integer.valueOf(selectedRow), Integer.valueOf(4));
            this.getTableModel().setInitialValueAt((Object)1, selectedRow, 4);
            this.updatedSGRelayMode();
        } else {
            this.setROCellForSelectedRow4(selectedRow);
        }
    }

    private void setROCellForSelectedRow4(int selectedRow) {
        this.getTableModel().setInitialValueAt(null, selectedRow, 4);
        this.getTableModel().setROCell(selectedRow, 4);
        this.setROCellsForSelectedRow(selectedRow);
    }

    public void controlTableButtons() {
        int row = this.getTable().getSelectedRow();
        if (row < 0 || row >= this.getTableModel().getRowCount()) {
            this.getRevertButton().setEnabled(false);
            return;
        }
        this.getRevertButton().setEnabled(true);
    }

    public void updatedSGRelayMode() {
        int selectedRow = this.getTable().getSelectedRow();
        if (selectedRow < 0) {
            return;
        }
        if (this.getTableModel().getValueAt(selectedRow, 4) == null || this.getTableModel().getValueAt(selectedRow, 4).equals("")) {
            return;
        }
        if ((Integer)this.getTableModel().getValueAt(selectedRow, 4) == 1) {
            this.getTableModel().resetTableAccess(Integer.valueOf(selectedRow));
        } else {
            this.setROCellsForSelectedRow(selectedRow);
        }
    }

    private void setROCellsForSelectedRow(int selectedRow) {
        this.getTableModel().setInitialValueAt(null, selectedRow, 5);
        this.getTableModel().setInitialValueAt(null, selectedRow, 6);
        this.getTableModel().setInitialValueAt(null, selectedRow, 7);
        this.getTableModel().setInitialValueAt(null, selectedRow, 8);
        this.getTableModel().setInitialValueAt(null, selectedRow, 9);
        this.getTableModel().setROCell(selectedRow, 5);
        this.getTableModel().setROCell(selectedRow, 6);
        this.getTableModel().setROCell(selectedRow, 7);
        this.getTableModel().setROCell(selectedRow, 8);
        this.getTableModel().setROCell(selectedRow, 9);
    }

    public void controlInsertRadioGroup() {
        if (this.form.getRadioSGRemove().isSelected()) {
            for (int i = 1; i < this.getTableModel().getColumnCount(); ++i) {
                for (int j = 0; j < this.getTableModel().getRowCount(); ++j) {
                    this.getTableModel().setROCell(j, i);
                }
            }
        } else {
            this.checkRowState();
        }
    }

    private void checkRowState() {
        for (int i = 0; i < this.getTableModel().getRowCount(); ++i) {
            this.getTableModel().resetTableAccess(Integer.valueOf(i), Integer.valueOf(1));
            this.getTableModel().resetTableAccess(Integer.valueOf(i), Integer.valueOf(2));
            this.getTableModel().resetTableAccess(Integer.valueOf(i), Integer.valueOf(3));
            if ((Integer)this.getTableModel().getValueAt(i, 3) == 2) {
                if ((Integer)this.getTableModel().getValueAt(i, 4) == 1) {
                    this.getTableModel().resetTableAccess(Integer.valueOf(i));
                    continue;
                }
                this.setROCellsForSelectedRow(i);
                continue;
            }
            this.setROCellForSelectedRow4(i);
        }
    }
}

