/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.multipleconfiguration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.RegexFormatter;
import com.bwanms.rb.tasks.multipleconfiguration.MultipleConfigRadiusAccSrvController;
import com.bwanms.rb.tasks.multipleconfiguration.MultipleConfigRadiusAuthSrvController;
import com.bwanms.rb.tasks.multipleconfiguration.MultipleConfigTaskBsRadiusTab;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.ROTableModel;
import com.bwanms.ui.components.SimpleRowTable;
import com.bwanms.ui.components.SimpleRowTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.regex.Pattern;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.text.DefaultFormatter;

public class MultipleConfigRadiusController {
    private MultipleConfigRadiusAccSrvController accSrvController;
    private MultipleConfigRadiusAuthSrvController authSrvController;
    private MultipleConfigTaskBsRadiusTab form;

    public MultipleConfigRadiusController(MultipleConfigTaskBsRadiusTab form) {
        this.accSrvController = new MultipleConfigRadiusAccSrvController(form);
        this.authSrvController = new MultipleConfigRadiusAuthSrvController(form);
        this.form = form;
    }

    public MultipleConfigRadiusAccSrvController getAccSrvController() {
        return this.accSrvController;
    }

    public MultipleConfigRadiusAuthSrvController getAuthSrvController() {
        return this.authSrvController;
    }

    public ROTableModel initTable(JTable table, Internationalizer i18n) {
        ComboItem[] dataPortAdoptItems = new ComboItem[]{new ComboItem((Object)1, i18n.translateString("DTPA_Yes")), new ComboItem((Object)2, i18n.translateString("DTPA_No"))};
        ROTableModel tableModel = new ROTableModel(new SimpleRowTableModel.ColumnDefinition[]{new SimpleRowTableModel.ColumnDefinition(i18n.translateString("serverIPAddress"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("udpPort"), Integer.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("AdoptDataPort"), Integer.class, dataPortAdoptItems), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("VlanId"), Integer.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("RadiusIfCIPAddress"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("RadiusServerSubnetMask"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("RadiusServerGateway"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("isPrimary"), Boolean.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("toBeRemoved"), Boolean.class)});
        tableModel.setNewRowReadOnlyOverride(true);
        SimpleRowTable srTable = new SimpleRowTable(table, (SimpleRowTableModel)tableModel);
        final JTable radiusTbl = table;
        final ROTableModel adoptTblModel = tableModel;
        JComboBox adoptDataPortCmb = new JComboBox();
        adoptDataPortCmb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                this.updatedAdoptDataPort();
            }

            private void updatedAdoptDataPort() {
                int selectedRow = radiusTbl.getSelectedRow();
                if (selectedRow < 0) {
                    return;
                }
                if (adoptTblModel.getValueAt(selectedRow, 2) == null) {
                    return;
                }
                if (((Integer)adoptTblModel.getValueAt(selectedRow, 2)).equals(1)) {
                    adoptTblModel.setInitialValueAt(null, selectedRow, 3);
                    adoptTblModel.setInitialValueAt(null, selectedRow, 4);
                    adoptTblModel.setInitialValueAt(null, selectedRow, 5);
                    adoptTblModel.setInitialValueAt(null, selectedRow, 6);
                    adoptTblModel.setROCell(selectedRow, 3);
                    adoptTblModel.setROCell(selectedRow, 4);
                    adoptTblModel.setROCell(selectedRow, 5);
                    adoptTblModel.setROCell(selectedRow, 6);
                } else {
                    adoptTblModel.resetTableAccess(Integer.valueOf(selectedRow));
                }
            }
        });
        srTable.setFormattedTextCellEditor(0, new RegexFormatter("(([0-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])){0,2}(\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])?)?|254\\.255\\.255\\.255|[1-9]?|[aA]|[aA][nN]|[aA][nN][yY])"), Pattern.compile("((([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-4])(\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])){2}\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])|254\\.255\\.255\\.255))?"));
        srTable.setComboCellEditor(2, adoptDataPortCmb);
        DefaultFormatter portFormatter = new DefaultFormatter(){
            private static final long serialVersionUID = -3433286437646488341L;

            public Object stringToValue(String text) throws ParseException {
                int port;
                if (text.equals("")) {
                    return null;
                }
                try {
                    port = Integer.parseInt(text);
                    if (port < 1 || port > 65535) {
                        throw new ParseException("Port number must be between 0 and 65535", 0);
                    }
                }
                catch (NumberFormatException nfe) {
                    throw new ParseException("Wrong port number format", 0);
                }
                return port;
            }
        };
        portFormatter.setOverwriteMode(false);
        portFormatter.setAllowsInvalid(false);
        portFormatter.setCommitsOnValidEdit(true);
        srTable.setFormattedTextCellEditor(1, portFormatter);
        DefaultFormatter vlanIdFormatter = new DefaultFormatter(){
            private static final long serialVersionUID = -3433286437646488341L;

            public Object stringToValue(String text) throws ParseException {
                int port;
                if (text.equals("")) {
                    return null;
                }
                try {
                    port = Integer.parseInt(text);
                    if (port < 0 || port > 4094) {
                        throw new ParseException("Port number must be between 0 and 4095", 0);
                    }
                }
                catch (NumberFormatException nfe) {
                    throw new ParseException("Wrong port number format", 0);
                }
                return port;
            }
        };
        vlanIdFormatter.setOverwriteMode(false);
        vlanIdFormatter.setAllowsInvalid(false);
        vlanIdFormatter.setCommitsOnValidEdit(true);
        srTable.setFormattedTextCellEditor(3, vlanIdFormatter);
        DefaultFormatter checkIfValidFormatter = new DefaultFormatter(){
            private static final long serialVersionUID = -3433286437646488341L;

            public Object stringToValue(String text) throws ParseException {
                if (text.equals("")) {
                    return null;
                }
                return text;
            }
        };
        checkIfValidFormatter.setOverwriteMode(false);
        checkIfValidFormatter.setAllowsInvalid(false);
        checkIfValidFormatter.setCommitsOnValidEdit(true);
        srTable.setFormattedTextCellEditor(4, checkIfValidFormatter);
        srTable.setFormattedTextCellEditor(5, checkIfValidFormatter);
        srTable.setFormattedTextCellEditor(6, checkIfValidFormatter);
        TableColumn tblColumn = table.getColumnModel().getColumn(8);
        JCheckBox isDeletedChkBox = new JCheckBox();
        isDeletedChkBox.setHorizontalAlignment(0);
        CheckBoxTableCellEditor chkBoxTblEditor = new CheckBoxTableCellEditor(isDeletedChkBox);
        tblColumn.setCellEditor(chkBoxTblEditor);
        return tableModel;
    }

    public void fillRadiusTables(ROTableModel tableModel) {
        tableModel.addNewRow(null, true);
        tableModel.addNewRow(null, true);
        tableModel.setInitialValueAt((Object)2, 0, 2);
        tableModel.setInitialValueAt((Object)2, 1, 2);
        tableModel.setInitialValueAt((Object)false, 0, 8);
        tableModel.setInitialValueAt((Object)false, 1, 8);
        tableModel.setColumnReadonly(7, true);
        tableModel.setInitialValueAt((Object)true, 0, 7);
    }

    public void updatedAdoptDataPort(ROTableModel adoptTblModel) {
        for (int selectedRow = 0; selectedRow < 2; ++selectedRow) {
            if (((Integer)adoptTblModel.getValueAt(selectedRow, 2)).equals(1)) {
                adoptTblModel.setInitialValueAt(null, selectedRow, 3);
                adoptTblModel.setInitialValueAt(null, selectedRow, 4);
                adoptTblModel.setInitialValueAt(null, selectedRow, 5);
                adoptTblModel.setInitialValueAt(null, selectedRow, 6);
                adoptTblModel.setROCell(selectedRow, 3);
                adoptTblModel.setROCell(selectedRow, 4);
                adoptTblModel.setROCell(selectedRow, 5);
                adoptTblModel.setROCell(selectedRow, 6);
            } else {
                adoptTblModel.resetTableAccess(Integer.valueOf(selectedRow));
            }
            if (!((Boolean)adoptTblModel.getValueAt(selectedRow, 8)).equals(true)) continue;
            adoptTblModel.setROCell(selectedRow, 1);
            adoptTblModel.setROCell(selectedRow, 2);
            adoptTblModel.setROCell(selectedRow, 3);
            adoptTblModel.setROCell(selectedRow, 4);
            adoptTblModel.setROCell(selectedRow, 5);
            adoptTblModel.setROCell(selectedRow, 6);
        }
    }

    private class CheckBoxTableCellEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        CheckBoxTableCellEditor(JCheckBox chkBox) {
            super(chkBox);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ROTableModel roTableModel = (ROTableModel)table.getModel();
            JCheckBox chkBox = (JCheckBox)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (!chkBox.isSelected()) {
                roTableModel.setROCell(row, 1);
                roTableModel.setROCell(row, 2);
                roTableModel.setROCell(row, 3);
                roTableModel.setROCell(row, 4);
                roTableModel.setROCell(row, 5);
                roTableModel.setROCell(row, 6);
                roTableModel.setValueAt(null, row, 1);
                roTableModel.setValueAt((Object)2, row, 2);
                roTableModel.setValueAt(null, row, 3);
                roTableModel.setValueAt(null, row, 4);
                roTableModel.setValueAt(null, row, 5);
                roTableModel.setValueAt(null, row, 6);
            } else {
                roTableModel.resetTableAccess(Integer.valueOf(row), Integer.valueOf(1));
                roTableModel.resetTableAccess(Integer.valueOf(row), Integer.valueOf(2));
                roTableModel.resetTableAccess(Integer.valueOf(row), Integer.valueOf(3));
                roTableModel.resetTableAccess(Integer.valueOf(row), Integer.valueOf(4));
                roTableModel.resetTableAccess(Integer.valueOf(row), Integer.valueOf(5));
                roTableModel.resetTableAccess(Integer.valueOf(row), Integer.valueOf(6));
            }
            return chkBox;
        }
    }
}

