/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.license;

import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.tasks.license.RbLicenseFeatureTask;
import com.bwanms.rb.tasks.license.RbLicenseFeatureTaskExecutor;
import com.bwanms.rb.tasks.license.RbLicenseFeatureTaskPanel;
import com.bwanms.rb.tasks.softwareupgrade.RbSoftwareUpgradeTaskView;
import com.bwanms.services.EntityManagerService;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.SimpleRowTable;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.IOUtil;
import com.bwanms.util.MessageBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbLicenseFeatureTaskView
extends AbstractBindedEditorView<RbLicenseFeatureTask> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbLicenseFeatureTask.class);
    private static final Logger log = Logger.getLogger(RbSoftwareUpgradeTaskView.class);
    private RbLicenseFeatureTaskPanel panel;
    private SimpleRowTableModel licensesTblModel;
    private final Hashtable<String, RbBaseStationEquipment> bsEquipments = new Hashtable();

    public RbLicenseFeatureTaskView() {
        EntityManagerService entityService = ServiceRegistry.getEntityManagerService();
        for (RbBaseStationEquipment bsEq : entityService.retrieveAll(RbBaseStationEquipment.class)) {
            String mac = bsEq.getMngmntIfMAC();
            if (mac == null) continue;
            this.bsEquipments.put(mac.replace(':', '-'), bsEq);
        }
        this.initUI();
    }

    public List<Binder> getBinders() {
        ArrayList<Binder> binders = new ArrayList<Binder>();
        DefaultBinder binder = new DefaultBinder((Object)this.getUI(), (Object)this.entity);
        binder.add((Binding)new JTextFieldBinding("txtName", "name", i18n.translateString("Name")));
        binders.add((Binder)binder);
        return binders;
    }

    public void fillUI(RbLicenseFeatureTask entity) {
        boolean bEditTask;
        boolean bl = bEditTask = null != entity && null != entity.getName() && 0 < entity.getName().trim().length();
        if (bEditTask) {
            Hashtable<String, String> licFiles = entity.getLicenses();
            this.licensesTblModel.clearTable();
            for (String licFile : licFiles.keySet()) {
                this.addRow(licFiles.get(licFile), licFile);
            }
        }
    }

    public List<InvalidValue> configureEntity(RbLicenseFeatureTask entity) {
        Hashtable<String, String> licFiles = new Hashtable<String, String>();
        for (int row = 0; row < this.licensesTblModel.getRowCount(); ++row) {
            licFiles.put(this.licensesTblModel.getRowKey(row).toString(), this.licensesTblModel.getValueAt(row, 0).toString());
        }
        entity.setLicenses(licFiles);
        return super.configureEntity((Serializable)((Object)entity));
    }

    private void actionRemoveFile() {
        int[] selectedRows = this.panel.getTblFiles().getSelectedRows();
        for (int i = selectedRows.length - 1; i >= 0; --i) {
            this.licensesTblModel.removeRow(selectedRows[i]);
        }
    }

    private void actionAddFile() {
        JFileChooser jFileChooser = new JFileChooser();
        int retValue = jFileChooser.showDialog(this.panel, i18n.translateString("SelectFile"));
        if (retValue == 0) {
            try {
                File selectedFile = jFileChooser.getSelectedFile();
                String licFile = IOUtil.getContents((File)selectedFile);
                if (!this.addRow(selectedFile.getName(), licFile)) {
                    MessageBox.Alert.quickShow((Component)this.getUI(), i18n.translateString("WrongMAC"));
                }
            }
            catch (Exception e) {
                log.debug((Object)e.toString());
                throw new RuntimeException(e);
            }
        }
    }

    private boolean addRow(String fileName, String licFile) {
        Matcher licFileMatcher = RbLicenseFeatureTaskExecutor.macPattern.matcher(licFile);
        if (!licFileMatcher.find()) {
            return false;
        }
        String bsMAC = licFileMatcher.group();
        String nameAndIP = i18n.translateString("Undiscovered");
        RbBaseStationEquipment bsEq = this.bsEquipments.get(bsMAC);
        if (bsEq != null) {
            nameAndIP = bsEq.getName() + " ( " + bsEq.getIPAddress() + " )";
        }
        SimpleRowTableModel simpleRowTableModel = this.licensesTblModel;
        simpleRowTableModel.getClass();
        SimpleRowTableModel.TableRow tr = new SimpleRowTableModel.TableRow(simpleRowTableModel, licFile);
        tr.setValues(new Object[]{fileName, nameAndIP, bsMAC, licFile.split("\\n", 2)[0]});
        this.licensesTblModel.addTableRow(tr);
        return true;
    }

    private void initUI() {
        this.panel = new RbLicenseFeatureTaskPanel();
        SimpleRowTableModel.ColumnDefinition fileNameColDef = new SimpleRowTableModel.ColumnDefinition(i18n.translateString("FileName"), String.class);
        SimpleRowTableModel.ColumnDefinition bstNameColDef = new SimpleRowTableModel.ColumnDefinition(i18n.translateString("BSTNameIPAddress"), String.class);
        SimpleRowTableModel.ColumnDefinition bstMacColDef = new SimpleRowTableModel.ColumnDefinition(i18n.translateString("BSTMAC"), String.class);
        SimpleRowTableModel.ColumnDefinition fileInfoColDef = new SimpleRowTableModel.ColumnDefinition(i18n.translateString("FileInfo"), String.class);
        SimpleRowTableModel.ColumnDefinition[] colDefs = new SimpleRowTableModel.ColumnDefinition[]{fileNameColDef, bstNameColDef, bstMacColDef, fileInfoColDef};
        this.licensesTblModel = new SimpleRowTableModel(colDefs, this.panel.getTblFiles().getTableHeader()){
            private static final long serialVersionUID = -8530492792413535921L;

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        };
        new SimpleRowTable(this.panel.getTblFiles(), this.licensesTblModel);
        this.panel.getBtnRemoveFile().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RbLicenseFeatureTaskView.this.actionRemoveFile();
            }
        });
        this.panel.getBtnAddFile().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RbLicenseFeatureTaskView.this.actionAddFile();
            }
        });
        this.panel.getTblFiles().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                RbLicenseFeatureTaskView.this.fireEquipmentTableSelectionChanged();
            }
        });
        i18n.getSwingInternationalizer().translateComponent((Component)this.panel);
        this.fireEquipmentTableSelectionChanged();
    }

    private void fireEquipmentTableSelectionChanged() {
        this.panel.getBtnRemoveFile().setEnabled(0 < this.panel.getTblFiles().getSelectedRowCount());
    }

    public JComponent getUI() {
        return this.panel;
    }

    public boolean close() {
        return true;
    }

    public String getTitle() {
        return i18n.translateString("RbLicenseFeatureTaskTitle");
    }

    public String getApplicationPermission() {
        return "Av:ConfigureTasks";
    }

    public String getHelpTopic() {
        return "";
    }
}

