/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.license;

import com.bwanms.domain.logic.Helpers;
import com.bwanms.domain.logic.LicenseHelper;
import com.bwanms.mediation.FileTransferEvent;
import com.bwanms.mediation.FileTransferRequest;
import com.bwanms.mediation.FileTransferService;
import com.bwanms.mediation.MediationException;
import com.bwanms.mediation.MediationServiceRegistry;
import com.bwanms.mediation.TftpFileTransferRequest;
import com.bwanms.mediation.TftpFileTransferService;
import com.bwanms.mediation.filetransfer.SynchronousFileTransfer;
import com.bwanms.model.Equipment;
import com.bwanms.model.TaskExecutionContext;
import com.bwanms.model.TaskExecutor;
import com.bwanms.model.TaskRuntimeStatus;
import com.bwanms.persistence.CallableDatastoreDecorator;
import com.bwanms.persistence.RunnableDatastoreDecorator;
import com.bwanms.rb.mo.RbLicenseLogEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.tasks.license.RbLicenseFeatureTask;
import com.bwanms.services.EntityManagerService;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.services.impl.LockManagerLocator;
import com.bwanms.util.concurrent.AsyncItemsExecutor;
import com.bwanms.util.concurrent.AsyncItemsProvider;
import com.bwanms.util.task.Operation;
import com.bwanms.util.task.OperationStatus;
import com.bwanms.util.task.OperationTaskRuntimeStatus;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class RbLicenseFeatureTaskExecutor
implements TaskExecutor {
    private static final Logger logger = Logger.getLogger(RbLicenseFeatureTaskExecutor.class);
    private transient TaskExecutionContext ctx = null;
    private RbLicenseFeatureTask task;
    private OperationTaskRuntimeStatus runtimeStatus;
    private Operation rootOperation;
    private boolean taskPrincipalFailed = false;
    private boolean oneUploadSucceeded = false;
    private boolean oneUploadFailed = false;
    public static final Pattern macPattern = Pattern.compile("(\\p{XDigit}{2}-){5}\\p{XDigit}{2}", 2);

    public RbLicenseFeatureTaskExecutor(RbLicenseFeatureTask task) {
        this.task = task;
        this.runtimeStatus = new OperationTaskRuntimeStatus();
        this.rootOperation = this.runtimeStatus.addOperation(null, "RbLicenseFeatureTaskWithName", new Object[]{task.getName()});
    }

    public void execute(TaskExecutionContext ctx) {
        this.ctx = ctx;
        this.task = (RbLicenseFeatureTask)ServiceRegistry.getTaskManagerService().retrieveTask(this.task.getId());
        final Hashtable<String, RbBaseStationEquipment> bsEquipments = new Hashtable<String, RbBaseStationEquipment>();
        EntityManagerService entityService = ServiceRegistry.getEntityManagerService();
        for (RbBaseStationEquipment bsEq : entityService.retrieveAll(RbBaseStationEquipment.class)) {
            String mac = bsEq.getMngmntIfMAC();
            if (mac == null) continue;
            bsEquipments.put(mac.replace(':', '-'), bsEq);
        }
        final Enumeration<String> licFiles = this.task.getLicenses().keys();
        AsyncItemsExecutor itemsExecutor = new AsyncItemsExecutor((AsyncItemsProvider)new AsyncItemsProvider<RbLicenseFeatureConfigurator>(){

            public boolean shouldAbort() {
                return RbLicenseFeatureTaskExecutor.this.taskShouldAbort();
            }

            public void itemFinished(RbLicenseFeatureConfigurator item) {
            }

            public void itemStarting(RbLicenseFeatureConfigurator item) {
            }

            public boolean hasNext() {
                return licFiles.hasMoreElements();
            }

            public RbLicenseFeatureConfigurator next() {
                String licFile = (String)licFiles.nextElement();
                String licFileName = RbLicenseFeatureTaskExecutor.this.task.getLicenses().get(licFile);
                Matcher licFileMatcher = macPattern.matcher(licFile);
                RbBaseStationEquipment bsEq = null;
                String bsMAC = null;
                if (licFileMatcher.find()) {
                    bsMAC = licFileMatcher.group();
                    bsEq = (RbBaseStationEquipment)((Object)bsEquipments.get(bsMAC));
                }
                return new RbLicenseFeatureConfigurator(bsEq, bsMAC, licFile, licFileName);
            }

            public void remove() {
                throw new UnsupportedOperationException("Remove Not Implemented!");
            }
        });
        if (this.task.getLicenses().isEmpty()) {
            Operation operation = this.runtimeStatus.addOperation(this.rootOperation, "LicenseFilesListEmpty", new Object[]{this.task.getName()});
            this.runtimeStatus.logOperationStatus(operation, OperationStatus.NULL_STATUS, null);
            this.runtimeStatus.logOperationStatus(this.rootOperation, OperationStatus.FAILED, null);
            this.taskPrincipalFailed = true;
        } else {
            logger.debug((Object)"Started license files upload.");
            itemsExecutor.executeItems();
            switch (this.getExecutionResult()) {
                case 2: {
                    this.runtimeStatus.logOperationStatus(this.rootOperation, OperationStatus.ABORTED, null);
                    break;
                }
                case 3: {
                    this.runtimeStatus.logOperationStatus(this.rootOperation, OperationStatus.FAILED, null);
                    break;
                }
                case 4: {
                    this.runtimeStatus.logOperationStatus(this.rootOperation, OperationStatus.COMPLETED_WITH_ERRORS, null);
                    break;
                }
                case 1: {
                    this.runtimeStatus.logOperationStatus(this.rootOperation, OperationStatus.COMPLETED, null);
                }
            }
            logger.debug((Object)"Done upload license files.");
        }
        ctx.taskFinished();
    }

    public TaskRuntimeStatus getStatus(Object clientData) {
        logger.debug((Object)("*** getStatus() " + clientData));
        Integer idx = null != clientData ? (Integer)clientData : 0;
        return this.runtimeStatus.getDiff(idx.intValue());
    }

    public String getReport() {
        return this.runtimeStatus.toXMLString();
    }

    private boolean taskShouldAbort() {
        return this.ctx.shouldAbort();
    }

    public int getExecutionResult() {
        if (this.ctx.shouldAbort()) {
            return 2;
        }
        if (this.taskPrincipalFailed || !this.oneUploadSucceeded) {
            return 3;
        }
        if (this.oneUploadSucceeded && this.oneUploadFailed) {
            return 4;
        }
        return 1;
    }

    private class RbLicenseFeatureConfigurator
    implements Runnable {
        private RbBaseStationEquipment equipment;
        private String licenseFile;
        private String bsMAC;
        private String licenseFileName;

        public RbLicenseFeatureConfigurator(RbBaseStationEquipment equipment, String bsMAC, String licenseFile, String licenseFileName) {
            this.equipment = equipment;
            this.licenseFile = licenseFile;
            this.licenseFileName = licenseFileName;
            this.bsMAC = bsMAC;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            final Operation licFileUploadOp = RbLicenseFeatureTaskExecutor.this.runtimeStatus.addOperation(RbLicenseFeatureTaskExecutor.this.rootOperation, "LicenseFileUpload", new Object[]{this.licenseFileName});
            if (RbLicenseFeatureTaskExecutor.this.taskShouldAbort()) {
                RbLicenseFeatureTaskExecutor.this.runtimeStatus.logOperationStatus(licFileUploadOp, OperationStatus.ABORTED, null);
                return;
            }
            if (this.bsMAC == null) {
                RbLicenseFeatureTaskExecutor.this.runtimeStatus.logOperationStatus(licFileUploadOp, OperationStatus.FAILED, (Serializable)((Object)"WrongMACParam"));
                RbLicenseFeatureTaskExecutor.this.oneUploadFailed = true;
                return;
            }
            if (this.equipment == null) {
                RbLicenseFeatureTaskExecutor.this.runtimeStatus.logOperationStatus(licFileUploadOp, OperationStatus.FAILED, (Serializable)((Object)"CantFindBS"), new Object[]{this.bsMAC});
                RbLicenseFeatureTaskExecutor.this.oneUploadFailed = true;
                return;
            }
            try {
                boolean licensed = (Boolean)new CallableDatastoreDecorator((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        return LicenseHelper.isLicensed((Object)((Object)RbLicenseFeatureConfigurator.this.equipment));
                    }
                }).call();
                if (!licensed) {
                    RbLicenseFeatureTaskExecutor.this.runtimeStatus.logOperationStatus(licFileUploadOp, OperationStatus.SKIPPED, (Serializable)((Object)"UnlicensedBS"));
                    return;
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
            Lock lock = LockManagerLocator.locate().getLock(Equipment.getConfigurationLockKey((long)this.equipment.getId()));
            lock.lock();
            try {
                new RunnableDatastoreDecorator(new Runnable(){

                    public void run() {
                        RbLicenseFeatureTaskExecutor.this.runtimeStatus.logOperationStatus(licFileUploadOp, OperationStatus.IN_PROGRESS, null);
                        TftpFileTransferService fts = MediationServiceRegistry.getTftpFileTransferService();
                        SynchronousFileTransfer syncFTS = new SynchronousFileTransfer((FileTransferService)fts, "topic/TftpMediationTopic");
                        String timeStamp = String.valueOf(System.currentTimeMillis());
                        FileTransferEvent res = syncFTS.executeTransfer((FileTransferRequest)new TftpFileTransferRequest(RbLicenseFeatureConfigurator.this.equipment.getIPAddress(), RbLicenseFeatureConfigurator.this.licenseFile.getBytes(), timeStamp), 600000L);
                        if (res != null && res.getEventType() == 3) {
                            List errors = null;
                            try {
                                errors = Helpers.getConfigurationHelper().retrieveData((Equipment)RbLicenseFeatureConfigurator.this.equipment, "BS", RbLicenseLogEntry.class, "*");
                            }
                            catch (MediationException e) {
                                e.printStackTrace();
                            }
                            if (errors == null) {
                                RbLicenseFeatureTaskExecutor.this.runtimeStatus.logOperationStatus(licFileUploadOp, OperationStatus.COMPLETED, (Serializable)((Object)"LicenseFileUploadedTo"), new Object[]{RbLicenseFeatureConfigurator.this.equipment.getName()});
                                RbLicenseFeatureTaskExecutor.this.oneUploadSucceeded = true;
                                logger.debug((Object)("License File upload done on" + RbLicenseFeatureConfigurator.this.equipment.getName()));
                            } else {
                                int i;
                                for (i = errors.size() - 1; i >= 0; --i) {
                                    RbLicenseLogEntry entry = (RbLicenseLogEntry)errors.get(i);
                                    if (!timeStamp.equals(entry.getRbLicenseLogFileName())) continue;
                                    i = -3;
                                    if (entry.getRbLicenseLogLoadStatus() == 0L) {
                                        RbLicenseFeatureTaskExecutor.this.runtimeStatus.logOperationStatus(licFileUploadOp, OperationStatus.COMPLETED, (Serializable)((Object)"LicenseFileUploadedTo"), new Object[]{RbLicenseFeatureConfigurator.this.equipment.getName()});
                                        RbLicenseFeatureTaskExecutor.this.oneUploadSucceeded = true;
                                        logger.debug((Object)("License File upload done on" + RbLicenseFeatureConfigurator.this.equipment.getName()));
                                        continue;
                                    }
                                    RbLicenseFeatureTaskExecutor.this.runtimeStatus.logOperationStatus(licFileUploadOp, OperationStatus.FAILED, (Serializable)((Object)RbLicenseLogEntry.toStringRbLicenseLogLoadStatus(entry.getRbLicenseLogLoadStatus())));
                                    RbLicenseFeatureTaskExecutor.this.oneUploadFailed = true;
                                    logger.debug((Object)("License File upload failed on" + RbLicenseFeatureConfigurator.this.equipment.getName()));
                                }
                                if (i == -1) {
                                    RbLicenseFeatureTaskExecutor.this.runtimeStatus.logOperationStatus(licFileUploadOp, OperationStatus.COMPLETED, (Serializable)((Object)"LicenseFileUploadedTo"), new Object[]{RbLicenseFeatureConfigurator.this.equipment.getName()});
                                    RbLicenseFeatureTaskExecutor.this.oneUploadSucceeded = true;
                                    logger.debug((Object)("License File upload done on" + RbLicenseFeatureConfigurator.this.equipment.getName()));
                                }
                            }
                        } else {
                            RbLicenseFeatureTaskExecutor.this.runtimeStatus.logOperationStatus(licFileUploadOp, OperationStatus.FAILED, null);
                            RbLicenseFeatureTaskExecutor.this.oneUploadFailed = true;
                            logger.debug((Object)("License File upload failed on" + RbLicenseFeatureConfigurator.this.equipment.getName()));
                        }
                    }
                }).run();
            }
            finally {
                lock.unlock();
            }
        }
    }
}

