/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.frequencybandfile;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.SelectorUtil;
import com.bwanms.gui.SelectorView;
import com.bwanms.gui.Selectors;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.equipmentmanager.EquipmentRowProviderClient;
import com.bwanms.rb.gui.selectors.equipment.RbBaseStationSelectorView;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.tasks.frequencybandfile.RbFrequencyBandFileBaseTask;
import com.bwanms.rb.tasks.frequencybandfile.RbFrequencyBandFileTask;
import com.bwanms.rb.tasks.frequencybandfile.RbFrequencyBandFileTaskPanel;
import com.bwanms.rb.tasks.softwareupgrade.RbSoftwareUpgradeTaskView;
import com.bwanms.ui.components.EntityManagerTableModel;
import com.bwanms.ui.components.SimpleRowTable;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.IOUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbFrequencyBandFileTaskView
extends AbstractBindedEditorView<RbFrequencyBandFileTask> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbFrequencyBandFileTask.class);
    private static final Logger log = Logger.getLogger(RbSoftwareUpgradeTaskView.class);
    private RbFrequencyBandFileTaskPanel panel;
    private EntityManagerTableModel<RbBaseStationEquipment> equipmentTableModel;
    private byte[] selectedFileZippedContent;
    private String selectedFileName;
    private boolean fileChanged = false;

    public RbFrequencyBandFileTaskView() {
        this.initUI();
    }

    public List<Binder> getBinders() {
        ArrayList<Binder> binders = new ArrayList<Binder>();
        DefaultBinder binder = new DefaultBinder((Object)this.getUI(), (Object)this.entity);
        binder.add((Binding)new JTextFieldBinding("txtName", "name", i18n.translateString("Name")));
        binders.add((Binder)binder);
        return binders;
    }

    public void fillUI(RbFrequencyBandFileTask entity) {
        block3: {
            block2: {
                boolean bEditTask;
                boolean bl = bEditTask = null != entity && null != entity.getName() && 0 < entity.getName().trim().length();
                if (!bEditTask) break block2;
                this.panel.getTxtName().setText(entity.getName());
                this.panel.getTxtFileName().setText(entity.getFreqBandFileName());
                this.panel.getTxtFileName().setToolTipText(entity.getFreqBandFileName());
                this.equipmentTableModel.clearTable();
                for (RbBaseStationEquipment equipment : entity.getEquipmentList()) {
                    this.equipmentTableModel.addRow((Object)equipment, String.valueOf(equipment.getId()));
                }
                break block3;
            }
            if (null == entity || entity.getEquipmentList() == null) break block3;
            this.equipmentTableModel.clearTable();
            for (RbBaseStationEquipment equipment : entity.getEquipmentList()) {
                this.equipmentTableModel.addRow((Object)equipment, String.valueOf(equipment.getId()));
            }
        }
    }

    public List<InvalidValue> configureEntity(RbFrequencyBandFileTask entity) {
        entity.setName(this.panel.getTxtName().getText());
        ArrayList<RbBaseStationEquipment> equipmentList = new ArrayList<RbBaseStationEquipment>(this.equipmentTableModel.getRowCount());
        for (int row = 0; row < this.equipmentTableModel.getRowCount(); ++row) {
            if (1 == this.equipmentTableModel.getRowState(row)) continue;
            RbBaseStationEquipment currentBS = (RbBaseStationEquipment)((Object)this.equipmentTableModel.getEntity(row));
            equipmentList.add(currentBS);
        }
        if (this.fileChanged) {
            entity.setFreqBandFileName(this.selectedFileName);
            entity.setZipFreqBand(this.selectedFileZippedContent);
        }
        entity.setEquipmentList(equipmentList);
        List iv = super.configureEntity((Serializable)((Object)entity));
        Internationalizer i18n = Internationalizer.getInternationalizer(RbFrequencyBandFileBaseTask.class);
        if (this.panel.getTxtFileName().getText().equals("")) {
            iv.add(new InvalidValue(i18n.translateString("NoFrequencyBandFile"), RbFrequencyBandFileBaseTask.class, "", (Object)"", (Object)this));
        }
        return iv;
    }

    private void actionAddEquipment() {
        SelectorView selectorView = Selectors.getSelectorView(RbBaseStationEquipment.class, (String)(RbFrequencyBandFileBaseTask.class.getName() + "_selector"), (String)"multipleSelection");
        if (selectorView == null) {
            throw new IllegalArgumentException("Selector View must be defined!");
        }
        SelectorUtil.displayModalSelector((JComponent)this.panel, (SelectorView)selectorView);
        for (RbBaseStationEquipment equipment : selectorView.getSelection()) {
            String key = String.valueOf(equipment.getId());
            int row = this.equipmentTableModel.getEntityRow(key);
            if (-1 != row) {
                this.equipmentTableModel.updateRow((Object)equipment, key);
                this.equipmentTableModel.revertRow(row);
                continue;
            }
            this.equipmentTableModel.addRow((Object)equipment, key);
        }
    }

    private void actionRemoveEquipment() {
        int[] selectedRows = this.panel.getTableEquipment().getSelectedRows();
        this.equipmentTableModel.removeRows(selectedRows);
    }

    private void actionBrowseFile() {
        JFileChooser jFileChooser = new JFileChooser();
        int retValue = jFileChooser.showDialog(this.panel, i18n.translateString("SelectFile"));
        if (retValue == 0) {
            try {
                File selectedFile = jFileChooser.getSelectedFile();
                ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
                ZipOutputStream zipOut = new ZipOutputStream(outBytes);
                zipOut.putNextEntry(new ZipEntry("FrequencyBandFile"));
                FileInputStream in = new FileInputStream(selectedFile);
                IOUtil.copyStream((InputStream)in, (OutputStream)zipOut);
                zipOut.closeEntry();
                zipOut.close();
                IOUtil.copyStream((InputStream)in, (OutputStream)outBytes);
                outBytes.close();
                outBytes.close();
                in.close();
                this.selectedFileZippedContent = outBytes.toByteArray();
                this.selectedFileName = selectedFile.getName();
                this.fileChanged = true;
                this.panel.getTxtFileName().setText(selectedFile.getName());
                this.panel.getTxtFileName().setToolTipText(selectedFile.getAbsolutePath());
            }
            catch (Exception e) {
                log.debug((Object)e.toString());
                throw new RuntimeException(e);
            }
        }
    }

    private void initUI() {
        this.panel = new RbFrequencyBandFileTaskPanel();
        final RbBaseStationSelectorView bsEqManagerSelectorView = new RbBaseStationSelectorView("RbFrequencyBandFileBaseTask_selector", "multipleSelection");
        SimpleRowTableModel.ColumnDefinition[] colDefs = new SimpleRowTableModel.ColumnDefinition[bsEqManagerSelectorView.getColumnNames().length];
        int idx = 0;
        for (String colName : bsEqManagerSelectorView.getColumnNames()) {
            colDefs[idx++] = new SimpleRowTableModel.ColumnDefinition(colName, String.class);
        }
        this.equipmentTableModel = new EntityManagerTableModel<RbBaseStationEquipment>(colDefs){
            private static final long serialVersionUID = -8530492792413535921L;

            public void setRowValues(int row, RbBaseStationEquipment entity) {
                EquipmentRowProviderClient rowProvider = new EquipmentRowProviderClient(bsEqManagerSelectorView.getEntityRowProvider().getAttributes());
                EntityManagerRow entityRow = rowProvider.createRow((Serializable)((Object)entity));
                List displayValues = rowProvider.getDisplayValues(entityRow);
                for (int i = 0; i < displayValues.size(); ++i) {
                    this.setInitialValueAt(displayValues.get(i), row, i);
                }
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        };
        new SimpleRowTable(this.panel.getTableEquipment(), this.equipmentTableModel);
        this.panel.getBtnEquipmentAdd().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RbFrequencyBandFileTaskView.this.actionAddEquipment();
            }
        });
        this.panel.getBtnEquipmentRemove().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RbFrequencyBandFileTaskView.this.actionRemoveEquipment();
            }
        });
        this.panel.getBtnBrowse().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RbFrequencyBandFileTaskView.this.actionBrowseFile();
            }
        });
        this.panel.getTableEquipment().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                RbFrequencyBandFileTaskView.this.fireEquipmentTableSelectionChanged();
            }
        });
        i18n.getSwingInternationalizer().translateComponent((Component)this.panel);
        this.fireEquipmentTableSelectionChanged();
    }

    private void fireEquipmentTableSelectionChanged() {
        this.panel.getBtnEquipmentRemove().setEnabled(0 < this.panel.getTableEquipment().getSelectedRowCount());
    }

    public JComponent getUI() {
        return this.panel;
    }

    public boolean close() {
        return true;
    }

    public String getTitle() {
        return i18n.translateString("RbFrequencyBandFileTaskTitle");
    }

    public String getApplicationPermission() {
        return "Av:ConfigureTasks";
    }

    public String getHelpTopic() {
        return "";
    }
}

