/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.frequencybandfile;

import com.bwanms.domain.logic.LicenseHelper;
import com.bwanms.mediation.FileTransferEvent;
import com.bwanms.mediation.FileTransferRequest;
import com.bwanms.mediation.FileTransferService;
import com.bwanms.mediation.MediationServiceRegistry;
import com.bwanms.mediation.TftpFileTransferRequest;
import com.bwanms.mediation.TftpFileTransferService;
import com.bwanms.mediation.filetransfer.SynchronousFileTransfer;
import com.bwanms.model.Equipment;
import com.bwanms.model.TaskExecutionContext;
import com.bwanms.model.TaskExecutor;
import com.bwanms.model.TaskRuntimeStatus;
import com.bwanms.persistence.CallableDatastoreDecorator;
import com.bwanms.persistence.Datastore;
import com.bwanms.persistence.RunnableDatastoreDecorator;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.tasks.frequencybandfile.RbFrequencyBandFileTask;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.services.impl.LockManagerLocator;
import com.bwanms.util.IOUtil;
import com.bwanms.util.concurrent.AsyncItemsExecutor;
import com.bwanms.util.concurrent.AsyncItemsProvider;
import com.bwanms.util.task.Operation;
import com.bwanms.util.task.OperationStatus;
import com.bwanms.util.task.OperationTaskRuntimeStatus;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;

public class RbFrequencyBandFileTaskExecutor
implements TaskExecutor {
    private static final Logger logger = Logger.getLogger(RbFrequencyBandFileTaskExecutor.class);
    private transient TaskExecutionContext ctx = null;
    private RbFrequencyBandFileTask task;
    private OperationTaskRuntimeStatus runtimeStatus;
    private Operation rootOperation;
    private boolean taskPrincipalFailed = false;
    private boolean oneUploadSucceded = false;
    private boolean oneUploadFaliled = false;

    public RbFrequencyBandFileTaskExecutor(RbFrequencyBandFileTask task) {
        this.task = task;
        this.runtimeStatus = new OperationTaskRuntimeStatus();
        this.rootOperation = this.runtimeStatus.addOperation(null, "RbFrequencyBandFileTaskWithName", new Object[]{task.getName()});
    }

    public void execute(TaskExecutionContext ctx) {
        this.ctx = ctx;
        this.task = (RbFrequencyBandFileTask)ServiceRegistry.getTaskManagerService().retrieveTask(this.task.getId());
        final Iterator<RbBaseStationEquipment> bsEquipmentIterator = this.task.getEquipmentList().iterator();
        AsyncItemsExecutor itemsExecutor = new AsyncItemsExecutor((AsyncItemsProvider)new AsyncItemsProvider<RbFrequencyBandFileConfigurator>(){

            public boolean shouldAbort() {
                return RbFrequencyBandFileTaskExecutor.this.taskShouldAbort();
            }

            public void itemFinished(RbFrequencyBandFileConfigurator item) {
            }

            public void itemStarting(RbFrequencyBandFileConfigurator item) {
            }

            public boolean hasNext() {
                return bsEquipmentIterator.hasNext();
            }

            public RbFrequencyBandFileConfigurator next() {
                RbBaseStationEquipment nextBaseStation = (RbBaseStationEquipment)((Object)bsEquipmentIterator.next());
                if (null == nextBaseStation) {
                    return null;
                }
                return new RbFrequencyBandFileConfigurator(nextBaseStation);
            }

            public void remove() {
                throw new UnsupportedOperationException("Remove Not Implemented!");
            }
        });
        if (!this.task.getEquipmentList().isEmpty()) {
            logger.debug((Object)"Started deploy service profiles.");
            itemsExecutor.executeItems();
            switch (this.getExecutionResult()) {
                case 2: {
                    this.runtimeStatus.logOperationStatus(this.rootOperation, OperationStatus.ABORTED, null);
                    break;
                }
                case 3: {
                    this.runtimeStatus.logOperationStatus(this.rootOperation, OperationStatus.FAILED, null);
                    break;
                }
                case 4: {
                    this.runtimeStatus.logOperationStatus(this.rootOperation, OperationStatus.COMPLETED_WITH_ERRORS, null);
                    break;
                }
                case 1: {
                    this.runtimeStatus.logOperationStatus(this.rootOperation, OperationStatus.COMPLETED, null);
                }
            }
            logger.debug((Object)"Done upload frequency band files.");
        } else {
            this.runtimeStatus.addOperation(this.rootOperation, "EquipmentListEmpty", new Object[]{this.task.getName()});
            this.taskPrincipalFailed = true;
        }
        ctx.taskFinished();
    }

    public TaskRuntimeStatus getStatus(Object clientData) {
        logger.debug((Object)("*** getStatus() " + clientData));
        Integer idx = null != clientData ? (Integer)clientData : 0;
        return this.runtimeStatus.getDiff(idx.intValue());
    }

    public String getReport() {
        if (this.taskPrincipalFailed) {
            return this.runtimeStatus.toXMLStringFailed(this.task.getName());
        }
        return this.runtimeStatus.toXMLString();
    }

    private boolean taskShouldAbort() {
        return this.ctx.shouldAbort();
    }

    public int getExecutionResult() {
        if (this.ctx.shouldAbort()) {
            return 2;
        }
        if (this.taskPrincipalFailed || !this.oneUploadSucceded) {
            return 3;
        }
        if (this.oneUploadSucceded && this.oneUploadFaliled) {
            return 4;
        }
        return 1;
    }

    private class RbFrequencyBandFileConfigurator
    implements Runnable {
        private RbBaseStationEquipment equipment;

        public RbFrequencyBandFileConfigurator(RbBaseStationEquipment equipment) {
            this.equipment = equipment;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            final Operation equipmentOperation = RbFrequencyBandFileTaskExecutor.this.runtimeStatus.addOperation(RbFrequencyBandFileTaskExecutor.this.rootOperation, "FrequencyBandFileUploadOn", new Object[]{this.equipment.getName()});
            if (RbFrequencyBandFileTaskExecutor.this.taskShouldAbort()) {
                RbFrequencyBandFileTaskExecutor.this.runtimeStatus.logOperationStatus(equipmentOperation, OperationStatus.ABORTED, null);
                return;
            }
            if (this.equipment.getFirmwareVersion() == null || !Integer.valueOf(0).equals(this.equipment.getState())) {
                RbFrequencyBandFileTaskExecutor.this.runtimeStatus.logOperationStatus(equipmentOperation, OperationStatus.SKIPPED, (Serializable)((Object)"UnreachableBS"));
                return;
            }
            if (!this.equipment.isTDDDuplexMode()) {
                RbFrequencyBandFileTaskExecutor.this.runtimeStatus.logOperationStatus(equipmentOperation, OperationStatus.SKIPPED, (Serializable)((Object)"BSNotTDD"));
                return;
            }
            boolean licensed = false;
            try {
                licensed = (Boolean)new CallableDatastoreDecorator((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        return LicenseHelper.isLicensed((Object)((Object)RbFrequencyBandFileConfigurator.this.equipment));
                    }
                }).call();
            }
            catch (Exception exception) {
                if (!licensed) {
                    RbFrequencyBandFileTaskExecutor.this.runtimeStatus.logOperationStatus(equipmentOperation, OperationStatus.SKIPPED, (Serializable)((Object)"UnlicensedBS"));
                    return;
                }
            }
            finally {
                if (!licensed) {
                    RbFrequencyBandFileTaskExecutor.this.runtimeStatus.logOperationStatus(equipmentOperation, OperationStatus.SKIPPED, (Serializable)((Object)"UnlicensedBS"));
                    return;
                }
            }
            Lock lock = LockManagerLocator.locate().getLock(Equipment.getConfigurationLockKey((long)this.equipment.getId()));
            lock.lock();
            try {
                new RunnableDatastoreDecorator(new Runnable(){

                    public void run() {
                        RbFrequencyBandFileConfigurator.this.equipment = (RbBaseStationEquipment)((Object)Datastore.session().get(((Object)((Object)RbFrequencyBandFileConfigurator.this.equipment)).getClass(), (Serializable)Long.valueOf(RbFrequencyBandFileConfigurator.this.equipment.getId())));
                        RbFrequencyBandFileTaskExecutor.this.runtimeStatus.logOperationStatus(equipmentOperation, OperationStatus.IN_PROGRESS, null);
                        ZipInputStream zipIn = new ZipInputStream(new ByteArrayInputStream(RbFrequencyBandFileTaskExecutor.this.task.getZipFreqBand()));
                        ByteArrayOutputStream zipOut = new ByteArrayOutputStream();
                        try {
                            zipIn.getNextEntry();
                            IOUtil.copyStream((InputStream)zipIn, (OutputStream)zipOut);
                        }
                        catch (IOException ioe) {
                            RbFrequencyBandFileTaskExecutor.this.taskPrincipalFailed = true;
                            logger.debug((Object)"Frequency Band File unzip failed");
                            return;
                        }
                        TftpFileTransferService fts = MediationServiceRegistry.getTftpFileTransferService();
                        SynchronousFileTransfer syncFTS = new SynchronousFileTransfer((FileTransferService)fts, "topic/TftpMediationTopic");
                        FileTransferEvent res = syncFTS.executeTransfer((FileTransferRequest)new TftpFileTransferRequest(RbFrequencyBandFileConfigurator.this.equipment.getIPAddress(), zipOut.toByteArray(), RbFrequencyBandFileTaskExecutor.this.task.getFreqBandFileName()), 600000L);
                        if (res != null && res.getEventType() == 3) {
                            RbFrequencyBandFileTaskExecutor.this.runtimeStatus.logOperationStatus(equipmentOperation, OperationStatus.COMPLETED, null);
                            RbFrequencyBandFileTaskExecutor.this.oneUploadSucceded = true;
                            logger.debug((Object)("Frequency Band File upload done on" + RbFrequencyBandFileConfigurator.this.equipment.getName()));
                        } else {
                            RbFrequencyBandFileTaskExecutor.this.runtimeStatus.logOperationStatus(equipmentOperation, OperationStatus.FAILED, null);
                            RbFrequencyBandFileTaskExecutor.this.oneUploadFaliled = true;
                            logger.debug((Object)("Frequency Band File upload faliled on" + RbFrequencyBandFileConfigurator.this.equipment.getName()));
                        }
                    }
                }).run();
            }
            finally {
                lock.unlock();
            }
        }
    }
}

