/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.frequencybandfile;

import com.bwanms.gui.Internationalizer;
import com.bwanms.meta.snmp.AlwaysValidate;
import com.bwanms.model.ManagedEntityBase;
import com.bwanms.model.ManagedEntityWeakAssociation;
import com.bwanms.model.TaskExecutor;
import com.bwanms.model.Validatable;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.tasks.frequencybandfile.RbFrequencyBandFileBaseTask;
import com.bwanms.rb.tasks.frequencybandfile.RbFrequencyBandFileTaskExecutor;
import com.bwanms.rb.tasks.frequencybandfile.RbFrequencyBandFileTaskHelper;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@AlwaysValidate
@Table(name="RbFreqBandFileTask")
public class RbFrequencyBandFileTask
extends RbFrequencyBandFileBaseTask
implements Validatable {
    private static final long serialVersionUID = 6991601162182170685L;
    private List<RbBaseStationEquipment> equipmentList;

    public TaskExecutor createExecutor() {
        return new RbFrequencyBandFileTaskExecutor(this);
    }

    void getEquipments() {
        if (this.equipmentList == null) {
            this.equipmentList = new ArrayList<RbBaseStationEquipment>();
        }
        for (ManagedEntityWeakAssociation weakAssociation : this.getManagedEntityAssociations()) {
            ManagedEntityBase me = weakAssociation.getManagedEntity();
            if (null == me || !(me instanceof RbBaseStationEquipment)) continue;
            this.equipmentList.add((RbBaseStationEquipment)me);
        }
    }

    void mergeAssociations() {
        ArrayList<RbBaseStationEquipment> meList = new ArrayList<RbBaseStationEquipment>(this.equipmentList.size());
        for (RbBaseStationEquipment equipment : this.equipmentList) {
            meList.add(equipment);
        }
        RbFrequencyBandFileTaskHelper.mergeMEWeakAssociationLists(this.getManagedEntityAssociations(), meList);
    }

    @Transient
    public List<RbBaseStationEquipment> getEquipmentList() {
        return this.equipmentList;
    }

    public void setEquipmentList(List<RbBaseStationEquipment> equipmentList) {
        this.equipmentList = equipmentList;
    }

    public void validate(List<InvalidValue> invalidValues) {
        super.validate(invalidValues);
        if (this.equipmentList.size() == 0) {
            Internationalizer i18n = Internationalizer.getInternationalizer(RbFrequencyBandFileBaseTask.class);
            invalidValues.add(new InvalidValue(i18n.translateString("NoDevicesSelected"), RbFrequencyBandFileBaseTask.class, "", (Object)"", (Object)this));
        } else {
            Internationalizer i18n = Internationalizer.getInternationalizer(RbFrequencyBandFileTask.class);
            for (int i = 0; i < this.equipmentList.size(); ++i) {
                RbBaseStationEquipment bs = this.equipmentList.get(i);
                if (bs.getFirmwareVersion() == null || bs.isTDDDuplexMode()) continue;
                invalidValues.add(new InvalidValue(i18n.translateString("EquipmentNotTDDAtRow", new Object[]{i + 1}), RbBaseStationEquipment.class, i18n.translateString("Equipment"), (Object)bs.getName(), (Object)this));
            }
        }
    }
}

