/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.configbackup;

import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.model.Task;
import com.bwanms.rb.model.RbBackupConfigFile;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.tasks.configbackup.RbConfigBackupTask;
import com.bwanms.rb.tasks.configbackup.RbConfigRestoreTask;
import com.bwanms.rb.tasks.configbackup.gui.RbConfigRestoreTaskPanel;
import com.bwanms.ui.components.EntityManagerTableModel;
import com.bwanms.util.DateFormatter;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.IpAddress;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbConfigRestoreTaskView
extends AbstractBindedEditorView<Task> {
    private RbConfigRestoreTaskPanel panel = new RbConfigRestoreTaskPanel();
    private Internationalizer i18n = Internationalizer.getInternationalizer(RbConfigRestoreTaskView.class);
    private static final Internationalizer taski18n = Internationalizer.getInternationalizer(RbConfigBackupTask.class);

    public List<Binder> getBinders() {
        ArrayList<Binder> binders = new ArrayList<Binder>();
        binders.add(new DefaultBinder((Object)this.getUI(), (Object)this.entity).add((Binding)new JTextFieldBinding("txtName", "name")));
        return binders;
    }

    public void fillUI(Task entity) {
        super.fillUI((Serializable)entity);
        RbConfigRestoreTask task = (RbConfigRestoreTask)entity;
        RbBackupConfigFile file = task.getBackupFile();
        if (file.getEquipmentAssoc() != null) {
            RbBaseStationEquipment temp = (RbBaseStationEquipment)file.getEquipmentAssoc().getManagedEntity();
            this.panel.getTxtName().setText(file.getEquipmentName());
            this.panel.getTxtIpAddress().setText(new IpAddress(file.getEquipmentIp().longValue()).toString());
            this.panel.getTxtLocation().setText(file.getLocationName());
            if (null != temp) {
                this.panel.getTableModel().addRow((Object)temp, temp.getIPAddress());
            }
        }
        this.panel.getCkbxAutoReset().setSelected(true);
        this.panel.getTxtBackupDate().setText(DateFormatter.formatSimple((Date)file.getDate()));
        this.panel.getTxtConfigFileType().setText(taski18n.translateString(file.getFileType()));
    }

    public List<InvalidValue> configureEntity(Task entity) {
        ArrayList<InvalidValue> iValues = new ArrayList<InvalidValue>();
        RbConfigRestoreTask task = (RbConfigRestoreTask)entity;
        ArrayList<RbBaseStationEquipment> equipments = new ArrayList<RbBaseStationEquipment>();
        EntityManagerTableModel tableModel = (EntityManagerTableModel)this.panel.getTable1().getModel();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            equipments.add((RbBaseStationEquipment)((Object)tableModel.getEntity(i)));
        }
        task.setEquipments(equipments);
        if (equipments.size() == 0) {
            iValues.add(new InvalidValue(this.i18n.translateString("NoTargetEquipment"), RbConfigRestoreTask.class, "", (Object)"", (Object)task));
        }
        iValues.addAll(super.configureEntity((Serializable)entity));
        task.setAutoReset(this.panel.getCkbxAutoReset().isSelected());
        if (this.panel.getCkbxAutoReset().isSelected() && iValues.isEmpty() && !FrameUtil.showConfirmation((Component)this.panel, (String)this.i18n.translateString("AutoReset"))) {
            iValues.add(new InvalidValue(this.i18n.translateString("CanceledByUser"), RbConfigBackupTask.class, "", (Object)"", (Object)task));
        }
        return iValues;
    }

    public JComponent getUI() {
        return this.panel;
    }

    public String getTitle() {
        return this.i18n.translateString("ConfigRestoreTask");
    }

    public String getApplicationPermission() {
        return "Av:ConfigureTasks";
    }

    public String getHelpTopic() {
        return "backup_manager";
    }
}

