/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.configbackup;

import com.bwanms.mediation.FileTransferEvent;
import com.bwanms.mediation.FileTransferRequest;
import com.bwanms.mediation.FileTransferService;
import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.mediation.MediationServiceRegistry;
import com.bwanms.mediation.TftpFileTransferRequest;
import com.bwanms.mediation.TftpFileTransferService;
import com.bwanms.mediation.filetransfer.SynchronousFileTransfer;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.model.Task;
import com.bwanms.model.TaskExecutionContext;
import com.bwanms.model.TaskExecutor;
import com.bwanms.model.TaskRuntimeStatus;
import com.bwanms.model.file.AbstractFile;
import com.bwanms.model.file.FileUtil;
import com.bwanms.rb.model.RbBackupConfigFile;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.tasks.configbackup.RbConfigBackupUtil;
import com.bwanms.services.ServiceException;
import com.bwanms.util.concurrent.AsyncItemsExecutor;
import com.bwanms.util.concurrent.AsyncItemsProvider;
import com.bwanms.util.task.Operation;
import com.bwanms.util.task.OperationStatus;
import com.bwanms.util.task.OperationTaskRuntimeStatus;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbConfigRestoreTask
extends Task {
    private static final long serialVersionUID = -4586362544079127751L;
    private static final Logger log = Logger.getLogger(RbConfigRestoreTask.class);
    private List<RbBaseStationEquipment> equipments;
    private RbBackupConfigFile backupFile;
    private boolean autoReset;

    public List<RbBaseStationEquipment> getEquipments() {
        return this.equipments;
    }

    public void setEquipments(List<RbBaseStationEquipment> equipments) {
        this.equipments = equipments;
    }

    public RbBackupConfigFile getBackupFile() {
        return this.backupFile;
    }

    public void setBackupFile(RbBackupConfigFile backupFile) {
        this.backupFile = backupFile;
    }

    public TaskExecutor createExecutor() {
        return new ConfigRestoreExecutor(this);
    }

    public void setBackup(RbBackupConfigFile backup) {
        this.backupFile = backup;
    }

    public void setAutoReset(boolean b) {
        this.autoReset = b;
    }

    public boolean isAutoReset() {
        return this.autoReset;
    }

    private class ConfigRestoreExecutor
    implements TaskExecutor {
        private HashMap<Long, Operation> operationMap = new HashMap();
        private OperationTaskRuntimeStatus runtimeStatus = new OperationTaskRuntimeStatus();
        private Operation rootOperation;
        private TaskExecutionContext ctx;

        public ConfigRestoreExecutor(RbConfigRestoreTask task) {
            this.rootOperation = this.runtimeStatus.addOperation(null, "RbConfigRestoreTaskName", new Object[]{task.getName()});
        }

        public void execute(TaskExecutionContext ctx) {
            this.ctx = ctx;
            final Iterator eqIterator = RbConfigRestoreTask.this.equipments.iterator();
            AsyncItemsExecutor itemsExecutor = new AsyncItemsExecutor((AsyncItemsProvider)new AsyncItemsProvider<Runnable>(){

                public boolean shouldAbort() {
                    return ConfigRestoreExecutor.this.shouldAbortTask();
                }

                public void itemFinished(Runnable item) {
                }

                public void itemStarting(Runnable item) {
                }

                public boolean hasNext() {
                    return eqIterator.hasNext();
                }

                public Runnable next() {
                    RbBaseStationEquipment nextEquipment = (RbBaseStationEquipment)((Object)eqIterator.next());
                    if (null == nextEquipment) {
                        return null;
                    }
                    return new RbConfigBackupTaskItem(nextEquipment);
                }

                public void remove() {
                    throw new UnsupportedOperationException("Remove Not Implemented!");
                }
            });
            itemsExecutor.executeItems();
            if (ctx.shouldAbort()) {
                this.logStatus(null, OperationStatus.ABORTED, null);
            } else {
                this.logStatus(null, OperationStatus.COMPLETED, null);
            }
            ctx.taskFinished();
        }

        public TaskRuntimeStatus getStatus(Object clientData) {
            Integer idx = null != clientData ? (Integer)clientData : 0;
            return this.runtimeStatus.getDiff(idx.intValue());
        }

        public String getReport() {
            return this.runtimeStatus.toXMLString();
        }

        protected boolean shouldAbortTask() {
            return this.ctx.shouldAbort();
        }

        private synchronized void logStatus(RbBaseStationEquipment equipment, OperationStatus status, String message) {
            if (null != equipment) {
                Operation eqOp = this.operationMap.get(equipment.getId());
                if (null == eqOp) {
                    eqOp = this.runtimeStatus.addOperation(this.rootOperation, "Restore", new Object[]{String.format("%s/%s", equipment.getName(), equipment.getEUID())});
                    this.operationMap.put(equipment.getId(), eqOp);
                } else {
                    this.runtimeStatus.logOperationStatus(eqOp, status, (Serializable)((Object)message));
                }
            } else {
                this.runtimeStatus.logOperationStatus(this.rootOperation, status, (Serializable)((Object)message));
            }
        }

        protected MOAccessSession createMOAccessSession(RbBaseStationEquipment equipment) throws MediationException {
            return MediationServiceRegistry.getMOSession((SNMPManagementInterface)equipment.getManagementInterface(), null);
        }

        protected void closeMOAccessSession(MOAccessSession access) {
            if (access != null) {
                try {
                    access.close();
                }
                catch (Exception e) {
                    log.debug((Object)"", (Throwable)e);
                }
            }
        }

        public int getExecutionResult() {
            if (this.ctx.shouldAbort()) {
                return 2;
            }
            return 1;
        }

        private class RbConfigBackupTaskItem
        implements Runnable {
            private RbBaseStationEquipment equipment;

            public RbConfigBackupTaskItem(RbBaseStationEquipment nextEquipment) {
                this.equipment = nextEquipment;
            }

            public void run() {
                if (ConfigRestoreExecutor.this.shouldAbortTask()) {
                    return;
                }
                ConfigRestoreExecutor.this.logStatus(this.equipment, OperationStatus.IN_PROGRESS, null);
                if (ConfigRestoreExecutor.this.shouldAbortTask()) {
                    ConfigRestoreExecutor.this.logStatus(this.equipment, OperationStatus.ABORTED, null);
                    return;
                }
                log.info((Object)("[" + this.equipment.getIPAddress() + "] starting upload of backup file"));
                long time = System.currentTimeMillis();
                TftpFileTransferService tftpService = MediationServiceRegistry.getTftpFileTransferService();
                SynchronousFileTransfer sft = new SynchronousFileTransfer((FileTransferService)tftpService, "topic/TftpMediationTopic");
                TftpFileTransferRequest req = new TftpFileTransferRequest(this.equipment.getIPAddress(), null, RbConfigRestoreTask.this.backupFile.getFileName(), 0, null);
                try {
                    req.setFileData(FileUtil.getFileBytes((AbstractFile)RbConfigRestoreTask.this.backupFile));
                }
                catch (ServiceException e1) {
                    ConfigRestoreExecutor.this.logStatus(this.equipment, OperationStatus.FAILED, "FileDataFailure");
                }
                FileTransferEvent res = sft.executeTransfer((FileTransferRequest)req, 600000L);
                if (res == null) {
                    ConfigRestoreExecutor.this.logStatus(this.equipment, OperationStatus.FAILED, "TFTPFailure");
                    return;
                }
                if (res.getEventType() == 2) {
                    ConfigRestoreExecutor.this.logStatus(this.equipment, OperationStatus.FAILED, "TFTPRequestError");
                    return;
                }
                log.info((Object)("[" + this.equipment.getIPAddress() + "] backup file uploaded in " + (System.currentTimeMillis() - time) + " millis."));
                if (RbConfigRestoreTask.this.autoReset) {
                    try {
                        RbConfigBackupUtil.resetEquipment(false, this.equipment, null);
                        log.info((Object)("[" + this.equipment.getIPAddress() + "] performed RESET"));
                    }
                    catch (MediationException e) {
                        ConfigRestoreExecutor.this.logStatus(this.equipment, OperationStatus.FAILED, "ResetError");
                    }
                }
                time = System.currentTimeMillis();
                ConfigRestoreExecutor.this.logStatus(this.equipment, OperationStatus.COMPLETED, null);
            }
        }
    }
}

