/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.configbackup;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.mediation.MediationServiceRegistry;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.persistence.Datastore;
import com.bwanms.persistence.RunnableDatastoreDecorator;
import com.bwanms.rb.command.RbMbsCommand;
import com.bwanms.rb.command.RbNpuCommand;
import com.bwanms.rb.ddi.RbBSCreateBackupFileCommand;
import com.bwanms.rb.ddi.RbMBSCreateBackupFileCommand;
import com.bwanms.rb.mo.RbNpuConfigEntry;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbMBS;
import com.bwanms.rb.model.RbNPU;
import com.bwanms.rb.tasks.configbackup.RbConfigBackupTask;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class RbConfigBackupUtil {
    private static final Logger log = Logger.getLogger(RbConfigBackupTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createBackupFile(RbBaseStationEquipment equipment, int fileType) throws MediationException {
        MOAccessSession snmpAccess = null;
        try {
            if (equipment instanceof RbBS) {
                snmpAccess = RbConfigBackupUtil.createMOAccessSession(equipment);
                RbBSCreateBackupFileCommand command = new RbBSCreateBackupFileCommand();
                command.setRbSlotNumber(5);
                command.setRbNpuCreateBackupConfigFile(fileType);
                snmpAccess.commitObject(null, (Object)command);
            } else if (equipment instanceof RbMBS) {
                snmpAccess = RbConfigBackupUtil.createMOAccessSession(equipment);
                RbMBSCreateBackupFileCommand command = new RbMBSCreateBackupFileCommand();
                command.setRbMBSTCreateBackupConfigFile(fileType);
                snmpAccess.commitObject(null, (Object)command);
            }
        }
        catch (Throwable throwable) {
            RbConfigBackupUtil.closeMOAccessSession(snmpAccess);
            throw throwable;
        }
        RbConfigBackupUtil.closeMOAccessSession(snmpAccess);
    }

    private static MOAccessSession createMOAccessSession(RbBaseStationEquipment equipment) throws MediationException {
        return MediationServiceRegistry.getMOSession((SNMPManagementInterface)equipment.getManagementInterface(), null);
    }

    private static void closeMOAccessSession(MOAccessSession access) {
        if (access != null) {
            try {
                access.close();
            }
            catch (Exception e) {
                log.debug((Object)"", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void resetEquipment(boolean isCraft, final RbBaseStationEquipment equipment, RbNpuConfigEntry rbNpuConfigEntry) throws MediationException {
        MOAccessSession snmpAccess = RbConfigBackupUtil.createMOAccessSession(equipment);
        try {
            if (equipment instanceof RbBS) {
                if (!isCraft) {
                    final ArrayList tempL = new ArrayList();
                    try {
                        new RunnableDatastoreDecorator(new Runnable(){

                            public void run() {
                                RbBS temp = (RbBS)((Object)Datastore.session().get(RbBS.class, (Serializable)Long.valueOf(equipment.getId())));
                                tempL.add(temp.getRunningNPU());
                            }
                        }).run();
                    }
                    catch (Exception e) {
                        log.error((Object)e, (Throwable)e);
                        throw new MediationException((Throwable)e);
                    }
                    RbNPU npu = (RbNPU)((Object)tempL.get(0));
                    if (npu == null) throw new MediationException();
                    snmpAccess.commitObject(null, (Object)npu.createResetCommand());
                    return;
                }
                snmpAccess.commitObject(null, (Object)RbNpuCommand.createResetCommand((RbBS)equipment, rbNpuConfigEntry));
                return;
            }
            if (!(equipment instanceof RbMBS)) return;
            RbMbsCommand command = ((RbMBS)equipment).createResetCommand();
            snmpAccess.commitObject(null, (Object)command);
            return;
        }
        finally {
            RbConfigBackupUtil.closeMOAccessSession(snmpAccess);
        }
    }
}

