/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.configbackup;

import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JComboBoxBinding;
import com.bwanms.gui.binding.JTextAreaBinding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.model.Equipment;
import com.bwanms.model.Task;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.tasks.configbackup.RbConfigBackupTask;
import com.bwanms.rb.tasks.configbackup.gui.RbConfigBackupTaskPanel;
import com.bwanms.ui.components.EntityManagerTableModel;
import com.bwanms.util.IpAddress;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbConfigBackupTaskView
extends AbstractBindedEditorView<Task> {
    private RbConfigBackupTaskPanel panel = new RbConfigBackupTaskPanel();
    private Internationalizer i18n = Internationalizer.getInternationalizer(RbConfigBackupTaskView.class);
    private Internationalizer paneli18n = Internationalizer.getInternationalizer(RbConfigBackupTaskPanel.class);

    public List<Binder> getBinders() {
        ArrayList<Binder> binders = new ArrayList<Binder>();
        binders.add(new DefaultBinder((Object)this.getUI(), (Object)this.entity).add((Binding)new JTextFieldBinding("txtName", "name", this.paneli18n.translateString("TaskName"))).add((Binding)new JComboBoxBinding("comboType", "fileType", this.paneli18n.translateString("Type"))).add((Binding)new JTextAreaBinding("txtDescription", "description", this.paneli18n.translateString("TaskDescription"))));
        return binders;
    }

    public void fillUI(Task entity) {
        super.fillUI((Serializable)entity);
        RbConfigBackupTask task = (RbConfigBackupTask)entity;
        this.panel.getTableModel().clearTable();
        if (task.getEquipments() != null) {
            for (Equipment temp : task.getEquipments()) {
                if (temp == null) continue;
                this.panel.getTableModel().addRow((Object)((RbBaseStationEquipment)temp), new IpAddress(temp.getIpAddr().longValue()).toString());
            }
        }
    }

    public List<InvalidValue> configureEntity(Task entity) {
        ArrayList<InvalidValue> iValues = new ArrayList<InvalidValue>();
        RbConfigBackupTask task = (RbConfigBackupTask)entity;
        ArrayList<Object> equipments = new ArrayList<Object>();
        EntityManagerTableModel tableModel = (EntityManagerTableModel)this.panel.getTable1().getModel();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            equipments.add(tableModel.getEntity(i));
        }
        task.setEquipments(equipments);
        if (equipments.size() == 0) {
            iValues.add(new InvalidValue(this.i18n.translateString("NoSourceEquipment"), RbConfigBackupTask.class, "", (Object)"", (Object)task));
        }
        iValues.addAll(super.configureEntity((Serializable)entity));
        return iValues;
    }

    public JComponent getUI() {
        return this.panel;
    }

    public String getTitle() {
        return this.i18n.translateString("ConfigBackupTask");
    }

    public String getApplicationPermission() {
        return "Av:ConfigureTasks";
    }

    public String getHelpTopic() {
        return "backup_manager";
    }
}

