/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.tasks.configbackup;

import com.bwanms.domain.logic.LicenseHelper;
import com.bwanms.mediation.FileTransferEvent;
import com.bwanms.mediation.FileTransferRequest;
import com.bwanms.mediation.FileTransferService;
import com.bwanms.mediation.MediationException;
import com.bwanms.mediation.MediationServiceRegistry;
import com.bwanms.mediation.TftpFileTransferRequest;
import com.bwanms.mediation.TftpFileTransferService;
import com.bwanms.mediation.filetransfer.SynchronousFileTransfer;
import com.bwanms.model.MultipleConfigTask;
import com.bwanms.model.TaskExecutionContext;
import com.bwanms.model.TaskExecutor;
import com.bwanms.model.TaskRuntimeStatus;
import com.bwanms.model.file.AbstractFile;
import com.bwanms.model.file.FileUtil;
import com.bwanms.persistence.CallableDatastoreDecorator;
import com.bwanms.rb.configfile.ConfigFile;
import com.bwanms.rb.model.RbBackupConfigFile;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.tasks.configbackup.RbConfigBackupUtil;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.MacAddress;
import com.bwanms.util.concurrent.AsyncItemsExecutor;
import com.bwanms.util.concurrent.AsyncItemsProvider;
import com.bwanms.util.task.Operation;
import com.bwanms.util.task.OperationStatus;
import com.bwanms.util.task.OperationTaskRuntimeStatus;
import com.bwanms.util.version.impl.DefaultVersion;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.Callable;
import javax.persistence.Entity;
import javax.persistence.PrimaryKeyJoinColumn;
import org.apache.log4j.Logger;

@Entity
@PrimaryKeyJoinColumn(name="taskId")
public class RbConfigBackupTask
extends MultipleConfigTask {
    private static final long serialVersionUID = 1577015251657916945L;
    private static final Logger log = Logger.getLogger(RbConfigBackupTask.class);
    private RbBackupConfigFile.FileType fileType;

    public RbBackupConfigFile.FileType getFileType() {
        return this.fileType;
    }

    public void setFileType(RbBackupConfigFile.FileType fileType) {
        this.fileType = fileType;
    }

    public TaskExecutor createExecutor() {
        return new ConfigBackupExecutor(this);
    }

    private class ConfigBackupExecutor
    implements TaskExecutor {
        private HashMap<Long, Operation> operationMap = new HashMap();
        private OperationTaskRuntimeStatus runtimeStatus = new OperationTaskRuntimeStatus();
        private Operation rootOperation;
        private TaskExecutionContext ctx;
        private boolean hasErrors = false;
        private boolean hasSuccesses = false;
        private boolean hasDoneSomething = false;
        private RbConfigBackupTask task = null;

        public ConfigBackupExecutor(RbConfigBackupTask task) {
            this.rootOperation = this.runtimeStatus.addOperation(null, "RbConfigBackupTaskName", new Object[]{task.getName()});
            this.task = task;
        }

        public void execute(TaskExecutionContext ctx) {
            this.ctx = ctx;
            if (RbConfigBackupTask.this.getEquipments().isEmpty()) {
                this.logStatus(null, OperationStatus.FAILED, "NoEquipment");
                ctx.taskFinished();
                return;
            }
            final Iterator eqIterator = RbConfigBackupTask.this.getEquipments().iterator();
            AsyncItemsExecutor itemsExecutor = new AsyncItemsExecutor((AsyncItemsProvider)new AsyncItemsProvider<Runnable>(){

                public boolean shouldAbort() {
                    return ConfigBackupExecutor.this.shouldAbortTask();
                }

                public void itemFinished(Runnable item) {
                }

                public void itemStarting(Runnable item) {
                }

                public boolean hasNext() {
                    return eqIterator.hasNext();
                }

                public Runnable next() {
                    RbBaseStationEquipment nextEquipment = (RbBaseStationEquipment)((Object)eqIterator.next());
                    if (null == nextEquipment) {
                        return null;
                    }
                    ConfigBackupExecutor.this.hasDoneSomething = true;
                    return new RbConfigBackupTaskItem(nextEquipment);
                }

                public void remove() {
                    throw new UnsupportedOperationException("Remove Not Implemented!");
                }
            });
            itemsExecutor.executeItems();
            if (ctx.shouldAbort()) {
                this.logStatus(null, OperationStatus.ABORTED, null);
            } else if (!this.hasDoneSomething) {
                this.logStatus(null, OperationStatus.FAILED, "NoEquipment");
            } else if (this.hasErrors) {
                if (this.hasSuccesses) {
                    this.logStatus(null, OperationStatus.COMPLETED_WITH_ERRORS, null);
                } else {
                    this.logStatus(null, OperationStatus.FAILED, null);
                }
            } else if (this.hasSuccesses) {
                this.logStatus(null, OperationStatus.COMPLETED, null);
            } else {
                this.logStatus(null, OperationStatus.FAILED, null);
            }
            ctx.taskFinished();
        }

        public TaskRuntimeStatus getStatus(Object clientData) {
            Integer idx = null != clientData ? (Integer)clientData : 0;
            return this.runtimeStatus.getDiff(idx.intValue());
        }

        public String getReport() {
            return this.runtimeStatus.toXMLString();
        }

        protected boolean shouldAbortTask() {
            return this.ctx.shouldAbort();
        }

        private synchronized void logStatus(RbBaseStationEquipment equipment, OperationStatus status, String message) {
            if (null != equipment) {
                Operation eqOp = this.operationMap.get(equipment.getId());
                if (null == eqOp) {
                    eqOp = this.runtimeStatus.addOperation(this.rootOperation, "Backup", new Object[]{String.format("%s/%s", equipment.getName(), equipment.getEUID())});
                    this.operationMap.put(equipment.getId(), eqOp);
                } else {
                    this.runtimeStatus.logOperationStatus(eqOp, status, (Serializable)((Object)message));
                }
            } else {
                this.runtimeStatus.logOperationStatus(this.rootOperation, status, (Serializable)((Object)message));
            }
        }

        public int getExecutionResult() {
            if (this.ctx.shouldAbort()) {
                return 2;
            }
            if (!this.hasDoneSomething) {
                return 3;
            }
            return this.hasErrors ? (this.hasSuccesses ? 4 : 3) : (this.hasSuccesses ? 1 : 3);
        }

        private class RbConfigBackupTaskItem
        implements Runnable {
            private RbBaseStationEquipment equipment;

            public RbConfigBackupTaskItem(RbBaseStationEquipment nextEquipment) {
                this.equipment = nextEquipment;
            }

            public void run() {
                TftpFileTransferRequest req;
                if (ConfigBackupExecutor.this.shouldAbortTask()) {
                    return;
                }
                try {
                    boolean licensed = (Boolean)new CallableDatastoreDecorator((Callable)new Callable<Boolean>(){

                        @Override
                        public Boolean call() {
                            return LicenseHelper.isLicensed((Object)((Object)RbConfigBackupTaskItem.this.equipment));
                        }
                    }).call();
                    if (!licensed) {
                        Operation eqOp = ConfigBackupExecutor.this.runtimeStatus.addOperation(ConfigBackupExecutor.this.rootOperation, "Backup", new Object[]{String.format("%s/%s", this.equipment.getName(), this.equipment.getEUID())});
                        ConfigBackupExecutor.this.operationMap.put(this.equipment.getId(), eqOp);
                        ConfigBackupExecutor.this.runtimeStatus.logOperationStatus(eqOp, OperationStatus.SKIPPED, (Serializable)((Object)"UnlicensedBS"));
                        return;
                    }
                }
                catch (Exception e1) {
                    // empty catch block
                }
                ConfigBackupExecutor.this.logStatus(this.equipment, OperationStatus.IN_PROGRESS, null);
                if (this.equipment.getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_IP_CS) {
                    if (RbConfigBackupTask.this.fileType == RbBackupConfigFile.FileType.RbFilters) {
                        ConfigBackupExecutor.this.logStatus(this.equipment, OperationStatus.SKIPPED, "FiltersBackupNotAvalaibleForIp_CsMode");
                        return;
                    }
                    if (RbConfigBackupTask.this.fileType == RbBackupConfigFile.FileType.RbServiceProfiles) {
                        ConfigBackupExecutor.this.logStatus(this.equipment, OperationStatus.SKIPPED, "ServiceProfilesBackupNotAvalaibleForIp_CsMode");
                        return;
                    }
                    if (RbConfigBackupTask.this.fileType == RbBackupConfigFile.FileType.RbServices) {
                        ConfigBackupExecutor.this.logStatus(this.equipment, OperationStatus.SKIPPED, "ServicesAndServiceProfilesBackupNotAvalaibleForIp_CsMode");
                        return;
                    }
                }
                StringBuffer fileName = new StringBuffer(RbBackupConfigFile.getBackupFileName(RbConfigBackupTask.this.fileType));
                if (RbConfigBackupTask.this.fileType == RbBackupConfigFile.FileType.RbLicensing) {
                    if (new DefaultVersion("4.1.1").compareTo(this.equipment.getSoftwareVersion()) > 0) {
                        ConfigBackupExecutor.this.logStatus(this.equipment, OperationStatus.SKIPPED, "WrongSwVersion");
                        return;
                    }
                    fileName.append(MacAddress.fromOctetString((String)this.equipment.getMngmntIfMAC()).toDashedString().toLowerCase());
                    fileName.append(".res");
                }
                try {
                    log.info((Object)("[" + this.equipment.getIPAddress() + "] creating backup file of type " + RbConfigBackupTask.this.fileType.name()));
                    RbConfigBackupUtil.createBackupFile(this.equipment, RbConfigBackupTask.this.fileType.mibValue());
                }
                catch (MediationException e) {
                    ConfigBackupExecutor.this.logStatus(this.equipment, OperationStatus.FAILED, "BackupError");
                    ConfigBackupExecutor.this.hasErrors = true;
                    return;
                }
                if (ConfigBackupExecutor.this.shouldAbortTask()) {
                    ConfigBackupExecutor.this.logStatus(this.equipment, OperationStatus.ABORTED, null);
                    return;
                }
                long time = System.currentTimeMillis();
                TftpFileTransferService tftpService = MediationServiceRegistry.getTftpFileTransferService();
                SynchronousFileTransfer sft = new SynchronousFileTransfer((FileTransferService)tftpService, "topic/TftpMediationTopic");
                FileTransferEvent res = sft.executeTransfer((FileTransferRequest)(req = new TftpFileTransferRequest(this.equipment.getIPAddress(), null, fileName.toString(), 1, (Serializable)((Object)"me"))), 600000L);
                if (res == null) {
                    ConfigBackupExecutor.this.logStatus(this.equipment, OperationStatus.FAILED, "TFTPFailure");
                    ConfigBackupExecutor.this.hasErrors = true;
                    return;
                }
                if (res.getEventType() == 2) {
                    ConfigBackupExecutor.this.logStatus(this.equipment, OperationStatus.FAILED, "TFTPRequestError");
                    ConfigBackupExecutor.this.hasErrors = true;
                    return;
                }
                log.debug((Object)("[" + this.equipment.getIPAddress() + "] backup file downloaded in " + (System.currentTimeMillis() - time) + " millis."));
                time = System.currentTimeMillis();
                if (ConfigBackupExecutor.this.shouldAbortTask()) {
                    ConfigBackupExecutor.this.logStatus(this.equipment, OperationStatus.ABORTED, null);
                    return;
                }
                byte[] configFileData = res.getFileData();
                try {
                    ConfigFile configFile = ConfigFile.parse(new ByteArrayInputStream(configFileData));
                }
                catch (Throwable t) {
                    log.debug((Object)t, t);
                    ConfigBackupExecutor.this.logStatus(this.equipment, OperationStatus.FAILED, "CorruptFileError");
                    ConfigBackupExecutor.this.hasErrors = true;
                    return;
                }
                RbBackupConfigFile backup = new RbBackupConfigFile(this.equipment);
                FileUtil.setFileBytes((AbstractFile)backup, (byte[])configFileData);
                backup.setTimestamp(Calendar.getInstance().getTimeInMillis());
                backup.setCustomType(RbConfigBackupTask.this.fileType);
                backup.setStatus(1);
                backup.setDescription(ConfigBackupExecutor.this.task.getDescription());
                log.info((Object)String.format("Saving backup for %s", this.equipment.getName()));
                try {
                    ServiceRegistry.getEntityManagerService().save((Serializable)((Object)backup));
                }
                catch (ServiceException e) {
                    log.error((Object)e, (Throwable)e);
                    ConfigBackupExecutor.this.logStatus(this.equipment, OperationStatus.FAILED, "PersistenceError");
                    ConfigBackupExecutor.this.hasErrors = true;
                    return;
                }
                ConfigBackupExecutor.this.logStatus(this.equipment, OperationStatus.COMPLETED, null);
                ConfigBackupExecutor.this.hasSuccesses = true;
            }
        }
    }
}

