/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.performance;

import com.bwanms.gui.Internationalizer;
import com.bwanms.model.ManagementInterface;
import com.bwanms.performance.PerformanceCollectionActiveEntity;
import com.bwanms.performance.PerformanceCollectionLookup;
import com.bwanms.performance.db.PmCollectionVariable;
import com.bwanms.rb.mo.services.RbServiceConfigEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import java.io.Serializable;

public class RbServiceEntryPerfCollEntityHandler
extends PerformanceCollectionActiveEntity {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbServiceEntryPerfCollEntityHandler.class);
    private static String SVC_IDX = "{SVC_IDX}";
    private String serviceID = null;

    protected ManagementInterface getManagementInterface(Serializable collectedEntity) {
        RbServiceConfigEntry serviceCfgEntry = (RbServiceConfigEntry)((Object)collectedEntity);
        RbBaseStationEquipment bs = (RbBaseStationEquipment)serviceCfgEntry.getNRConfiguration().getConfigurationEquipment();
        this.serviceID = serviceCfgEntry.getRbServiceID().toString();
        return bs.getManagementInterface();
    }

    protected PmCollectionVariable getPmCollectionVar(String pName, String snmpName, int pType, PerformanceCollectionLookup lookup) throws Exception {
        if (null != this.serviceID) {
            int svcIdxPos = snmpName.indexOf(SVC_IDX);
            String varSnmpName = -1 != svcIdxPos ? pName.substring(0, svcIdxPos) + this.serviceID + pName.substring(svcIdxPos + SVC_IDX.length()) : pName;
            return super.getPmCollectionVar(pName, varSnmpName, pType, lookup);
        }
        return null;
    }

    protected void setEntitySpecificParameters(Serializable entity) {
        if (entity instanceof RbServiceConfigEntry) {
            RbServiceConfigEntry srvc = (RbServiceConfigEntry)((Object)entity);
            this.entityUID = String.format("SRVC.%d.%d", srvc.getRbSubscriberIdx(), srvc.getRbServiceIdx());
            this.entityName = srvc.getRbServiceName();
            this.entityType = i18n.translateString(RbServiceConfigEntry.class.getName() + "." + RbServiceConfigEntry.toStringRbServiceType(srvc.getRbServiceType()));
            this.managedElement = false;
            RbBaseStationEquipment bs = (RbBaseStationEquipment)srvc.getNRConfiguration().getConfigurationEquipment();
            this.groupUID = bs != null ? bs.getManagedObjectId() : "";
            this.elementUID = bs != null ? bs.getManagedObjectId() : "";
            this.elementName = "";
            this.elementType = "";
            this.swVersion = "";
        }
    }
}

