/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.performance;

import com.bwanms.model.ManagedEntity;
import com.bwanms.model.ManagedEntityWeakAssociation;
import com.bwanms.performance.PerformanceCollectionEntity;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbSU;
import com.bwanms.util.NameValuePair;
import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.OneToOne;
import javax.persistence.Transient;

@Entity
public class RbPerformanceMECollectionEntity
extends PerformanceCollectionEntity {
    private ManagedEntityWeakAssociation managedEntityWA;

    protected RbPerformanceMECollectionEntity() {
    }

    public RbPerformanceMECollectionEntity(ManagedEntity managedEntity) {
        this.managedEntityWA = new ManagedEntityWeakAssociation(managedEntity);
    }

    @Transient
    public Serializable getEntity() {
        return this.getManagedEntityWA().getEntity();
    }

    @OneToOne(cascade={CascadeType.ALL})
    public ManagedEntityWeakAssociation getManagedEntityWA() {
        return this.managedEntityWA;
    }

    public void setManagedEntityWA(ManagedEntityWeakAssociation managedEntityWA) {
        this.managedEntityWA = managedEntityWA;
    }

    @Transient
    public String getEntityName() {
        return ((ManagedEntity)this.getEntity()).getName();
    }

    @Transient
    public String getEntityFileName() {
        Serializable me = this.getEntity();
        if (null != me) {
            if (me instanceof RbBaseStationEquipment) {
                RbBaseStationEquipment bsEq = (RbBaseStationEquipment)((Object)me);
                return bsEq.getName() + "-" + bsEq.getIPAddress().replace('.', '_');
            }
            if (me instanceof RbSU) {
                RbSU su = (RbSU)((Object)me);
                return su.getName() + "-" + su.getMacAddress().replace(' ', '-');
            }
        }
        return super.getEntityFileName();
    }

    @Transient
    public NameValuePair[] getEntityAdditionalHeaderColumns() {
        Serializable me = this.getEntity();
        if (null != me) {
            if (me instanceof RbBaseStationEquipment) {
                RbBaseStationEquipment bsEq = (RbBaseStationEquipment)((Object)me);
                return new NameValuePair[]{new NameValuePair("BS_IP", (Object)bsEq.getIPAddress())};
            }
            if (me instanceof RbSU) {
                RbSU su = (RbSU)((Object)me);
                RbBaseStationEquipment bsEq = su.getManagerBS();
                if (null != bsEq) {
                    return new NameValuePair[]{new NameValuePair("BS_IP", (Object)bsEq.getIPAddress()), new NameValuePair("SU_MAC", (Object)su.getMacAddress().replace(' ', '-'))};
                }
                return new NameValuePair[]{new NameValuePair("SU_MAC", (Object)su.getMacAddress().replace(' ', '-'))};
            }
        }
        return super.getEntityAdditionalHeaderColumns();
    }
}

