/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.performance;

import com.bwanms.gui.Internationalizer;
import com.bwanms.model.ManagementInterface;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.performance.PerformanceCollectionActiveEntity;
import com.bwanms.performance.PerformanceCollectionLookup;
import com.bwanms.performance.db.PmCollectionVariable;
import com.bwanms.rb.model.RbAU;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbNPU;
import com.bwanms.rb.model.RbSU;
import com.bwanms.util.MacAddress;
import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import org.snmp4j.PDU;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbEquipmentPerfCollEntityHandler
extends PerformanceCollectionActiveEntity {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbEquipmentPerfCollEntityHandler.class);
    private static final Logger logger = Logger.getLogger(RbEquipmentPerfCollEntityHandler.class);
    private static String SU_MAC_ADDR = "{SU_MAC_ADDR}";
    public static final String COLLECTED_STATISTICS_TABLE_NAME = "CollectedStatInfoTbl";
    private String suMacAddrAsInstance;

    protected ManagementInterface getManagementInterface(Serializable collectionEntity) {
        SNMPManagementInterface ret = null;
        try {
            RbSU su;
            if (collectionEntity instanceof RbBaseStationEquipment) {
                ret = ((RbBaseStationEquipment)((Object)collectionEntity)).getManagementInterface();
            }
            if (collectionEntity instanceof RbNPU) {
                ret = ((RbNPU)((Object)collectionEntity)).getManagementInterface();
            } else if (collectionEntity instanceof RbAU) {
                ret = ((RbAU)((Object)collectionEntity)).getManagementInterface();
            } else if (collectionEntity instanceof RbSU && null != (su = (RbSU)((Object)collectionEntity)).getManagerBS()) {
                ret = su.getManagementInterface();
                this.suMacAddrAsInstance = MacAddress.fromSimpleString((String)su.getMacAddress()).toInstanceString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    protected String processRowID(PDU req, PDU resp, boolean success, String pName, List<PmCollectionVariable> pKeys, List<PmCollectionVariable> pVars) {
        String rowID = super.processRowID(req, resp, success, pName, pKeys, pVars);
        if (null != rowID && rowID.startsWith(COLLECTED_STATISTICS_TABLE_NAME) && pKeys != null) {
            if (rowID.endsWith(".1")) {
                return rowID.substring(0, rowID.length() - 2);
            }
            return null;
        }
        return rowID;
    }

    protected PmCollectionVariable getPmCollectionVar(String pName, String snmpName, int pType, PerformanceCollectionLookup lookup) throws Exception {
        if (null != this.suMacAddrAsInstance) {
            int suMacPos = snmpName.indexOf(SU_MAC_ADDR);
            String varSnmpName = -1 != suMacPos ? pName.substring(0, suMacPos) + this.suMacAddrAsInstance + pName.substring(suMacPos + SU_MAC_ADDR.length()) : pName;
            return super.getPmCollectionVar(pName, varSnmpName, pType, lookup);
        }
        return super.getPmCollectionVar(pName, snmpName, pType, lookup);
    }

    protected void setEntitySpecificParameters(Serializable entity) {
        if (entity instanceof RbBaseStationEquipment) {
            RbBaseStationEquipment bs = (RbBaseStationEquipment)((Object)entity);
            this.entityUID = bs.getManagedObjectId();
            this.entityName = bs.getName();
            this.entityType = i18n.translateString(((Object)((Object)bs)).getClass().getName());
            this.groupUID = bs.getManagedObjectId();
            this.managedElement = true;
            this.elementUID = bs.getManagedObjectId();
            this.elementName = bs.getName();
            this.elementType = bs.getModel();
            this.swVersion = bs.getFirmwareVersion();
        } else if (entity instanceof RbSU) {
            RbSU su = (RbSU)((Object)entity);
            this.entityUID = su.getManagedObjectId();
            this.entityName = su.getName();
            this.entityType = i18n.translateString(((Object)((Object)su)).getClass().getName());
            RbBaseStationEquipment bs = su.getManagerBS();
            this.groupUID = bs != null ? bs.getManagedObjectId() : "";
            this.managedElement = true;
            this.elementUID = su.getManagedObjectId();
            this.elementName = su.getName();
            this.elementType = su.getModel();
            this.swVersion = su.getFirmwareVersion();
        }
    }
}

