/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.performance;

import com.bwanms.gui.Internationalizer;
import com.bwanms.performance.viewer.CounterNodeInternationalizer;
import com.ngnms.apps.pmcollection.AvPMCounterNode;

public class RbCounterNodeInternationalizer
implements CounterNodeInternationalizer {
    private static String SVC_IDX_DOT_STR = "{SVC_IDX}.";
    private Internationalizer internationalizer;
    private boolean defaultTranslation = false;

    public RbCounterNodeInternationalizer() {
        this.internationalizer = Internationalizer.getInternationalizer(RbCounterNodeInternationalizer.class);
        this.defaultTranslation = true;
    }

    public RbCounterNodeInternationalizer(Internationalizer internationalizer) {
        this.internationalizer = internationalizer;
    }

    public void translateNode(AvPMCounterNode node) {
        String label = node.getLabel();
        if (this.defaultTranslation) {
            node.setLabel(this.internationalizer.translateString(label));
        } else {
            String prefix = "";
            String suffix = "";
            int idx = label.indexOf("::");
            if (-1 != idx) {
                suffix = label.substring(idx);
                label = label.substring(0, idx);
            }
            if (-1 != (idx = label.indexOf("."))) {
                String inst = label.substring(idx + 1);
                label = label.substring(0, idx);
                int svcIdxPos = inst.indexOf(SVC_IDX_DOT_STR);
                if (-1 != svcIdxPos) {
                    int beginIdx = svcIdxPos + SVC_IDX_DOT_STR.length();
                    int endIdx = inst.indexOf(46, beginIdx);
                    String levelStr = -1 != endIdx ? inst.substring(beginIdx, endIdx) : inst.substring(beginIdx);
                    prefix = this.internationalizer.translateString(1 == Integer.parseInt(levelStr) ? "Down" : "Up") + " ";
                }
            }
            node.setLabel(prefix + this.internationalizer.translateString(label) + suffix);
        }
    }
}

